/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.DirectionResolver;
import com.graphhopper.routing.DirectionResolverResult;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DirectionResolverOnQueryGraphTest {
    private QueryGraph queryGraph;
    private NodeAccess na;
    private BooleanEncodedValue accessEnc;
    private DecimalEncodedValue speedEnc;
    private BaseGraph graph;
    private LocationIndexTree locationIndex;

    @BeforeEach
    public void setup() {
        this.accessEnc = new SimpleBooleanEncodedValue("access", true);
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)this.accessEnc).add((EncodedValue)this.speedEnc).build();
        this.graph = new BaseGraph.Builder(em).create();
        this.na = this.graph.getNodeAccess();
    }

    @Test
    public void junction() {
        this.addNode(0, 2.0, 1.99);
        this.addNode(1, 2.0, 2.0);
        this.addNode(2, 2.0, 2.01);
        this.addNode(3, 2.01, 2.0);
        this.addNode(4, 1.99, 2.0);
        this.addEdge(0, 1, false);
        this.addEdge(1, 2, false);
        this.addEdge(1, 3, true);
        this.addEdge(1, 4, true);
        this.init();
        this.checkResult(2.001, 1.998, this.onlyLeft(this.edge(0, 5), this.edge(5, 1)));
        this.checkResult(2.002, 1.999, this.restricted(this.edge(3, 5), this.edge(5, 1), this.edge(1, 5), this.edge(5, 3)));
        this.checkResult(2.001, 2.002, this.onlyLeft(this.edge(1, 5), this.edge(5, 2)));
        this.checkResult(2.002, 2.001, this.restricted(this.edge(1, 5), this.edge(5, 3), this.edge(3, 5), this.edge(5, 1)));
        this.checkResult(1.999, 1.998, this.onlyRight(this.edge(0, 5), this.edge(5, 1)));
        this.checkResult(1.998, 1.999, this.restricted(this.edge(1, 5), this.edge(5, 4), this.edge(4, 5), this.edge(5, 1)));
        this.checkResult(1.999, 2.002, this.onlyRight(this.edge(1, 5), this.edge(5, 2)));
        this.checkResult(1.998, 2.001, this.restricted(this.edge(4, 5), this.edge(5, 1), this.edge(1, 5), this.edge(5, 4)));
        this.assertUnrestricted(2.0, 2.0);
    }

    @Test
    public void multiple_locations_same_road() {
        this.addNode(0, 1.0, 1.0);
        this.addNode(1, 1.0, 2.0);
        this.addNode(2, 5.0, 5.0);
        this.addEdge(0, 1, true);
        this.init();
        this.checkResults(this.result(1.01, 1.2, this.restricted(this.edge(4, 3), this.edge(3, 0), this.edge(0, 3), this.edge(3, 4))), this.result(0.99, 1.5, this.restricted(this.edge(3, 4), this.edge(4, 5), this.edge(5, 4), this.edge(4, 3))), this.result(1.01, 1.7, this.restricted(this.edge(1, 5), this.edge(5, 4), this.edge(4, 5), this.edge(5, 1))));
    }

    @Test
    public void multiple_locations_same_road_one_way() {
        this.addNode(0, 1.0, 1.0);
        this.addNode(1, 1.0, 2.0);
        this.addNode(2, 5.0, 5.0);
        this.addEdge(0, 1, false);
        this.init();
        this.checkResults(this.result(1.01, 1.2, this.onlyLeft(this.edge(0, 3), this.edge(3, 4))), this.result(0.99, 1.5, this.onlyRight(this.edge(3, 4), this.edge(4, 5))), this.result(1.01, 1.7, this.onlyLeft(this.edge(4, 5), this.edge(5, 1))));
    }

    @Test
    public void two_locations_same_spot_same_side() {
        this.addNode(0, 1.0, 1.0);
        this.addNode(1, 1.0, 2.0);
        this.addNode(2, 5.0, 5.0);
        this.addEdge(0, 1, true);
        this.init();
        this.checkResults(this.result(1.01, 1.5, this.restricted(this.edge(1, 3), this.edge(3, 0), this.edge(0, 3), this.edge(3, 1))), this.result(1.01, 1.5, this.restricted(this.edge(1, 3), this.edge(3, 0), this.edge(0, 3), this.edge(3, 1))));
    }

    @Test
    public void two_locations_same_spot_different_sides() {
        this.addNode(0, 1.0, 1.0);
        this.addNode(1, 1.0, 2.0);
        this.addNode(2, 5.0, 5.0);
        this.addEdge(0, 1, true);
        this.init();
        this.checkResults(this.result(1.01, 1.5, this.restricted(this.edge(1, 3), this.edge(3, 0), this.edge(0, 3), this.edge(3, 1))), this.result(0.99, 1.5, this.restricted(this.edge(0, 3), this.edge(3, 1), this.edge(1, 3), this.edge(3, 0))));
    }

    @Test
    public void road_with_geometry() {
        this.addNode(0, 1.0, 2.0);
        this.addNode(1, 1.0, 3.0);
        this.addNode(2, 5.0, 5.0);
        this.addEdge(0, 1, true).setWayGeometry(Helper.createPointList((double[])new double[]{2.0, 2.0, 2.0, 3.0}));
        this.init();
        this.checkResult(1.5, 1.99, this.restricted(this.edge(1, 3), this.edge(3, 0), this.edge(0, 3), this.edge(3, 1)));
        this.checkResult(2.01, 2.5, this.restricted(this.edge(1, 3), this.edge(3, 0), this.edge(0, 3), this.edge(3, 1)));
        this.checkResult(1.5, 3.01, this.restricted(this.edge(1, 3), this.edge(3, 0), this.edge(0, 3), this.edge(3, 1)));
        this.checkResult(1.99, 2.5, this.restricted(this.edge(0, 3), this.edge(3, 1), this.edge(1, 3), this.edge(3, 0)));
    }

    @Test
    public void sharp_curves() {
        this.addNode(0, 2.0, 1.0);
        this.addNode(1, 1.0, 3.0);
        this.addEdge(0, 1, true).setWayGeometry(Helper.createPointList((double[])new double[]{2.0, 1.5, 1.0, 1.3}));
        this.init();
        this.checkResult(2.0, 1.501, this.restricted(this.edge(1, 2), this.edge(2, 0), this.edge(0, 2), this.edge(2, 1)));
        this.checkResult(1.0, 1.299, this.restricted(this.edge(0, 2), this.edge(2, 1), this.edge(1, 2), this.edge(2, 0)));
        this.checkResult(1.99, 1.49, this.restricted(this.edge(0, 2), this.edge(2, 1), this.edge(1, 2), this.edge(2, 0)));
        this.checkResult(1.01, 1.31, this.restricted(this.edge(1, 2), this.edge(2, 0), this.edge(0, 2), this.edge(2, 1)));
    }

    @Test
    public void junction_hitFromTheSide() {
        this.addNode(0, 2.0, 1.0);
        this.addNode(1, 2.0, 2.0);
        this.addNode(2, 2.0, 3.0);
        this.addNode(3, 1.0, 2.0);
        this.addEdge(0, 3, true);
        this.addEdge(1, 3, true);
        this.addEdge(2, 3, true);
        this.init();
        this.assertUnrestricted(0.99, 2.0);
    }

    @Test
    public void duplicateCoordinatesAtBaseOrAdjNode() {
        this.addNode(0, 0.0, 0.0);
        this.addNode(1, 1.0, 1.0);
        this.addEdge(0, 1, true).setWayGeometry(Helper.createPointList((double[])new double[]{0.1, 0.1, 0.1, 0.1, 0.2, 0.2, 0.9, 0.9, 0.9, 0.9}));
        this.init();
        this.checkResult(0.1, 0.1, this.restricted(this.edge(0, 2), this.edge(2, 1), this.edge(1, 2), this.edge(2, 0)));
        this.checkResult(0.9, 0.9, this.restricted(this.edge(0, 2), this.edge(2, 1), this.edge(1, 2), this.edge(2, 0)));
    }

    @Test
    public void closeToTowerNode_issue2443() {
        this.addNode(0, 51.986, 19.255);
        this.addNode(1, 51.9855, 19.254);
        DistancePlaneProjection distCalc = new DistancePlaneProjection();
        this.addEdge(0, 1, true).setDistance(distCalc.calcDist(this.na.getLat(0), this.na.getLon(0), this.na.getLat(1), this.na.getLon(1)));
        this.init();
        double lat = 51.9855003;
        double lon = 19.2540003;
        Snap snap = this.snapCoordinate(lat, lon);
        this.queryGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)snap);
        DirectionResolver resolver = new DirectionResolver((Graph)this.queryGraph, this::isAccessible);
        DirectionResolverResult result = resolver.resolveDirections(snap.getClosestNode(), snap.getQueryPoint());
        Assertions.assertEquals((int)0, (int)result.getInEdgeRight());
        Assertions.assertEquals((int)0, (int)result.getOutEdgeRight());
        Assertions.assertEquals((int)0, (int)result.getInEdgeLeft());
        Assertions.assertEquals((int)0, (int)result.getOutEdgeRight());
    }

    @Test
    public void unblockedBarrierEdge_issue2443() {
        this.addNode(0, 51.986, 19.255);
        this.addNode(1, 51.9861, 19.2551);
        this.addNode(2, 51.9861, 19.2551);
        DistancePlaneProjection distCalc = new DistancePlaneProjection();
        this.addEdge(0, 1, true).setDistance(distCalc.calcDist(this.na.getLat(0), this.na.getLon(0), this.na.getLat(1), this.na.getLon(1)));
        this.addEdge(1, 2, true).setDistance(0.0);
        this.init();
        this.assertUnrestricted(51.9861, 19.2551);
    }

    private void addNode(int nodeId, double lat, double lon) {
        this.na.setNode(nodeId, lat, lon);
    }

    private EdgeIteratorState addEdge(int from, int to, boolean bothDirections) {
        return GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)bothDirections, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(from, to).setDistance(1.0));
    }

    private void init() {
        this.locationIndex = new LocationIndexTree((Graph)this.graph, (Directory)new RAMDirectory());
        this.locationIndex.prepareIndex();
    }

    private void checkResult(double lat, double lon, ExpectedEdge ... edges) {
        this.checkResults(this.result(lat, lon, edges));
    }

    private void checkResults(ExpectedResult ... expectedResults) {
        ArrayList<Snap> snaps = new ArrayList<Snap>(expectedResults.length);
        for (ExpectedResult r : expectedResults) {
            snaps.add(this.snapCoordinate(r.lat, r.lon));
        }
        this.queryGraph = QueryGraph.create((BaseGraph)this.graph, snaps);
        DirectionResolver resolver = new DirectionResolver((Graph)this.queryGraph, this::isAccessible);
        for (int i = 0; i < expectedResults.length; ++i) {
            Assertions.assertEquals((Object)this.restrictedDirection(expectedResults[i]), (Object)resolver.resolveDirections(((Snap)snaps.get(i)).getClosestNode(), ((Snap)snaps.get(i)).getQueryPoint()), (String)"unexpected resolved direction");
        }
    }

    private ExpectedEdge[] onlyLeft(ExpectedEdge leftIn, ExpectedEdge leftOut) {
        return new ExpectedEdge[]{null, null, leftIn, leftOut};
    }

    private ExpectedEdge[] onlyRight(ExpectedEdge rightIn, ExpectedEdge rightOut) {
        return new ExpectedEdge[]{rightIn, rightOut, null, null};
    }

    private ExpectedEdge[] restricted(ExpectedEdge rightIn, ExpectedEdge rightOut, ExpectedEdge leftIn, ExpectedEdge leftOut) {
        return new ExpectedEdge[]{rightIn, rightOut, leftIn, leftOut};
    }

    private void assertUnrestricted(double lat, double lon) {
        Snap snap = this.snapCoordinate(lat, lon);
        this.queryGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)snap);
        DirectionResolver resolver = new DirectionResolver((Graph)this.queryGraph, this::isAccessible);
        Assertions.assertEquals((Object)DirectionResolverResult.unrestricted(), (Object)resolver.resolveDirections(snap.getClosestNode(), snap.getQueryPoint()));
    }

    private DirectionResolverResult restrictedDirection(ExpectedResult restriction) {
        IntArrayList edgeIds = new IntArrayList(restriction.expectedEdges.length);
        for (ExpectedEdge e : restriction.expectedEdges) {
            edgeIds.add(e == null ? -1 : this.findEdge(e.from, e.to));
        }
        return DirectionResolverResult.restricted((int)edgeIds.get(0), (int)edgeIds.get(1), (int)edgeIds.get(2), (int)edgeIds.get(3));
    }

    private int findEdge(int from, int to) {
        EdgeExplorer explorer = this.queryGraph.createEdgeExplorer((EdgeFilter)AccessFilter.outEdges((BooleanEncodedValue)this.accessEnc));
        EdgeIterator iter = explorer.setBaseNode(from);
        while (iter.next()) {
            if (iter.getAdjNode() != to) continue;
            return iter.getEdge();
        }
        throw new IllegalStateException("Could not find edge from: " + from + ", to: " + to);
    }

    private boolean isAccessible(EdgeIteratorState edge, boolean reverse) {
        return reverse ? edge.getReverse(this.accessEnc) : edge.get(this.accessEnc);
    }

    private Snap snapCoordinate(double lat, double lon) {
        return this.locationIndex.findClosest(lat, lon, EdgeFilter.ALL_EDGES);
    }

    private ExpectedEdge edge(int from, int to) {
        return new ExpectedEdge(from, to);
    }

    private ExpectedResult result(double lat, double lon, ExpectedEdge ... edges) {
        return new ExpectedResult(lat, lon, edges);
    }

    private static class ExpectedEdge {
        int from;
        int to;

        ExpectedEdge(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }

    private static class ExpectedResult {
        double lat;
        double lon;
        ExpectedEdge[] expectedEdges;

        ExpectedResult(double lat, double lon, ExpectedEdge[] expectedEdges) {
            if (expectedEdges.length != 4) {
                Assertions.fail((String)("there should be four expected edges, but got: " + expectedEdges.length));
            }
            this.lat = lat;
            this.lon = lon;
            this.expectedEdges = expectedEdges;
        }
    }
}

