/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.DirectionResolver;
import com.graphhopper.routing.DirectionResolverResult;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.shapes.GHPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DirectionResolverTest {
    private BooleanEncodedValue accessEnc;
    private DecimalEncodedValue speedEnc;
    private BaseGraph graph;
    private NodeAccess na;

    @BeforeEach
    public void setup() {
        this.accessEnc = new SimpleBooleanEncodedValue("access", true);
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)this.accessEnc).add((EncodedValue)this.speedEnc).build();
        this.graph = new BaseGraph.Builder(em).create();
        this.na = this.graph.getNodeAccess();
    }

    @Test
    public void isolated_nodes() {
        this.addNode(0, 0.0, 0.0);
        this.addNode(1, 0.1, 0.1);
        this.checkResult(0, DirectionResolverResult.impossible());
        this.checkResult(1, DirectionResolverResult.impossible());
    }

    @Test
    public void isolated_nodes_blocked_edge() {
        this.addNode(0, 0.0, 0.0);
        this.addNode(1, 0.1, 0.1);
        this.graph.edge(0, 1).set(this.accessEnc, false, false);
        this.checkResult(0, DirectionResolverResult.impossible());
        this.checkResult(1, DirectionResolverResult.impossible());
    }

    @Test
    public void nodes_at_end_of_dead_end_street() {
        this.addNode(0, 2.0, 1.9);
        this.addNode(1, 2.0, 2.0);
        this.addNode(2, 2.0, 2.1);
        this.addNode(3, 1.9, 2.0);
        this.addNode(4, 2.1, 2.0);
        this.addEdge(0, 1, false);
        this.addEdge(1, 2, false);
        this.addEdge(1, 3, true);
        this.addEdge(1, 4, true);
        this.checkResult(0, DirectionResolverResult.impossible());
        this.checkResult(2, DirectionResolverResult.impossible());
        this.checkResult(3, DirectionResolverResult.restricted((int)this.edge(1, 3), (int)this.edge(3, 1), (int)this.edge(1, 3), (int)this.edge(3, 1)));
        this.checkResult(4, DirectionResolverResult.restricted((int)this.edge(1, 4), (int)this.edge(4, 1), (int)this.edge(1, 4), (int)this.edge(4, 1)));
    }

    @Test
    public void unreachable_nodes() {
        this.addNode(0, 1.0, 1.0);
        this.addNode(1, 2.0, 1.5);
        this.addNode(2, 1.0, 2.0);
        this.addNode(3, 2.0, 2.5);
        this.addEdge(0, 1, false);
        this.addEdge(2, 1, false);
        this.addEdge(2, 3, false);
        this.checkResult(1, DirectionResolverResult.impossible());
        this.checkResult(2, DirectionResolverResult.impossible());
    }

    @Test
    public void junction() {
        this.addNode(0, 2.0, 1.99);
        this.addNode(1, 2.0, 2.0);
        this.addNode(2, 2.0, 2.01);
        this.addNode(3, 2.01, 2.0);
        this.addNode(4, 1.99, 2.0);
        this.addEdge(0, 1, false);
        this.addEdge(1, 2, false);
        this.addEdge(1, 3, true);
        this.addEdge(2, 3, true);
        this.addEdge(1, 4, true);
        this.addEdge(2, 5, true);
        this.checkResult(1, DirectionResolverResult.unrestricted());
        this.checkResult(2, DirectionResolverResult.unrestricted());
    }

    @Test
    public void junction_exposed() {
        this.addNode(0, 2.0, 1.0);
        this.addNode(1, 2.0, 2.0);
        this.addNode(2, 2.0, 3.0);
        this.addNode(3, 1.0, 2.0);
        this.addEdge(0, 3, true);
        this.addEdge(1, 3, true);
        this.addEdge(2, 3, true);
        this.checkResult(3, DirectionResolverResult.unrestricted());
    }

    @Test
    public void duplicateEdges() {
        this.addNode(0, 0.0, 0.0);
        this.addNode(1, 1.0, 1.0);
        this.addNode(2, 0.0, 2.0);
        this.addEdge(0, 1, true);
        this.addEdge(0, 1, true);
        this.addEdge(1, 2, true);
        this.checkResult(1, DirectionResolverResult.unrestricted());
        this.checkResult(0, DirectionResolverResult.unrestricted());
    }

    @Test
    public void duplicateEdges_in() {
        this.addNode(0, 1.0, 1.0);
        this.addNode(1, 2.0, 2.0);
        this.addNode(2, 1.0, 3.0);
        this.addEdge(0, 1, false);
        this.addEdge(0, 1, false);
        this.addEdge(1, 2, false);
        this.checkResult(1, DirectionResolverResult.unrestricted());
    }

    @Test
    public void duplicateEdges_out() {
        this.addNode(0, 1.0, 1.0);
        this.addNode(1, 2.0, 2.0);
        this.addNode(2, 1.0, 3.0);
        this.addEdge(0, 1, false);
        this.addEdge(1, 2, false);
        this.addEdge(1, 2, false);
        this.checkResult(1, DirectionResolverResult.unrestricted());
    }

    @Test
    public void simple_road() {
        this.addNode(0, 1.0, 0.0);
        this.addNode(1, 1.0, 1.0);
        this.addNode(2, 1.0, 2.0);
        this.addNode(3, 1.0, 3.0);
        this.addNode(4, 1.0, 4.0);
        this.addNode(5, 2.0, 5.0);
        this.addEdge(0, 1, true);
        this.addEdge(1, 2, true);
        this.addEdge(2, 3, true);
        this.addEdge(3, 4, true);
        this.checkResult(1, 1.01, 1.0, DirectionResolverResult.restricted((int)this.edge(2, 1), (int)this.edge(1, 0), (int)this.edge(0, 1), (int)this.edge(1, 2)));
        this.checkResult(1, 0.99, 1.0, DirectionResolverResult.restricted((int)this.edge(0, 1), (int)this.edge(1, 2), (int)this.edge(2, 1), (int)this.edge(1, 0)));
        this.checkResult(3, 1.01, 3.0, DirectionResolverResult.restricted((int)this.edge(4, 3), (int)this.edge(3, 2), (int)this.edge(2, 3), (int)this.edge(3, 4)));
        this.checkResult(3, 0.99, 3.0, DirectionResolverResult.restricted((int)this.edge(2, 3), (int)this.edge(3, 4), (int)this.edge(4, 3), (int)this.edge(3, 2)));
    }

    @Test
    public void simple_road_one_way() {
        this.addNode(0, 1.0, 0.0);
        this.addNode(1, 1.0, 1.0);
        this.addNode(2, 1.0, 2.0);
        this.addNode(3, 1.0, 3.0);
        this.addNode(4, 1.0, 4.0);
        this.addNode(5, 2.0, 5.0);
        this.addEdge(0, 1, false);
        this.addEdge(1, 2, false);
        this.addEdge(2, 3, false);
        this.addEdge(3, 4, false);
        this.checkResult(1, 1.01, 1.0, DirectionResolverResult.onlyLeft((int)this.edge(0, 1), (int)this.edge(1, 2)));
        this.checkResult(1, 0.99, 1.0, DirectionResolverResult.onlyRight((int)this.edge(0, 1), (int)this.edge(1, 2)));
        this.checkResult(3, 1.01, 3.0, DirectionResolverResult.onlyLeft((int)this.edge(2, 3), (int)this.edge(3, 4)));
        this.checkResult(3, 0.99, 3.0, DirectionResolverResult.onlyRight((int)this.edge(2, 3), (int)this.edge(3, 4)));
    }

    @Test
    public void twoOutOneIn_oneWayRight() {
        this.addNode(0, 0.0, 0.0);
        this.addNode(1, 1.0, 1.0);
        this.addNode(2, 2.0, 2.0);
        this.addEdge(0, 1, true);
        this.addEdge(1, 2, false);
        this.checkResult(1, 0.99, 1.0, DirectionResolverResult.onlyRight((int)0, (int)1));
        this.checkResult(1, 1.01, 1.0, DirectionResolverResult.onlyLeft((int)0, (int)1));
    }

    @Test
    public void twoOutOneIn_oneWayLeft() {
        this.addNode(0, 0.0, 0.0);
        this.addNode(1, 1.0, 1.0);
        this.addNode(2, 2.0, 2.0);
        this.addEdge(1, 0, false);
        this.addEdge(1, 2, true);
        this.checkResult(1, 0.99, 1.0, DirectionResolverResult.onlyLeft((int)1, (int)0));
        this.checkResult(1, 1.01, 1.0, DirectionResolverResult.onlyRight((int)1, (int)0));
    }

    @Test
    public void twoInOneOut_oneWayRight() {
        this.addNode(0, 0.0, 0.0);
        this.addNode(1, 1.0, 1.0);
        this.addNode(2, 2.0, 2.0);
        this.addEdge(0, 1, true);
        this.addEdge(2, 1, false);
        this.checkResult(1, 0.99, 1.0, DirectionResolverResult.onlyLeft((int)1, (int)0));
        this.checkResult(1, 1.01, 1.0, DirectionResolverResult.onlyRight((int)1, (int)0));
    }

    @Test
    public void twoInOneOut_oneWayLeft() {
        this.addNode(0, 0.0, 0.0);
        this.addNode(1, 1.0, 1.0);
        this.addNode(2, 2.0, 2.0);
        this.addEdge(0, 1, false);
        this.addEdge(2, 1, true);
        this.checkResult(1, 0.99, 1.0, DirectionResolverResult.onlyRight((int)0, (int)1));
        this.checkResult(1, 1.01, 1.0, DirectionResolverResult.onlyLeft((int)0, (int)1));
    }

    private void addNode(int nodeId, double lat, double lon) {
        this.na.setNode(nodeId, lat, lon);
    }

    private EdgeIteratorState addEdge(int from, int to, boolean bothDirections) {
        return GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)bothDirections, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(from, to).setDistance(1.0));
    }

    private boolean isAccessible(EdgeIteratorState edge, boolean reverse) {
        return reverse ? edge.getReverse(this.accessEnc) : edge.get(this.accessEnc);
    }

    private void checkResult(int node, DirectionResolverResult expectedResult) {
        this.checkResult(node, this.graph.getNodeAccess().getLat(node), this.graph.getNodeAccess().getLon(node), expectedResult);
    }

    private void checkResult(int node, double lat, double lon, DirectionResolverResult expectedResult) {
        DirectionResolver resolver = new DirectionResolver((Graph)this.graph, this::isAccessible);
        Assertions.assertEquals((Object)expectedResult, (Object)resolver.resolveDirections(node, new GHPoint(lat, lon)));
    }

    private int edge(int from, int to) {
        EdgeExplorer explorer = this.graph.createEdgeExplorer((EdgeFilter)AccessFilter.outEdges((BooleanEncodedValue)this.accessEnc));
        EdgeIterator iter = explorer.setBaseNode(from);
        while (iter.next()) {
            if (iter.getAdjNode() != to) continue;
            return iter.getEdge();
        }
        throw new IllegalStateException("Could not find edge from: " + from + ", to: " + to);
    }
}

