/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.GHUtility;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeBasedRoutingAlgorithmTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeBasedRoutingAlgorithmTest.class);
    private DecimalEncodedValue speedEnc;
    private DecimalEncodedValue turnCostEnc;
    private TurnCostStorage tcs;

    private void initGraph(Graph graph) {
        graph.edge(0, 1).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(0, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(1, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(2, 5).setDistance(5.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(3, 6).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(4, 7).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(6, 7).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
    }

    private EncodingManager createEncodingManager(boolean restrictedOnly) {
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.turnCostEnc = TurnCost.create((String)"car", (int)(restrictedOnly ? 1 : 3));
        return EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();
    }

    public Path calcPath(Graph g, int from, int to, String algoStr) {
        return this.createAlgo(g, this.createWeighting(), algoStr, TraversalMode.EDGE_BASED).calcPath(from, to);
    }

    public RoutingAlgorithm createAlgo(Graph g, Weighting weighting, String algoStr, TraversalMode traversalMode) {
        AlgorithmOptions opts = new AlgorithmOptions().setTraversalMode(traversalMode).setAlgorithm(algoStr);
        return new RoutingAlgorithmFactorySimple().createAlgo(g, weighting, opts);
    }

    private BaseGraph createStorage(EncodingManager em) {
        BaseGraph graph = new BaseGraph.Builder(em).withTurnCosts(true).create();
        this.tcs = graph.getTurnCostStorage();
        return graph;
    }

    private void initTurnRestrictions(BaseGraph g) {
        this.setTurnRestriction(g, 2, 3, 6);
        this.setTurnRestriction(g, 2, 3, 1);
        this.setTurnRestriction(g, 5, 2, 0);
        this.setTurnRestriction(g, 7, 6, 5);
        this.setTurnRestriction(g, 5, 6, 3);
        this.setTurnRestriction(g, 4, 3, 1);
        this.setTurnRestriction(g, 4, 3, 2);
        this.setTurnRestriction(g, 6, 7, 6);
        this.setTurnRestriction(g, 3, 6, 3);
    }

    private Weighting createWeighting() {
        return this.createWeighting(Double.POSITIVE_INFINITY);
    }

    private Weighting createWeighting(double uTurnCosts) {
        return new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.tcs, uTurnCosts);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testRandomGraph(String algoStr) {
        long seed = System.nanoTime();
        int numQueries = 100;
        Random rnd = new Random(seed);
        EncodingManager em = this.createEncodingManager(false);
        BaseGraph g = this.createStorage(em);
        GHUtility.buildRandomGraph((Graph)g, (Random)rnd, (int)50, (double)2.2, (boolean)true, (DecimalEncodedValue)this.speedEnc, null, (double)0.8, (double)0.8);
        GHUtility.addRandomTurnCosts((Graph)g, (long)seed, null, (DecimalEncodedValue)this.turnCostEnc, (int)3, (TurnCostStorage)this.tcs);
        g.freeze();
        int numPathsNotFound = 0;
        ArrayList<CallSite> strictViolations = new ArrayList<CallSite>();
        for (int i = 0; i < 100; ++i) {
            double weight;
            int from = rnd.nextInt(g.getNodes());
            int to = rnd.nextInt(g.getNodes());
            Weighting w = this.createWeighting();
            Dijkstra refAlgo = new Dijkstra((Graph)g, w, TraversalMode.EDGE_BASED);
            Path refPath = refAlgo.calcPath(from, to);
            double refWeight = refPath.getWeight();
            if (!refPath.isFound()) {
                ++numPathsNotFound;
                continue;
            }
            Path path = this.calcPath((Graph)g, from, to, algoStr);
            if (!path.isFound()) {
                Assertions.fail((String)("path not found for " + from + "->" + to + ", expected weight: " + refWeight));
            }
            if (Math.abs(refWeight - (weight = path.getWeight())) > 0.01) {
                LOGGER.warn("expected: " + String.valueOf(refPath.calcNodes()));
                LOGGER.warn("given:    " + String.valueOf(path.calcNodes()));
                Assertions.fail((String)("wrong weight: " + from + "->" + to + ", dijkstra: " + refWeight + " vs. " + algoStr + ": " + path.getWeight()));
            }
            if (Math.abs(path.getDistance() - refPath.getDistance()) > 0.1) {
                strictViolations.add((CallSite)((Object)("wrong distance " + from + "->" + to + ", expected: " + refPath.getDistance() + ", given: " + path.getDistance())));
            }
            if (Math.abs(path.getTime() - refPath.getTime()) <= 50L) continue;
            strictViolations.add((CallSite)((Object)("wrong time " + from + "->" + to + ", expected: " + refPath.getTime() + ", given: " + path.getTime())));
        }
        if ((double)numPathsNotFound > 90.0) {
            Assertions.fail((String)("Too many paths not found: " + numPathsNotFound + "/100"));
        }
        if ((double)strictViolations.size() > 5.0) {
            Assertions.fail((String)("Too many strict violations: " + strictViolations.size() + "/100\n" + String.join((CharSequence)"\n", strictViolations)));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testBasicTurnRestriction(String algoStr) {
        BaseGraph g = this.createStorage(this.createEncodingManager(true));
        this.initGraph((Graph)g);
        this.initTurnRestrictions(g);
        Path p = this.calcPath((Graph)g, 5, 1, algoStr);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 2, 3, 4, 7, 6, 3, 1}), (Object)p.calcNodes());
        p = this.calcPath((Graph)g, 5, 7, algoStr);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 7}), (Object)p.calcNodes());
        p = this.calcPath((Graph)g, 7, 5, algoStr);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 6, 3, 2, 5}), (Object)p.calcNodes());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testTurnCosts_timeCalculation(String algoStr) {
        BaseGraph graph = this.createStorage(this.createEncodingManager(false));
        int distance = 60;
        int turnCosts = 2;
        graph.edge(0, 1).setDistance(60.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(1, 2).setDistance(60.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(2, 3).setDistance(60.0).set(this.speedEnc, 10.0, 10.0);
        graph.edge(3, 4).setDistance(60.0).set(this.speedEnc, 10.0, 10.0);
        this.setTurnCost(graph, 2.0, 1, 2, 3);
        Path p14 = this.calcPath((Graph)graph, 1, 4, algoStr);
        this.assertDistTimeWeight(p14, 3, 60.0, 6.0, 2);
        Assertions.assertEquals((double)20.0, (double)p14.getWeight(), (double)1.0E-6);
        Assertions.assertEquals((long)20000L, (long)p14.getTime());
        Path p04 = this.calcPath((Graph)graph, 0, 4, algoStr);
        this.assertDistTimeWeight(p04, 4, 60.0, 6.0, 2);
        Assertions.assertEquals((double)26.0, (double)p04.getWeight(), (double)1.0E-6);
        Assertions.assertEquals((long)26000L, (long)p04.getTime());
    }

    private void assertDistTimeWeight(Path path, int numEdges, double distPerEdge, double weightPerEdge, int turnCost) {
        Assertions.assertEquals((double)((double)numEdges * distPerEdge), (double)path.getDistance(), (double)1.0E-6, (String)"wrong distance");
        Assertions.assertEquals((double)((double)numEdges * weightPerEdge + (double)turnCost), (double)path.getWeight(), (double)1.0E-6, (String)"wrong weight");
        Assertions.assertEquals((double)(1000.0 * ((double)numEdges * weightPerEdge + (double)turnCost)), (double)path.getTime(), (double)1.0E-6, (String)"wrong time");
    }

    private void blockNode3(BaseGraph g) {
        this.setTurnRestriction(g, 2, 3, 1);
        this.setTurnRestriction(g, 2, 3, 4);
        this.setTurnRestriction(g, 4, 3, 1);
        this.setTurnRestriction(g, 4, 3, 2);
        this.setTurnRestriction(g, 6, 3, 1);
        this.setTurnRestriction(g, 6, 3, 4);
        this.setTurnRestriction(g, 1, 3, 6);
        this.setTurnRestriction(g, 1, 3, 2);
        this.setTurnRestriction(g, 1, 3, 4);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testBlockANode(String algoStr) {
        BaseGraph g = this.createStorage(this.createEncodingManager(true));
        this.initGraph((Graph)g);
        this.blockNode3(g);
        for (int i = 0; i <= 7; ++i) {
            if (i == 3) continue;
            for (int j = 0; j <= 7; ++j) {
                if (j == 3) continue;
                Path p = this.calcPath((Graph)g, i, j, algoStr);
                Assertions.assertTrue((boolean)p.isFound());
                for (IntCursor node : p.calcNodes()) {
                    Assertions.assertNotEquals((int)3, (int)node.value, (String)p.calcNodes().toString());
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testUTurns(String algoStr) {
        BaseGraph g = this.createStorage(this.createEncodingManager(true));
        this.initGraph((Graph)g);
        GHUtility.getEdge((Graph)g, (int)3, (int)6).setDistance(1.0);
        GHUtility.getEdge((Graph)g, (int)3, (int)2).setDistance(8640.0);
        GHUtility.getEdge((Graph)g, (int)1, (int)0).setDistance(8640.0);
        this.setTurnRestriction(g, 7, 6, 5);
        this.setTurnRestriction(g, 4, 3, 6);
        Path p = this.createAlgo((Graph)g, this.createWeighting(50.0), algoStr, TraversalMode.EDGE_BASED).calcPath(7, 5);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 6, 3, 6, 5}), (Object)p.calcNodes());
        Assertions.assertEquals((double)22.0, (double)p.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)52.2, (double)p.getWeight(), (double)1.0E-6);
        Assertions.assertEquals((double)52200.0, (double)p.getTime(), (double)1.0E-6);
        p = this.calcPath((Graph)g, 7, 5, algoStr);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 6, 3, 2, 5}), (Object)p.calcNodes());
        Assertions.assertEquals((double)8656.0, (double)p.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)865.6, (double)p.getWeight(), (double)1.0E-6);
        this.setTurnRestriction(g, 6, 3, 6);
        p = this.createAlgo((Graph)g, this.createWeighting(1000.0), algoStr, TraversalMode.EDGE_BASED).calcPath(7, 5);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 6, 3, 2, 5}), (Object)p.calcNodes());
        Assertions.assertEquals((double)8656.0, (double)p.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)865.6, (double)p.getWeight(), (double)1.0E-6);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void uTurnCostAtMeetingNode(String algoStr) {
        BaseGraph g = this.createStorage(this.createEncodingManager(false));
        g.edge(0, 1).setDistance(100.0).set(this.speedEnc, 10.0, 0.0);
        g.edge(1, 2).setDistance(100.0).set(this.speedEnc, 10.0, 0.0);
        g.edge(2, 3).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        g.edge(2, 4).setDistance(100.0).set(this.speedEnc, 10.0, 0.0);
        g.edge(4, 5).setDistance(100.0).set(this.speedEnc, 10.0, 0.0);
        this.setTurnRestriction(g, 1, 2, 4);
        Path path = this.calcPath((Graph)g, 0, 5, algoStr);
        Assertions.assertFalse((boolean)path.isFound());
        path = this.createAlgo((Graph)g, this.createWeighting(67.0), algoStr, TraversalMode.EDGE_BASED).calcPath(0, 5);
        Assertions.assertEquals((double)600.0, (double)path.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)127.0, (double)path.getWeight(), (double)1.0E-6);
        Assertions.assertEquals((double)127000.0, (double)path.getTime(), (double)1.0E-6);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testBasicTurnCosts(String algoStr) {
        BaseGraph g = this.createStorage(this.createEncodingManager(false));
        this.initGraph((Graph)g);
        Path p = this.calcPath((Graph)g, 5, 1, algoStr);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 2, 3, 1}), (Object)p.calcNodes());
        GHUtility.getEdge((Graph)g, (int)5, (int)6).setDistance(20.0);
        this.setTurnCost(g, 2.0, 5, 2, 3);
        p = this.calcPath((Graph)g, 5, 1, algoStr);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 3, 1}), (Object)p.calcNodes());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testTurnCostsBug_991(String algoStr) {
        final BaseGraph g = this.createStorage(this.createEncodingManager(false));
        g.edge(0, 1).setDistance(3.0).set(this.speedEnc, 10.0, 10.0);
        g.edge(0, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        g.edge(1, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        g.edge(2, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        g.edge(3, 4).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        g.edge(2, 5).setDistance(0.5).set(this.speedEnc, 10.0, 10.0);
        g.edge(3, 6).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        g.edge(4, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        g.edge(5, 6).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        g.edge(6, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.setTurnCost(g, 2.0, 5, 2, 3);
        this.setTurnCost(g, 2.0, 2, 0, 1);
        this.setTurnCost(g, 2.0, 5, 6, 3);
        this.setTurnCost(g, 1.0, 6, 7, 4);
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.tcs, Double.POSITIVE_INFINITY){

            public double calcTurnWeight(int edgeFrom, int nodeVia, int edgeTo) {
                if (edgeFrom >= 0) {
                    Assertions.assertNotNull((Object)g.getEdgeIteratorState(edgeFrom, nodeVia), (String)("edge " + edgeFrom + " to " + nodeVia + " does not exist"));
                }
                if (edgeTo >= 0) {
                    Assertions.assertNotNull((Object)g.getEdgeIteratorState(edgeTo, nodeVia), (String)("edge " + edgeTo + " to " + nodeVia + " does not exist"));
                }
                return super.calcTurnWeight(edgeFrom, nodeVia, edgeTo);
            }
        };
        Path p = this.createAlgo((Graph)g, (Weighting)weighting, algoStr, TraversalMode.EDGE_BASED).calcPath(5, 1);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 7, 4, 3, 1}), (Object)p.calcNodes());
        Assertions.assertEquals((double)1.5, (double)p.getWeight(), (double)1.0E-6);
        Assertions.assertEquals((double)1500.0, (double)p.getTime(), (double)0.1);
    }

    private void setTurnRestriction(BaseGraph g, int from, int via, int to) {
        this.setTurnCost(g, Double.POSITIVE_INFINITY, from, via, to);
    }

    private void setTurnCost(BaseGraph g, double cost, int from, int via, int to) {
        g.getTurnCostStorage().set(this.turnCostEnc, GHUtility.getEdge((Graph)g, (int)from, (int)via).getEdge(), via, GHUtility.getEdge((Graph)g, (int)via, (int)to).getEdge(), cost);
    }

    private static class FixtureProvider
    implements ArgumentsProvider {
        private FixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of("dijkstra", "dijkstrabi", "astar", "astarbi").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

