/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.HeadingResolver;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEuclidean;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HeadingResolverTest {
    HeadingResolverTest() {
    }

    @Test
    public void straightEdges() {
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 49.5073, 1.5545);
        na.setNode(1, 49.5002, 2.3895);
        na.setNode(2, 49.4931, 3.3013);
        na.setNode(3, 48.8574, 3.2025);
        na.setNode(4, 48.2575, 3.0651);
        na.setNode(5, 48.2393, 2.2576);
        na.setNode(6, 48.2246, 1.2249);
        na.setNode(7, 48.8611, 1.2194);
        na.setNode(8, 48.8538, 2.395);
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(8, 0).setDistance(10.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(8, 1).setDistance(10.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(8, 2).setDistance(10.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(8, 3).setDistance(10.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(8, 4).setDistance(10.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(8, 5).setDistance(10.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(8, 6).setDistance(10.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(8, 7).setDistance(10.0));
        HeadingResolver resolver = new HeadingResolver((Graph)graph);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 6, 0}), (Object)resolver.getEdgesWithDifferentHeading(8, 90.0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 6, 0}), (Object)resolver.setTolerance(100.0).getEdgesWithDifferentHeading(8, 90.0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 6, 5, 4, 2, 1, 0}), (Object)resolver.setTolerance(10.0).getEdgesWithDifferentHeading(8, 90.0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 6, 5, 1, 0}), (Object)resolver.setTolerance(60.0).getEdgesWithDifferentHeading(8, 90.0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1}), (Object)resolver.setTolerance(170.0).getEdgesWithDifferentHeading(8, 180.0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2, 1, 0}), (Object)resolver.setTolerance(130.0).getEdgesWithDifferentHeading(8, 180.0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4, 3}), (Object)resolver.setTolerance(90.0).getEdgesWithDifferentHeading(8, 315.0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{6, 5, 4, 3, 2}), (Object)resolver.setTolerance(50.0).getEdgesWithDifferentHeading(8, 315.0));
    }

    @Test
    public void curvyEdge() {
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(1, 0.01, 0.0);
        na.setNode(0, 0.0, 0.0);
        na.setNode(2, -0.01, 0.0);
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(0, 1).setDistance(10.0)).setWayGeometry(Helper.createPointList((double[])new double[]{0.0, 0.01, 0.01, 0.01}));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(0, 2).setDistance(10.0)).setWayGeometry(Helper.createPointList((double[])new double[]{0.0, -0.01, -0.01, -0.01}));
        HeadingResolver resolver = new HeadingResolver((Graph)graph);
        resolver.setTolerance(120.0);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1}), (Object)resolver.getEdgesWithDifferentHeading(0, 90.0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0}), (Object)resolver.getEdgesWithDifferentHeading(0, 270.0));
    }

    @Test
    public void withQueryGraph() {
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 48.8611, 1.2194);
        na.setNode(1, 48.8538, 2.395);
        EdgeIteratorState edge = GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)graph.edge(0, 1).setDistance(10.0));
        Snap snap = this.createSnap(edge, 48.859, 2.0, 0);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)graph, (Snap)snap);
        HeadingResolver resolver = new HeadingResolver((Graph)queryGraph);
        Assertions.assertEquals((Object)"0->2", (Object)queryGraph.getEdgeIteratorState(1, Integer.MIN_VALUE).toString());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1}), (Object)resolver.getEdgesWithDifferentHeading(2, 90.0));
        Assertions.assertEquals((Object)"2->1", (Object)queryGraph.getEdgeIteratorState(2, Integer.MIN_VALUE).toString());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2}), (Object)resolver.getEdgesWithDifferentHeading(2, 270.0));
    }

    private Snap createSnap(EdgeIteratorState closestEdge, double lat, double lon, int wayIndex) {
        Snap snap = new Snap(lat, lon);
        snap.setClosestEdge(closestEdge);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.setWayIndex(wayIndex);
        snap.calcSnappedPoint((DistanceCalc)new DistanceCalcEuclidean());
        return snap;
    }
}

