/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.Router;
import com.graphhopper.routing.RouterConfig;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadClassLink;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HeadingRoutingTest {
    HeadingRoutingTest() {
    }

    @Test
    public void headingTest1() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Subnetwork.create((String)"profile")).build();
        BaseGraph graph = this.createSquareGraph(encodingManager, accessEnc, speedEnc);
        Router router = this.createRouter(graph, encodingManager);
        GHPoint start = new GHPoint(0.0015, 0.002);
        GHPoint end = new GHPoint(0.002, 5.0E-4);
        GHRequest req = new GHRequest().setPoints(Arrays.asList(start, end)).setHeadings(Arrays.asList(180.0, Double.NaN)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
        GHResponse response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        Assertions.assertArrayEquals((int[])new int[]{4, 5, 8, 3, 2}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
    }

    @Test
    public void headingTest2() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Subnetwork.create((String)"profile")).build();
        BaseGraph graph = this.createSquareGraph(encodingManager, accessEnc, speedEnc);
        Router router = this.createRouter(graph, encodingManager);
        GHPoint start = new GHPoint(0.0015, 0.002);
        GHPoint end = new GHPoint(0.002, 5.0E-4);
        GHRequest req = new GHRequest(start, end).setHeadings(Arrays.asList(180.0, 90.0)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
        GHResponse response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertArrayEquals((int[])new int[]{4, 5, 8, 1, 2, 3}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
        req.setAlgorithm("dijkstra");
        response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        Assertions.assertArrayEquals((int[])new int[]{4, 5, 8, 1, 2, 3}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
    }

    @Test
    public void headingTest3() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Subnetwork.create((String)"profile")).build();
        BaseGraph graph = this.createSquareGraph(encodingManager, accessEnc, speedEnc);
        Router router = this.createRouter(graph, encodingManager);
        GHPoint start = new GHPoint(0.0015, 0.002);
        GHPoint via = new GHPoint(5.0E-4, 0.001);
        GHPoint end = new GHPoint(0.002, 5.0E-4);
        GHRequest req = new GHRequest().setPoints(Arrays.asList(start, via, end)).setHeadings(Arrays.asList(Double.NaN, 0.0, Double.NaN)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
        GHResponse response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertArrayEquals((int[])new int[]{4, 5, 6, 7, 7, 8, 3, 2}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
    }

    @Test
    public void headingTest4() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Subnetwork.create((String)"profile")).build();
        BaseGraph graph = this.createSquareGraph(encodingManager, accessEnc, speedEnc);
        Router router = this.createRouter(graph, encodingManager);
        GHPoint start = new GHPoint(0.0015, 0.002);
        GHPoint end = new GHPoint(0.002, 5.0E-4);
        GHPoint via = new GHPoint(0.0015, 0.001);
        GHRequest req = new GHRequest().setPoints(Arrays.asList(start, via, end)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
        req.putHint("pass_through", (Object)true);
        GHResponse response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertEquals((int)1, (int)response.getAll().size());
        Assertions.assertArrayEquals((int[])new int[]{5, 4, 3, 3, 8, 1, 2, 3}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
    }

    @Test
    public void headingTest5() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Subnetwork.create((String)"profile")).build();
        BaseGraph graph = this.createSquareGraph(encodingManager, accessEnc, speedEnc);
        Router router = this.createRouter(graph, encodingManager);
        GHPoint start = new GHPoint(0.0015, 0.002);
        GHPoint via = new GHPoint(0.0, 0.0015);
        GHPoint end = new GHPoint(0.002, 5.0E-4);
        GHRequest req = new GHRequest().setPoints(Arrays.asList(start, via, end)).setHeadings(Arrays.asList(0.0, 90.0, Double.NaN)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
        req.putHint("pass_through", (Object)true);
        GHResponse response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertArrayEquals((int[])new int[]{5, 4, 3, 8, 7, 7, 6, 5, 4, 3, 2}, (int[])this.calcNodes((Graph)graph, response.getBest()));
    }

    @Test
    public void testHeadingWithSnapFilter() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Subnetwork.create((String)"profile")).build();
        BaseGraph graph = this.createSquareGraphWithTunnel(encodingManager, accessEnc, speedEnc);
        Router router = this.createRouter(graph, encodingManager);
        GHPoint start = new GHPoint(0.0011, 0.001);
        GHPoint end = new GHPoint(0.002, 5.0E-4);
        GHRequest req = new GHRequest().setPoints(Arrays.asList(start, end)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
        req.putHint("pass_through", (Object)true);
        GHResponse response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertArrayEquals((int[])new int[]{8, 3, 2}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
        req = new GHRequest().setPoints(Arrays.asList(start, end)).setHeadings(Arrays.asList(0.0)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
        req.putHint("pass_through", (Object)true);
        response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertArrayEquals((int[])new int[]{8, 3, 2}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
        req = new GHRequest().setPoints(Arrays.asList(start, end)).setHeadings(Arrays.asList(90.0, Double.NaN)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
        req.putHint("pass_through", (Object)true);
        response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertArrayEquals((int[])new int[]{1, 5, 4, 3, 2}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
        for (double angle = 0.0; angle < 360.0; angle += 10.0) {
            int[] nArray;
            if (angle >= 60.0 && angle <= 120.0) continue;
            req = new GHRequest().setPoints(Arrays.asList(start, end)).setHeadings(Arrays.asList(angle, Double.NaN)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
            req.putHint("pass_through", (Object)true);
            response = router.route(req);
            Assertions.assertFalse((boolean)response.hasErrors());
            if (angle >= 130.0 && angle <= 250.0) {
                int[] nArray2 = new int[7];
                nArray2[0] = 3;
                nArray2[1] = 8;
                nArray2[2] = 7;
                nArray2[3] = 0;
                nArray2[4] = 1;
                nArray2[5] = 2;
                nArray = nArray2;
                nArray2[6] = 3;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 8;
                nArray3[1] = 3;
                nArray = nArray3;
                nArray3[2] = 2;
            }
            int[] expectedNodes = nArray;
            Assertions.assertArrayEquals((int[])expectedNodes, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)), (String)("angle: " + angle));
        }
    }

    @Test
    public void testHeadingWithSnapFilter2() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Subnetwork.create((String)"profile")).build();
        BaseGraph graph = this.createSquareGraphWithTunnel(encodingManager, accessEnc, speedEnc);
        Router router = this.createRouter(graph, encodingManager);
        GHPoint start = new GHPoint(0.001, 0.0011);
        GHPoint end = new GHPoint(0.002, 5.0E-4);
        GHRequest req = new GHRequest().setPoints(Arrays.asList(start, end)).setProfile("profile").setHeadings(Arrays.asList(0.0)).setPathDetails(Collections.singletonList("edge_key"));
        req.putHint("pass_through", (Object)true);
        GHResponse response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertArrayEquals((int[])new int[]{8, 3, 2}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
        req = new GHRequest().setPoints(Arrays.asList(start, end)).setProfile("profile").setHeadings(Arrays.asList(180.0)).setPathDetails(Collections.singletonList("edge_key"));
        req.putHint("pass_through", (Object)true);
        response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertArrayEquals((int[])new int[]{8, 3, 2}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
    }

    @Test
    public void headingTest6() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Subnetwork.create((String)"profile")).build();
        BaseGraph graph = this.createSquareGraph(encodingManager, accessEnc, speedEnc);
        Router router = this.createRouter(graph, encodingManager);
        GHPoint start = new GHPoint(0.0, 0.0);
        GHPoint via = new GHPoint(0.002, 0.0);
        GHPoint end = new GHPoint(0.002, 0.002);
        GHRequest req = new GHRequest().setPoints(Arrays.asList(start, via, end)).setHeadings(Arrays.asList(90.0, 270.0, 270.0)).setProfile("profile").setPathDetails(Collections.singletonList("edge_key"));
        GHResponse response = router.route(req);
        Assertions.assertFalse((boolean)response.hasErrors());
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])this.calcNodes((Graph)graph, (ResponsePath)response.getAll().get(0)));
    }

    private Router createRouter(BaseGraph graph, EncodingManager encodingManager) {
        LocationIndexTree locationIndex = new LocationIndexTree((Graph)graph, (Directory)new RAMDirectory());
        locationIndex.prepareIndex();
        HashMap<String, Profile> profilesByName = new HashMap<String, Profile>();
        profilesByName.put("profile", TestProfiles.accessAndSpeed((String)"profile", (String)"car"));
        return new Router(graph.getBaseGraph(), encodingManager, (LocationIndex)locationIndex, profilesByName, new PathDetailsBuilderFactory(), new TranslationMap().doImport(), new RouterConfig(), (WeightingFactory)new DefaultWeightingFactory(graph.getBaseGraph(), encodingManager), Collections.emptyMap(), Collections.emptyMap());
    }

    private BaseGraph createSquareGraph(EncodingManager encodingManager, BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc) {
        BaseGraph g = new BaseGraph.Builder(encodingManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.001, 0.0);
        na.setNode(2, 0.002, 0.0);
        na.setNode(3, 0.002, 0.001);
        na.setNode(4, 0.002, 0.002);
        na.setNode(5, 0.001, 0.002);
        na.setNode(6, 0.0, 0.002);
        na.setNode(7, 0.0, 0.001);
        na.setNode(8, 0.001, 0.001);
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(0, 1).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(1, 2).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(2, 3).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(3, 4).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(4, 5).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(5, 6).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(6, 7).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(7, 0).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(1, 8).setDistance(110.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(3, 8).setDistance(110.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(5, 8).setDistance(110.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(7, 8).setDistance(110.0));
        return g;
    }

    private BaseGraph createSquareGraphWithTunnel(EncodingManager encodingManager, BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc) {
        BaseGraph g = new BaseGraph.Builder(encodingManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.001, 0.0);
        na.setNode(2, 0.002, 0.0);
        na.setNode(3, 0.002, 0.001);
        na.setNode(4, 0.002, 0.002);
        na.setNode(5, 0.001, 0.002);
        na.setNode(6, 0.0, 0.002);
        na.setNode(7, 0.0, 0.001);
        na.setNode(8, 0.001, 0.001);
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(0, 1).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(1, 2).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(2, 3).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(3, 4).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(4, 5).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(5, 6).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(6, 7).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(7, 0).setDistance(100.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)false, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(1, 5).setDistance(110.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(3, 8).setDistance(110.0));
        GHUtility.setSpeed((double)60.0, (boolean)true, (boolean)true, (BooleanEncodedValue)accessEnc, (DecimalEncodedValue)speedEnc, (EdgeIteratorState)g.edge(7, 8).setDistance(110.0));
        return g;
    }

    private int[] calcNodes(Graph graph, ResponsePath responsePath) {
        List edgeKeys = (List)responsePath.getPathDetails().get("edge_key");
        int[] result = new int[edgeKeys.size() + 1];
        for (int i = 0; i < edgeKeys.size(); ++i) {
            EdgeIteratorState edgeIteratorState = graph.getEdgeIteratorStateForKey(((Integer)((PathDetail)edgeKeys.get(i)).getValue()).intValue());
            result[i] = edgeIteratorState.getBaseNode();
            if (i != edgeKeys.size() - 1) continue;
            result[edgeKeys.size()] = edgeIteratorState.getAdjNode();
        }
        return result;
    }
}

