/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.InstructionsFromEdges;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathExtractor;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.Orientation;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadClassLink;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.util.parsers.OrientationCalculator;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.AbstractGraphStorageTester;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.TranslationMapTest;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.details.PathDetailsFromEdges;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathTest {
    private final DecimalEncodedValue carAvSpeedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
    private final EncodingManager carManager = EncodingManager.start().add((EncodedValue)this.carAvSpeedEnc).add((EncodedValue)Orientation.create()).add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)Roundabout.create()).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)MaxSpeed.create()).build();
    private final DecimalEncodedValue mixedCarSpeedEnc = new DecimalEncodedValueImpl("mixed_car_speed", 5, 5.0, true);
    private final BooleanEncodedValue mixedCarAccessEnc = VehicleAccess.create((String)"car");
    private final DecimalEncodedValue mixedFootSpeedEnc = new DecimalEncodedValueImpl("mixed_foot_speed", 4, 1.0, true);
    private final EncodingManager mixedEncodingManager = EncodingManager.start().add((EncodedValue)this.mixedCarAccessEnc).add((EncodedValue)this.mixedCarSpeedEnc).add((EncodedValue)this.mixedFootSpeedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Roundabout.create()).build();
    private final TranslationMap trMap = TranslationMapTest.SINGLETON;
    private final Translation tr = this.trMap.getWithFallBack(Locale.US);
    private final RoundaboutGraph roundaboutGraph = new RoundaboutGraph();
    private final Graph pathDetailGraph = this.generatePathDetailsGraph();

    @Test
    public void testFound() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        Path p = new Path((Graph)g);
        Assertions.assertFalse((boolean)p.isFound());
        Assertions.assertEquals((double)0.0, (double)p.getDistance(), (double)1.0E-7);
        Assertions.assertEquals((int)0, (int)p.calcNodes().size());
    }

    @Test
    public void testWayList() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 0.0, 0.1);
        na.setNode(1, 1.0, 0.1);
        na.setNode(2, 2.0, 0.1);
        EdgeIteratorState edge1 = g.edge(0, 1).setDistance(1000.0).set(this.carAvSpeedEnc, 10.0, 10.0);
        edge1.setWayGeometry(Helper.createPointList((double[])new double[]{8.0, 1.0, 9.0, 1.0}));
        EdgeIteratorState edge2 = g.edge(2, 1).setDistance(2000.0).set(this.carAvSpeedEnc, 50.0, 50.0);
        edge2.setWayGeometry(Helper.createPointList((double[])new double[]{11.0, 1.0, 10.0, 1.0}));
        SPTEntry e1 = new SPTEntry(edge2.getEdge(), 2, 1.0, new SPTEntry(edge1.getEdge(), 1, 1.0, new SPTEntry(0, 1.0)));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path path = PathTest.extractPath((Graph)g, (Weighting)weighting, e1);
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{0.0, 0.1, 8.0, 1.0, 9.0, 1.0, 1.0, 0.1, 10.0, 1.0, 11.0, 1.0, 2.0, 0.1}), path.calcPoints());
        InstructionList instr = InstructionsFromEdges.calcInstructions((Path)path, (Graph)path.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Instruction tmp = instr.get(0);
        Assertions.assertEquals((double)3000.0, (double)tmp.getDistance(), (double)0.0);
        Assertions.assertEquals((long)140000L, (long)tmp.getTime());
        Assertions.assertEquals((Object)"continue", (Object)tmp.getTurnDescription(this.tr));
        Assertions.assertEquals((int)6, (int)tmp.getLength());
        tmp = instr.get(1);
        Assertions.assertEquals((double)0.0, (double)tmp.getDistance(), (double)0.0);
        Assertions.assertEquals((long)0L, (long)tmp.getTime());
        Assertions.assertEquals((Object)"arrive at destination", (Object)tmp.getTurnDescription(this.tr));
        Assertions.assertEquals((int)0, (int)tmp.getLength());
        int acc = 0;
        for (Instruction instruction : instr) {
            acc += instruction.getLength();
        }
        Assertions.assertEquals((int)(path.calcPoints().size() - 1), (int)acc);
        edge2.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"2")));
        na.setNode(3, 1.0, 1.0);
        g.edge(1, 3).setDistance(1000.0).set(this.carAvSpeedEnc, 10.0, 10.0);
        e1 = new SPTEntry(edge2.getEdge(), 2, 1.0, new SPTEntry(edge1.getEdge(), 1, 1.0, new SPTEntry(0, 1.0)));
        path = PathTest.extractPath((Graph)g, (Weighting)weighting, e1);
        instr = InstructionsFromEdges.calcInstructions((Path)path, (Graph)path.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        tmp = instr.get(0);
        Assertions.assertEquals((double)1000.0, (double)tmp.getDistance(), (double)0.0);
        Assertions.assertEquals((long)100000L, (long)tmp.getTime());
        Assertions.assertEquals((Object)"continue", (Object)tmp.getTurnDescription(this.tr));
        Assertions.assertEquals((int)3, (int)tmp.getLength());
        tmp = instr.get(1);
        Assertions.assertEquals((double)2000.0, (double)tmp.getDistance(), (double)0.0);
        Assertions.assertEquals((long)40000L, (long)tmp.getTime());
        Assertions.assertEquals((Object)"turn sharp right onto 2", (Object)tmp.getTurnDescription(this.tr));
        Assertions.assertEquals((int)3, (int)tmp.getLength());
        acc = 0;
        for (Instruction instruction : instr) {
            acc += instruction.getLength();
        }
        Assertions.assertEquals((int)(path.calcPoints().size() - 1), (int)acc);
        e1 = new SPTEntry(edge1.getEdge(), 0, 1.0, new SPTEntry(edge2.getEdge(), 1, 1.0, new SPTEntry(2, 1.0)));
        path = PathTest.extractPath((Graph)g, (Weighting)weighting, e1);
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{2.0, 0.1, 11.0, 1.0, 10.0, 1.0, 1.0, 0.1, 9.0, 1.0, 8.0, 1.0, 0.0, 0.1}), path.calcPoints());
        instr = InstructionsFromEdges.calcInstructions((Path)path, (Graph)path.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        tmp = instr.get(0);
        Assertions.assertEquals((double)2000.0, (double)tmp.getDistance(), (double)0.0);
        Assertions.assertEquals((long)40000L, (long)tmp.getTime());
        Assertions.assertEquals((Object)"continue onto 2", (Object)tmp.getTurnDescription(this.tr));
        Assertions.assertEquals((int)3, (int)tmp.getLength());
        tmp = instr.get(1);
        Assertions.assertEquals((double)1000.0, (double)tmp.getDistance(), (double)0.0);
        Assertions.assertEquals((long)100000L, (long)tmp.getTime());
        Assertions.assertEquals((Object)"turn sharp left", (Object)tmp.getTurnDescription(this.tr));
        Assertions.assertEquals((int)3, (int)tmp.getLength());
        acc = 0;
        for (Instruction instruction : instr) {
            acc += instruction.getLength();
        }
        Assertions.assertEquals((int)(path.calcPoints().size() - 1), (int)acc);
    }

    @Test
    public void testFindInstruction() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 5.0, 0.0);
        na.setNode(2, 5.0, 0.5);
        na.setNode(3, 10.0, 0.5);
        na.setNode(4, 7.5, 0.25);
        na.setNode(5, 5.0, 1.0);
        EdgeIteratorState edge1 = g.edge(0, 1).setDistance(1000.0).set(this.carAvSpeedEnc, 50.0, 50.0);
        edge1.setWayGeometry(Helper.createPointList((double[])new double[0]));
        edge1.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Street 1")));
        EdgeIteratorState edge2 = g.edge(1, 2).setDistance(1000.0).set(this.carAvSpeedEnc, 50.0, 50.0);
        edge2.setWayGeometry(Helper.createPointList((double[])new double[0]));
        edge2.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Street 2")));
        EdgeIteratorState edge3 = g.edge(2, 3).setDistance(1000.0).set(this.carAvSpeedEnc, 50.0, 50.0);
        edge3.setWayGeometry(Helper.createPointList((double[])new double[0]));
        edge3.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Street 3")));
        EdgeIteratorState edge4 = g.edge(3, 4).setDistance(500.0).set(this.carAvSpeedEnc, 50.0, 50.0);
        edge4.setWayGeometry(Helper.createPointList((double[])new double[0]));
        edge4.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Street 4")));
        g.edge(1, 5).setDistance(10000.0).set(this.carAvSpeedEnc, 50.0, 50.0);
        g.edge(2, 5).setDistance(10000.0).set(this.carAvSpeedEnc, 50.0, 50.0);
        g.edge(3, 5).setDistance(100000.0).set(this.carAvSpeedEnc, 50.0, 50.0);
        SPTEntry e1 = new SPTEntry(edge4.getEdge(), 4, 1.0, new SPTEntry(edge3.getEdge(), 3, 1.0, new SPTEntry(edge2.getEdge(), 2, 1.0, new SPTEntry(edge1.getEdge(), 1, 1.0, new SPTEntry(0, 1.0)))));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path path = PathTest.extractPath((Graph)g, (Weighting)weighting, e1);
        InstructionList il = InstructionsFromEdges.calcInstructions((Path)path, (Graph)path.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)5, (int)il.size());
        Assertions.assertEquals((int)0, (int)il.get(0).getSign());
        Assertions.assertEquals((int)2, (int)il.get(1).getSign());
        Assertions.assertEquals((int)-2, (int)il.get(2).getSign());
        Assertions.assertEquals((int)-3, (int)il.get(3).getSign());
        Assertions.assertEquals((int)4, (int)il.get(4).getSign());
    }

    @Test
    void testCalcInstructionsRoundabout() {
        this.calcInstructionsRoundabout(this.mixedCarSpeedEnc);
        this.calcInstructionsRoundabout(this.mixedFootSpeedEnc);
    }

    public void calcInstructionsRoundabout(DecimalEncodedValue speedEnc) {
        SpeedWeighting weighting = new SpeedWeighting(speedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 8);
        Assertions.assertTrue((boolean)p.isFound());
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 5, 8]", (Object)p.calcNodes().toString());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        List<String> tmpList = this.getTurnDescriptions(wayList);
        Assertions.assertEquals(List.of("continue onto MainStreet 1 2", "at roundabout, take exit 3 onto 5-8", "arrive at destination"), tmpList);
        double delta = this.roundaboutGraph.getAngle(1, 2, 5, 8);
        RoundaboutInstruction instr = (RoundaboutInstruction)wayList.get(1);
        Assertions.assertEquals((double)delta, (double)instr.getTurnAngle(), (double)0.01);
        p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 7);
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        tmpList = this.getTurnDescriptions(wayList);
        Assertions.assertEquals(List.of("continue onto MainStreet 1 2", "at roundabout, take exit 2 onto MainStreet 4 7", "arrive at destination"), tmpList);
        delta = this.roundaboutGraph.getAngle(1, 2, 4, 7);
        instr = (RoundaboutInstruction)wayList.get(1);
        Assertions.assertEquals((double)delta, (double)instr.getTurnAngle(), (double)0.01);
    }

    @Test
    public void testCalcInstructionsRoundaboutBegin() {
        SpeedWeighting weighting = new SpeedWeighting(this.mixedCarSpeedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(2, 8);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        List<String> tmpList = this.getTurnDescriptions(wayList);
        Assertions.assertEquals(List.of("at roundabout, take exit 3 onto 5-8", "arrive at destination"), tmpList);
    }

    @Test
    public void testCalcInstructionsRoundaboutDirectExit() {
        this.roundaboutGraph.inverse3to9();
        SpeedWeighting weighting = new SpeedWeighting(this.mixedCarSpeedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(6, 8);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        List<String> tmpList = this.getTurnDescriptions(wayList);
        Assertions.assertEquals(List.of("continue onto 3-6", "at roundabout, take exit 3 onto 5-8", "arrive at destination"), tmpList);
        this.roundaboutGraph.inverse3to9();
    }

    @Test
    public void testCalcAverageSpeedDetails() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 5);
        Assertions.assertTrue((boolean)p.isFound());
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("average_speed"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        Assertions.assertEquals((int)1, (int)details.size());
        List averageSpeedDetails = (List)details.get("average_speed");
        Assertions.assertEquals((int)4, (int)averageSpeedDetails.size());
        Assertions.assertEquals((double)162.2, (double)((Double)((PathDetail)averageSpeedDetails.get(0)).getValue()), (double)0.001);
        Assertions.assertEquals((double)327.3, (double)((Double)((PathDetail)averageSpeedDetails.get(1)).getValue()), (double)0.001);
        Assertions.assertEquals((double)36.0, (double)((Double)((PathDetail)averageSpeedDetails.get(2)).getValue()), (double)0.001);
        Assertions.assertEquals((double)162.2, (double)((Double)((PathDetail)averageSpeedDetails.get(3)).getValue()), (double)0.001);
        Assertions.assertEquals((int)0, (int)((PathDetail)averageSpeedDetails.get(0)).getFirst());
        Assertions.assertEquals((int)1, (int)((PathDetail)averageSpeedDetails.get(1)).getFirst());
        Assertions.assertEquals((int)2, (int)((PathDetail)averageSpeedDetails.get(2)).getFirst());
        Assertions.assertEquals((int)3, (int)((PathDetail)averageSpeedDetails.get(3)).getFirst());
        Assertions.assertEquals((int)4, (int)((PathDetail)averageSpeedDetails.get(3)).getLast());
    }

    @Test
    public void testCalcAverageSpeedDetailsWithShortDistances_issue1848() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 6);
        Assertions.assertTrue((boolean)p.isFound());
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("average_speed"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        Assertions.assertEquals((int)1, (int)details.size());
        List averageSpeedDetails = (List)details.get("average_speed");
        Assertions.assertEquals((int)4, (int)averageSpeedDetails.size());
        p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(6, 1);
        Assertions.assertTrue((boolean)p.isFound());
        details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("average_speed"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        Assertions.assertEquals((int)1, (int)details.size());
        averageSpeedDetails = (List)details.get("average_speed");
        Assertions.assertEquals((int)5, (int)averageSpeedDetails.size());
        Assertions.assertNull((Object)((PathDetail)averageSpeedDetails.get(0)).getValue());
    }

    @Test
    public void testCalcStreetNameDetails() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 5);
        Assertions.assertTrue((boolean)p.isFound());
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("street_name"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        Assertions.assertEquals((int)1, (int)details.size());
        List streetNameDetails = (List)details.get("street_name");
        Assertions.assertEquals((int)1, (int)details.size());
        Assertions.assertEquals((int)4, (int)streetNameDetails.size());
        Assertions.assertEquals((Object)"1-2", (Object)((PathDetail)streetNameDetails.get(0)).getValue());
        Assertions.assertEquals((Object)"2-3", (Object)((PathDetail)streetNameDetails.get(1)).getValue());
        Assertions.assertEquals((Object)"3-4", (Object)((PathDetail)streetNameDetails.get(2)).getValue());
        Assertions.assertEquals((Object)"4-5", (Object)((PathDetail)streetNameDetails.get(3)).getValue());
        Assertions.assertEquals((int)0, (int)((PathDetail)streetNameDetails.get(0)).getFirst());
        Assertions.assertEquals((int)1, (int)((PathDetail)streetNameDetails.get(1)).getFirst());
        Assertions.assertEquals((int)2, (int)((PathDetail)streetNameDetails.get(2)).getFirst());
        Assertions.assertEquals((int)3, (int)((PathDetail)streetNameDetails.get(3)).getFirst());
        Assertions.assertEquals((int)4, (int)((PathDetail)streetNameDetails.get(3)).getLast());
    }

    @Test
    public void testCalcEdgeIdDetails() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 5);
        Assertions.assertTrue((boolean)p.isFound());
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("edge_id"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        Assertions.assertEquals((int)1, (int)details.size());
        List edgeIdDetails = (List)details.get("edge_id");
        Assertions.assertEquals((int)4, (int)edgeIdDetails.size());
        Assertions.assertEquals((Object)0, (Object)((PathDetail)edgeIdDetails.get(0)).getValue());
        Assertions.assertEquals((Object)2, (Object)((PathDetail)edgeIdDetails.get(1)).getValue());
        Assertions.assertEquals((Object)3, (Object)((PathDetail)edgeIdDetails.get(2)).getValue());
        Assertions.assertEquals((Object)1, (Object)((PathDetail)edgeIdDetails.get(3)).getValue());
        Assertions.assertEquals((int)0, (int)((PathDetail)edgeIdDetails.get(0)).getFirst());
        Assertions.assertEquals((int)1, (int)((PathDetail)edgeIdDetails.get(1)).getFirst());
        Assertions.assertEquals((int)2, (int)((PathDetail)edgeIdDetails.get(2)).getFirst());
        Assertions.assertEquals((int)3, (int)((PathDetail)edgeIdDetails.get(3)).getFirst());
        Assertions.assertEquals((int)4, (int)((PathDetail)edgeIdDetails.get(3)).getLast());
    }

    @Test
    public void testCalcEdgeKeyDetailsForward() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 5);
        Assertions.assertTrue((boolean)p.isFound());
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("edge_key"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        List edgeKeyDetails = (List)details.get("edge_key");
        Assertions.assertEquals((int)4, (int)edgeKeyDetails.size());
        Assertions.assertEquals((Object)0, (Object)((PathDetail)edgeKeyDetails.get(0)).getValue());
        Assertions.assertEquals((Object)4, (Object)((PathDetail)edgeKeyDetails.get(1)).getValue());
        Assertions.assertEquals((Object)6, (Object)((PathDetail)edgeKeyDetails.get(2)).getValue());
        Assertions.assertEquals((Object)2, (Object)((PathDetail)edgeKeyDetails.get(3)).getValue());
    }

    @Test
    public void testCalcEdgeKeyDetailsBackward() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(5, 1);
        Assertions.assertTrue((boolean)p.isFound());
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("edge_key"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        List edgeKeyDetails = (List)details.get("edge_key");
        Assertions.assertEquals((int)4, (int)edgeKeyDetails.size());
        Assertions.assertEquals((Object)3, (Object)((PathDetail)edgeKeyDetails.get(0)).getValue());
        Assertions.assertEquals((Object)7, (Object)((PathDetail)edgeKeyDetails.get(1)).getValue());
        Assertions.assertEquals((Object)5, (Object)((PathDetail)edgeKeyDetails.get(2)).getValue());
        Assertions.assertEquals((Object)1, (Object)((PathDetail)edgeKeyDetails.get(3)).getValue());
    }

    @Test
    public void testCalcTimeDetails() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 5);
        Assertions.assertTrue((boolean)p.isFound());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5}), (Object)p.calcNodes());
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("time"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        Assertions.assertEquals((int)1, (int)details.size());
        List timeDetails = (List)details.get("time");
        Assertions.assertEquals((int)4, (int)timeDetails.size());
        Assertions.assertEquals((Object)111L, (Object)((PathDetail)timeDetails.get(0)).getValue());
        Assertions.assertEquals((Object)55L, (Object)((PathDetail)timeDetails.get(1)).getValue());
        Assertions.assertEquals((Object)1000L, (Object)((PathDetail)timeDetails.get(2)).getValue());
        Assertions.assertEquals((Object)111L, (Object)((PathDetail)timeDetails.get(3)).getValue());
        Assertions.assertEquals((int)0, (int)((PathDetail)timeDetails.get(0)).getFirst());
        Assertions.assertEquals((int)1, (int)((PathDetail)timeDetails.get(1)).getFirst());
        Assertions.assertEquals((int)2, (int)((PathDetail)timeDetails.get(2)).getFirst());
        Assertions.assertEquals((int)3, (int)((PathDetail)timeDetails.get(3)).getFirst());
        Assertions.assertEquals((int)4, (int)((PathDetail)timeDetails.get(3)).getLast());
    }

    @Test
    public void testCalcDistanceDetails() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 5);
        Assertions.assertTrue((boolean)p.isFound());
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("distance"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        Assertions.assertEquals((int)1, (int)details.size());
        List distanceDetails = (List)details.get("distance");
        Assertions.assertEquals((Object)5.0, (Object)((PathDetail)distanceDetails.get(0)).getValue());
        Assertions.assertEquals((Object)5.0, (Object)((PathDetail)distanceDetails.get(1)).getValue());
        Assertions.assertEquals((Object)10.0, (Object)((PathDetail)distanceDetails.get(2)).getValue());
        Assertions.assertEquals((Object)5.0, (Object)((PathDetail)distanceDetails.get(3)).getValue());
    }

    @Test
    public void testCalcIntersectionDetails() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 5);
        Assertions.assertTrue((boolean)p.isFound());
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("intersection"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        Assertions.assertEquals((int)1, (int)details.size());
        List intersectionDetails = (List)details.get("intersection");
        Assertions.assertEquals((int)4, (int)intersectionDetails.size());
        HashMap<String, Object> intersectionMap = new HashMap<String, Object>();
        intersectionMap.put("out", 0);
        intersectionMap.put("entries", List.of(Boolean.valueOf(true)));
        intersectionMap.put("bearings", List.of(Integer.valueOf(90)));
        Assertions.assertEquals(intersectionMap, (Object)((PathDetail)intersectionDetails.get(0)).getValue());
        intersectionMap.clear();
        intersectionMap.put("out", 0);
        intersectionMap.put("in", 1);
        intersectionMap.put("entries", List.of(Boolean.valueOf(true), Boolean.valueOf(false)));
        intersectionMap.put("bearings", List.of(Integer.valueOf(90), Integer.valueOf(270)));
        Assertions.assertEquals(intersectionMap, (Object)((PathDetail)intersectionDetails.get(1)).getValue());
    }

    @Test
    public void testChangeDetails() {
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        DecimalEncodedValue orEnc = this.carManager.getDecimalEncodedValue("orientation");
        OrientationCalculator calc = new OrientationCalculator(orEnc);
        AllEdgesIterator allEdges = this.pathDetailGraph.getAllEdges();
        EdgeIntAccess intAccess = this.pathDetailGraph.getBaseGraph().getEdgeAccess();
        while (allEdges.next()) {
            ReaderWay way = new ReaderWay((long)allEdges.getEdge());
            way.setTag("point_list", (Object)allEdges.fetchWayGeometry(FetchMode.ALL));
            calc.handleWayTags(allEdges.getEdge(), intAccess, way, null);
        }
        Path path = new Dijkstra(this.pathDetailGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 7);
        Assertions.assertTrue((boolean)path.isFound());
        Map details = PathDetailsFromEdges.calcDetails((Path)path, (EncodedValueLookup)this.carManager, (Weighting)weighting, List.of("change_angle"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)this.pathDetailGraph);
        Assertions.assertEquals((int)1, (int)details.size());
        List caDetail = (List)details.get("change_angle");
        Assertions.assertEquals((int)4, (int)caDetail.size());
        Assertions.assertNull((Object)((PathDetail)caDetail.get(0)).getValue());
        Assertions.assertEquals((Object)0.0, (Object)((PathDetail)caDetail.get(1)).getValue());
        Assertions.assertEquals((Object)-132.0, (Object)((PathDetail)caDetail.get(2)).getValue());
        Assertions.assertEquals((Object)72.0, (Object)((PathDetail)caDetail.get(3)).getValue());
    }

    @Test
    public void testCalcInstructionsRoundabout2() {
        this.roundaboutGraph.inverse3to6();
        SpeedWeighting weighting = new SpeedWeighting(this.mixedCarSpeedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 8);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        List<String> tmpList = this.getTurnDescriptions(wayList);
        Assertions.assertEquals(List.of("continue onto MainStreet 1 2", "at roundabout, take exit 2 onto 5-8", "arrive at destination"), tmpList);
        double delta = this.roundaboutGraph.getAngle(1, 2, 5, 8);
        RoundaboutInstruction instr = (RoundaboutInstruction)wayList.get(1);
        Assertions.assertEquals((double)delta, (double)instr.getTurnAngle(), (double)0.01);
        this.roundaboutGraph.inverse3to6();
    }

    @Test
    public void testCalcInstructionsRoundaboutIssue353() {
        BaseGraph graph = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(1, 52.514, 13.348);
        na.setNode(2, 52.514, 13.349);
        na.setNode(3, 52.5135, 13.35);
        na.setNode(4, 52.514, 13.351);
        na.setNode(5, 52.5145, 13.351);
        na.setNode(6, 52.513, 13.35);
        na.setNode(7, 52.514, 13.352);
        na.setNode(8, 52.515, 13.351);
        na.setNode(9, 52.5135, 13.349);
        na.setNode(10, 52.5135, 13.348);
        na.setNode(11, 52.514, 13.347);
        graph.edge(2, 1).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"MainStreet 2 1")));
        graph.edge(1, 11).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"MainStreet 1 11")));
        EdgeIteratorState tmpEdge = graph.edge(3, 9).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(2.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-9")));
        BooleanEncodedValue carManagerRoundabout = this.carManager.getBooleanEncodedValue("roundabout");
        tmpEdge.set(carManagerRoundabout, true);
        tmpEdge = graph.edge(9, 10).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(2.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"9-10")));
        tmpEdge.set(carManagerRoundabout, true);
        tmpEdge = graph.edge(6, 10).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(2.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"6-10")));
        tmpEdge.set(carManagerRoundabout, true);
        tmpEdge = graph.edge(10, 1).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(2.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"10-1")));
        tmpEdge.set(carManagerRoundabout, true);
        tmpEdge = graph.edge(3, 2).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"2-3")));
        tmpEdge.set(carManagerRoundabout, true);
        tmpEdge = graph.edge(4, 3).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-4")));
        tmpEdge.set(carManagerRoundabout, true);
        tmpEdge = graph.edge(5, 4).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"4-5")));
        tmpEdge.set(carManagerRoundabout, true);
        tmpEdge = graph.edge(2, 5).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"5-2")));
        tmpEdge.set(carManagerRoundabout, true);
        graph.edge(4, 7).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"MainStreet 4 7")));
        graph.edge(5, 8).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"5-8")));
        graph.edge(3, 6).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-6")));
        BooleanEncodedValue carAccessEncTmp = this.carManager.getBooleanEncodedValue(VehicleAccess.key((String)"car"));
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            if (iter.get(this.carAvSpeedEnc) > 0.0) {
                iter.set(carAccessEncTmp, true);
            }
            if (!(iter.getReverse(this.carAvSpeedEnc) > 0.0)) continue;
            iter.setReverse(carAccessEncTmp, true);
        }
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(6, 11);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        List<String> tmpList = this.getTurnDescriptions(wayList);
        Assertions.assertEquals(List.of("at roundabout, take exit 1 onto MainStreet 1 11", "arrive at destination"), tmpList);
    }

    @Test
    public void testCalcInstructionsRoundaboutClockwise() {
        this.roundaboutGraph.setRoundabout(true);
        SpeedWeighting weighting = new SpeedWeighting(this.mixedCarSpeedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 8);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        List<String> tmpList = this.getTurnDescriptions(wayList);
        Assertions.assertEquals(List.of("continue onto MainStreet 1 2", "at roundabout, take exit 1 onto 5-8", "arrive at destination"), tmpList);
        double delta = this.roundaboutGraph.getAngle(1, 2, 5, 8);
        RoundaboutInstruction instr = (RoundaboutInstruction)wayList.get(1);
        Assertions.assertEquals((double)delta, (double)instr.getTurnAngle(), (double)0.01);
    }

    @Test
    public void testCalcInstructionsIgnoreContinue() {
        SpeedWeighting weighting = new SpeedWeighting(this.mixedCarSpeedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(4, 11);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        Assertions.assertEquals((int)2, (int)wayList.size());
    }

    @Test
    public void testCalcInstructionsIgnoreTurnIfNoAlternative() {
        SpeedWeighting weighting = new SpeedWeighting(this.mixedCarSpeedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(10, 12);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        Assertions.assertEquals((int)2, (int)wayList.size());
    }

    @Test
    public void testCalcInstructionForForkWithSameName() {
        BaseGraph graph = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(1, 48.982618, 13.122021);
        na.setNode(2, 48.982565, 13.121597);
        na.setNode(3, 48.982611, 13.121012);
        na.setNode(4, 48.982336, 13.121002);
        graph.edge(1, 2).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Regener Weg")));
        graph.edge(2, 4).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Regener Weg")));
        graph.edge(2, 3).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0);
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 4);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)-7, (int)wayList.get(1).getSign());
    }

    @Test
    public void testCalcInstructionForMotorwayFork() {
        BaseGraph graph = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(1, 48.909071, 8.647136);
        na.setNode(2, 48.908962, 8.647978);
        na.setNode(3, 48.908867, 8.648155);
        na.setNode(4, 48.908789, 8.649244);
        EnumEncodedValue roadClassEnc = this.carManager.getEnumEncodedValue("road_class", RoadClass.class);
        BooleanEncodedValue roadClassLinkEnc = this.carManager.getBooleanEncodedValue("road_class_link");
        graph.edge(1, 2).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"A 8"))).set(roadClassEnc, (Enum)RoadClass.MOTORWAY).set(roadClassLinkEnc, false);
        graph.edge(2, 4).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"A 8"))).set(roadClassEnc, (Enum)RoadClass.MOTORWAY).set(roadClassLinkEnc, false);
        graph.edge(2, 3).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).set(roadClassEnc, (Enum)RoadClass.MOTORWAY).set(roadClassLinkEnc, true);
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 4);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)2, (int)wayList.size());
    }

    @Test
    public void testFerry() {
        BaseGraph graph = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(1, 48.909071, 8.647136);
        na.setNode(2, 48.909071, 8.647978);
        na.setNode(3, 48.909071, 8.648155);
        na.setNode(3, 48.909071, 8.6482);
        EnumEncodedValue roadEnvEnc = this.carManager.getEnumEncodedValue("road_environment", RoadEnvironment.class);
        graph.edge(1, 2).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).set(roadEnvEnc, (Enum)RoadEnvironment.ROAD).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"A B")));
        graph.edge(2, 3).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).set(roadEnvEnc, (Enum)RoadEnvironment.FERRY).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"B C")));
        graph.edge(3, 4).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).set(roadEnvEnc, (Enum)RoadEnvironment.ROAD).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"C D")));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 4);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)4, (int)wayList.size());
        Assertions.assertEquals((Object)"continue onto A B", (Object)wayList.get(0).getTurnDescription(this.tr));
        Assertions.assertEquals((Object)"Attention, take ferry (B C)", (Object)wayList.get(1).getTurnDescription(this.tr));
        Assertions.assertEquals((int)9, (int)wayList.get(1).getSign());
        Assertions.assertEquals((Object)"leave ferry and turn right onto C D", (Object)wayList.get(2).getTurnDescription(this.tr));
        Assertions.assertEquals((int)2, (int)wayList.get(2).getSign());
        Assertions.assertEquals((Object)"arrive at destination", (Object)wayList.get(3).getTurnDescription(this.tr));
    }

    @Test
    public void testCalcInstructionsEnterMotorway() {
        BaseGraph graph = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(1, 48.630647, 9.459041);
        na.setNode(2, 48.630586, 9.459604);
        na.setNode(3, 48.630558, 9.459851);
        na.setNode(4, 48.63054, 9.459406);
        graph.edge(1, 2).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"A 8")));
        graph.edge(2, 3).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"A 8")));
        graph.edge(4, 2).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"A 8")));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(4, 3);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)2, (int)wayList.size());
    }

    @Test
    public void testCalcInstructionsMotorwayJunction() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 48.70672, 9.164266);
        na.setNode(2, 48.706741, 9.163719);
        na.setNode(3, 48.706805, 9.162995);
        na.setNode(4, 48.706705, 9.16329);
        g.edge(1, 2).setDistance(5.0).set(this.carAvSpeedEnc, 60.0, 0.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"A 8")));
        g.edge(2, 3).setDistance(5.0).set(this.carAvSpeedEnc, 60.0, 0.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"A 8")));
        g.edge(2, 4).setDistance(5.0).set(this.carAvSpeedEnc, 60.0, 0.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"A 8")));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 3);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)0, (int)wayList.get(1).getSign());
    }

    @Test
    public void testCalcInstructionsOntoOneway() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, -33.824245, 151.187866);
        na.setNode(2, -33.824335, 151.188017);
        na.setNode(3, -33.824415, 151.188177);
        na.setNode(4, -33.824437, 151.187925);
        g.edge(1, 2).setDistance(5.0).set(this.carAvSpeedEnc, 60.0, 0.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Pacific Highway")));
        g.edge(2, 3).setDistance(5.0).set(this.carAvSpeedEnc, 60.0, 0.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Pacific Highway")));
        g.edge(4, 2).setDistance(5.0).set(this.carAvSpeedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Greenwich Road")));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(4, 3);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)2, (int)wayList.get(1).getSign());
    }

    @Test
    public void testCalcInstructionIssue1047() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 51.367544, 14.488209);
        na.setNode(2, 51.368046, 14.486525);
        na.setNode(3, 51.36875, 14.487019);
        na.setNode(4, 51.368428, 14.485173);
        EnumEncodedValue roadClassEnc = this.carManager.getEnumEncodedValue("road_class", RoadClass.class);
        BooleanEncodedValue roadClassLinkEnc = this.carManager.getBooleanEncodedValue("road_class_link");
        g.edge(1, 2).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"B 156"))).set(roadClassEnc, (Enum)RoadClass.PRIMARY).set(roadClassLinkEnc, false);
        g.edge(2, 4).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"S 108"))).set(roadClassEnc, (Enum)RoadClass.SECONDARY).set(roadClassLinkEnc, false);
        g.edge(2, 3).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"B 156"))).set(roadClassEnc, (Enum)RoadClass.PRIMARY).set(roadClassLinkEnc, false);
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 4);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 3);
        Assertions.assertTrue((boolean)p.isFound());
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
    }

    @Test
    public void testCalcInstructionContinueLeavingStreet() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 48.982618, 13.122021);
        na.setNode(2, 48.982565, 13.121597);
        na.setNode(3, 48.982611, 13.121012);
        na.setNode(4, 48.982565, 13.121002);
        g.edge(1, 2).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Regener Weg")));
        g.edge(2, 4).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0);
        g.edge(2, 3).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Regener Weg")));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 4);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)-7, (int)wayList.get(1).getSign());
    }

    @Test
    public void testCalcInstructionSlightTurn() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 48.412094, 15.598816);
        na.setNode(2, 48.412055, 15.599068);
        na.setNode(3, 48.412034, 15.599411);
        na.setNode(4, 48.411927, 15.599197);
        g.edge(1, 2).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"St\u00f6hrgasse")));
        g.edge(2, 3).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0);
        g.edge(2, 4).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"St\u00f6hrgasse")));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(4, 1);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)-1, (int)wayList.get(1).getSign());
    }

    @Test
    public void testUTurnLeft() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 48.402116, 9.994367);
        na.setNode(2, 48.402198, 9.99507);
        na.setNode(3, 48.402344, 9.996266);
        na.setNode(4, 48.402191, 9.994351);
        na.setNode(5, 48.402298, 9.995053);
        na.setNode(6, 48.402422, 9.996067);
        na.setNode(7, 48.402604, 9.994962);
        g.edge(1, 2).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Olgastra\u00dfe")));
        g.edge(2, 3).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Olgastra\u00dfe")));
        g.edge(6, 5).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Olgastra\u00dfe")));
        g.edge(5, 4).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Olgastra\u00dfe")));
        g.edge(2, 5).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Neithardtstra\u00dfe")));
        g.edge(5, 7).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Neithardtstra\u00dfe")));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 4);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)-8, (int)wayList.get(1).getSign());
    }

    @Test
    public void testUTurnRight() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, -33.885758, 151.181472);
        na.setNode(2, -33.885852, 151.180968);
        na.setNode(3, -33.885968, 151.180501);
        na.setNode(4, -33.885883, 151.180442);
        na.setNode(5, -33.885772, 151.180941);
        na.setNode(6, -33.885692, 151.181445);
        na.setNode(7, -33.885692, 151.181445);
        g.edge(1, 2).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Parramatta Road")));
        g.edge(2, 3).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Parramatta Road")));
        g.edge(4, 5).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Parramatta Road")));
        g.edge(5, 6).set(this.carAvSpeedEnc, 60.0, 0.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Parramatta Road")));
        g.edge(2, 5).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Larkin Street")));
        g.edge(5, 7).set(this.carAvSpeedEnc, 60.0, 60.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Larkin Street")));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 6);
        Assertions.assertTrue((boolean)p.isFound());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 5, 6}), (Object)p.calcNodes());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals(List.of("continue onto Parramatta Road", "make a U-turn onto Parramatta Road", "arrive at destination"), this.getTurnDescriptions(wayList));
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)8, (int)wayList.get(1).getSign());
    }

    @Test
    public void testCalcInstructionsForTurn() {
        SpeedWeighting weighting = new SpeedWeighting(this.mixedCarSpeedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(11, 13);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)2, (int)wayList.get(1).getSign());
    }

    @Test
    public void testCalcInstructionsForSlightTurnWithOtherSlightTurn() {
        SpeedWeighting weighting = new SpeedWeighting(this.mixedCarSpeedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(12, 16);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)7, (int)wayList.get(1).getSign());
    }

    @Test
    public void testCalcInstructionsForSlightTurnOntoDifferentStreet() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 48.76423, 8.679103);
        na.setNode(2, 48.76417, 8.678647);
        na.setNode(3, 48.764149, 8.678926);
        na.setNode(4, 48.764085, 8.679183);
        g.edge(1, 3).setDistance(5.0).set(this.carAvSpeedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Talstra\u00dfe, new KValue( K 4313")));
        g.edge(2, 3).setDistance(5.0).set(this.carAvSpeedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Calmbacher Stra\u00dfe, new KValue( K 4312")));
        g.edge(3, 4).setDistance(5.0).set(this.carAvSpeedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Calmbacher Stra\u00dfe, new KValue( K 4312")));
        SpeedWeighting weighting = new SpeedWeighting(this.carAvSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(1, 2);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)this.tr);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((int)1, (int)wayList.get(1).getSign());
    }

    @Test
    public void testIgnoreInstructionsForSlightTurnWithOtherTurn() {
        SpeedWeighting weighting = new SpeedWeighting(this.mixedCarSpeedEnc);
        Path p = new Dijkstra((Graph)this.roundaboutGraph.g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(16, 19);
        Assertions.assertTrue((boolean)p.isFound());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)p.graph, (Weighting)weighting, (EncodedValueLookup)this.mixedEncodingManager, (Translation)this.tr);
        Assertions.assertEquals((int)2, (int)wayList.size());
    }

    @Test
    public void testFootAndCar_issue3081() {
        BooleanEncodedValue carAccessEnc = VehicleAccess.create((String)"car");
        BooleanEncodedValue footAccessEnc = VehicleAccess.create((String)"foot");
        BooleanEncodedValue rdEnc = Roundabout.create();
        EncodingManager manager = EncodingManager.start().add((EncodedValue)carAccessEnc).add((EncodedValue)footAccessEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)rdEnc).build();
        BaseGraph g = new BaseGraph.Builder(manager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 52.503809, 13.410198);
        na.setNode(1, 52.503871, 13.410249);
        na.setNode(2, 52.503751, 13.410377);
        na.setNode(3, 52.50387, 13.410807);
        na.setNode(4, 52.503989, 13.41094);
        na.setNode(5, 52.503794, 13.411024);
        na.setNode(6, 52.503925, 13.411034);
        na.setNode(7, 52.503277, 13.41041);
        na.setNode(8, 52.50344, 13.410545);
        na.setNode(9, 52.503536, 13.411099);
        na.setNode(10, 52.503515, 13.411178);
        g.edge(0, 2).setDistance(5.0).set(carAccessEnc, true, true).set(footAccessEnc, true, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Nordwest")));
        g.edge(1, 2).setDistance(5.0).set(carAccessEnc, false, false).set(footAccessEnc, true, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Nordwest, foot-only")));
        g.edge(4, 3).setDistance(5.0).set(carAccessEnc, true, false).set(footAccessEnc, true, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Nordeast in")));
        g.edge(5, 6).setDistance(5.0).set(carAccessEnc, true, false).set(footAccessEnc, true, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Nordeast out")));
        g.edge(10, 9).setDistance(5.0).set(carAccessEnc, true, false).set(footAccessEnc, true, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Southeast in")));
        g.edge(7, 8).setDistance(5.0).set(carAccessEnc, true, true).set(footAccessEnc, true, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Southwest")));
        g.edge(3, 2).setDistance(5.0).set(carAccessEnc, true, false).set(footAccessEnc, true, false).set(rdEnc, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"roundabout")));
        g.edge(5, 3).setDistance(5.0).set(carAccessEnc, true, false).set(footAccessEnc, true, false).set(rdEnc, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"roundabout")));
        g.edge(9, 5).setDistance(5.0).set(carAccessEnc, true, false).set(footAccessEnc, true, false).set(rdEnc, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"roundabout")));
        g.edge(8, 9).setDistance(5.0).set(carAccessEnc, true, false).set(footAccessEnc, true, false).set(rdEnc, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"roundabout")));
        g.edge(2, 8).setDistance(5.0).set(carAccessEnc, true, false).set(footAccessEnc, true, false).set(rdEnc, true).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"roundabout")));
        AccessWeighting weighting = new AccessWeighting(footAccessEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(7, 10);
        Assertions.assertEquals((Object)"[7, 8, 9, 10]", (Object)p.calcNodes().toString());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)manager, (Translation)this.tr);
        Assertions.assertEquals((Object)"at roundabout, take exit 1 onto Southeast in", (Object)wayList.get(1).getTurnDescription(this.tr));
        p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(10, 1);
        Assertions.assertEquals((Object)"[10, 9, 5, 3, 2, 1]", (Object)p.calcNodes().toString());
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)manager, (Translation)this.tr);
        Assertions.assertEquals((Object)"at roundabout, take exit 2 onto Nordwest, foot-only", (Object)wayList.get(1).getTurnDescription(this.tr));
        p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(10, 4);
        Assertions.assertEquals((Object)"[10, 9, 5, 3, 4]", (Object)p.calcNodes().toString());
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)manager, (Translation)this.tr);
        Assertions.assertEquals((Object)"at roundabout, take exit 1 onto Nordeast in", (Object)wayList.get(1).getTurnDescription(this.tr));
        p = new Dijkstra((Graph)g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(10, 6);
        Assertions.assertEquals((Object)"[10, 9, 5, 6]", (Object)p.calcNodes().toString());
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)manager, (Translation)this.tr);
        Assertions.assertEquals((Object)"at roundabout, take exit 1 onto Nordeast out", (Object)wayList.get(1).getTurnDescription(this.tr));
    }

    List<String> getTurnDescriptions(InstructionList instructionJson) {
        ArrayList<String> list = new ArrayList<String>();
        for (Instruction instruction : instructionJson) {
            list.add(instruction.getTurnDescription(this.tr));
        }
        return list;
    }

    private Graph generatePathDetailsGraph() {
        BaseGraph graph = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(1, 52.514, 13.348);
        na.setNode(2, 52.514, 13.349);
        na.setNode(3, 52.514, 13.35);
        na.setNode(4, 52.515, 13.349);
        na.setNode(5, 52.516, 13.3452);
        na.setNode(6, 52.516, 13.344);
        na.setNode(7, 52.516, 13.35);
        graph.edge(1, 2).set(this.carAvSpeedEnc, 45.0, 45.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"1-2")));
        graph.edge(4, 5).set(this.carAvSpeedEnc, 45.0, 45.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"4-5")));
        graph.edge(2, 3).set(this.carAvSpeedEnc, 90.0, 90.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"2-3")));
        graph.edge(3, 4).set(this.carAvSpeedEnc, 9.0, 9.0).setDistance(10.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-4")));
        graph.edge(5, 6).set(this.carAvSpeedEnc, 9.0, 9.0).setDistance(0.001).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-4")));
        graph.edge(4, 7).set(this.carAvSpeedEnc, 45.0, 45.0).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"4-7")));
        return graph;
    }

    private static Path extractPath(Graph graph, Weighting weighting, SPTEntry sptEntry) {
        return PathExtractor.extractPath((Graph)graph, (Weighting)weighting, (SPTEntry)sptEntry);
    }

    private class RoundaboutGraph {
        final BaseGraph g;
        final NodeAccess na;
        final EdgeIteratorState edge3to6;
        final EdgeIteratorState edge3to9;
        boolean clockwise = false;
        List<EdgeIteratorState> roundaboutEdges = new LinkedList<EdgeIteratorState>();

        private RoundaboutGraph() {
            this.g = new BaseGraph.Builder(PathTest.this.mixedEncodingManager).create();
            this.na = this.g.getNodeAccess();
            this.na.setNode(1, 52.514, 13.348);
            this.na.setNode(2, 52.514, 13.349);
            this.na.setNode(3, 52.5135, 13.35);
            this.na.setNode(4, 52.514, 13.351);
            this.na.setNode(5, 52.5145, 13.351);
            this.na.setNode(6, 52.513, 13.35);
            this.na.setNode(7, 52.514, 13.352);
            this.na.setNode(8, 52.515, 13.351);
            this.na.setNode(9, 52.513, 13.351);
            this.na.setNode(10, 52.514, 13.353);
            this.na.setNode(11, 52.514, 13.354);
            this.na.setNode(12, 52.515, 13.354);
            this.na.setNode(13, 52.515, 13.355);
            this.na.setNode(14, 52.516, 13.354);
            this.na.setNode(15, 52.516, 13.36);
            this.na.setNode(16, 52.514, 13.36);
            this.na.setNode(17, 52.514, 13.361);
            this.na.setNode(18, 52.513, 13.361);
            this.na.setNode(19, 52.515, 13.368);
            this.roundaboutEdges.add(this.g.edge(3, 2).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"2-3"))));
            this.roundaboutEdges.add(this.g.edge(4, 3).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-4"))));
            this.roundaboutEdges.add(this.g.edge(5, 4).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"4-5"))));
            this.roundaboutEdges.add(this.g.edge(2, 5).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"5-2"))));
            ArrayList<EdgeIteratorState> bothDir = new ArrayList<EdgeIteratorState>();
            ArrayList<EdgeIteratorState> oneDir = new ArrayList<EdgeIteratorState>(this.roundaboutEdges);
            bothDir.add(this.g.edge(1, 2).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"MainStreet 1 2"))));
            bothDir.add(this.g.edge(4, 7).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"MainStreet 4 7"))));
            bothDir.add(this.g.edge(5, 8).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"5-8"))));
            this.edge3to6 = this.g.edge(3, 6).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-6")));
            bothDir.add(this.edge3to6);
            this.edge3to9 = this.g.edge(3, 9).setDistance(5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-9")));
            oneDir.add(this.edge3to9);
            bothDir.add(this.g.edge(7, 10).setDistance(5.0));
            bothDir.add(this.g.edge(10, 11).setDistance(5.0));
            bothDir.add(this.g.edge(11, 12).setDistance(5.0));
            bothDir.add(this.g.edge(12, 13).setDistance(5.0));
            bothDir.add(this.g.edge(12, 14).setDistance(5.0));
            bothDir.add(this.g.edge(13, 15).setDistance(5.0));
            bothDir.add(this.g.edge(13, 16).setDistance(5.0));
            bothDir.add(this.g.edge(16, 17).setDistance(5.0));
            bothDir.add(this.g.edge(17, 18).setDistance(5.0));
            bothDir.add(this.g.edge(17, 19).setDistance(5.0));
            for (EdgeIteratorState edge : bothDir) {
                edge.set(PathTest.this.mixedCarAccessEnc, true, true);
                edge.set(PathTest.this.mixedCarSpeedEnc, 70.0, 70.0);
                edge.set(PathTest.this.mixedFootSpeedEnc, 7.0, 7.0);
            }
            for (EdgeIteratorState edge : oneDir) {
                edge.set(PathTest.this.mixedCarAccessEnc, true);
                edge.set(PathTest.this.mixedCarSpeedEnc, 70.0, 0.0);
                edge.set(PathTest.this.mixedFootSpeedEnc, 7.0, 0.0);
            }
            this.setRoundabout(this.clockwise);
            this.inverse3to9();
        }

        public void setRoundabout(boolean clockwise) {
            BooleanEncodedValue mixedRoundabout = PathTest.this.mixedEncodingManager.getBooleanEncodedValue("roundabout");
            for (EdgeIteratorState edge : this.roundaboutEdges) {
                edge.set(PathTest.this.mixedCarSpeedEnc, clockwise ? 70.0 : 0.0, clockwise ? 0.0 : 70.0);
                edge.set(PathTest.this.mixedFootSpeedEnc, clockwise ? 7.0 : 0.0, clockwise ? 0.0 : 7.0);
                edge.set(PathTest.this.mixedCarAccessEnc, clockwise, !clockwise);
                edge.set(mixedRoundabout, true);
            }
            this.clockwise = clockwise;
        }

        public void inverse3to9() {
            this.edge3to9.set(PathTest.this.mixedCarAccessEnc, !this.edge3to9.get(PathTest.this.mixedCarAccessEnc), false);
            this.edge3to9.set(PathTest.this.mixedCarSpeedEnc, this.edge3to9.get(PathTest.this.mixedCarSpeedEnc) > 0.0 ? 0.0 : 70.0, 0.0);
            this.edge3to9.set(PathTest.this.mixedFootSpeedEnc, this.edge3to9.get(PathTest.this.mixedFootSpeedEnc) > 0.0 ? 0.0 : 7.0, 0.0);
        }

        public void inverse3to6() {
            this.edge3to6.set(PathTest.this.mixedCarAccessEnc, !this.edge3to6.get(PathTest.this.mixedCarAccessEnc), true);
            this.edge3to6.set(PathTest.this.mixedCarSpeedEnc, this.edge3to6.get(PathTest.this.mixedCarSpeedEnc) > 0.0 ? 0.0 : 70.0, 70.0);
            this.edge3to6.set(PathTest.this.mixedFootSpeedEnc, this.edge3to6.get(PathTest.this.mixedFootSpeedEnc) > 0.0 ? 0.0 : 7.0, 7.0);
        }

        private double getAngle(int n1, int n2, int n3, int n4) {
            double inOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.na.getLat(n1), this.na.getLon(n1), this.na.getLat(n2), this.na.getLon(n2));
            double outOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.na.getLat(n3), this.na.getLon(n3), this.na.getLat(n4), this.na.getLon(n4));
            outOrientation = AngleCalc.ANGLE_CALC.alignOrientation(inOrientation, outOrientation);
            double delta = inOrientation - outOrientation;
            delta = this.clockwise ? Math.PI + delta : -1.0 * (Math.PI - delta);
            return delta;
        }
    }

    static class AccessWeighting
    implements Weighting {
        private final BooleanEncodedValue accessEnc;

        public AccessWeighting(BooleanEncodedValue accessEnc) {
            this.accessEnc = accessEnc;
        }

        public double calcMinWeightPerDistance() {
            throw new IllegalStateException();
        }

        public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
            return reverse && edgeState.getReverse(this.accessEnc) || edgeState.get(this.accessEnc) ? 1.0 : Double.POSITIVE_INFINITY;
        }

        public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
            return reverse && edgeState.getReverse(this.accessEnc) || edgeState.get(this.accessEnc) ? 1000L : 0L;
        }

        public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
            return 0.0;
        }

        public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
            return 0L;
        }

        public boolean hasTurnCosts() {
            return false;
        }

        public String getName() {
            return "access";
        }
    }
}

