/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.json.Statement;
import com.graphhopper.routing.AStar;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeIteratorState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PriorityRoutingTest {
    @Test
    void testMaxPriority() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 4, 2.0, false);
        DecimalEncodedValueImpl priorityEnc = new DecimalEncodedValueImpl("priority", 4, PriorityCode.getFactor((int)1), false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).add((EncodedValue)priorityEnc).add((EncodedValue)RoadClass.create()).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 48.0, 11.0);
        na.setNode(1, 48.1, 11.1);
        na.setNode(2, 48.2, 11.2);
        na.setNode(3, 48.3, 11.3);
        na.setNode(4, 48.1, 11.0);
        na.setNode(5, 48.2, 11.1);
        double speed = speedEnc.getNextStorableValue(30.0);
        double dist1 = 0.0;
        dist1 += this.addEdge(em, graph, 0, 1, 1.0, (DecimalEncodedValue)speedEnc, (DecimalEncodedValue)priorityEnc, speed).getDistance();
        dist1 += this.addEdge(em, graph, 1, 2, 1.0, (DecimalEncodedValue)speedEnc, (DecimalEncodedValue)priorityEnc, speed).getDistance();
        double maxPrio = PriorityCode.getFactor((int)PriorityCode.BEST.getValue());
        double dist2 = 0.0;
        dist2 += this.addEdge(em, graph, 0, 4, maxPrio, (DecimalEncodedValue)speedEnc, (DecimalEncodedValue)priorityEnc, speed).getDistance();
        dist2 += this.addEdge(em, graph, 4, 5, maxPrio, (DecimalEncodedValue)speedEnc, (DecimalEncodedValue)priorityEnc, speed).getDistance();
        Assertions.assertEquals((double)40101.0, (double)(dist1 += this.addEdge(em, graph, 2, 3, 1.0, (DecimalEncodedValue)speedEnc, (DecimalEncodedValue)priorityEnc, speed).getDistance()), (double)1.0);
        Assertions.assertEquals((double)43005.0, (double)(dist2 += this.addEdge(em, graph, 5, 3, maxPrio, (DecimalEncodedValue)speedEnc, (DecimalEncodedValue)priorityEnc, speed).getDistance()), (double)1.0);
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"true", (Statement.Op)Statement.Op.MULTIPLY, (String)priorityEnc.getName()));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)speedEnc.getName()));
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)em, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)customModel);
        Path pathDijkstra = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(0, 3);
        Path pathAStar = new AStar((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(0, 3);
        Assertions.assertEquals((Object)pathDijkstra.calcNodes(), (Object)pathAStar.calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4, 5, 3}), (Object)pathAStar.calcNodes());
        customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)"true", (Statement.Op)Statement.Op.MULTIPLY, (String)priorityEnc.getName()));
        customModel.addToPriority(Statement.If((String)"road_class == MOTORWAY", (Statement.Op)Statement.Op.MULTIPLY, (String)"3"));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)speedEnc.getName()));
        weighting = CustomModelParser.createWeighting((EncodedValueLookup)em, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)customModel);
        pathDijkstra = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(0, 3);
        pathAStar = new AStar((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(0, 3);
        Assertions.assertEquals((Object)pathDijkstra.calcNodes(), (Object)pathAStar.calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4, 5, 3}), (Object)pathAStar.calcNodes());
    }

    private EdgeIteratorState addEdge(EncodingManager em, BaseGraph graph, int p, int q, double prio, DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, double speed) {
        EnumEncodedValue roadClassEnc = em.getEnumEncodedValue("road_class", RoadClass.class);
        return graph.edge(p, q).set(speedEnc, speed).set(priorityEnc, prio).set(roadClassEnc, (Enum)RoadClass.MOTORWAY).setDistance(this.calcDist(graph, p, q));
    }

    private double calcDist(BaseGraph graph, int p, int q) {
        NodeAccess na = graph.getNodeAccess();
        return DistanceCalcEarth.DIST_EARTH.calcDist(na.getLat(p), na.getLon(p), na.getLat(q), na.getLon(q));
    }
}

