/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryRoutingCHGraph;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.CHStorageBuilder;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIterator;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class QueryRoutingCHGraphTest {
    private DecimalEncodedValue speedEnc;
    private DecimalEncodedValue turnCostEnc;
    private SpeedWeighting weighting;
    private BaseGraph graph;
    private NodeAccess na;

    QueryRoutingCHGraphTest() {
    }

    @BeforeEach
    public void setup() {
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.turnCostEnc = TurnCost.create((String)"car", (int)5);
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();
        this.graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        this.weighting = new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.graph.getTurnCostStorage(), Double.POSITIVE_INFINITY);
        this.na = this.graph.getNodeAccess();
    }

    @Test
    public void basic() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        Assertions.assertEquals((int)2, (int)this.graph.getEdges());
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Collections.emptyList());
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        Assertions.assertEquals((int)3, (int)queryCHGraph.getNodes());
        Assertions.assertEquals((int)2, (int)queryCHGraph.getEdges());
        Assertions.assertTrue((boolean)queryCHGraph.isEdgeBased());
        Assertions.assertTrue((boolean)queryCHGraph.hasTurnCosts());
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 0, 1, true);
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 1, 2, true);
        RoutingCHEdgeIterator outIter = queryCHGraph.createOutEdgeExplorer().setBaseNode(0);
        this.assertNextEdge(outIter, 0, 1, 0);
        this.assertEnd(outIter);
        RoutingCHEdgeIterator inIter = queryCHGraph.createInEdgeExplorer().setBaseNode(1);
        this.assertNextEdge(inIter, 1, 2, 1);
        this.assertNextEdge(inIter, 1, 0, 0);
        this.assertEnd(inIter);
        inIter = queryCHGraph.createInEdgeExplorer().setBaseNode(2);
        this.assertNextEdge(inIter, 2, 1, 1);
        this.assertEnd(inIter);
    }

    @Test
    public void withShortcuts() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        Assertions.assertEquals((int)2, (int)this.graph.getEdges());
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutEdgeBased(0, 2, PrepareEncoder.getScFwdDir(), 20.0, 0, 1, 0, 2);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Collections.emptyList());
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        Assertions.assertEquals((int)3, (int)queryCHGraph.getNodes());
        Assertions.assertEquals((int)3, (int)queryCHGraph.getEdges());
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 0, 1, true);
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 1, 2, true);
        RoutingCHEdgeIterator outIter = queryCHGraph.createOutEdgeExplorer().setBaseNode(0);
        this.assertNextShortcut(outIter, 0, 2, 0, 1);
        this.assertNextEdge(outIter, 0, 1, 0);
        this.assertEnd(outIter);
        RoutingCHEdgeIterator inIter = queryCHGraph.createInEdgeExplorer().setBaseNode(2);
        this.assertNextEdge(inIter, 2, 1, 1);
        this.assertEnd(inIter);
    }

    @Test
    public void withVirtualEdges() {
        this.na.setNode(0, 50.0, 10.0);
        this.na.setNode(1, 50.0, 10.1);
        this.na.setNode(2, 50.0, 10.2);
        EdgeIteratorState edge = this.addEdge((Graph)this.graph, 0, 1);
        this.addEdge((Graph)this.graph, 1, 2);
        this.graph.freeze();
        Assertions.assertEquals((int)2, (int)this.graph.getEdges());
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        Snap snap = new Snap(50.0, 10.05);
        snap.setClosestEdge(edge);
        snap.setWayIndex(0);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.calcSnappedPoint((DistanceCalc)DistancePlaneProjection.DIST_PLANE);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Collections.singletonList(snap));
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        Assertions.assertEquals((int)4, (int)queryCHGraph.getNodes());
        Assertions.assertEquals((int)6, (int)queryCHGraph.getEdges());
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 1, 2, true);
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 0, 3, true);
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 3, 1, true);
        RoutingCHEdgeIterator outIter = queryCHGraph.createOutEdgeExplorer().setBaseNode(2);
        this.assertNextEdge(outIter, 2, 1, 1);
        this.assertEnd(outIter);
        RoutingCHEdgeIterator inIter = queryCHGraph.createInEdgeExplorer().setBaseNode(2);
        this.assertNextEdge(inIter, 2, 1, 1);
        this.assertEnd(inIter);
        outIter = queryCHGraph.createOutEdgeExplorer().setBaseNode(0);
        this.assertNextEdge(outIter, 0, 3, 2);
        this.assertEnd(outIter);
        inIter = queryCHGraph.createInEdgeExplorer().setBaseNode(1);
        this.assertNextEdge(inIter, 1, 3, 3);
        this.assertNextEdge(inIter, 1, 2, 1);
        this.assertEnd(inIter);
        outIter = queryCHGraph.createOutEdgeExplorer().setBaseNode(3);
        this.assertNextEdge(outIter, 3, 0, 2);
        this.assertNextEdge(outIter, 3, 1, 3);
        this.assertEnd(outIter);
        inIter = queryCHGraph.createInEdgeExplorer().setBaseNode(3);
        this.assertNextEdge(inIter, 3, 0, 2);
        this.assertNextEdge(inIter, 3, 1, 3);
        this.assertEnd(inIter);
    }

    @Test
    public void withVirtualEdgesAndShortcuts() {
        this.na.setNode(0, 50.0, 10.0);
        this.na.setNode(1, 50.0, 10.1);
        this.na.setNode(2, 50.0, 10.2);
        EdgeIteratorState edge = this.addEdge((Graph)this.graph, 0, 1);
        this.addEdge((Graph)this.graph, 1, 2);
        this.graph.freeze();
        Assertions.assertEquals((int)2, (int)this.graph.getEdges());
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutEdgeBased(0, 2, PrepareEncoder.getScFwdDir(), 20.0, 0, 1, 0, 2);
        Snap snap = new Snap(50.0, 10.05);
        snap.setClosestEdge(edge);
        snap.setWayIndex(0);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.calcSnappedPoint((DistanceCalc)DistancePlaneProjection.DIST_PLANE);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Collections.singletonList(snap));
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        Assertions.assertEquals((int)4, (int)queryCHGraph.getNodes());
        Assertions.assertEquals((int)7, (int)queryCHGraph.getEdges());
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 0, 3, true);
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 3, 1, true);
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 1, 2, true);
        RoutingCHEdgeIterator outIter = queryCHGraph.createOutEdgeExplorer().setBaseNode(0);
        this.assertNextEdge(outIter, 0, 3, 2);
        this.assertNextShortcut(outIter, 0, 2, 0, 1);
        this.assertEnd(outIter);
        RoutingCHEdgeIterator inIter = queryCHGraph.createInEdgeExplorer().setBaseNode(2);
        this.assertNextEdge(inIter, 2, 1, 1);
        this.assertEnd(inIter);
        outIter = queryCHGraph.createOutEdgeExplorer().setBaseNode(3);
        this.assertNextEdge(outIter, 3, 0, 2);
        this.assertNextEdge(outIter, 3, 1, 3);
        this.assertEnd(outIter);
        inIter = queryCHGraph.createInEdgeExplorer().setBaseNode(3);
        this.assertNextEdge(inIter, 3, 0, 2);
        this.assertNextEdge(inIter, 3, 1, 3);
        this.assertEnd(inIter);
    }

    @Test
    public void getBaseGraph() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Collections.emptyList());
        Assertions.assertSame((Object)this.graph.getBaseGraph(), (Object)routingCHGraph.getBaseGraph());
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        Assertions.assertSame((Object)queryGraph, (Object)queryCHGraph.getBaseGraph());
    }

    @Test
    public void getEdgeIteratorState() {
        this.na.setNode(0, 50.0, 10.0);
        this.na.setNode(1, 50.0, 10.1);
        this.na.setNode(2, 50.0, 10.2);
        EdgeIteratorState edge = this.addEdge((Graph)this.graph, 0, 1);
        this.addEdge((Graph)this.graph, 1, 2);
        this.graph.freeze();
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutEdgeBased(0, 2, PrepareEncoder.getScFwdDir(), 20.0, 0, 1, 0, 2);
        Snap snap = new Snap(50.0, 10.05);
        snap.setClosestEdge(edge);
        snap.setWayIndex(0);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.calcSnappedPoint((DistanceCalc)DistancePlaneProjection.DIST_PLANE);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Collections.singletonList(snap));
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        this.assertGetEdgeIteratorState((RoutingCHGraph)queryCHGraph, 1, 2, 1);
        this.assertGetEdgeIteratorShortcut((RoutingCHGraph)queryCHGraph, 0, 2, 0, 1);
        this.assertGetEdgeIteratorState((RoutingCHGraph)queryCHGraph, 0, 3, 2);
        this.assertGetEdgeIteratorState((RoutingCHGraph)queryCHGraph, 3, 0, 2);
        this.assertGetEdgeIteratorState((RoutingCHGraph)queryCHGraph, 1, 3, 3);
        this.assertGetEdgeIteratorState((RoutingCHGraph)queryCHGraph, 3, 1, 3);
    }

    @Test
    public void getWeighting() {
        this.graph.freeze();
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Collections.emptyList());
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        Assertions.assertSame((Object)this.weighting, (Object)queryCHGraph.getWeighting());
    }

    @Test
    public void getLevel() {
        this.na.setNode(0, 50.0, 10.0);
        this.na.setNode(1, 50.0, 10.1);
        EdgeIteratorState edge = this.addEdge((Graph)this.graph, 0, 1);
        this.graph.freeze();
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setLevel(0, 5);
        chBuilder.setLevel(1, 7);
        Snap snap = new Snap(50.0, 10.05);
        snap.setClosestEdge(edge);
        snap.setWayIndex(0);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.calcSnappedPoint((DistanceCalc)DistancePlaneProjection.DIST_PLANE);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Collections.singletonList(snap));
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        Assertions.assertEquals((int)5, (int)queryCHGraph.getLevel(0));
        Assertions.assertEquals((int)7, (int)queryCHGraph.getLevel(1));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)queryCHGraph.getLevel(2));
    }

    @Test
    public void getWeight() {
        this.na.setNode(0, 50.0, 10.0);
        this.na.setNode(1, 50.0, 10.1);
        this.na.setNode(2, 50.0, 10.2);
        EdgeIteratorState edge = this.addEdge((Graph)this.graph, 0, 1).set(this.speedEnc, 30.0, 10.0);
        this.addEdge((Graph)this.graph, 1, 2);
        this.graph.freeze();
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutEdgeBased(0, 2, PrepareEncoder.getScDirMask(), 20.0, 0, 1, 0, 2);
        RoutingCHEdgeIterator iter = routingCHGraph.createOutEdgeExplorer().setBaseNode(0);
        this.assertNextShortcut(iter, 0, 2, 0, 1);
        Assertions.assertEquals((double)20.0, (double)iter.getWeight(false), (double)1.0E-6);
        Assertions.assertEquals((double)20.0, (double)iter.getWeight(true), (double)1.0E-6);
        this.assertNextEdge(iter, 0, 1, 0);
        Assertions.assertEquals((double)238.249066, (double)iter.getWeight(false), (double)1.0E-6);
        Assertions.assertEquals((double)714.7472, (double)iter.getWeight(true), (double)1.0E-6);
        this.assertEnd(iter);
        iter = routingCHGraph.createInEdgeExplorer().setBaseNode(0);
        this.assertNextShortcut(iter, 0, 2, 0, 1);
        Assertions.assertEquals((double)20.0, (double)iter.getWeight(false), (double)1.0E-6);
        Assertions.assertEquals((double)20.0, (double)iter.getWeight(true), (double)1.0E-6);
        this.assertNextEdge(iter, 0, 1, 0);
        Assertions.assertEquals((double)238.249066, (double)iter.getWeight(false), (double)1.0E-6);
        Assertions.assertEquals((double)714.7472, (double)iter.getWeight(true), (double)1.0E-6);
        this.assertEnd(iter);
        Snap snap = new Snap(50.0, 10.05);
        snap.setClosestEdge(edge);
        snap.setWayIndex(0);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.calcSnappedPoint((DistanceCalc)DistancePlaneProjection.DIST_PLANE);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Collections.singletonList(snap));
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        iter = queryCHGraph.createOutEdgeExplorer().setBaseNode(0);
        this.assertNextEdge(iter, 0, 3, 2);
        Assertions.assertEquals((double)119.12453, (double)iter.getWeight(false), (double)1.0E-4);
        Assertions.assertEquals((double)357.373605, (double)iter.getWeight(true), (double)1.0E-4);
        this.assertNextShortcut(iter, 0, 2, 0, 1);
        Assertions.assertEquals((double)20.0, (double)iter.getWeight(false), (double)1.0E-6);
        Assertions.assertEquals((double)20.0, (double)iter.getWeight(true), (double)1.0E-6);
        this.assertEnd(iter);
        iter = queryCHGraph.createInEdgeExplorer().setBaseNode(0);
        this.assertNextEdge(iter, 0, 3, 2);
        Assertions.assertEquals((double)119.12453, (double)iter.getWeight(false), (double)1.0E-4);
        Assertions.assertEquals((double)357.373605, (double)iter.getWeight(true), (double)1.0E-4);
        this.assertNextShortcut(iter, 0, 2, 0, 1);
        Assertions.assertEquals((double)20.0, (double)iter.getWeight(false), (double)1.0E-6);
        Assertions.assertEquals((double)20.0, (double)iter.getWeight(true), (double)1.0E-6);
        this.assertEnd(iter);
        iter = queryCHGraph.createOutEdgeExplorer().setBaseNode(3);
        this.assertNextEdge(iter, 3, 0, 2);
        Assertions.assertEquals((double)357.373605, (double)iter.getWeight(false), (double)1.0E-4);
        Assertions.assertEquals((double)119.12453, (double)iter.getWeight(true), (double)1.0E-4);
        this.assertNextEdge(iter, 3, 1, 3);
        Assertions.assertEquals((double)119.12453, (double)iter.getWeight(false), (double)1.0E-4);
        Assertions.assertEquals((double)357.373605, (double)iter.getWeight(true), (double)1.0E-4);
        this.assertEnd(iter);
        iter = queryCHGraph.createInEdgeExplorer().setBaseNode(3);
        this.assertNextEdge(iter, 3, 0, 2);
        Assertions.assertEquals((double)357.373605, (double)iter.getWeight(false), (double)1.0E-4);
        Assertions.assertEquals((double)119.12453, (double)iter.getWeight(true), (double)1.0E-4);
        this.assertNextEdge(iter, 3, 1, 3);
        Assertions.assertEquals((double)119.12453, (double)iter.getWeight(false), (double)1.0E-4);
        Assertions.assertEquals((double)357.373605, (double)iter.getWeight(true), (double)1.0E-4);
        this.assertEnd(iter);
        RoutingCHEdgeIteratorState edgeState = queryCHGraph.getEdgeIteratorState(3, 3);
        this.assertEdgeState(edgeState, 0, 3, 2);
        Assertions.assertEquals((double)119.12453, (double)edgeState.getWeight(false), (double)1.0E-4);
        Assertions.assertEquals((double)357.373605, (double)edgeState.getWeight(true), (double)1.0E-4);
        edgeState = queryCHGraph.getEdgeIteratorState(3, 0);
        this.assertEdgeState(edgeState, 3, 0, 2);
        Assertions.assertEquals((double)357.373605, (double)edgeState.getWeight(false), (double)1.0E-4);
        Assertions.assertEquals((double)119.12453, (double)edgeState.getWeight(true), (double)1.0E-4);
    }

    @Test
    public void getTurnCost() {
        this.na.setNode(0, 50.0, 10.0);
        this.na.setNode(1, 50.0, 10.1);
        this.na.setNode(2, 50.0, 10.2);
        EdgeIteratorState edge1 = this.addEdge((Graph)this.graph, 0, 1);
        EdgeIteratorState edge2 = this.addEdge((Graph)this.graph, 1, 2);
        this.graph.getTurnCostStorage().set(this.turnCostEnc, 0, 1, 1, 5.0);
        this.graph.freeze();
        CHConfig chConfig = CHConfig.edgeBased((String)"x", (Weighting)this.weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)chStore, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutEdgeBased(0, 2, PrepareEncoder.getScFwdDir(), 20.0, 0, 1, 0, 2);
        Assertions.assertEquals((double)5.0, (double)routingCHGraph.getTurnWeight(0, 1, 1));
        Snap snap1 = new Snap(50.0, 10.05);
        snap1.setClosestEdge(edge1);
        snap1.setWayIndex(0);
        snap1.setSnappedPosition(Snap.Position.EDGE);
        snap1.calcSnappedPoint((DistanceCalc)DistancePlaneProjection.DIST_PLANE);
        Snap snap2 = new Snap(50.0, 10.15);
        snap2.setClosestEdge(edge2);
        snap2.setWayIndex(0);
        snap2.setSnappedPosition(Snap.Position.EDGE);
        snap2.calcSnappedPoint((DistanceCalc)DistancePlaneProjection.DIST_PLANE);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, Arrays.asList(snap1, snap2));
        QueryRoutingCHGraph queryCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
        Assertions.assertEquals((double)5.0, (double)queryCHGraph.getTurnWeight(0, 1, 1));
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 3, 1, true);
        this.assertNodesConnected((RoutingCHGraph)queryCHGraph, 1, 4, true);
        int expectedEdge31 = 3;
        int expectedEdge14 = 4;
        RoutingCHEdgeIterator iter = queryCHGraph.createOutEdgeExplorer().setBaseNode(3);
        this.assertNextEdge(iter, 3, 0, 2);
        this.assertNextEdge(iter, 3, 1, expectedEdge31);
        this.assertEnd(iter);
        iter = queryCHGraph.createOutEdgeExplorer().setBaseNode(1);
        this.assertNextEdge(iter, 1, 3, 3);
        this.assertNextEdge(iter, 1, 4, expectedEdge14);
        this.assertEnd(iter);
        Assertions.assertEquals((double)5.0, (double)queryCHGraph.getTurnWeight(expectedEdge31, 1, expectedEdge14));
    }

    private void assertGetEdgeIteratorState(RoutingCHGraph graph, int base, int adj, int origEdge) {
        int chEdge = this.getCHEdge(graph.createOutEdgeExplorer(), base, adj);
        this.assertEdgeState(graph.getEdgeIteratorState(chEdge, adj), base, adj, origEdge);
        this.assertEdgeState(graph.getEdgeIteratorState(chEdge, base), adj, base, origEdge);
    }

    private void assertGetEdgeIteratorShortcut(RoutingCHGraph graph, int base, int adj, int skip1, int skip2) {
        int chEdge = this.getCHEdge(graph.createOutEdgeExplorer(), base, adj);
        this.assertShortcut(graph.getEdgeIteratorState(chEdge, adj), base, adj, skip1, skip2);
        this.assertShortcut(graph.getEdgeIteratorState(chEdge, base), adj, base, skip1, skip2);
    }

    private void assertNextEdge(RoutingCHEdgeIterator iter, int base, int adj, int origEdge) {
        Assertions.assertTrue((boolean)iter.next(), (String)"there is no further edge");
        this.assertEdgeState((RoutingCHEdgeIteratorState)iter, base, adj, origEdge);
    }

    private void assertEdgeState(RoutingCHEdgeIteratorState edgeState, int base, int adj, int origEdge) {
        Assertions.assertFalse((boolean)edgeState.isShortcut(), (String)"did not expect a shortcut");
        Assertions.assertEquals((int)base, (int)edgeState.getBaseNode(), (String)"wrong base node");
        Assertions.assertEquals((int)adj, (int)edgeState.getAdjNode(), (String)"wrong adj node");
        Assertions.assertEquals((int)origEdge, (int)edgeState.getOrigEdge(), (String)"wrong orig edge");
    }

    private void assertNextShortcut(RoutingCHEdgeIterator iter, int base, int adj, int skip1, int skip2) {
        Assertions.assertTrue((boolean)iter.next(), (String)"there is no further edge");
        this.assertShortcut((RoutingCHEdgeIteratorState)iter, base, adj, skip1, skip2);
    }

    private void assertShortcut(RoutingCHEdgeIteratorState edgeState, int base, int adj, int skip1, int skip2) {
        Assertions.assertTrue((boolean)edgeState.isShortcut(), (String)"expected a shortcut");
        Assertions.assertEquals((int)base, (int)edgeState.getBaseNode(), (String)"wrong base node");
        Assertions.assertEquals((int)adj, (int)edgeState.getAdjNode(), (String)"wrong adj node");
        Assertions.assertEquals((int)-1, (int)edgeState.getOrigEdge(), (String)"wrong orig edge");
        Assertions.assertEquals((int)skip1, (int)edgeState.getSkippedEdge1(), (String)"wrong skip1 edge");
        Assertions.assertEquals((int)skip2, (int)edgeState.getSkippedEdge2(), (String)"wrong skip2 edge");
    }

    private void assertNodesConnected(RoutingCHGraph graph, int p, int q, boolean bothDirections) {
        int chEdge = this.getCHEdge(graph.createOutEdgeExplorer(), p, q);
        Assertions.assertNotEquals((int)-1, (int)chEdge, (String)("No CH out-edge " + p + "->" + q));
        this.assertEdgeAtNodes(graph, chEdge, p, q);
        chEdge = this.getCHEdge(graph.createInEdgeExplorer(), q, p);
        Assertions.assertNotEquals((int)-1, (int)chEdge, (String)("No CH in-edge " + q + "<-" + p));
        this.assertEdgeAtNodes(graph, chEdge, p, q);
        int revCHEdge = this.getCHEdge(graph.createOutEdgeExplorer(), q, p);
        if (bothDirections) {
            Assertions.assertNotEquals((int)-1, (int)revCHEdge, (String)("No CH out-edge " + q + "->" + p));
            this.assertEdgeAtNodes(graph, revCHEdge, p, q);
        } else {
            Assertions.assertEquals((int)-1, (int)revCHEdge, (String)("Unexpected CH out-edge " + q + "->" + p));
        }
        revCHEdge = this.getCHEdge(graph.createInEdgeExplorer(), p, q);
        if (bothDirections) {
            Assertions.assertNotEquals((int)-1, (int)revCHEdge, (String)("No CH in-edge " + q + "<-" + p));
            this.assertEdgeAtNodes(graph, revCHEdge, p, q);
        } else {
            Assertions.assertEquals((int)-1, (int)revCHEdge, (String)("Unexpected CH in-edge " + q + "<-" + p));
        }
    }

    private int getCHEdge(RoutingCHEdgeExplorer explorer, int base, int adj) {
        RoutingCHEdgeIterator iter = explorer.setBaseNode(base);
        while (iter.next()) {
            if (iter.getAdjNode() != adj) continue;
            return iter.getEdge();
        }
        return -1;
    }

    private void assertEdgeAtNodes(RoutingCHGraph graph, int shortcut, int p, int q) {
        boolean fails = true;
        RoutingCHEdgeIterator iter = graph.createOutEdgeExplorer().setBaseNode(p);
        while (iter.next()) {
            if (iter.getAdjNode() != q || iter.getEdge() != shortcut) continue;
            fails = false;
        }
        iter = graph.createInEdgeExplorer().setBaseNode(q);
        while (iter.next()) {
            if (iter.getAdjNode() != p || iter.getEdge() != shortcut) continue;
            fails = false;
        }
        Assertions.assertFalse((boolean)fails);
    }

    private void assertEnd(RoutingCHEdgeIterator outIter) {
        Assertions.assertFalse((boolean)outIter.next());
    }

    private EdgeIteratorState addEdge(Graph graph, int from, int to) {
        NodeAccess na = graph.getNodeAccess();
        double dist = DistancePlaneProjection.DIST_PLANE.calcDist(na.getLat(from), na.getLon(from), na.getLat(to), na.getLon(to));
        return graph.edge(from, to).setDistance(dist).set(this.speedEnc, 10.0, 10.0);
    }
}

