/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryRoutingCHGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomCHRoutingTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomCHRoutingTest.class);

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void random(Fixture f) {
        int numNodes = 50;
        long seed = System.nanoTime();
        LOGGER.info("seed: " + seed);
        Random rnd = new Random(seed);
        double pOffset = 0.0;
        GHUtility.buildRandomGraph((Graph)f.graph, (Random)rnd, (int)numNodes, (double)2.5, (boolean)true, (DecimalEncodedValue)f.speedEnc, null, (double)0.9, (double)pOffset);
        if (f.traversalMode.isEdgeBased()) {
            GHUtility.addRandomTurnCosts((Graph)f.graph, (long)seed, null, (DecimalEncodedValue)f.turnCostEnc, (int)f.maxTurnCosts, (TurnCostStorage)f.graph.getTurnCostStorage());
        }
        this.runRandomTest(f, rnd);
    }

    private void runRandomTest(Fixture f, Random rnd) {
        LocationIndexTree locationIndex = new LocationIndexTree((Graph)f.graph, f.graph.getDirectory());
        locationIndex.prepareIndex();
        f.freeze();
        PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraph((BaseGraph)f.graph, (CHConfig)f.chConfig);
        PrepareContractionHierarchies.Result res = pch.doWork();
        RoutingCHGraph chGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)f.graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
        int numQueryGraph = 25;
        int numVirtualNodes = 20;
        for (int j = 0; j < numQueryGraph; ++j) {
            List snaps = GHUtility.createRandomSnaps((BBox)f.graph.getBounds(), (LocationIndex)locationIndex, (Random)rnd, (int)numVirtualNodes, (boolean)false, (EdgeFilter)EdgeFilter.ALL_EDGES);
            QueryGraph queryGraph = QueryGraph.create((BaseGraph)f.graph, (List)snaps);
            int numQueries = 100;
            int numPathsNotFound = 0;
            ArrayList<CallSite> strictViolations = new ArrayList<CallSite>();
            for (int i = 0; i < numQueries; ++i) {
                int from = rnd.nextInt(queryGraph.getNodes());
                int to = rnd.nextInt(queryGraph.getNodes());
                Weighting w = queryGraph.wrapWeighting(f.weighting);
                Dijkstra refAlgo = new Dijkstra((Graph)queryGraph, w, f.traversalMode);
                Path refPath = refAlgo.calcPath(from, to);
                double refWeight = refPath.getWeight();
                QueryRoutingCHGraph routingCHGraph = new QueryRoutingCHGraph(chGraph, queryGraph);
                EdgeToEdgeRoutingAlgorithm algo = new CHRoutingAlgorithmFactory((RoutingCHGraph)routingCHGraph).createAlgo(new PMap().putObject("stall_on_demand", (Object)true));
                Path path = algo.calcPath(from, to);
                if (refPath.isFound() && !path.isFound()) {
                    Assertions.fail((String)("path not found for " + from + "->" + to + ", expected weight: " + refWeight));
                }
                Assertions.assertEquals((Object)refPath.isFound(), (Object)path.isFound());
                if (!path.isFound()) {
                    ++numPathsNotFound;
                    continue;
                }
                double weight = path.getWeight();
                if (Math.abs(refWeight - weight) > 0.01) {
                    LOGGER.warn("expected: " + String.valueOf(refPath.calcNodes()));
                    LOGGER.warn("given:    " + String.valueOf(path.calcNodes()));
                    Assertions.fail((String)("wrong weight: " + from + "->" + to + ", dijkstra: " + refWeight + " vs. ch: " + path.getWeight()));
                }
                if (Math.abs(path.getDistance() - refPath.getDistance()) > 0.1) {
                    strictViolations.add((CallSite)((Object)("wrong distance " + from + "->" + to + ", expected: " + refPath.getDistance() + ", given: " + path.getDistance())));
                }
                if (Math.abs(path.getTime() - refPath.getTime()) <= 50L) continue;
                strictViolations.add((CallSite)((Object)("wrong time " + from + "->" + to + ", expected: " + refPath.getTime() + ", given: " + path.getTime())));
            }
            if ((double)numPathsNotFound > 0.9 * (double)numQueries) {
                Assertions.fail((String)("Too many paths not found: " + numPathsNotFound + "/" + numQueries));
            }
            if (!((double)strictViolations.size() > 0.05 * (double)numQueries)) continue;
            Assertions.fail((String)("Too many strict violations: " + strictViolations.size() + "/" + numQueries + "\n" + String.join((CharSequence)"\n", strictViolations)));
        }
    }

    private static final class Fixture {
        private final TraversalMode traversalMode;
        private final int maxTurnCosts;
        private final double uTurnCosts;
        private final DecimalEncodedValue speedEnc;
        private final DecimalEncodedValue turnCostEnc;
        private Weighting weighting;
        private final BaseGraph graph;
        private CHConfig chConfig;

        Fixture(TraversalMode traversalMode, double uTurnCosts) {
            this.traversalMode = traversalMode;
            this.maxTurnCosts = 10;
            this.uTurnCosts = uTurnCosts;
            this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
            this.turnCostEnc = TurnCost.create((String)"car", (int)this.maxTurnCosts);
            EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();
            this.graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        }

        void freeze() {
            this.graph.freeze();
            this.chConfig = this.traversalMode.isEdgeBased() ? CHConfig.edgeBased((String)"p", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.graph.getTurnCostStorage(), this.uTurnCosts)) : CHConfig.nodeBased((String)"p", (Weighting)new SpeedWeighting(this.speedEnc));
            this.weighting = this.chConfig.getWeighting();
        }

        public String toString() {
            return String.valueOf(this.traversalMode) + ", u-turn-costs=" + this.uTurnCosts;
        }
    }

    private static class FixtureProvider
    implements ArgumentsProvider {
        private FixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of(new Fixture(TraversalMode.NODE_BASED, Double.POSITIVE_INFINITY), new Fixture(TraversalMode.EDGE_BASED, 40.0), new Fixture(TraversalMode.EDGE_BASED, Double.POSITIVE_INFINITY)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

