/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMRoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.PerfectApproximator;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryRoutingCHGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomizedRoutingTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomizedRoutingTest.class);

    @ParameterizedTest
    @ArgumentsSource(value=RepeatedFixtureProvider.class)
    public void randomGraph(FixtureSupplier fixtureSupplier) {
        Fixture f = fixtureSupplier.supplier.get();
        long seed = System.nanoTime();
        int numQueries = 50;
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)f.graph, (Random)rnd, (int)100, (double)2.2, (boolean)true, (DecimalEncodedValue)f.speedEnc, null, (double)0.8, (double)0.8);
        GHUtility.addRandomTurnCosts((Graph)f.graph, (long)seed, null, (DecimalEncodedValue)f.turnCostEnc, (int)f.maxTurnCosts, (TurnCostStorage)f.turnCostStorage);
        f.preProcessGraph();
        ArrayList strictViolations = new ArrayList();
        for (int i = 0; i < 50; ++i) {
            int source = rnd.nextInt(f.graph.getNodes());
            int target = rnd.nextInt(f.graph.getNodes());
            Path refPath = new DijkstraBidirectionRef((Graph)f.graph, f.weighting, f.traversalMode).calcPath(source, target);
            Path path = f.createAlgo().calcPath(source, target);
            strictViolations.addAll(GHUtility.comparePaths((Path)refPath, (Path)path, (int)source, (int)target, (long)seed));
        }
        if (strictViolations.size() > 3) {
            for (String strictViolation : strictViolations) {
                LOGGER.info("strict violation: " + strictViolation);
            }
            Assertions.fail((String)("Too many strict violations: " + strictViolations.size() + " / 50, seed: " + seed));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=RepeatedFixtureProvider.class)
    public void randomGraph_withQueryGraph(FixtureSupplier fixtureSupplier) {
        Fixture f = fixtureSupplier.supplier.get();
        long seed = System.nanoTime();
        int numQueries = 50;
        double pOffset = 0.0;
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)f.graph, (Random)rnd, (int)50, (double)2.2, (boolean)true, (DecimalEncodedValue)f.speedEnc, null, (double)0.8, (double)pOffset);
        GHUtility.addRandomTurnCosts((Graph)f.graph, (long)seed, null, (DecimalEncodedValue)f.turnCostEnc, (int)f.maxTurnCosts, (TurnCostStorage)f.turnCostStorage);
        f.preProcessGraph();
        LocationIndexTree index = new LocationIndexTree((Graph)f.graph, f.graph.getDirectory());
        index.prepareIndex();
        ArrayList strictViolations = new ArrayList();
        for (int i = 0; i < 50; ++i) {
            List snaps = GHUtility.createRandomSnaps((BBox)f.graph.getBounds(), (LocationIndex)index, (Random)rnd, (int)2, (boolean)true, (EdgeFilter)EdgeFilter.ALL_EDGES);
            QueryGraph queryGraph = QueryGraph.create((BaseGraph)f.graph, (List)snaps);
            int source = ((Snap)snaps.get(0)).getClosestNode();
            int target = ((Snap)snaps.get(1)).getClosestNode();
            Path refPath = new DijkstraBidirectionRef((Graph)queryGraph, queryGraph.wrapWeighting(f.weighting), f.traversalMode).calcPath(source, target);
            Path path = f.createAlgo((Graph)queryGraph).calcPath(source, target);
            strictViolations.addAll(GHUtility.comparePaths((Path)refPath, (Path)path, (int)source, (int)target, (long)seed));
        }
        if (strictViolations.size() > 3) {
            LOGGER.warn(((Object)strictViolations).toString());
            Assertions.fail((String)("Too many strict violations: " + strictViolations.size() + " / 50, seed: " + seed));
        }
    }

    private static class FixtureSupplier {
        private final Supplier<Fixture> supplier;
        private final String name;

        static FixtureSupplier create(Algo algo, boolean prepareCH, boolean prepareLM, TraversalMode traversalMode) {
            return new FixtureSupplier(() -> new Fixture(algo, prepareCH, prepareLM, traversalMode), algo.toString());
        }

        public FixtureSupplier(Supplier<Fixture> supplier, String name) {
            this.supplier = supplier;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class Fixture {
        private final Algo algo;
        private final boolean prepareCH;
        private final boolean prepareLM;
        private final TraversalMode traversalMode;
        private final BaseGraph graph;
        private final DecimalEncodedValue speedEnc;
        private final DecimalEncodedValue turnCostEnc;
        private final TurnCostStorage turnCostStorage;
        private final int maxTurnCosts;
        private Weighting weighting;
        private final EncodingManager encodingManager;
        private RoutingCHGraph routingCHGraph;
        private LandmarkStorage lm;

        Fixture(Algo algo, boolean prepareCH, boolean prepareLM, TraversalMode traversalMode) {
            this.algo = algo;
            this.prepareCH = prepareCH;
            this.prepareLM = prepareLM;
            this.traversalMode = traversalMode;
            this.maxTurnCosts = 10;
            this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
            this.turnCostEnc = TurnCost.create((String)"car", (int)this.maxTurnCosts);
            this.encodingManager = new EncodingManager.Builder().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).add((EncodedValue)Subnetwork.create((String)"car")).build();
            this.graph = new BaseGraph.Builder(this.encodingManager).withTurnCosts(true).create();
            this.turnCostStorage = this.graph.getTurnCostStorage();
        }

        public String toString() {
            return String.valueOf((Object)this.algo) + ", " + String.valueOf(this.traversalMode);
        }

        private void preProcessGraph() {
            this.graph.freeze();
            SpeedWeighting speedWeighting = this.weighting = this.traversalMode.isEdgeBased() ? new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.graph.getTurnCostStorage(), Double.POSITIVE_INFINITY) : new SpeedWeighting(this.speedEnc);
            if (this.prepareCH) {
                CHConfig chConfig = this.traversalMode.isEdgeBased() ? CHConfig.edgeBased((String)"p", (Weighting)this.weighting) : CHConfig.nodeBased((String)"p", (Weighting)this.weighting);
                PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
                PrepareContractionHierarchies.Result res = pch.doWork();
                this.routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
            }
            if (this.prepareLM) {
                LMConfig lmConfig = new LMConfig("car", (Weighting)new SpeedWeighting(this.speedEnc));
                PrepareLandmarks prepare = new PrepareLandmarks(this.graph.getDirectory(), this.graph, (EncodedValueLookup)this.encodingManager, lmConfig, 16);
                prepare.setMaximumWeight(10000.0);
                prepare.doWork();
                this.lm = prepare.getLandmarkStorage();
            }
        }

        private RoutingAlgorithm createAlgo() {
            return this.createAlgo((Graph)this.graph);
        }

        private RoutingAlgorithm createAlgo(Graph graph) {
            switch (this.algo.ordinal()) {
                case 0: {
                    return new Dijkstra(graph, graph.wrapWeighting(this.weighting), this.traversalMode);
                }
                case 2: {
                    return new AStar(graph, graph.wrapWeighting(this.weighting), this.traversalMode);
                }
                case 1: {
                    return new AStarBidirection(graph, graph.wrapWeighting(this.weighting), this.traversalMode);
                }
                case 4: {
                    CHRoutingAlgorithmFactory algoFactory = graph instanceof QueryGraph ? new CHRoutingAlgorithmFactory((RoutingCHGraph)new QueryRoutingCHGraph(this.routingCHGraph, (QueryGraph)graph)) : new CHRoutingAlgorithmFactory(this.routingCHGraph);
                    return algoFactory.createAlgo(new PMap().putObject("algorithm", (Object)"dijkstrabi"));
                }
                case 3: {
                    CHRoutingAlgorithmFactory algoFactory = graph instanceof QueryGraph ? new CHRoutingAlgorithmFactory((RoutingCHGraph)new QueryRoutingCHGraph(this.routingCHGraph, (QueryGraph)graph)) : new CHRoutingAlgorithmFactory(this.routingCHGraph);
                    return algoFactory.createAlgo(new PMap().putObject("algorithm", (Object)"astarbi"));
                }
                case 5: {
                    return new LMRoutingAlgorithmFactory(this.lm).createAlgo(graph, this.weighting, new AlgorithmOptions().setAlgorithm("astarbi").setTraversalMode(this.traversalMode));
                }
                case 6: {
                    return new LMRoutingAlgorithmFactory(this.lm).createAlgo(graph, this.weighting, new AlgorithmOptions().setAlgorithm("astar").setTraversalMode(this.traversalMode));
                }
                case 7: {
                    AStarBidirection perfectAStarBi = new AStarBidirection(graph, this.weighting, this.traversalMode);
                    perfectAStarBi.setApproximation((WeightApproximator)new PerfectApproximator(graph, this.weighting, this.traversalMode, false));
                    return perfectAStarBi;
                }
            }
            throw new IllegalArgumentException("unknown algo " + String.valueOf((Object)this.algo));
        }
    }

    private static class RepeatedFixtureProvider
    implements ArgumentsProvider {
        private RepeatedFixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.generate(() -> new FixtureProvider().provideArguments(context)).limit(5L).flatMap(s -> s);
        }
    }

    private static enum Algo {
        DIJKSTRA,
        ASTAR_BIDIR,
        ASTAR_UNIDIR,
        CH_ASTAR,
        CH_DIJKSTRA,
        LM_BIDIR,
        LM_UNIDIR,
        PERFECT_ASTAR;

    }

    private static class FixtureProvider
    implements ArgumentsProvider {
        private FixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of(FixtureSupplier.create(Algo.DIJKSTRA, false, false, TraversalMode.NODE_BASED), FixtureSupplier.create(Algo.ASTAR_UNIDIR, false, false, TraversalMode.NODE_BASED), FixtureSupplier.create(Algo.ASTAR_BIDIR, false, false, TraversalMode.NODE_BASED), FixtureSupplier.create(Algo.CH_ASTAR, true, false, TraversalMode.NODE_BASED), FixtureSupplier.create(Algo.CH_DIJKSTRA, true, false, TraversalMode.NODE_BASED), FixtureSupplier.create(Algo.LM_UNIDIR, false, true, TraversalMode.NODE_BASED), FixtureSupplier.create(Algo.LM_BIDIR, false, true, TraversalMode.NODE_BASED), FixtureSupplier.create(Algo.DIJKSTRA, false, false, TraversalMode.EDGE_BASED), FixtureSupplier.create(Algo.ASTAR_UNIDIR, false, false, TraversalMode.EDGE_BASED), FixtureSupplier.create(Algo.ASTAR_BIDIR, false, false, TraversalMode.EDGE_BASED), FixtureSupplier.create(Algo.CH_ASTAR, true, false, TraversalMode.EDGE_BASED), FixtureSupplier.create(Algo.CH_DIJKSTRA, true, false, TraversalMode.EDGE_BASED), FixtureSupplier.create(Algo.LM_UNIDIR, false, true, TraversalMode.EDGE_BASED), FixtureSupplier.create(Algo.LM_BIDIR, false, true, TraversalMode.EDGE_BASED), FixtureSupplier.create(Algo.PERFECT_ASTAR, false, false, TraversalMode.NODE_BASED)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

