/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.AlternativeRouteTest;
import com.graphhopper.routing.FlexiblePathCalculator;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoundTripRouting;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FiniteWeightFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoundTripRoutingTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
    private final EncodingManager em = EncodingManager.start().add((EncodedValue)this.speedEnc).build();
    private final Weighting weighting = new SpeedWeighting(this.speedEnc);
    private final TraversalMode tMode = TraversalMode.NODE_BASED;
    private final GHPoint ghPoint1 = new GHPoint(0.0, 0.0);
    private final GHPoint ghPoint2 = new GHPoint(1.0, 1.0);

    @Test
    public void lookup_throwsIfNumberOfPointsNotOne() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RoundTripRouting.lookup(Arrays.asList(this.ghPoint1, this.ghPoint2), (EdgeFilter)new FiniteWeightFilter(this.weighting), null, (RoundTripRouting.Params)new RoundTripRouting.Params()));
    }

    @Test
    public void testLookupAndCalcPaths_simpleSquareGraph() {
        BaseGraph g = this.createSquareGraph();
        GHPoint start = new GHPoint(1.0, -1.0);
        double heading = 180.0;
        int numPoints = 2;
        double roundTripDistance = 670000.0;
        PMap hints = new PMap();
        hints.putObject("round_trip.points", (Object)numPoints);
        hints.putObject("round_trip.distance", (Object)roundTripDistance);
        LocationIndex locationIndex = new LocationIndexTree((Graph)g, (Directory)new RAMDirectory()).prepareIndex();
        List stagePoints = RoundTripRouting.lookup(Collections.singletonList(start), (EdgeFilter)new FiniteWeightFilter(this.weighting), (LocationIndex)locationIndex, (RoundTripRouting.Params)new RoundTripRouting.Params(hints, heading, 3));
        Assertions.assertEquals((int)3, (int)stagePoints.size());
        Assertions.assertEquals((int)0, (int)((Snap)stagePoints.get(0)).getClosestNode());
        Assertions.assertEquals((int)6, (int)((Snap)stagePoints.get(1)).getClosestNode());
        Assertions.assertEquals((int)0, (int)((Snap)stagePoints.get(2)).getClosestNode());
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)g, (List)stagePoints);
        List paths = RoundTripRouting.calcPaths((List)stagePoints, (FlexiblePathCalculator)new FlexiblePathCalculator((QueryGraph)queryGraph, (RoutingAlgorithmFactory)new RoutingAlgorithmFactorySimple(), (Weighting)this.weighting, (AlgorithmOptions)new AlgorithmOptions().setAlgorithm((String)"dijkstrabi").setTraversalMode((TraversalMode)this.tMode))).paths;
        Assertions.assertEquals((int)2, (int)paths.size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 7, 6, 5}), (Object)((Path)paths.get(0)).calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4, 3, 2, 1, 0}), (Object)((Path)paths.get(1)).calcNodes());
    }

    @Test
    public void testCalcRoundTrip() {
        BaseGraph g = this.createTestGraph();
        LocationIndex locationIndex = new LocationIndexTree((Graph)g, (Directory)new RAMDirectory()).prepareIndex();
        Snap snap4 = locationIndex.findClosest(0.05, 0.25, EdgeFilter.ALL_EDGES);
        Assertions.assertEquals((int)4, (int)snap4.getClosestNode());
        Snap snap5 = locationIndex.findClosest(0.0, 0.05, EdgeFilter.ALL_EDGES);
        Assertions.assertEquals((int)5, (int)snap5.getClosestNode());
        Snap snap6 = locationIndex.findClosest(0.0, 0.1, EdgeFilter.ALL_EDGES);
        Assertions.assertEquals((int)6, (int)snap6.getClosestNode());
        QueryGraph qGraph = QueryGraph.create((BaseGraph)g, Arrays.asList(snap4, snap5));
        FlexiblePathCalculator pathCalculator = new FlexiblePathCalculator(qGraph, (RoutingAlgorithmFactory)new RoutingAlgorithmFactorySimple(), this.weighting, new AlgorithmOptions().setAlgorithm("dijkstrabi").setTraversalMode(this.tMode));
        List paths = RoundTripRouting.calcPaths(Arrays.asList(new Snap[]{snap5, snap4, snap5}), (FlexiblePathCalculator)pathCalculator).paths;
        Assertions.assertEquals((int)2, (int)paths.size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 3}), (Object)((Path)paths.get(0)).calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3, 2, 9, 1, 5}), (Object)((Path)paths.get(1)).calcNodes());
        qGraph = QueryGraph.create((BaseGraph)g, Arrays.asList(snap4, snap6));
        pathCalculator = new FlexiblePathCalculator(qGraph, (RoutingAlgorithmFactory)new RoutingAlgorithmFactorySimple(), this.weighting, new AlgorithmOptions().setAlgorithm("dijkstrabi").setTraversalMode(this.tMode));
        paths = RoundTripRouting.calcPaths(Arrays.asList(new Snap[]{snap6, snap4, snap6}), (FlexiblePathCalculator)pathCalculator).paths;
        Assertions.assertEquals((int)2, (int)paths.size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{6, 3}), (Object)((Path)paths.get(0)).calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3, 4, 8, 7, 6}), (Object)((Path)paths.get(1)).calcNodes());
    }

    private BaseGraph createTestGraph() {
        BaseGraph graph = new BaseGraph.Builder(this.em).withTurnCosts(true).create();
        AlternativeRouteTest.initTestGraph((Graph)graph, this.speedEnc);
        return graph;
    }

    private BaseGraph createSquareGraph() {
        BaseGraph graph = new BaseGraph.Builder(this.em).create();
        for (int i = 0; i < 8; ++i) {
            graph.edge(i, (i + 1) % 8).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        }
        GHUtility.updateDistancesFor((Graph)graph, (int)0, (double[])new double[]{1.0, -1.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)1, (double[])new double[]{1.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)2, (double[])new double[]{1.0, 1.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)3, (double[])new double[]{0.0, 1.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)4, (double[])new double[]{-1.0, 1.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)5, (double[])new double[]{-1.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)6, (double[])new double[]{-1.0, -1.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)7, (double[])new double[]{0.0, -1.0});
        return graph;
    }
}

