/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.DijkstraOneToMany;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryRoutingCHGraph;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingAlgorithmTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingAlgorithmTest.class);

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCalcShortestPath(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        RoutingAlgorithmTest.initTestStorage((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, 0, 7);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 4, 5, 7), (Object)p.calcNodes(), (String)p.toString());
        Assertions.assertEquals((double)62.1, (double)p.getDistance(), (double)0.1, (String)p.toString());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCalcShortestPath_sourceEqualsTarget(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        graph.edge(0, 1).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(1, 2).setDistance(2.0).set(f.carSpeedEnc, 60.0, 60.0);
        Path p = f.calcPath(graph, 0, 0);
        RoutingAlgorithmTest.assertPathFromEqualsTo(p, 0);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testSimpleAlternative(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        graph.edge(0, 2).setDistance(9.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(2, 1).setDistance(2.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(11.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(3, 4).setDistance(6.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(4, 1).setDistance(9.0).set(f.carSpeedEnc, 60.0, 60.0);
        Path p = f.calcPath(graph, 0, 4);
        Assertions.assertEquals((double)20.0, (double)p.getDistance(), (double)1.0E-4, (String)p.toString());
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 2, 1, 4), (Object)p.calcNodes());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testBidirectionalLinear(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        graph.edge(2, 1).setDistance(2.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(11.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(5, 4).setDistance(6.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(4, 1).setDistance(9.0).set(f.carSpeedEnc, 60.0, 60.0);
        Path p = f.calcPath(graph, 3, 5);
        Assertions.assertEquals((double)28.0, (double)p.getDistance(), (double)1.0E-4, (String)p.toString());
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(3, 2, 1, 4, 5), (Object)p.calcNodes());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCalcFastestPath(Fixture f) {
        BaseGraph graph = f.createGHStorage(false);
        RoutingAlgorithmTest.initDirectedAndDiffSpeed((Graph)graph, f.carSpeedEnc);
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            if (iter.get(f.carSpeedEnc) > 0.0) {
                iter.set(f.carSpeedEnc, 10.0);
            }
            if (!(iter.getReverse(f.carSpeedEnc) > 0.0)) continue;
            iter.setReverse(f.carSpeedEnc, 10.0);
        }
        Path p1 = f.calcPath(graph, f.defaultWeighting, 0, 3);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 1, 5, 2, 3), (Object)p1.calcNodes());
        Assertions.assertEquals((double)402.3, (double)p1.getDistance(), (double)0.1, (String)p1.toString());
        Assertions.assertEquals((long)40228L, (long)p1.getTime(), (String)p1.toString());
        graph = f.createGHStorage(false);
        RoutingAlgorithmTest.initDirectedAndDiffSpeed((Graph)graph, f.carSpeedEnc);
        SpeedWeighting weighting = new SpeedWeighting(f.carSpeedEnc);
        Path p2 = f.calcPath(graph, (Weighting)weighting, 0, 3);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 4, 6, 7, 5, 3), (Object)p2.calcNodes());
        Assertions.assertEquals((double)1261.7, (double)p2.getDistance(), (double)0.1, (String)p2.toString());
        Assertions.assertEquals((long)30953L, (long)p2.getTime(), (String)p2.toString());
    }

    static void initDirectedAndDiffSpeed(Graph graph, DecimalEncodedValue speedEnc) {
        graph.edge(0, 1).set(speedEnc, 10.0, 0.0);
        graph.edge(0, 4).set(speedEnc, 100.0, 0.0);
        graph.edge(1, 4).set(speedEnc, 10.0, 10.0);
        graph.edge(1, 5).set(speedEnc, 10.0, 10.0);
        EdgeIteratorState edge12 = graph.edge(1, 2).set(speedEnc, 10.0, 10.0);
        graph.edge(5, 2).set(speedEnc, 10.0, 0.0);
        graph.edge(2, 3).set(speedEnc, 10.0, 0.0);
        EdgeIteratorState edge53 = graph.edge(5, 3).set(speedEnc, 20.0, 0.0);
        graph.edge(3, 7).set(speedEnc, 10.0, 0.0);
        graph.edge(4, 6).set(speedEnc, 100.0, 0.0);
        graph.edge(5, 4).set(speedEnc, 10.0, 0.0);
        graph.edge(5, 6).set(speedEnc, 10.0, 0.0);
        graph.edge(7, 5).set(speedEnc, 100.0, 0.0);
        graph.edge(6, 7).set(speedEnc, 100.0, 100.0);
        GHUtility.updateDistancesFor((Graph)graph, (int)0, (double[])new double[]{0.002, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)1, (double[])new double[]{0.002, 0.001});
        GHUtility.updateDistancesFor((Graph)graph, (int)2, (double[])new double[]{0.002, 0.002});
        GHUtility.updateDistancesFor((Graph)graph, (int)3, (double[])new double[]{0.002, 0.003});
        GHUtility.updateDistancesFor((Graph)graph, (int)4, (double[])new double[]{0.0015, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)5, (double[])new double[]{0.0015, 0.001});
        GHUtility.updateDistancesFor((Graph)graph, (int)6, (double[])new double[]{0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)7, (double[])new double[]{0.001, 0.003});
        edge12.setDistance(edge12.getDistance() * 2.0);
        edge53.setDistance(edge53.getDistance() * 2.0);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCalcFootPath(Fixture f) {
        SpeedWeighting weighting = new SpeedWeighting(f.footSpeedEnc);
        BaseGraph graph = f.createGHStorage(false);
        RoutingAlgorithmTest.initFootVsCar(f.carSpeedEnc, f.footSpeedEnc, (Graph)graph);
        Path p1 = f.calcPath(graph, (Weighting)weighting, 0, 7);
        Assertions.assertEquals((double)17000.0, (double)p1.getDistance(), (double)1.0E-6, (String)p1.toString());
        Assertions.assertEquals((long)3400000L, (long)p1.getTime(), (String)p1.toString());
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 4, 5, 7), (Object)p1.calcNodes());
    }

    static void initFootVsCar(DecimalEncodedValue carSpeedEnc, DecimalEncodedValue footSpeedEnc, Graph graph) {
        EdgeIteratorState edge = graph.edge(0, 1).setDistance(7000.0);
        edge.set(footSpeedEnc, 5.0, 5.0);
        edge.set(carSpeedEnc, 10.0, 0.0);
        edge = graph.edge(0, 4).setDistance(5000.0);
        edge.set(footSpeedEnc, 5.0, 5.0);
        edge.set(carSpeedEnc, 20.0, 0.0);
        graph.edge(1, 4).setDistance(7000.0).set(carSpeedEnc, 10.0, 10.0);
        graph.edge(1, 5).setDistance(7000.0).set(carSpeedEnc, 10.0, 10.0);
        edge = graph.edge(1, 2).setDistance(20000.0);
        edge.set(footSpeedEnc, 5.0, 5.0);
        edge.set(carSpeedEnc, 10.0, 10.0);
        graph.edge(5, 2).setDistance(5000.0).set(carSpeedEnc, 10.0, 0.0);
        edge = graph.edge(2, 3).setDistance(5000.0);
        edge.set(footSpeedEnc, 5.0, 5.0);
        edge.set(carSpeedEnc, 10.0, 0.0);
        graph.edge(5, 3).setDistance(11000.0).set(carSpeedEnc, 20.0, 0.0);
        edge = graph.edge(3, 7).setDistance(7000.0);
        edge.set(footSpeedEnc, 5.0, 5.0);
        edge.set(carSpeedEnc, 10.0, 0.0);
        graph.edge(4, 6).setDistance(5000.0).set(carSpeedEnc, 20.0, 0.0);
        edge = graph.edge(5, 4).setDistance(7000.0);
        edge.set(footSpeedEnc, 5.0, 5.0);
        edge.set(carSpeedEnc, 10.0, 0.0);
        graph.edge(5, 6).setDistance(7000.0).set(carSpeedEnc, 10.0, 0.0);
        edge = graph.edge(7, 5).setDistance(5000.0);
        edge.set(footSpeedEnc, 5.0, 5.0);
        edge.set(carSpeedEnc, 20.0, 0.0);
        graph.edge(6, 7).setDistance(5000.0).set(carSpeedEnc, 20.0, 20.0);
    }

    static void initTestStorage(Graph graph, DecimalEncodedValue speedEnc) {
        graph.edge(0, 1).setDistance(7.0).set(speedEnc, 60.0, 60.0);
        graph.edge(0, 4).setDistance(6.0).set(speedEnc, 60.0, 60.0);
        graph.edge(1, 4).setDistance(2.0).set(speedEnc, 60.0, 60.0);
        graph.edge(1, 5).setDistance(8.0).set(speedEnc, 60.0, 60.0);
        graph.edge(1, 2).setDistance(2.0).set(speedEnc, 60.0, 60.0);
        graph.edge(2, 5).setDistance(5.0).set(speedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(2.0).set(speedEnc, 60.0, 60.0);
        graph.edge(3, 5).setDistance(2.0).set(speedEnc, 60.0, 60.0);
        graph.edge(3, 7).setDistance(10.0).set(speedEnc, 60.0, 60.0);
        graph.edge(4, 6).setDistance(4.0).set(speedEnc, 60.0, 60.0);
        graph.edge(4, 5).setDistance(7.0).set(speedEnc, 60.0, 60.0);
        graph.edge(5, 6).setDistance(2.0).set(speedEnc, 60.0, 60.0);
        graph.edge(5, 7).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        EdgeIteratorState edge6_7 = graph.edge(6, 7).setDistance(5.0).set(speedEnc, 60.0, 60.0);
        GHUtility.updateDistancesFor((Graph)graph, (int)0, (double[])new double[]{0.001, 1.0E-5});
        GHUtility.updateDistancesFor((Graph)graph, (int)1, (double[])new double[]{8.0E-4, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)2, (double[])new double[]{5.0E-4, 1.0E-4});
        GHUtility.updateDistancesFor((Graph)graph, (int)3, (double[])new double[]{6.0E-4, 2.0E-4});
        GHUtility.updateDistancesFor((Graph)graph, (int)4, (double[])new double[]{9.0E-4, 1.0E-4});
        GHUtility.updateDistancesFor((Graph)graph, (int)5, (double[])new double[]{7.0E-4, 1.0E-4});
        GHUtility.updateDistancesFor((Graph)graph, (int)6, (double[])new double[]{9.0E-4, 2.0E-4});
        GHUtility.updateDistancesFor((Graph)graph, (int)7, (double[])new double[]{8.0E-4, 3.0E-4});
        edge6_7.setDistance(5.0 * edge6_7.getDistance());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testNoPathFound(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        graph.edge(100, 101);
        Assertions.assertFalse((boolean)f.calcPath(graph, 0, 1).isFound());
        graph = f.createGHStorage();
        graph.edge(100, 101);
        graph.edge(0, 1).setDistance(7.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(5, 6).setDistance(2.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(5, 7).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(5, 8).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(7, 8).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        Assertions.assertFalse((boolean)f.calcPath(graph, 0, 5).isFound());
        graph = f.createGHStorage();
        graph.edge(0, 1).setDistance(1.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(0, 2).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        f.resetCH();
        Assertions.assertFalse((boolean)f.calcPath(graph, 1, 2).isFound());
        Assertions.assertTrue((boolean)f.calcPath(graph, 2, 1).isFound());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testWikipediaShortestPath(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        this.initWikipediaTestGraph((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, 0, 4);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 2, 5, 4), (Object)p.calcNodes(), (String)p.toString());
        Assertions.assertEquals((double)20.0, (double)p.getDistance(), (double)1.0E-4, (String)p.toString());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCalcIf1EdgeAway(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        RoutingAlgorithmTest.initTestStorage((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, 1, 2);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(1, 2), (Object)p.calcNodes());
        Assertions.assertEquals((double)35.1, (double)p.getDistance(), (double)0.1, (String)p.toString());
    }

    private void initWikipediaTestGraph(Graph graph, DecimalEncodedValue speedEnc) {
        graph.edge(0, 1).setDistance(7.0).set(speedEnc, 60.0, 60.0);
        graph.edge(0, 2).setDistance(9.0).set(speedEnc, 60.0, 60.0);
        graph.edge(0, 5).setDistance(14.0).set(speedEnc, 60.0, 60.0);
        graph.edge(1, 2).setDistance(10.0).set(speedEnc, 60.0, 60.0);
        graph.edge(1, 3).setDistance(15.0).set(speedEnc, 60.0, 60.0);
        graph.edge(2, 5).setDistance(2.0).set(speedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(11.0).set(speedEnc, 60.0, 60.0);
        graph.edge(3, 4).setDistance(6.0).set(speedEnc, 60.0, 60.0);
        graph.edge(4, 5).setDistance(9.0).set(speedEnc, 60.0, 60.0);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testBidirectional(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        RoutingAlgorithmTest.initBiGraph((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, 0, 4);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 7, 6, 8, 3, 4), (Object)p.calcNodes(), (String)p.toString());
        Assertions.assertEquals((double)335.8, (double)p.getDistance(), (double)0.1, (String)p.toString());
        p = f.calcPath(graph, 1, 2);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(1, 2), (Object)p.calcNodes(), (String)p.toString());
        Assertions.assertEquals((double)10007.7, (double)p.getDistance(), (double)0.1, (String)p.toString());
    }

    public static void initBiGraph(Graph graph, DecimalEncodedValue speedEnc) {
        graph.edge(0, 1).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(1, 2).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(3, 4).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(4, 5).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(5, 6).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(6, 7).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(7, 0).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(3, 8).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(8, 6).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        GHUtility.updateDistancesFor((Graph)graph, (int)0, (double[])new double[]{0.001, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)1, (double[])new double[]{0.1, 5.0E-4});
        GHUtility.updateDistancesFor((Graph)graph, (int)2, (double[])new double[]{0.01, 0.001});
        GHUtility.updateDistancesFor((Graph)graph, (int)3, (double[])new double[]{0.001, 0.0011});
        GHUtility.updateDistancesFor((Graph)graph, (int)4, (double[])new double[]{0.001, 0.00111});
        GHUtility.updateDistancesFor((Graph)graph, (int)8, (double[])new double[]{5.0E-4, 0.0011});
        GHUtility.updateDistancesFor((Graph)graph, (int)7, (double[])new double[]{0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)6, (double[])new double[]{0.0, 0.001});
        GHUtility.updateDistancesFor((Graph)graph, (int)5, (double[])new double[]{0.0, 0.004});
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCreateAlgoTwice(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        graph.edge(0, 1).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(1, 2).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(3, 4).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(4, 5).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(5, 6).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(6, 7).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(7, 0).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(3, 8).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(8, 6).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        Path p1 = f.calcPath(graph, 0, 4);
        Path p2 = f.calcPath(graph, 0, 4);
        Assertions.assertEquals((Object)p1.calcNodes(), (Object)p2.calcNodes());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testMaxVisitedNodes(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        RoutingAlgorithmTest.initBiGraph((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, 0, 4);
        Assertions.assertTrue((boolean)p.isFound());
        int maxVisitedNodes = 3;
        p = f.calcPath(graph, f.defaultWeighting, maxVisitedNodes, 0, 4);
        Assertions.assertFalse((boolean)p.isFound());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testBidirectional2(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        this.initBidirGraphManualDistances(graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, 0, 4);
        Assertions.assertEquals((double)40.0, (double)p.getDistance(), (double)1.0E-4, (String)p.toString());
        Assertions.assertEquals((int)5, (int)p.calcNodes().size(), (String)p.toString());
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 7, 6, 5, 4), (Object)p.calcNodes());
    }

    private void initBidirGraphManualDistances(BaseGraph graph, DecimalEncodedValue speedEnc) {
        graph.edge(0, 1).setDistance(100.0).set(speedEnc, 60.0, 60.0);
        graph.edge(1, 2).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(3, 4).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(4, 5).setDistance(20.0).set(speedEnc, 60.0, 60.0);
        graph.edge(5, 6).setDistance(10.0).set(speedEnc, 60.0, 60.0);
        graph.edge(6, 7).setDistance(5.0).set(speedEnc, 60.0, 60.0);
        graph.edge(7, 0).setDistance(5.0).set(speedEnc, 60.0, 60.0);
        graph.edge(3, 8).setDistance(20.0).set(speedEnc, 60.0, 60.0);
        graph.edge(8, 6).setDistance(20.0).set(speedEnc, 60.0, 60.0);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testRekeyBugOfIntBinHeap(Fixture f) {
        BaseGraph matrixGraph = f.createGHStorage();
        RoutingAlgorithmTest.initMatrixALikeGraph(matrixGraph, f.carSpeedEnc);
        Path p = f.calcPath(matrixGraph, 36, 91);
        Assertions.assertEquals((int)12, (int)p.calcNodes().size());
        IntIndexedContainer nodes = p.calcNodes();
        if (!RoutingAlgorithmTest.nodes(36, 46, 56, 66, 76, 86, 85, 84, 94, 93, 92, 91).equals((Object)nodes) && !RoutingAlgorithmTest.nodes(36, 46, 56, 66, 76, 86, 85, 84, 83, 82, 92, 91).equals((Object)nodes)) {
            Assertions.fail((String)("wrong locations: " + nodes.toString()));
        }
        Assertions.assertEquals((double)66.0, (double)p.getDistance(), (double)0.001);
        this.testBug1(f, matrixGraph);
        this.testCorrectWeight(f, matrixGraph);
    }

    private static void initMatrixALikeGraph(BaseGraph tmpGraph, DecimalEncodedValue speedEnc) {
        int WIDTH = 10;
        int HEIGHT = 15;
        int[][] matrix = new int[WIDTH][HEIGHT];
        int counter = 0;
        Random rand = new Random(12L);
        boolean print = false;
        for (int h = 0; h < HEIGHT; ++h) {
            float dist;
            int w;
            for (w = 0; w < WIDTH; ++w) {
                matrix[w][h] = counter++;
                if (h <= 0) continue;
                dist = 5 + Math.abs(rand.nextInt(5));
                tmpGraph.edge(matrix[w][h], matrix[w][h - 1]).setDistance((double)dist).set(speedEnc, 60.0, 60.0);
            }
            for (w = 0; w < WIDTH; ++w) {
                if (w <= 0) continue;
                dist = 5 + Math.abs(rand.nextInt(5));
                tmpGraph.edge(matrix[w][h], matrix[w - 1][h]).setDistance((double)dist).set(speedEnc, 60.0, 60.0);
            }
        }
    }

    private void testBug1(Fixture f, BaseGraph g) {
        Path p = f.calcPath(g, 34, 36);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(34, 35, 36), (Object)p.calcNodes());
        Assertions.assertEquals((int)3, (int)p.calcNodes().size());
        Assertions.assertEquals((double)17.0, (double)p.getDistance(), (double)1.0E-5);
    }

    private void testCorrectWeight(Fixture f, BaseGraph g) {
        Path p = f.calcPath(g, 45, 72);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(45, 44, 54, 64, 74, 73, 72), (Object)p.calcNodes());
        Assertions.assertEquals((double)38.0, (double)p.getDistance(), (double)0.001);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCannotCalculateSP(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        graph.edge(0, 1).setDistance(1.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(1, 2).setDistance(1.0).set(f.carSpeedEnc, 60.0, 0.0);
        Path p = f.calcPath(graph, 0, 2);
        Assertions.assertEquals((int)3, (int)p.calcNodes().size(), (String)p.toString());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testDirectedGraphBug1(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        graph.edge(0, 1).setDistance(3.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(1, 2).setDistance(2.99).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(0, 3).setDistance(2.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(3, 4).setDistance(3.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(4, 2).setDistance(1.0).set(f.carSpeedEnc, 60.0, 0.0);
        Path p = f.calcPath(graph, 0, 2);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 1, 2), (Object)p.calcNodes(), (String)p.toString());
        Assertions.assertEquals((double)5.99, (double)p.getDistance(), (double)1.0E-4, (String)p.toString());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testDirectedGraphBug2(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        graph.edge(0, 1).setDistance(1.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(1, 2).setDistance(1.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(2, 3).setDistance(1.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(3, 1).setDistance(4.0).set(f.carSpeedEnc, 60.0, 60.0);
        Path p = f.calcPath(graph, 0, 3);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 1, 2, 3), (Object)p.calcNodes());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testWithCoordinates(Fixture f) {
        SpeedWeighting weighting = new SpeedWeighting(f.carSpeedEnc);
        BaseGraph graph = f.createGHStorage(false);
        graph.edge(0, 1).setDistance(2.0).set(f.carSpeedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{1.5, 1.0}));
        graph.edge(2, 3).setDistance(2.0).set(f.carSpeedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{0.0, 1.5}));
        graph.edge(3, 4).setDistance(2.0).set(f.carSpeedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{0.0, 2.0}));
        graph.edge(0, 2).setDistance(1.2).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(0, 2).setDistance(1.5).set(f.carSpeedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{0.5, 0.0}));
        graph.edge(1, 3).setDistance(1.3).set(f.carSpeedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{0.5, 1.5}));
        graph.edge(1, 4).setDistance(1.0).set(f.carSpeedEnc, 60.0, 60.0);
        GHUtility.updateDistancesFor((Graph)graph, (int)0, (double[])new double[]{1.0, 0.6});
        GHUtility.updateDistancesFor((Graph)graph, (int)1, (double[])new double[]{1.0, 1.5});
        GHUtility.updateDistancesFor((Graph)graph, (int)2, (double[])new double[]{0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)3, (double[])new double[]{0.0, 1.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)4, (double[])new double[]{0.0, 2.0});
        Path p = f.calcPath(graph, (Weighting)weighting, 4, 0);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(4, 1, 0), (Object)p.calcNodes());
        Assertions.assertEquals((Object)Helper.createPointList((double[])new double[]{0.0, 2.0, 1.0, 1.5, 1.5, 1.0, 1.0, 0.6}), (Object)p.calcPoints());
        Assertions.assertEquals((double)274128.0, (double)new DistanceCalcEarth().calcDistance(p.calcPoints()), (double)1.0);
        p = f.calcPath(graph, (Weighting)weighting, 2, 1);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(2, 0, 1), (Object)p.calcNodes());
        Assertions.assertEquals((Object)Helper.createPointList((double[])new double[]{0.0, 0.0, 1.0, 0.6, 1.5, 1.0, 1.0, 1.5}), (Object)p.calcPoints());
        Assertions.assertEquals((double)279482.0, (double)new DistanceCalcEarth().calcDistance(p.calcPoints()), (double)1.0);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCalcIfEmptyWay(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        RoutingAlgorithmTest.initTestStorage((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, 0, 0);
        RoutingAlgorithmTest.assertPathFromEqualsTo(p, 0);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testViaEdges_FromEqualsTo(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        RoutingAlgorithmTest.initTestStorage((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, new GHPoint(0.001, 0.0), new GHPoint(0.001, 0.0));
        RoutingAlgorithmTest.assertPathFromEqualsTo(p, 0);
        p = f.calcPath(graph, f.defaultWeighting, 0, 1, 0, 1);
        RoutingAlgorithmTest.assertPathFromEqualsTo(p, 8);
        p = f.calcPath(graph, new GHPoint(9.2E-4, 0.0), new GHPoint(9.1E-4, 0.0));
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(8, 9), (Object)p.calcNodes());
        Assertions.assertEquals((double)1.11, (double)p.getDistance(), (double)0.1, (String)p.toString());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testViaEdges_BiGraph(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        RoutingAlgorithmTest.initBiGraph((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, new GHPoint(9.0E-4, 0.0), new GHPoint(0.001, 0.001105));
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(10, 7, 6, 8, 3, 9), (Object)p.calcNodes(), (String)p.toString());
        Assertions.assertEquals((double)324.12, (double)p.getDistance(), (double)0.01, (String)p.toString());
        p = f.calcPath(graph, new GHPoint(0.001, 1.0E-4), new GHPoint(0.01, 0.0011));
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 7, 6, 8, 3, 9), (Object)p.calcNodes(), (String)p.toString());
        Assertions.assertEquals((double)1335.38, (double)p.getDistance(), (double)0.01, (String)p.toString());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testViaEdges_WithCoordinates(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        RoutingAlgorithmTest.initTestStorage((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, f.defaultWeighting, 0, 1, 2, 3);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(8, 1, 2, 9), (Object)p.calcNodes());
        Assertions.assertEquals((double)56.7, (double)p.getDistance(), (double)0.1, (String)p.toString());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testViaEdges_SpecialCases(Fixture f) {
        BaseGraph graph = f.createGHStorage();
        graph.edge(0, 1).setDistance(7.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(1, 2).setDistance(7.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(7.0).set(f.carSpeedEnc, 60.0, 60.0);
        graph.edge(3, 4).setDistance(7.0).set(f.carSpeedEnc, 60.0, 0.0);
        graph.edge(4, 0).setDistance(7.0).set(f.carSpeedEnc, 60.0, 60.0);
        GHUtility.updateDistancesFor((Graph)graph, (int)4, (double[])new double[]{0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)0, (double[])new double[]{1.0E-4, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)1, (double[])new double[]{1.0E-4, 1.0E-4});
        GHUtility.updateDistancesFor((Graph)graph, (int)2, (double[])new double[]{5.0E-5, 1.5E-4});
        GHUtility.updateDistancesFor((Graph)graph, (int)3, (double[])new double[]{0.0, 1.0E-4});
        Path p = f.calcPath(graph, new GHPoint(1.0E-4, 1.0E-5), new GHPoint(0.0, 9.0E-5));
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(5, 1, 2, 3, 6), (Object)p.calcNodes());
        Assertions.assertEquals((double)26.81, (double)p.getDistance(), (double)0.1, (String)p.toString());
        p = f.calcPath(graph, new GHPoint(4.9E-5, 1.4E-4), new GHPoint(1.0E-5, 1.0E-4));
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(5, 6), (Object)p.calcNodes());
        Assertions.assertEquals((double)6.2, (double)p.getDistance(), (double)0.1, (String)p.toString());
        p = f.calcPath(graph, new GHPoint(9.0E-5, 1.1E-4), new GHPoint(1.0E-5, 1.1E-4));
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(6, 2, 5), (Object)p.calcNodes(), (String)p.toString());
        Assertions.assertEquals((double)12.57, (double)p.getDistance(), (double)0.1, (String)p.toString());
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testQueryGraphAndFastest(Fixture f) {
        SpeedWeighting weighting = new SpeedWeighting(f.carSpeedEnc);
        BaseGraph graph = f.createGHStorage(false);
        RoutingAlgorithmTest.initDirectedAndDiffSpeed((Graph)graph, f.carSpeedEnc);
        Path p = f.calcPath(graph, (Weighting)weighting, new GHPoint(0.002, 5.0E-4), new GHPoint(0.0017, 0.0031));
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(8, 1, 5, 3, 9), (Object)p.calcNodes());
        Assertions.assertEquals((double)602.98, (double)p.getDistance(), (double)0.1);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testTwoWeightsPerEdge(Fixture f) {
        SpeedWeighting weighting = new SpeedWeighting(f.bike2SpeedEnc);
        BaseGraph graph = f.createGHStorage(true);
        this.initEleGraph((Graph)graph, 18.0, f.bike2SpeedEnc);
        GHUtility.getEdge((Graph)graph, (int)0, (int)3).set(f.bike2SpeedEnc, 0.0, 10.0);
        Path p = f.calcPath(graph, (Weighting)weighting, 0, 10);
        Assertions.assertEquals((long)23645657L, (long)p.getTime());
        Assertions.assertEquals((double)425622.0, (double)p.getDistance(), (double)1.0);
        Assertions.assertEquals((double)23646.0, (double)p.getWeight(), (double)1.0);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testTwoWeightsPerEdge2(final Fixture f) {
        Weighting fakeWeighting = new Weighting(){
            private final Weighting tmpW;
            {
                this.tmpW = new SpeedWeighting(f.carSpeedEnc);
            }

            public double calcMinWeightPerDistance() {
                return 0.8;
            }

            public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
                if (Double.isInfinite(this.tmpW.calcEdgeWeight(edgeState, reverse))) {
                    return Double.POSITIVE_INFINITY;
                }
                int adj = edgeState.getAdjNode();
                int base = edgeState.getBaseNode();
                if (reverse) {
                    int tmp = base;
                    base = adj;
                    adj = tmp;
                }
                if (adj == 6) {
                    return 3.0 * edgeState.getDistance();
                }
                if (base == 6) {
                    return edgeState.getDistance() * 0.9;
                }
                if (adj == 4) {
                    return 2.0 * edgeState.getDistance();
                }
                return edgeState.getDistance() * 0.8;
            }

            public final long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
                return this.tmpW.calcEdgeMillis(edgeState, reverse);
            }

            public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
                return this.tmpW.calcTurnWeight(inEdge, viaNode, outEdge);
            }

            public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
                return this.tmpW.calcTurnMillis(inEdge, viaNode, outEdge);
            }

            public boolean hasTurnCosts() {
                return this.tmpW.hasTurnCosts();
            }

            public String getName() {
                return "custom";
            }

            public String toString() {
                return this.getName();
            }
        };
        BaseGraph graph = f.createGHStorage(true);
        this.initEleGraph((Graph)graph, 60.0, f.carSpeedEnc);
        Path p = f.calcPath(graph, 0, 10);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 4, 6, 10), (Object)p.calcNodes());
        graph = f.createGHStorage(true);
        this.initEleGraph((Graph)graph, 60.0, f.carSpeedEnc);
        p = f.calcPath(graph, fakeWeighting, 3, 0, 10, 9);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(12, 0, 1, 2, 11, 7, 10, 13), (Object)p.calcNodes());
        Assertions.assertEquals((long)10280445L, (long)p.getTime());
        Assertions.assertEquals((double)616827.0, (double)p.getDistance(), (double)1.0);
        Assertions.assertEquals((double)493462.0, (double)p.getWeight(), (double)1.0);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testRandomGraph(Fixture f) {
        SpeedWeighting weighting = new SpeedWeighting(f.carSpeedEnc);
        BaseGraph graph = f.createGHStorage(false);
        long seed = System.nanoTime();
        LOGGER.info("testRandomGraph - using seed: " + seed);
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)graph, (Random)rnd, (int)10, (double)2.0, (boolean)true, (DecimalEncodedValue)f.carSpeedEnc, null, (double)0.7, (double)0.7);
        DijkstraCalculator refCalculator = new DijkstraCalculator();
        int numRuns = 100;
        for (int i = 0; i < numRuns; ++i) {
            BBox bounds = graph.getBounds();
            double latFrom = bounds.minLat + rnd.nextDouble() * (bounds.maxLat - bounds.minLat);
            double lonFrom = bounds.minLon + rnd.nextDouble() * (bounds.maxLon - bounds.minLon);
            double latTo = bounds.minLat + rnd.nextDouble() * (bounds.maxLat - bounds.minLat);
            double lonTo = bounds.minLon + rnd.nextDouble() * (bounds.maxLon - bounds.minLon);
            f.compareWithRef((Weighting)weighting, graph, refCalculator, new GHPoint(latFrom, lonFrom), new GHPoint(latTo, lonTo), seed);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testMultipleVehicles_issue548(Fixture f) {
        SpeedWeighting footWeighting = new SpeedWeighting(f.footSpeedEnc);
        SpeedWeighting carWeighting = new SpeedWeighting(f.carSpeedEnc);
        BaseGraph graph = f.createGHStorage(false);
        RoutingAlgorithmTest.initFootVsCar(f.carSpeedEnc, f.footSpeedEnc, (Graph)graph);
        Path carPath1 = f.calcPath(graph, (Weighting)carWeighting, 0, 7);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 4, 6, 7), (Object)carPath1.calcNodes());
        Assertions.assertEquals((double)15000.0, (double)carPath1.getDistance(), (double)1.0E-6, (String)carPath1.toString());
        Path footPath1 = f.calcPath(graph, (Weighting)footWeighting, 0, 7);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 4, 5, 7), (Object)footPath1.calcNodes());
        Assertions.assertEquals((double)17000.0, (double)footPath1.getDistance(), (double)1.0E-6, (String)footPath1.toString());
        graph = f.createGHStorage(false);
        RoutingAlgorithmTest.initFootVsCar(f.carSpeedEnc, f.footSpeedEnc, (Graph)graph);
        GHUtility.getEdge((Graph)graph, (int)4, (int)6).set(f.carSpeedEnc, 0.0, 0.0);
        f.resetCH();
        Path carPath2 = f.calcPath(graph, (Weighting)carWeighting, 0, 7);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 1, 5, 6, 7), (Object)carPath2.calcNodes());
        Assertions.assertEquals((double)26000.0, (double)carPath2.getDistance(), (double)1.0E-6, (String)carPath2.toString());
        Path footPath2 = f.calcPath(graph, (Weighting)footWeighting, 0, 7);
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(0, 4, 5, 7), (Object)footPath2.calcNodes());
        Assertions.assertEquals((double)17000.0, (double)footPath2.getDistance(), (double)1.0E-6, (String)footPath2.toString());
    }

    private void initEleGraph(Graph graph, double s, DecimalEncodedValue speedEnc) {
        graph.edge(0, 1).setDistance(10.0).set(speedEnc, s, s);
        graph.edge(0, 4).setDistance(12.0).set(speedEnc, s, s);
        graph.edge(0, 3).setDistance(5.0).set(speedEnc, s, s);
        graph.edge(1, 2).setDistance(10.0).set(speedEnc, s, s);
        graph.edge(1, 4).setDistance(5.0).set(speedEnc, s, s);
        graph.edge(3, 5).setDistance(5.0).set(speedEnc, s, 0.0);
        graph.edge(5, 6).setDistance(10.0).set(speedEnc, s, s);
        graph.edge(5, 8).setDistance(10.0).set(speedEnc, s, s);
        graph.edge(6, 4).setDistance(5.0).set(speedEnc, s, s);
        graph.edge(6, 7).setDistance(10.0).set(speedEnc, s, s);
        graph.edge(6, 10).setDistance(12.0).set(speedEnc, s, s);
        graph.edge(6, 9).setDistance(12.0).set(speedEnc, s, s);
        graph.edge(2, 11).setDistance(5.0).set(speedEnc, s, 0.0);
        graph.edge(4, 11).setDistance(10.0).set(speedEnc, s, s);
        graph.edge(7, 11).setDistance(5.0).set(speedEnc, s, s);
        graph.edge(7, 10).setDistance(5.0).set(speedEnc, s, s);
        graph.edge(8, 9).setDistance(10.0).set(speedEnc, s, 0.0);
        graph.edge(9, 8).setDistance(9.0).set(speedEnc, s, 0.0);
        graph.edge(10, 9).setDistance(10.0).set(speedEnc, s, 0.0);
        GHUtility.updateDistancesFor((Graph)graph, (int)0, (double[])new double[]{3.0, 0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)3, (double[])new double[]{2.5, 0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)5, (double[])new double[]{1.0, 0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)8, (double[])new double[]{0.0, 0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)1, (double[])new double[]{3.0, 1.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)4, (double[])new double[]{2.0, 1.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)6, (double[])new double[]{1.0, 1.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)9, (double[])new double[]{0.0, 1.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)2, (double[])new double[]{3.0, 2.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)11, (double[])new double[]{2.0, 2.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)7, (double[])new double[]{1.0, 2.0, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)10, (double[])new double[]{0.0, 2.0, 0.0});
    }

    private static String getCHGraphName(Weighting weighting) {
        return weighting.getName() + "_" + weighting.hashCode();
    }

    private static void assertPathFromEqualsTo(Path p, int node) {
        Assertions.assertTrue((boolean)p.isFound());
        Assertions.assertEquals((Object)RoutingAlgorithmTest.nodes(node), (Object)p.calcNodes(), (String)p.toString());
        Assertions.assertEquals((int)1, (int)p.calcPoints().size(), (String)p.toString());
        Assertions.assertEquals((int)0, (int)p.calcEdges().size(), (String)p.toString());
        Assertions.assertEquals((double)0.0, (double)p.getWeight(), (double)1.0E-4, (String)p.toString());
        Assertions.assertEquals((double)0.0, (double)p.getDistance(), (double)1.0E-4, (String)p.toString());
        Assertions.assertEquals((double)0.0, (double)p.getTime(), (double)1.0E-4, (String)p.toString());
    }

    private static IntArrayList nodes(int ... nodes) {
        return IntArrayList.from((int[])nodes);
    }

    private static class Fixture {
        private final EncodingManager encodingManager;
        private final DecimalEncodedValue carSpeedEnc;
        private final DecimalEncodedValue footSpeedEnc;
        private final DecimalEncodedValue bike2SpeedEnc;
        private final PathCalculator pathCalculator;
        private final TraversalMode traversalMode;
        private final Weighting defaultWeighting;
        private final int defaultMaxVisitedNodes;

        public Fixture(PathCalculator pathCalculator, TraversalMode traversalMode) {
            this.pathCalculator = pathCalculator;
            this.traversalMode = traversalMode;
            this.carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, true);
            this.footSpeedEnc = new DecimalEncodedValueImpl("foot_speed", 4, 1.0, true);
            this.bike2SpeedEnc = new DecimalEncodedValueImpl("bike2_speed", 4, 2.0, true);
            this.encodingManager = EncodingManager.start().add((EncodedValue)this.carSpeedEnc).add((EncodedValue)this.footSpeedEnc).add((EncodedValue)this.bike2SpeedEnc).build();
            this.defaultWeighting = new SpeedWeighting(this.carSpeedEnc);
            this.defaultMaxVisitedNodes = Integer.MAX_VALUE;
        }

        public String toString() {
            return String.valueOf(this.pathCalculator) + ", " + String.valueOf(this.traversalMode);
        }

        private BaseGraph createGHStorage() {
            return this.createGHStorage(false);
        }

        private BaseGraph createGHStorage(boolean is3D) {
            return new BaseGraph.Builder(this.encodingManager).set3D(is3D).withTurnCosts(this.traversalMode.isEdgeBased()).create();
        }

        private Path calcPath(BaseGraph graph, int from, int to) {
            return this.calcPath(graph, this.defaultWeighting, from, to);
        }

        private Path calcPath(BaseGraph graph, Weighting weighting, int from, int to) {
            return this.calcPath(graph, weighting, this.defaultMaxVisitedNodes, from, to);
        }

        private Path calcPath(BaseGraph graph, Weighting weighting, int maxVisitedNodes, int from, int to) {
            return this.pathCalculator.calcPath(graph, weighting, this.traversalMode, maxVisitedNodes, from, to);
        }

        private Path calcPath(BaseGraph graph, GHPoint from, GHPoint to) {
            return this.calcPath(graph, this.defaultWeighting, from, to);
        }

        private Path calcPath(BaseGraph graph, Weighting weighting, GHPoint from, GHPoint to) {
            return this.pathCalculator.calcPath(graph, weighting, this.traversalMode, this.defaultMaxVisitedNodes, from, to);
        }

        private Path calcPath(BaseGraph graph, Weighting weighting, int fromNode1, int fromNode2, int toNode1, int toNode2) {
            Snap from = this.createSnapBetweenNodes((Graph)graph, fromNode1, fromNode2);
            Snap to = this.createSnapBetweenNodes((Graph)graph, toNode1, toNode2);
            return this.pathCalculator.calcPath(graph, weighting, this.traversalMode, this.defaultMaxVisitedNodes, from, to);
        }

        private Snap createSnapBetweenNodes(Graph graph, int node1, int node2) {
            EdgeIteratorState edge = GHUtility.getEdge((Graph)graph, (int)node1, (int)node2);
            if (edge == null) {
                throw new IllegalStateException("edge not found? " + node1 + "-" + node2);
            }
            NodeAccess na = graph.getNodeAccess();
            double lat = na.getLat(edge.getBaseNode());
            double lon = na.getLon(edge.getBaseNode());
            double latAdj = na.getLat(edge.getAdjNode());
            double lonAdj = na.getLon(edge.getAdjNode());
            Snap res = new Snap(lat + (latAdj - lat) * 0.1, lon + (lonAdj - lon) * 0.1);
            res.setClosestNode(edge.getBaseNode());
            res.setClosestEdge(edge);
            res.setWayIndex(0);
            res.setSnappedPosition(Snap.Position.EDGE);
            res.calcSnappedPoint((DistanceCalc)DistanceCalcEarth.DIST_EARTH);
            return res;
        }

        private void compareWithRef(Weighting weighting, BaseGraph graph, PathCalculator refCalculator, GHPoint from, GHPoint to, long seed) {
            Path path = this.calcPath(graph, weighting, from, to);
            Path refPath = refCalculator.calcPath(graph, weighting, this.traversalMode, this.defaultMaxVisitedNodes, from, to);
            Assertions.assertEquals((double)refPath.getWeight(), (double)path.getWeight(), (double)0.1, (String)("wrong weight, " + String.valueOf(weighting) + ", seed: " + seed));
            Assertions.assertEquals((Object)refPath.calcNodes(), (Object)path.calcNodes(), (String)("wrong nodes, " + String.valueOf(weighting) + ", seed: " + seed));
            Assertions.assertEquals((double)refPath.getDistance(), (double)path.getDistance(), (double)0.1, (String)("wrong distance, " + String.valueOf(weighting) + ", seed: " + seed));
            Assertions.assertEquals((float)refPath.getTime(), (float)path.getTime(), (float)100.0f, (String)("wrong time, " + String.valueOf(weighting) + ", seed: " + seed));
        }

        public void resetCH() {
            if (this.pathCalculator instanceof CHCalculator) {
                ((CHCalculator)this.pathCalculator).routingCHGraphs.clear();
            }
        }
    }

    private static class DijkstraCalculator
    extends SimpleCalculator {
        private DijkstraCalculator() {
        }

        @Override
        RoutingAlgorithm createAlgo(Graph graph, Weighting weighting, TraversalMode traversalMode) {
            return new Dijkstra(graph, weighting, traversalMode);
        }

        public String toString() {
            return "DIJKSTRA";
        }
    }

    private static interface PathCalculator {
        public Path calcPath(BaseGraph var1, Weighting var2, TraversalMode var3, int var4, int var5, int var6);

        public Path calcPath(BaseGraph var1, Weighting var2, TraversalMode var3, int var4, GHPoint var5, GHPoint var6);

        public Path calcPath(BaseGraph var1, Weighting var2, TraversalMode var3, int var4, Snap var5, Snap var6);
    }

    private static class CHDijkstraCalculator
    extends CHCalculator {
        private CHDijkstraCalculator() {
        }

        @Override
        String getAlgorithm() {
            return "dijkstrabi";
        }

        public String toString() {
            return "CH_DIJKSTRA";
        }
    }

    private static class CHAStarCalculator
    extends CHCalculator {
        private CHAStarCalculator() {
        }

        @Override
        String getAlgorithm() {
            return "astarbi";
        }

        public String toString() {
            return "CH_ASTAR";
        }
    }

    private static abstract class CHCalculator
    implements PathCalculator {
        private final Map<String, RoutingCHGraph> routingCHGraphs = new HashMap<String, RoutingCHGraph>();

        private CHCalculator() {
        }

        @Override
        public Path calcPath(BaseGraph graph, Weighting weighting, TraversalMode traversalMode, int maxVisitedNodes, int from, int to) {
            String chGraphName = RoutingAlgorithmTest.getCHGraphName(weighting) + (traversalMode.isEdgeBased() ? "_edge" : "_node");
            RoutingCHGraph routingCHGraph = this.routingCHGraphs.computeIfAbsent(chGraphName, name -> {
                if (!graph.isFrozen()) {
                    graph.freeze();
                }
                CHConfig chConfig = new CHConfig(name, weighting, traversalMode.isEdgeBased());
                PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
                PrepareContractionHierarchies.Result res = pch.doWork();
                return RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
            });
            EdgeToEdgeRoutingAlgorithm algo = new CHRoutingAlgorithmFactory(routingCHGraph).createAlgo(new PMap().putObject("algorithm", (Object)this.getAlgorithm()).putObject("max_visited_nodes", (Object)maxVisitedNodes));
            return algo.calcPath(from, to);
        }

        @Override
        public Path calcPath(BaseGraph graph, Weighting weighting, TraversalMode traversalMode, int maxVisitedNodes, GHPoint from, GHPoint to) {
            LocationIndexTree locationIndex = new LocationIndexTree((Graph)graph, (Directory)new RAMDirectory());
            LocationIndex index = locationIndex.prepareIndex();
            Snap fromSnap = index.findClosest(from.getLat(), from.getLon(), EdgeFilter.ALL_EDGES);
            Snap toSnap = index.findClosest(to.getLat(), to.getLon(), EdgeFilter.ALL_EDGES);
            return this.calcPath(graph, weighting, traversalMode, maxVisitedNodes, fromSnap, toSnap);
        }

        @Override
        public Path calcPath(BaseGraph graph, Weighting weighting, TraversalMode traversalMode, int maxVisitedNodes, Snap from, Snap to) {
            String chGraphName = RoutingAlgorithmTest.getCHGraphName(weighting) + (traversalMode.isEdgeBased() ? "_edge" : "_node");
            RoutingCHGraph routingCHGraph = this.routingCHGraphs.computeIfAbsent(chGraphName, name -> {
                graph.freeze();
                CHConfig chConfig = new CHConfig(name, weighting, traversalMode.isEdgeBased());
                PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
                PrepareContractionHierarchies.Result res = pch.doWork();
                return RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
            });
            QueryGraph queryGraph = QueryGraph.create((BaseGraph)graph, Arrays.asList(from, to));
            QueryRoutingCHGraph queryRoutingCHGraph = new QueryRoutingCHGraph(routingCHGraph, queryGraph);
            EdgeToEdgeRoutingAlgorithm algo = new CHRoutingAlgorithmFactory((RoutingCHGraph)queryRoutingCHGraph).createAlgo(new PMap().putObject("algorithm", (Object)this.getAlgorithm()).putObject("max_visited_nodes", (Object)maxVisitedNodes));
            return algo.calcPath(from.getClosestNode(), to.getClosestNode());
        }

        abstract String getAlgorithm();
    }

    private static class DijkstraOneToManyCalculator
    extends SimpleCalculator {
        private DijkstraOneToManyCalculator() {
        }

        @Override
        RoutingAlgorithm createAlgo(Graph graph, Weighting weighting, TraversalMode traversalMode) {
            return new DijkstraOneToMany(graph, weighting, traversalMode);
        }

        public String toString() {
            return "DIJKSTRA_ONE_TO_MANY";
        }
    }

    private static class BidirAStarCalculator
    extends SimpleCalculator {
        private BidirAStarCalculator() {
        }

        @Override
        RoutingAlgorithm createAlgo(Graph graph, Weighting weighting, TraversalMode traversalMode) {
            return new AStarBidirection(graph, weighting, traversalMode);
        }

        public String toString() {
            return "ASTAR_BIDIR";
        }
    }

    private static class AStarCalculator
    extends SimpleCalculator {
        private AStarCalculator() {
        }

        @Override
        RoutingAlgorithm createAlgo(Graph graph, Weighting weighting, TraversalMode traversalMode) {
            return new AStar(graph, weighting, traversalMode);
        }

        public String toString() {
            return "ASTAR";
        }
    }

    private static class BidirDijkstraCalculator
    extends SimpleCalculator {
        private BidirDijkstraCalculator() {
        }

        @Override
        RoutingAlgorithm createAlgo(Graph graph, Weighting weighting, TraversalMode traversalMode) {
            return new DijkstraBidirectionRef(graph, weighting, traversalMode);
        }

        public String toString() {
            return "DIJKSTRA_BIDIR";
        }
    }

    private static abstract class SimpleCalculator
    implements PathCalculator {
        private SimpleCalculator() {
        }

        @Override
        public Path calcPath(BaseGraph graph, Weighting weighting, TraversalMode traversalMode, int maxVisitedNodes, int from, int to) {
            RoutingAlgorithm algo = this.createAlgo((Graph)graph, weighting, traversalMode);
            algo.setMaxVisitedNodes(maxVisitedNodes);
            return algo.calcPath(from, to);
        }

        @Override
        public Path calcPath(BaseGraph graph, Weighting weighting, TraversalMode traversalMode, int maxVisitedNodes, GHPoint from, GHPoint to) {
            LocationIndexTree index = new LocationIndexTree((Graph)graph, (Directory)new RAMDirectory());
            index.prepareIndex();
            Snap fromSnap = index.findClosest(from.getLat(), from.getLon(), EdgeFilter.ALL_EDGES);
            Snap toSnap = index.findClosest(to.getLat(), to.getLon(), EdgeFilter.ALL_EDGES);
            return this.calcPath(graph, weighting, traversalMode, maxVisitedNodes, fromSnap, toSnap);
        }

        @Override
        public Path calcPath(BaseGraph graph, Weighting weighting, TraversalMode traversalMode, int maxVisitedNodes, Snap from, Snap to) {
            QueryGraph queryGraph = QueryGraph.create((BaseGraph)graph, (Snap)from, (Snap)to);
            RoutingAlgorithm algo = this.createAlgo((Graph)queryGraph, weighting, traversalMode);
            algo.setMaxVisitedNodes(maxVisitedNodes);
            return algo.calcPath(from.getClosestNode(), to.getClosestNode());
        }

        abstract RoutingAlgorithm createAlgo(Graph var1, Weighting var2, TraversalMode var3);
    }

    private static class FixtureProvider
    implements ArgumentsProvider {
        private FixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            return Stream.of(new Fixture(new DijkstraCalculator(), TraversalMode.NODE_BASED), new Fixture(new DijkstraCalculator(), TraversalMode.EDGE_BASED), new Fixture(new BidirDijkstraCalculator(), TraversalMode.NODE_BASED), new Fixture(new BidirDijkstraCalculator(), TraversalMode.EDGE_BASED), new Fixture(new AStarCalculator(), TraversalMode.NODE_BASED), new Fixture(new AStarCalculator(), TraversalMode.EDGE_BASED), new Fixture(new BidirAStarCalculator(), TraversalMode.NODE_BASED), new Fixture(new BidirAStarCalculator(), TraversalMode.EDGE_BASED), new Fixture(new DijkstraOneToManyCalculator(), TraversalMode.NODE_BASED), new Fixture(new CHAStarCalculator(), TraversalMode.NODE_BASED), new Fixture(new CHAStarCalculator(), TraversalMode.EDGE_BASED), new Fixture(new CHDijkstraCalculator(), TraversalMode.NODE_BASED), new Fixture(new CHDijkstraCalculator(), TraversalMode.EDGE_BASED)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

