/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.json.Statement;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.TurnCostsConfig;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RoutingAlgorithmWithOSMTest {
    private static final String DIR = "../core/files";
    private static final String ANDORRA = "../core/files/andorra.osm.gz";
    private static final String ANDORRA_PBF = "../core/files/andorra.osm.pbf";
    private static final String BAYREUTH = "../core/files/north-bayreuth.osm.gz";
    private static final String HOHEWARTE = "../core/files/hohe-warte.osm.gz";
    private static final String KREMS = "../core/files/krems.osm.gz";
    private static final String MONACO = "../core/files/monaco.osm.gz";
    private static final String MOSCOW = "../core/files/moscow.osm.gz";
    private static final String GH_LOCATION = "target/routing-algorithm-with-osm-test-gh";
    private final DistanceCalc distCalc = DistanceCalcEarth.DIST_EARTH;

    @BeforeEach
    @AfterEach
    public void setup() {
        Helper.removeDir((File)new File(GH_LOCATION));
    }

    @Test
    public void testMonaco() {
        Profile profile = TestProfiles.accessAndSpeed((String)"car");
        profile.getCustomModel().setDistanceInfluence(Double.valueOf(10000.0));
        GraphHopper hopper = this.createHopper(MONACO, profile);
        hopper.importOrLoad();
        this.checkQueries(hopper, this.createMonacoCarQueries());
        BaseGraph g = hopper.getBaseGraph();
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{9, 11}), (Object)GHUtility.getNeighbors((EdgeIterator)g.createEdgeExplorer().setBaseNode(10)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{25, 12, 16}), (Object)GHUtility.getNeighbors((EdgeIterator)g.createEdgeExplorer().setBaseNode(20)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{536, 481, 479}), (Object)GHUtility.getNeighbors((EdgeIterator)g.createEdgeExplorer().setBaseNode(480)));
        Assertions.assertEquals((double)43.7253762, (double)g.getNodeAccess().getLat(10), (double)1.0E-6);
        Assertions.assertEquals((double)7.4281012, (double)g.getNodeAccess().getLon(201), (double)1.0E-6);
    }

    private List<Query> createMonacoCarQueries() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(43.730729, 7.42135, 43.727697, 7.419199, 2580.0, 110));
        queries.add(new Query(43.727687, 7.418737, 43.74958, 7.436566, 3588.0, 170));
        queries.add(new Query(43.728677, 7.41016, 43.739213, 7.4277, 2561.0, 133));
        queries.add(new Query(43.733802, 7.413433, 43.739662, 7.424355, 2230.0, 137));
        queries.add(new Query(43.730949, 7.412338, 43.739643, 7.424542, 2100.0, 116));
        queries.add(new Query(43.727592, 7.419333, 43.727712, 7.419333, 0.0, 1));
        queries.add(new Query(43.727592, 7.419333, 43.727712, 7.41934, 0.0, 1));
        queries.add(new Query(43.727592, 7.419333, 43.727712, 7.4193, 3.0, 2));
        queries.add(new Query(43.729445, 7.415063, 43.728856, 7.41472, 103.0, 4));
        queries.add(new Query(43.728856, 7.41472, 43.729445, 7.415063, 320.0, 11));
        return queries;
    }

    @Test
    public void testMonacoMotorcycleCurvature() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(43.730729, 7.42135, 43.727697, 7.419199, 2675.0, 117));
        queries.add(new Query(43.727687, 7.418737, 43.74958, 7.436566, 3727.0, 170));
        queries.add(new Query(43.728677, 7.41016, 43.739213, 7.4277, 2769.0, 167));
        queries.add(new Query(43.733802, 7.413433, 43.739662, 7.424355, 2373.0, 137));
        queries.add(new Query(43.730949, 7.412338, 43.739643, 7.424542, 2203.0, 116));
        queries.add(new Query(43.727592, 7.419333, 43.727712, 7.419333, 0.0, 1));
        GraphHopper hopper = this.createHopper(MONACO, new Profile("car").setCustomModel(CustomModel.merge((CustomModel)RoutingAlgorithmWithOSMTest.getCustomModel("motorcycle.json"), (CustomModel)RoutingAlgorithmWithOSMTest.getCustomModel("curvature.json"))));
        hopper.setEncodedValuesString("curvature,track_type,surface,road_access, road_class, car_average_speed, car_access");
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testBike2_issue432() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(52.349969, 8.013813, 52.349713, 8.013293, 56.0, 7));
        GraphHopper hopper = this.createHopper("../core/files/map-bug432.osm.gz", TestProfiles.accessSpeedAndPriority((String)"bike"));
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testOneWayCircleBug() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(51.376197, -0.531576, 51.376509, -0.530863, 153.0, 18));
        queries.add(new Query(51.376509, -0.530863, 51.376197, -0.531576, 75.0, 15));
        GraphHopper hopper = this.createHopper("../core/files/circle-bug.osm.gz", TestProfiles.accessAndSpeed((String)"car"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testMoscow() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(55.818891, 37.59515, 55.81997, 37.59854, 1052.0, 14));
        queries.add(new Query(55.818536, 37.595848, 55.818702, 37.595564, 24.0, 2));
        queries.add(new Query(55.818702, 37.595564, 55.818536, 37.595848, 1114.0, 23));
        GraphHopper hopper = this.createHopper(MOSCOW, TestProfiles.accessAndSpeed((String)"car"));
        hopper.setMinNetworkSize(200);
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testMoscowTurnCosts() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(55.813357, 37.5958585, 55.811042, 37.594689, 1043.99, 12));
        queries.add(new Query(55.813159, 37.593884, 55.811278, 37.594217, 1048.0, 13));
        GraphHopper hopper = this.createHopper(MOSCOW, TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car()));
        hopper.setMinNetworkSize(200);
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testSimpleTurnCosts() {
        ArrayList<Query> list = new ArrayList<Query>();
        list.add(new Query(-0.49, 0.0, 0.0, -0.49, 298792.107, 6));
        GraphHopper hopper = this.createHopper("../core/files/test_simple_turncosts.osm.xml", TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car()));
        hopper.importOrLoad();
        this.checkQueries(hopper, list);
    }

    @Test
    public void testSimplePTurn() {
        ArrayList<Query> list = new ArrayList<Query>();
        list.add(new Query(0.0, 9.9E-4, -9.9E-4, 0.0, 664.0, 6));
        GraphHopper hopper = this.createHopper("../core/files/test_simple_pturn.osm.xml", TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car()));
        hopper.importOrLoad();
        this.checkQueries(hopper, list);
    }

    static CustomModel getCustomModel(String file) {
        return GHUtility.loadCustomModelFromJar((String)file);
    }

    @Test
    public void testSidewalkNo() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(57.154888, -2.101822, 57.153445, -2.099869, 329.0, 31));
        queries.add(new Query(57.154888, -2.101822, 57.147299, -2.096286, 1118.0, 68));
        Profile profile = TestProfiles.accessSpeedAndPriority((String)"foot");
        GraphHopper hopper = this.createHopper("../core/files/map-sidewalk-no.osm.gz", profile);
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testMonacoFastest() {
        List<Query> queries = this.createMonacoCarQueries();
        queries.get((int)0).getPoints().get((int)1).expectedDistance = 2584.0;
        queries.get((int)0).getPoints().get((int)1).expectedPoints = 117;
        queries.get((int)3).getPoints().get((int)1).expectedDistance = 2279.0;
        queries.get((int)3).getPoints().get((int)1).expectedPoints = 141;
        queries.get((int)4).getPoints().get((int)1).expectedDistance = 2149.0;
        queries.get((int)4).getPoints().get((int)1).expectedPoints = 120;
        GraphHopper hopper = this.createHopper(MONACO, TestProfiles.accessAndSpeed((String)"car"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testMonacoMixed() {
        List<Query> queries = this.createMonacoCarQueries();
        queries.get((int)0).getPoints().get((int)1).expectedPoints = 110;
        queries.get((int)1).getPoints().get((int)1).expectedPoints = 170;
        queries.get((int)2).getPoints().get((int)1).expectedPoints = 132;
        queries.get((int)3).getPoints().get((int)1).expectedPoints = 137;
        queries.get((int)4).getPoints().get((int)1).expectedPoints = 116;
        Profile carProfile = TestProfiles.accessAndSpeed((String)"car");
        carProfile.getCustomModel().setDistanceInfluence(Double.valueOf(10000.0));
        Profile footProfile = TestProfiles.accessSpeedAndPriority((String)"foot");
        footProfile.getCustomModel().setDistanceInfluence(Double.valueOf(10000.0));
        GraphHopper hopper = this.createHopper(MONACO, carProfile, footProfile);
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testRealFootCustomModelInMonaco() {
        Profile profile = new Profile("foot").setCustomModel(RoutingAlgorithmWithOSMTest.getCustomModel("foot.json"));
        profile.getCustomModel().setDistanceInfluence(Double.valueOf(10000.0));
        GraphHopper hopper = this.createHopper(MONACO, profile);
        hopper.importOrLoad();
        this.checkQueries(hopper, this.createMonacoFoot());
    }

    @Test
    public void testMonacoFoot3D() {
        List<Query> queries = this.createMonacoFoot();
        queries.get((int)0).getPoints().get((int)1).expectedDistance = 1627.0;
        queries.get((int)2).getPoints().get((int)1).expectedDistance = 2250.0;
        queries.get((int)3).getPoints().get((int)1).expectedDistance = 1482.0;
        queries.get((int)1).getPoints().get((int)1).expectedDistance = 3573.0;
        queries.get((int)1).getPoints().get((int)1).expectedPoints = 149;
        Profile profile = TestProfiles.accessSpeedAndPriority((String)"foot");
        profile.getCustomModel().setDistanceInfluence(Double.valueOf(10000.0));
        GraphHopper hopper = this.createHopper(MONACO, profile);
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    private List<Query> createMonacoFoot() {
        ArrayList<Query> list = new ArrayList<Query>();
        list.add(new Query(43.730729, 7.421288, 43.727697, 7.419199, 1566.0, 92));
        list.add(new Query(43.727687, 7.418737, 43.74958, 7.436566, 3438.0, 136));
        list.add(new Query(43.728677, 7.41016, 43.739213, 7.427806, 2085.0, 112));
        list.add(new Query(43.733802, 7.413433, 43.739662, 7.424355, 1425.0, 89));
        return list;
    }

    @Test
    public void testNorthBayreuthHikeFastestAnd3D() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(49.974972, 11.515657, 49.991022, 11.512299, 2365.0, 67));
        queries.add(new Query(49.990967, 11.545258, 50.023182, 11.555386, 5690.0, 118));
        GraphHopper hopper = this.createHopper(BAYREUTH, new Profile("hike").setCustomModel(RoutingAlgorithmWithOSMTest.getCustomModel("hike.json")));
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testHikeCanUseExtremeSacScales() {
        GraphHopper hopper = this.createHopper(HOHEWARTE, new Profile("hike").setCustomModel(RoutingAlgorithmWithOSMTest.getCustomModel("hike.json")));
        hopper.importOrLoad();
        GHResponse res = hopper.route(new GHRequest(47.290322, 11.333889, 47.301593, 11.333489).setProfile("hike"));
        Assertions.assertEquals((double)4806.0, (double)((double)res.getBest().getTime() / 1000.0), (double)60.0);
        Assertions.assertEquals((double)2000.0, (double)res.getBest().getDistance(), (double)10.0);
    }

    @Test
    public void testMonacoBike3D() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(43.730864, 7.420771, 43.727687, 7.418737, 2702.0, 111));
        queries.add(new Query(43.728499, 7.417907, 43.74958, 7.436566, 4208.0, 228));
        queries.add(new Query(43.728677, 7.41016, 43.739213, 7.427806, 2776.0, 167));
        queries.add(new Query(43.733802, 7.413433, 43.739662, 7.424355, 1593.0, 85));
        queries.add(new Query(43.727687, 7.418737, 43.730864, 7.420771, 2598.0, 115));
        queries.add(new Query(43.74958, 7.436566, 43.728499, 7.417907, 4250.0, 165));
        queries.add(new Query(43.739213, 7.427806, 43.728677, 7.41016, 2806.0, 145));
        queries.add(new Query(43.739662, 7.424355, 43.733802, 7.413433, 1901.0, 116));
        GraphHopper hopper = this.createHopper(MONACO, new Profile("bike").setCustomModel(CustomModel.merge((CustomModel)RoutingAlgorithmWithOSMTest.getCustomModel("bike.json"), (CustomModel)RoutingAlgorithmWithOSMTest.getCustomModel("bike_elevation.json")).addToPriority(Statement.If((String)"!bike_access", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"))));
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testLandmarkBug() {
        ArrayList<Query> queries = new ArrayList<Query>();
        Query run = new Query();
        run.add(50.016923, 11.514187, 0.0, 0);
        run.add(50.019129, 11.500325, 0.0, 0);
        run.add(50.023623, 11.56929, 7069.0, 178);
        queries.add(run);
        GraphHopper hopper = this.createHopper(BAYREUTH, TestProfiles.accessSpeedAndPriority((String)"bike"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testBug1014() {
        ArrayList<Query> queries = new ArrayList<Query>();
        Query query = new Query();
        query.add(50.015861, 11.51041, 0.0, 0);
        query.add(50.019129, 11.500325, 0.0, 0);
        query.add(50.023623, 11.56929, 6777.0, 175);
        queries.add(query);
        GraphHopper hopper = this.createHopper(BAYREUTH, TestProfiles.accessSpeedAndPriority((String)"bike"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testMonacoBike() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(43.730864, 7.420771, 43.727687, 7.418737, 1642.0, 87));
        queries.add(new Query(43.727687, 7.418737, 43.74958, 7.436566, 3580.0, 168));
        queries.add(new Query(43.728677, 7.41016, 43.739213, 7.427806, 2323.0, 121));
        queries.add(new Query(43.733802, 7.413433, 43.739662, 7.424355, 1446.0, 91));
        Profile profile = TestProfiles.accessSpeedAndPriority((String)"bike");
        profile.getCustomModel().setDistanceInfluence(Double.valueOf(7000.0));
        GraphHopper hopper = this.createHopper(MONACO, profile);
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testMonacoMountainBike() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(43.730864, 7.420771, 43.727687, 7.418737, 2594.0, 111));
        queries.add(new Query(43.727687, 7.418737, 43.74958, 7.436566, 3655.0, 185));
        queries.add(new Query(43.728677, 7.41016, 43.739213, 7.427806, 2651.0, 167));
        queries.add(new Query(43.733802, 7.413433, 43.739662, 7.424355, 1867.0, 107));
        GraphHopper hopper = this.createHopper(MONACO, TestProfiles.accessSpeedAndPriority((String)"mtb"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
        Helper.removeDir((File)new File(GH_LOCATION));
        hopper = this.createHopper(MONACO, TestProfiles.accessSpeedAndPriority((String)"mtb"), TestProfiles.accessSpeedAndPriority((String)"racingbike"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testMonacoRacingBike() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(43.730864, 7.420771, 43.727687, 7.418737, 2594.0, 111));
        queries.add(new Query(43.727687, 7.418737, 43.74958, 7.436566, 3615.0, 184));
        queries.add(new Query(43.728677, 7.41016, 43.739213, 7.427806, 2651.0, 167));
        queries.add(new Query(43.733802, 7.413433, 43.739662, 7.424355, 1516.0, 86));
        GraphHopper hopper = this.createHopper(MONACO, TestProfiles.accessSpeedAndPriority((String)"racingbike"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
        Helper.removeDir((File)new File(GH_LOCATION));
        hopper = this.createHopper(MONACO, TestProfiles.accessSpeedAndPriority((String)"racingbike"), TestProfiles.accessSpeedAndPriority((String)"bike"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testKremsBikeRelation() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(48.409523, 15.602394, 48.375466, 15.72916, 12491.0, 159));
        queries.add(new Query(48.410061, 15.63951, 48.411386, 15.604899, 3077.0, 79));
        queries.add(new Query(48.412294, 15.62007, 48.398306, 15.609667, 3965.0, 94));
        GraphHopper hopper = this.createHopper(KREMS, TestProfiles.accessSpeedAndPriority((String)"bike"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
        hopper.getBaseGraph();
        Helper.removeDir((File)new File(GH_LOCATION));
        hopper = this.createHopper(KREMS, TestProfiles.accessSpeedAndPriority((String)"bike"), TestProfiles.accessAndSpeed((String)"car"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testKremsMountainBikeRelation() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(48.409523, 15.602394, 48.375466, 15.72916, 12574.0, 169));
        queries.add(new Query(48.410061, 15.63951, 48.411386, 15.604899, 3101.0, 94));
        queries.add(new Query(48.412294, 15.62007, 48.398306, 15.609667, 3965.0, 95));
        GraphHopper hopper = this.createHopper(KREMS, TestProfiles.accessSpeedAndPriority((String)"mtb"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
        Helper.removeDir((File)new File(GH_LOCATION));
        hopper = this.createHopper(KREMS, TestProfiles.accessSpeedAndPriority((String)"mtb"), TestProfiles.accessSpeedAndPriority((String)"bike"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    private List<Query> createAndorraQueries() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(42.56819, 1.603231, 42.571034, 1.520662, 17708.0, 524));
        queries.add(new Query(42.529176, 1.571302, 42.571034, 1.520662, 11408.0, 305));
        return queries;
    }

    @Test
    public void testAndorra() {
        Profile profile = TestProfiles.accessAndSpeed((String)"car");
        GraphHopper hopper = this.createHopper(ANDORRA, profile);
        hopper.importOrLoad();
        this.checkQueries(hopper, this.createAndorraQueries());
    }

    @Test
    public void testAndorraPbf() {
        Profile profile = TestProfiles.accessAndSpeed((String)"car");
        GraphHopper hopper = this.createHopper(ANDORRA_PBF, profile);
        hopper.importOrLoad();
        this.checkQueries(hopper, this.createAndorraQueries());
    }

    @Test
    public void testAndorraFoot() {
        List<Query> queries = this.createAndorraQueries();
        queries.get((int)0).getPoints().get((int)1).expectedDistance = 16460.0;
        queries.get((int)0).getPoints().get((int)1).expectedPoints = 653;
        queries.get((int)1).getPoints().get((int)1).expectedDistance = 12840.0;
        queries.get((int)1).getPoints().get((int)1).expectedPoints = 435;
        queries.add(new Query(42.521269, 1.52298, 42.50418, 1.520662, 3223.0, 107));
        GraphHopper hopper = this.createHopper(ANDORRA, TestProfiles.accessSpeedAndPriority((String)"foot"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testCampoGrande() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(-20.4001, -54.5999, -20.598, -54.54, 25323.0, 271));
        queries.add(new Query(-20.43, -54.54, -20.537, -54.5999, 16233.0, 226));
        Profile profile = TestProfiles.accessAndSpeed((String)"car");
        profile.getCustomModel().setDistanceInfluence(Double.valueOf(1000.0));
        GraphHopper hopper = this.createHopper("../core/files/campo-grande.osm.gz", profile);
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testMonacoVia() {
        Query query = new Query();
        query.add(43.730729, 7.42135, 0.0, 0);
        query.add(43.727697, 7.419199, 2581.0, 110);
        query.add(43.726387, 7.405, 3001.0, 90);
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(query);
        Profile profile = TestProfiles.accessAndSpeed((String)"car");
        profile.getCustomModel().setDistanceInfluence(Double.valueOf(10000.0));
        GraphHopper hopper = this.createHopper(MONACO, profile);
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testHarsdorf() {
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(new Query(50.004333, 11.600254, 50.044449, 11.543434, 6951.0, 190));
        GraphHopper hopper = this.createHopper(BAYREUTH, TestProfiles.accessSpeedAndPriority((String)"bike"));
        hopper.importOrLoad();
        this.checkQueries(hopper, queries);
    }

    @Test
    public void testNeudrossenfeld() {
        ArrayList<Query> list = new ArrayList<Query>();
        list.add(new Query(49.987132, 11.510496, 50.018839, 11.505024, 3985.0, 106));
        GraphHopper hopper = this.createHopper(BAYREUTH, TestProfiles.accessSpeedAndPriority((String)"bike"));
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        this.checkQueries(hopper, list);
        Helper.removeDir((File)new File(GH_LOCATION));
        hopper = this.createHopper(BAYREUTH, TestProfiles.accessSpeedAndPriority((String)"bike"));
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        this.checkQueries(hopper, list);
    }

    @Test
    public void testBikeBayreuth_UseBikeNetwork() {
        ArrayList<Query> list = new ArrayList<Query>();
        list.add(new Query(49.979667, 11.521019, 49.987415, 11.510577, 1288.0, 45));
        GraphHopper hopper = this.createHopper(BAYREUTH, new Profile("bike").setCustomModel(CustomModel.merge((CustomModel)RoutingAlgorithmWithOSMTest.getCustomModel("bike.json"), (CustomModel)RoutingAlgorithmWithOSMTest.getCustomModel("bike_elevation.json"))));
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        this.checkQueries(hopper, list);
    }

    @Test
    public void testDisconnectedAreaAndMultiplePoints() {
        Query query = new Query();
        query.add(53.753177, 9.435968, 10.0, 10);
        query.add(53.751299, 9.386959, 10.0, 10);
        query.add(53.751299, 9.3869, 10.0, 10);
        GraphHopper hopper = this.createHopper("../core/files/krautsand.osm.gz", TestProfiles.accessAndSpeed((String)"car"));
        hopper.importOrLoad();
        for (Function<Query, GHRequest> requestFactory : this.createRequestFactories()) {
            GHRequest request = requestFactory.apply(query);
            request.setProfile(((Profile)hopper.getProfiles().get(0)).getName());
            GHResponse res = hopper.route(request);
            Assertions.assertTrue((boolean)res.hasErrors());
            Assertions.assertTrue((boolean)res.getErrors().toString().contains("ConnectionNotFound"), (String)res.getErrors().toString());
        }
    }

    @Test
    public void testMonacoParallel() throws InterruptedException {
        Profile profile = TestProfiles.accessAndSpeed((String)"car");
        profile.getCustomModel().setDistanceInfluence(Double.valueOf(10000.0));
        GraphHopper hopper = this.createHopper(MONACO, profile);
        hopper.getReaderConfig().setMaxWayPointDistance(0.0);
        hopper.getRouterConfig().setSimplifyResponse(false);
        hopper.importOrLoad();
        List<Query> queries = this.createMonacoCarQueries();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        AtomicInteger routeCount = new AtomicInteger(0);
        List<Function> requestFactories = Arrays.asList(q -> this.createRequest((Query)q).setAlgorithm("dijkstrabi").setProfile("car"), q -> this.createRequest((Query)q).setAlgorithm("astarbi").setProfile("car"));
        int loops = 100;
        for (int i = 0; i < loops; ++i) {
            for (Query query : queries) {
                for (Function requestFactory : requestFactories) {
                    GHRequest req = (GHRequest)requestFactory.apply(query);
                    Thread t = new Thread(() -> {
                        GHResponse res = hopper.route(req);
                        this.checkResponse(req.getHints().getString("expected_algo", "no_expected_algo"), res, query);
                        routeCount.incrementAndGet();
                    });
                    t.start();
                    threads.add(t);
                }
            }
        }
        for (Thread t : threads) {
            t.join();
        }
        Assertions.assertEquals((int)(loops * queries.size() * requestFactories.size()), (int)routeCount.get());
    }

    private GraphHopper createHopper(String osmFile, Profile ... profiles) {
        GraphHopper hopper = new GraphHopper().setStoreOnFlush(false).setOSMFile(osmFile).setProfiles(profiles).setEncodedValuesString("average_slope, max_slope, hike_rating, car_access, car_average_speed, foot_access, foot_priority, foot_average_speed, bike_access, bike_priority, bike_average_speed, foot_network, roundabout, mtb_access, mtb_priority, mtb_average_speed, mtb_rating, racingbike_access, racingbike_priority, racingbike_average_speed, foot_road_access, bike_road_access, country, road_class").setGraphHopperLocation(GH_LOCATION);
        hopper.getRouterConfig().setSimplifyResponse(false);
        hopper.setMinNetworkSize(0);
        hopper.getReaderConfig().setMaxWayPointDistance(0.0);
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile(profiles[0].getName())});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile(profiles[0].getName())});
        return hopper;
    }

    private void checkQueries(GraphHopper hopper, List<Query> queries) {
        for (Function<Query, GHRequest> requestFactory : this.createRequestFactories()) {
            for (Query query : queries) {
                GHRequest request = requestFactory.apply(query);
                Profile profile = (Profile)hopper.getProfiles().get(0);
                request.setProfile(profile.getName());
                GHResponse res = hopper.route(request);
                String expectedAlgo = request.getHints().getString("expected_algo", "no_expected_algo");
                this.checkResponse(expectedAlgo, res, query);
                if (profile.hasTurnCosts()) {
                    expectedAlgo = expectedAlgo.replaceAll("\\|ch-routing", "|ch|edge_based|no_sod-routing");
                }
                Assertions.assertTrue((boolean)res.getBest().getDebugInfo().contains(expectedAlgo), (String)("Response does not contain expected algo string. Expected: '" + expectedAlgo + "', got: '" + res.getBest().getDebugInfo() + "'"));
            }
        }
    }

    private void checkResponse(String expectedAlgo, GHResponse res, Query query) {
        Assertions.assertFalse((boolean)res.hasErrors(), (String)res.getErrors().toString());
        ResponsePath responsePath = res.getBest();
        Assertions.assertFalse((boolean)responsePath.hasErrors(), (String)responsePath.getErrors().toString());
        Assertions.assertEquals((double)this.distCalc.calcDistance(responsePath.getPoints()), (double)responsePath.getDistance(), (double)2.0, (String)"responsePath.getDistance does not equal point list distance");
        Assertions.assertEquals((double)query.getPoints().stream().mapToDouble(a -> a.expectedDistance).sum(), (double)responsePath.getDistance(), (double)2.0, (String)("unexpected distance, " + expectedAlgo));
        Assertions.assertEquals((float)query.getPoints().stream().mapToInt(a -> a.expectedPoints).sum(), (float)responsePath.getPoints().size(), (float)1.0f, (String)("unexpected point list size, " + expectedAlgo));
    }

    private List<Function<Query, GHRequest>> createRequestFactories() {
        return Arrays.asList(q -> this.createRequest((Query)q).putHint("expected_algo", (Object)"dijkstra-routing").putHint("ch.disable", (Object)true).putHint("lm.disable", (Object)true).setAlgorithm("dijkstra"), q -> this.createRequest((Query)q).putHint("expected_algo", (Object)"astar|beeline-routing").putHint("ch.disable", (Object)true).putHint("lm.disable", (Object)true).setAlgorithm("astar"), q -> this.createRequest((Query)q).putHint("expected_algo", (Object)"dijkstrabi-routing").putHint("ch.disable", (Object)true).putHint("lm.disable", (Object)true).setAlgorithm("dijkstrabi"), q -> this.createRequest((Query)q).putHint("expected_algo", (Object)"astarbi|beeline-routing").putHint("ch.disable", (Object)true).putHint("lm.disable", (Object)true).setAlgorithm("astarbi").putHint("astarbi.approximation", (Object)"BeelineSimplification"), q -> this.createRequest((Query)q).putHint("expected_algo", (Object)"astarbi|landmarks-routing").putHint("ch.disable", (Object)true).setAlgorithm("astarbi").putHint("astarbi.approximation", (Object)"BeelineSimplification"), q -> this.createRequest((Query)q).putHint("expected_algo", (Object)"dijkstrabi|ch-routing").setAlgorithm("dijkstrabi"), q -> this.createRequest((Query)q).putHint("expected_algo", (Object)"astarbi|ch-routing").setAlgorithm("astarbi"));
    }

    private GHRequest createRequest(Query query) {
        GHRequest req = new GHRequest();
        for (ViaPoint assumption : query.points) {
            req.addPoint(new GHPoint(assumption.lat, assumption.lon));
        }
        return req;
    }

    private static class Query {
        private final List<ViaPoint> points = new ArrayList<ViaPoint>();

        public Query() {
        }

        public Query(double fromLat, double fromLon, double toLat, double toLon, double expectedDistance, int expectedPoints) {
            this.add(fromLat, fromLon, 0.0, 0);
            this.add(toLat, toLon, expectedDistance, expectedPoints);
        }

        public Query add(double lat, double lon, double dist, int locs) {
            this.points.add(new ViaPoint(lat, lon, dist, locs));
            return this;
        }

        public List<ViaPoint> getPoints() {
            return this.points;
        }

        public String toString() {
            return this.points.toString();
        }
    }

    private static class ViaPoint {
        double lat;
        double lon;
        int expectedPoints;
        double expectedDistance;

        public ViaPoint(double lat, double lon, double expectedDistance, int expectedPoints) {
            this.lat = lat;
            this.lon = lon;
            this.expectedPoints = expectedPoints;
            this.expectedDistance = expectedDistance;
        }

        public String toString() {
            return this.lat + ", " + this.lon + ", expectedPoints:" + this.expectedPoints + ", expectedDistance:" + this.expectedDistance;
        }
    }
}

