/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntHashSet;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.CHStorageBuilder;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIterator;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutingCHGraphImplTest {
    @Test
    public void testBaseAndCHEdges() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        graph.edge(1, 0);
        graph.edge(8, 9);
        graph.freeze();
        CHConfig chConfig = CHConfig.nodeBased((String)"p", (Weighting)new SpeedWeighting((DecimalEncodedValue)speedEnc));
        CHStorage store = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(store);
        chBuilder.setIdentityLevels();
        RoutingCHGraph chGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)store, (CHConfig)chConfig);
        Assertions.assertEquals((int)1, (int)GHUtility.count((EdgeIterator)graph.createEdgeExplorer().setBaseNode(1)));
        Assertions.assertEquals((int)0, (int)GHUtility.count((RoutingCHEdgeIterator)chGraph.createInEdgeExplorer().setBaseNode(1)));
        chBuilder.addShortcutNodeBased(2, 3, PrepareEncoder.getScDirMask(), 10.0, -1, -1);
        Assertions.assertEquals((int)1, (int)GHUtility.count((EdgeIterator)graph.createEdgeExplorer().setBaseNode(1)));
        Assertions.assertEquals((int)0, (int)GHUtility.count((RoutingCHEdgeIterator)chGraph.createOutEdgeExplorer().setBaseNode(1)));
        Assertions.assertEquals((int)0, (int)GHUtility.count((EdgeIterator)graph.createEdgeExplorer().setBaseNode(2)));
        Assertions.assertEquals((int)1, (int)GHUtility.count((RoutingCHEdgeIterator)chGraph.createOutEdgeExplorer().setBaseNode(2)));
        Assertions.assertEquals((int)10, (int)chGraph.getNodes());
        Assertions.assertEquals((int)2, (int)graph.getEdges());
        Assertions.assertEquals((int)3, (int)chGraph.getEdges());
        Assertions.assertEquals((int)1, (int)GHUtility.count((RoutingCHEdgeIterator)chGraph.createOutEdgeExplorer().setBaseNode(2)));
    }

    @Test
    void testShortcutConnection() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        graph.edge(4, 1).setDistance(30.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.freeze();
        CHConfig chConfig = CHConfig.nodeBased((String)"ch", (Weighting)new SpeedWeighting((DecimalEncodedValue)speedEnc));
        CHStorage store = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(store);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutNodeBased(0, 1, PrepareEncoder.getScBwdDir(), 10.0, 12, 13);
        chBuilder.addShortcutNodeBased(1, 2, PrepareEncoder.getScDirMask(), 10.0, 10, 11);
        chBuilder.addShortcutNodeBased(1, 3, PrepareEncoder.getScBwdDir(), 10.0, 14, 15);
        EdgeExplorer baseExplorer = graph.createEdgeExplorer();
        RoutingCHGraph lg = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)store, (CHConfig)chConfig);
        RoutingCHEdgeExplorer chOutExplorer = lg.createOutEdgeExplorer();
        RoutingCHEdgeExplorer chInExplorer = lg.createInEdgeExplorer();
        Assertions.assertEquals((int)0, (int)GHUtility.count((RoutingCHEdgeIterator)chOutExplorer.setBaseNode(2)));
        Assertions.assertEquals((int)0, (int)GHUtility.count((RoutingCHEdgeIterator)chInExplorer.setBaseNode(2)));
        Assertions.assertEquals((int)2, (int)GHUtility.count((RoutingCHEdgeIterator)chOutExplorer.setBaseNode(1)));
        Assertions.assertEquals((int)3, (int)GHUtility.count((RoutingCHEdgeIterator)chInExplorer.setBaseNode(1)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{2, 4}), (Object)GHUtility.getNeighbors((RoutingCHEdgeIterator)chOutExplorer.setBaseNode(1)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{4}), (Object)GHUtility.getNeighbors((EdgeIterator)baseExplorer.setBaseNode(1)));
        Assertions.assertEquals((int)0, (int)GHUtility.count((RoutingCHEdgeIterator)chOutExplorer.setBaseNode(3)));
        Assertions.assertEquals((int)0, (int)GHUtility.count((RoutingCHEdgeIterator)chInExplorer.setBaseNode(3)));
        Assertions.assertEquals((int)0, (int)GHUtility.count((RoutingCHEdgeIterator)chOutExplorer.setBaseNode(0)));
        Assertions.assertEquals((int)1, (int)GHUtility.count((RoutingCHEdgeIterator)chInExplorer.setBaseNode(0)));
    }

    @Test
    public void testGetWeight() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        EdgeIteratorState edge1 = graph.edge(0, 1);
        EdgeIteratorState edge2 = graph.edge(1, 2);
        graph.freeze();
        CHConfig chConfig = CHConfig.nodeBased((String)"ch", (Weighting)new SpeedWeighting((DecimalEncodedValue)speedEnc));
        CHStorage store = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        RoutingCHGraph g = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)store, (CHConfig)chConfig);
        Assertions.assertFalse((boolean)g.getEdgeIteratorState(edge1.getEdge(), Integer.MIN_VALUE).isShortcut());
        Assertions.assertFalse((boolean)g.getEdgeIteratorState(edge2.getEdge(), Integer.MIN_VALUE).isShortcut());
        CHStorageBuilder chBuilder = new CHStorageBuilder(store);
        chBuilder.setIdentityLevels();
        int flags = PrepareEncoder.getScDirMask();
        chBuilder.addShortcutNodeBased(0, 1, flags, 5.0, -1, -1);
        RoutingCHEdgeIteratorState sc1 = g.getEdgeIteratorState(2, 1);
        Assertions.assertEquals((int)0, (int)sc1.getBaseNode());
        Assertions.assertEquals((int)1, (int)sc1.getAdjNode());
        Assertions.assertEquals((double)5.0, (double)sc1.getWeight(false), (double)0.001);
        Assertions.assertTrue((boolean)sc1.isShortcut());
    }

    @Test
    public void testGetWeightIfAdvancedEncoder() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 4, 2.0, true);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph ghStorage = new BaseGraph.Builder(em).create();
        ghStorage.edge(0, 3);
        ghStorage.freeze();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)"p1", (Weighting)weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)ghStorage, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        int sc1 = ghStorage.getEdges() + chBuilder.addShortcutNodeBased(0, 1, PrepareEncoder.getScFwdDir(), 100.123, -1, -1);
        RoutingCHGraph lg = RoutingCHGraphImpl.fromGraph((BaseGraph)ghStorage, (CHStorage)chStore, (CHConfig)chConfig);
        Assertions.assertEquals((int)1, (int)lg.getEdgeIteratorState(sc1, 1).getAdjNode());
        Assertions.assertEquals((int)0, (int)lg.getEdgeIteratorState(sc1, 1).getBaseNode());
        Assertions.assertEquals((double)100.123, (double)lg.getEdgeIteratorState(sc1, 1).getWeight(false), (double)0.001);
        Assertions.assertEquals((double)100.123, (double)lg.getEdgeIteratorState(sc1, 0).getWeight(false), (double)0.001);
        int sc2 = ghStorage.getEdges() + chBuilder.addShortcutNodeBased(2, 3, PrepareEncoder.getScDirMask(), 1.011011, -1, -1);
        Assertions.assertEquals((int)3, (int)lg.getEdgeIteratorState(sc2, 3).getAdjNode());
        Assertions.assertEquals((int)2, (int)lg.getEdgeIteratorState(sc2, 3).getBaseNode());
        Assertions.assertEquals((double)1.011011, (double)lg.getEdgeIteratorState(sc2, 2).getWeight(false), (double)0.001);
        Assertions.assertEquals((double)1.011011, (double)lg.getEdgeIteratorState(sc2, 3).getWeight(false), (double)0.001);
    }

    @Test
    public void testWeightExact() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        graph.edge(0, 1).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.edge(1, 2).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.freeze();
        CHConfig chConfig = CHConfig.nodeBased((String)"ch", (Weighting)new SpeedWeighting((DecimalEncodedValue)speedEnc));
        CHStorage store = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(store);
        chBuilder.setIdentityLevels();
        double x1 = 1.004;
        double x2 = 1.006;
        RoutingCHGraph rg = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)store, (CHConfig)chConfig);
        chBuilder.addShortcutNodeBased(0, 2, PrepareEncoder.getScFwdDir(), x1 + x2, 0, 1);
        RoutingCHEdgeIteratorState sc = rg.getEdgeIteratorState(2, 2);
        Assertions.assertEquals((double)2.01, (double)sc.getWeight(false), (double)1.0E-6);
    }

    @Test
    public void testSimpleShortcutCreationAndTraversal() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        graph.edge(1, 3).setDistance(10.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.edge(3, 4).setDistance(10.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)"p1", (Weighting)weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutNodeBased(1, 4, PrepareEncoder.getScFwdDir(), 3.0, -1, -1);
        RoutingCHGraph lg = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)chStore, (CHConfig)chConfig);
        RoutingCHEdgeExplorer exp = lg.createOutEdgeExplorer();
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{3, 4}), (Object)GHUtility.getNeighbors((RoutingCHEdgeIterator)exp.setBaseNode(1)));
    }

    @Test
    public void testAddShortcutSkippedEdgesWriteRead() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        EdgeIteratorState edge1 = graph.edge(1, 3).setDistance(10.0).set((DecimalEncodedValue)speedEnc, 60.0);
        EdgeIteratorState edge2 = graph.edge(3, 4).setDistance(10.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)"p1", (Weighting)weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutNodeBased(1, 4, PrepareEncoder.getScDirMask(), 10.0, -1, -1);
        chStore.setSkippedEdges(chStore.toShortcutPointer(0), edge1.getEdge(), edge2.getEdge());
        Assertions.assertEquals((int)edge1.getEdge(), (int)chStore.getSkippedEdge1(chStore.toShortcutPointer(0)));
        Assertions.assertEquals((int)edge2.getEdge(), (int)chStore.getSkippedEdge2(chStore.toShortcutPointer(0)));
    }

    @Test
    public void testSkippedEdges() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        EdgeIteratorState edge1 = graph.edge(1, 3).setDistance(10.0).set((DecimalEncodedValue)speedEnc, 60.0);
        EdgeIteratorState edge2 = graph.edge(3, 4).setDistance(10.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)"p1", (Weighting)weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutNodeBased(1, 4, PrepareEncoder.getScDirMask(), 10.0, edge1.getEdge(), edge2.getEdge());
        Assertions.assertEquals((int)edge1.getEdge(), (int)chStore.getSkippedEdge1(chStore.toShortcutPointer(0)));
        Assertions.assertEquals((int)edge2.getEdge(), (int)chStore.getSkippedEdge2(chStore.toShortcutPointer(0)));
    }

    @Test
    public void testAddShortcut_edgeBased_throwsIfNotConfiguredForEdgeBased() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        graph.edge(0, 1).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.edge(1, 2).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)"p1", (Weighting)weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        Assertions.assertThrows(IllegalArgumentException.class, () -> chBuilder.addShortcutEdgeBased(0, 2, PrepareEncoder.getScFwdDir(), 10.0, 0, 1, 0, 2));
    }

    @Test
    public void testAddShortcut_edgeBased() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).set3D(true).create();
        graph.edge(0, 1).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.edge(1, 2).setDistance(3.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.edgeBased((String)"p1", (Weighting)weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutEdgeBased(0, 2, PrepareEncoder.getScFwdDir(), 10.0, 0, 1, 0, 2);
        Assertions.assertEquals((int)0, (int)chStore.getOrigEdgeKeyFirst(chStore.toShortcutPointer(0)));
        Assertions.assertEquals((int)2, (int)chStore.getOrigEdgeKeyLast(chStore.toShortcutPointer(0)));
    }

    @Test
    public void outOfBounds() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).set3D(true).create();
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)"p1", (Weighting)weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        RoutingCHGraph lg = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)chStore, (CHConfig)chConfig);
        Assertions.assertThrows(IllegalArgumentException.class, () -> lg.getEdgeIteratorState(0, Integer.MIN_VALUE));
    }

    @Test
    public void testGetEdgeIterator() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).set3D(true).create();
        graph.edge(0, 1).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.edge(1, 2).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0);
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.edgeBased((String)"p1", (Weighting)weighting);
        CHStorage store = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(store);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutEdgeBased(0, 2, PrepareEncoder.getScFwdDir(), 10.0, 0, 1, 0, 2);
        RoutingCHGraph lg = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)store, (CHConfig)chConfig);
        RoutingCHEdgeIteratorState sc02 = lg.getEdgeIteratorState(2, 2);
        Assertions.assertNotNull((Object)sc02);
        Assertions.assertEquals((int)0, (int)sc02.getBaseNode());
        Assertions.assertEquals((int)2, (int)sc02.getAdjNode());
        Assertions.assertEquals((int)2, (int)sc02.getEdge());
        Assertions.assertEquals((int)0, (int)sc02.getSkippedEdge1());
        Assertions.assertEquals((int)1, (int)sc02.getSkippedEdge2());
        Assertions.assertEquals((int)0, (int)sc02.getOrigEdgeKeyFirst());
        Assertions.assertEquals((int)2, (int)sc02.getOrigEdgeKeyLast());
        RoutingCHEdgeIteratorState sc20 = lg.getEdgeIteratorState(2, 0);
        Assertions.assertNotNull((Object)sc20);
        Assertions.assertEquals((int)2, (int)sc20.getBaseNode());
        Assertions.assertEquals((int)0, (int)sc20.getAdjNode());
        Assertions.assertEquals((int)2, (int)sc20.getEdge());
        Assertions.assertEquals((int)0, (int)sc20.getSkippedEdge1());
        Assertions.assertEquals((int)1, (int)sc20.getSkippedEdge2());
        Assertions.assertEquals((int)0, (int)sc20.getOrigEdgeKeyFirst());
        Assertions.assertEquals((int)2, (int)sc20.getOrigEdgeKeyLast());
    }

    @Test
    public void testAccept_fwdLoopShortcut_acceptedByInExplorer() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        DecimalEncodedValue turnCostEnc = TurnCost.create((String)"car", (int)1);
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)speedEnc).addTurnCostEncodedValue((EncodedValue)turnCostEnc).build();
        BaseGraph graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        graph.edge(0, 1).setDistance(100.0).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        graph.edge(1, 2).setDistance(200.0).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        graph.edge(2, 0).setDistance(300.0).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        graph.freeze();
        CHConfig chConfig = CHConfig.edgeBased((String)"profile", (Weighting)new SpeedWeighting((DecimalEncodedValue)speedEnc, turnCostEnc, graph.getTurnCostStorage(), 50.0));
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        CHStorageBuilder chBuilder = new CHStorageBuilder(chStore);
        chBuilder.setIdentityLevels();
        chBuilder.addShortcutEdgeBased(0, 0, PrepareEncoder.getScFwdDir(), 5.0, 0, 2, 0, 5);
        RoutingCHGraph chGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)chStore, (CHConfig)chConfig);
        RoutingCHEdgeExplorer outExplorer = chGraph.createOutEdgeExplorer();
        RoutingCHEdgeExplorer inExplorer = chGraph.createInEdgeExplorer();
        IntHashSet inEdges = new IntHashSet();
        IntHashSet outEdges = new IntHashSet();
        RoutingCHEdgeIterator outIter = outExplorer.setBaseNode(0);
        while (outIter.next()) {
            outEdges.add(outIter.getEdge());
        }
        RoutingCHEdgeIterator inIter = inExplorer.setBaseNode(0);
        while (inIter.next()) {
            inEdges.add(inIter.getEdge());
        }
        Assertions.assertEquals((Object)IntHashSet.from((int[])new int[]{0, 3}), (Object)outEdges, (String)"Wrong outgoing edges");
        Assertions.assertEquals((Object)IntHashSet.from((int[])new int[]{2, 3}), (Object)inEdges, (String)"Wrong incoming edges");
    }
}

