/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeIterator;
import com.graphhopper.util.GHUtility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CHPreparationGraphTest {
    CHPreparationGraphTest() {
    }

    @Test
    void basic() {
        CHPreparationGraph pg = CHPreparationGraph.nodeBased((int)5, (int)10);
        double inf = Double.POSITIVE_INFINITY;
        pg.addEdge(0, 4, 3, 10.0, inf);
        pg.addEdge(4, 2, 0, inf, 5.0);
        pg.addEdge(0, 3, 1, 6.0, 6.0);
        pg.addEdge(1, 3, 2, 9.0, inf);
        pg.prepareForContraction();
        Assertions.assertEquals((int)3, (int)pg.getDegree(0));
        Assertions.assertEquals((int)2, (int)pg.getDegree(4));
        pg.addShortcut(3, 4, 1, 3, 1, 3, 16.0, 2);
        pg.disconnect(0);
        PrepareGraphEdgeIterator iter = pg.createOutEdgeExplorer().setBaseNode(3);
        StringBuilder res = new StringBuilder();
        while (iter.next()) {
            res.append(iter).append(",");
        }
        Assertions.assertEquals((Object)"3-4 16.0,", (Object)res.toString());
    }

    @Test
    void useLargeEdgeId() {
        CHPreparationGraph.OrigGraph.Builder builder = new CHPreparationGraph.OrigGraph.Builder();
        int largeEdgeID = 0x3FFFFFFF;
        Assertions.assertEquals((int)0x3FFFFFFF, (int)largeEdgeID);
        builder.addEdge(0, 1, largeEdgeID, true, false);
        CHPreparationGraph.OrigGraph g = builder.build();
        PrepareGraphOrigEdgeIterator iter = g.createOutOrigEdgeExplorer().setBaseNode(0);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)largeEdgeID, (int)GHUtility.getEdgeFromEdgeKey((int)iter.getOrigEdgeKeyFirst()));
        iter = g.createInOrigEdgeExplorer().setBaseNode(0);
        Assertions.assertFalse((boolean)iter.next());
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new CHPreparationGraph.OrigGraph.Builder().addEdge(0, 1, largeEdgeID + 1, true, false));
        Assertions.assertTrue((boolean)e.getMessage().contains("Maximum node or edge key exceeded: -2147483648, max: 2147483647"), (String)e.getMessage());
    }
}

