/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryRoutingCHGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.ArrayUtil;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHTurnCostTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(CHTurnCostTest.class);
    private int maxCost;
    private DecimalEncodedValue speedEnc;
    private DecimalEncodedValue turnCostEnc;
    private EncodingManager encodingManager;
    private BaseGraph graph;
    private TurnCostStorage turnCostStorage;
    private List<CHConfig> chConfigs;
    private CHConfig chConfig;
    private RoutingCHGraph chGraph;
    private boolean checkStrict;

    @BeforeEach
    public void init() {
        this.maxCost = 10;
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.turnCostEnc = TurnCost.create((String)"car", (int)this.maxCost);
        this.encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();
        this.graph = new BaseGraph.Builder(this.encodingManager).withTurnCosts(true).build();
        this.turnCostStorage = this.graph.getTurnCostStorage();
        this.chConfigs = this.createCHConfigs();
        this.chConfig = this.chConfigs.get(0);
        this.checkStrict = true;
    }

    private List<CHConfig> createCHConfigs() {
        LinkedHashSet<CHConfig> configs = new LinkedHashSet<CHConfig>(5);
        configs.add(CHConfig.edgeBased((String)"p0", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.turnCostStorage, Double.POSITIVE_INFINITY)));
        configs.add(CHConfig.edgeBased((String)"p1", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.turnCostStorage, 0.0)));
        configs.add(CHConfig.edgeBased((String)"p2", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.turnCostStorage, 50.0)));
        long seed = System.nanoTime();
        Random rnd = new Random(seed);
        while (configs.size() < 6) {
            int uTurnCosts = 10 + rnd.nextInt(90);
            configs.add(CHConfig.edgeBased((String)("p" + configs.size()), (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.turnCostStorage, (double)uTurnCosts)));
        }
        return new ArrayList<CHConfig>(configs);
    }

    @RepeatedTest(value=10)
    public void testFindPath_randomContractionOrder_linear() {
        this.graph.edge(2, 1).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 0).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        this.setTurnCost(2, 1, 0, 2.0);
        this.setTurnCost(0, 3, 4, 4.0);
        this.checkPathUsingRandomContractionOrder(IntArrayList.from((int[])new int[]{2, 1, 0, 3, 4}), 9, 6, 2, 4);
    }

    @Test
    public void testFindPath_randomContractionOrder_duplicate_edges() {
        this.graph.edge(0, 1).setDistance(50.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 1).setDistance(60.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 2).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 4).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.setRestriction(3, 2, 4);
        this.graph.freeze();
        this.compareCHWithDijkstra(10, new int[]{0, 1, 2, 3, 4});
    }

    @Test
    public void testFindPath_randomContractionOrder_double_duplicate_edges() {
        this.graph.edge(0, 1).setDistance(250.789).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 1).setDistance(260.016).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(210.902).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(210.862).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(520.987).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        this.compareCHWithDijkstra(1000, new int[]{0, 1, 2, 3});
    }

    @RepeatedTest(value=100)
    public void testFindPath_multipleInOutEdges_turnReplacementDifference() {
        this.graph.edge(0, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 7).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 8).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 9).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 10).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        long seed = System.nanoTime();
        Random rnd = new Random(seed);
        LOGGER.info("Seed used to generate turn costs and restrictions: {}", (Object)seed);
        this.setRandomCost(2, 5, 3, rnd);
        this.setRandomCost(2, 5, 6, rnd);
        this.setRandomCost(4, 7, 10, rnd);
        this.setRandomCost(6, 7, 10, rnd);
        this.setRandomCostOrRestriction(0, 5, 3, rnd);
        this.setRandomCostOrRestriction(1, 5, 3, rnd);
        this.setRandomCostOrRestriction(0, 5, 6, rnd);
        this.setRandomCostOrRestriction(1, 5, 6, rnd);
        this.setRandomCostOrRestriction(4, 7, 8, rnd);
        this.setRandomCostOrRestriction(4, 7, 9, rnd);
        this.setRandomCostOrRestriction(6, 7, 8, rnd);
        this.setRandomCostOrRestriction(6, 7, 9, rnd);
        this.prepareCH(6, 0, 1, 2, 8, 9, 10, 5, 3, 4, 7);
        this.checkStrict = false;
        this.compareCHQueryWithDijkstra(2, 10);
        this.compareCHQueryWithDijkstra(1, 10);
        this.compareCHQueryWithDijkstra(2, 9);
        this.compareCHQueryWithDijkstra(1, 9);
    }

    @Test
    public void testFindPath_multipleInOutEdges_turnReplacementDifference_bug1() {
        this.graph.edge(1, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 7).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 9).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 10).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.setTurnCost(2, 5, 6, 4.0);
        this.setRestriction(1, 5, 6);
        this.setRestriction(4, 7, 9);
        this.prepareCH(6, 0, 1, 2, 8, 9, 10, 5, 3, 4, 7);
        this.compareCHQueryWithDijkstra(2, 9);
    }

    @Test
    public void testFindPath_duplicateEdge() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.compareCHWithDijkstra(100, new int[]{2, 3, 0, 4, 1});
    }

    @Test
    public void testFindPath_chain() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 8).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.freeze();
        this.setTurnCost(1, 2, 3, 4.0);
        this.setTurnCost(3, 4, 5, 2.0);
        this.setTurnCost(5, 6, 7, 3.0);
        this.checkPathUsingCH(ArrayUtil.iota((int)9), 8, 9, 0, 8, new int[]{1, 3, 5, 7, 0, 8, 2, 6, 4});
    }

    @Test
    public void testFindPath_bidir_chain() {
        EdgeIteratorState edge0 = this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge1 = this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge2 = this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge3 = this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge4 = this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge5 = this.graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        this.setTurnCost(edge0, edge1, 1, 5.0);
        this.setTurnCost(edge1, edge2, 2, 3.0);
        this.setTurnCost(edge2, edge3, 3, 2.0);
        this.setTurnCost(edge3, edge4, 4, 1.0);
        this.setTurnCost(edge4, edge5, 5, 4.0);
        this.setTurnCost(edge5, edge4, 5, 3.0);
        this.setTurnCost(edge4, edge3, 4, 2.0);
        this.setTurnCost(edge3, edge2, 3, 4.0);
        this.setTurnCost(edge2, edge1, 2, 1.0);
        this.setTurnCost(edge1, edge0, 1, 0.0);
        this.prepareCH(1, 3, 5, 2, 4, 0, 6);
        Path pathFwd = this.createAlgo().calcPath(0, 6);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5, 6}), (Object)pathFwd.calcNodes());
        Assertions.assertEquals((double)21.0, (double)pathFwd.getWeight(), (double)1.0E-6);
        Path pathBwd = this.createAlgo().calcPath(6, 0);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{6, 5, 4, 3, 2, 1, 0}), (Object)pathBwd.calcNodes());
        Assertions.assertEquals((double)16.0, (double)pathBwd.getWeight(), (double)1.0E-6);
    }

    @RepeatedTest(value=10)
    public void testFindPath_randomContractionOrder_simpleLoop() {
        this.graph.edge(0, 4).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 3).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.freeze();
        this.setRestriction(0, 4, 1);
        this.setTurnCost(4, 2, 3, 4.0);
        this.setTurnCost(3, 2, 4, 2.0);
        this.checkPathUsingRandomContractionOrder(IntArrayList.from((int[])new int[]{0, 4, 3, 2, 4, 1}), 7, 2, 0, 1);
    }

    @RepeatedTest(value=10)
    public void testFindPath_randomContractionOrder_singleDirectedLoop() {
        this.graph.edge(3, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 5).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 0).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 1).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 4).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.freeze();
        this.setRestriction(7, 5, 6);
        this.setTurnCost(0, 2, 1, 2.0);
        IntArrayList expectedPath = IntArrayList.from((int[])new int[]{3, 7, 5, 0, 2, 1, 5, 6, 4});
        int roadCosts = 12;
        int turnCosts = 2;
        this.checkPathUsingRandomContractionOrder(expectedPath, 12, 2, 3, 4);
    }

    @RepeatedTest(value=10)
    public void testFindPath_randomContractionOrder_singleLoop() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.freeze();
        this.setRestriction(1, 2, 5);
        this.setTurnCost(3, 4, 2, 2.0);
        this.setTurnCost(2, 4, 3, 4.0);
        IntArrayList expectedPath = IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 2, 5, 6});
        int roadCosts = 10;
        int turnCosts = 2;
        this.checkPathUsingRandomContractionOrder(expectedPath, 10, 2, 0, 6);
    }

    @RepeatedTest(value=10)
    public void testFindPath_randomContractionOrder_singleLoopWithNoise() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 6).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(6, 7).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(7, 8).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(8, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 2).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 7).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(7, 12).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(12, 13).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(13, 14).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(80.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(6, 11).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(11, 12).setDistance(500.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(8, 13).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 15).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(15, 16).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(16, 17).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(17, 4).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 9).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(9, 14).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        this.setRestriction(6, 7, 12);
        this.setTurnCost(8, 3, 2, 2.0);
        this.setTurnCost(2, 3, 8, 4.0);
        this.setTurnCost(1, 2, 7, 3.0);
        this.setTurnCost(7, 8, 13, 8.0);
        this.setTurnCost(8, 13, 14, 7.0);
        this.setTurnCost(16, 17, 4, 4.0);
        this.setTurnCost(4, 9, 14, 3.0);
        this.setTurnCost(3, 4, 9, 3.0);
        IntArrayList expectedPath = IntArrayList.from((int[])new int[]{0, 1, 6, 7, 8, 3, 2, 7, 12, 13, 14});
        int roadCosts = 15;
        int turnCosts = 2;
        this.checkPathUsingRandomContractionOrder(expectedPath, 15, 2, 0, 14);
    }

    @RepeatedTest(value=10)
    public void testFindPath_randomContractionOrder_complicatedGraphAndPath() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 7).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(7, 8).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(8, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 2).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 7).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(7, 12).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(12, 11).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(11, 6).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(6, 7).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 13).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(13, 14).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(14, 9).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(9, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 5).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 10).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(10, 9).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(14, 19).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(19, 18).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(18, 17).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(17, 16).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(16, 21).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(21, 22).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(22, 23).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(23, 24).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(24, 19).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(19, 20).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(20, 25).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(25, 26).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(8, 9).setDistance(750.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(17, 22).setDistance(90.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(18, 23).setDistance(150.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(12, 17).setDistance(500.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(13, 18).setDistance(800.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(14, 15).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(15, 27).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(27, 28).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(28, 26).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(20, 28).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        this.setRestriction(1, 7, 13);
        this.setTurnCost(1, 7, 12, 7.0);
        this.setTurnCost(2, 7, 13, 7.0);
        this.setRestriction(13, 14, 19);
        this.setTurnCost(4, 5, 10, 3.0);
        this.setTurnCost(10, 5, 4, 2.0);
        this.setRestriction(14, 19, 20);
        this.setTurnCost(17, 16, 21, 3.0);
        this.setTurnCost(1, 2, 7, 8.0);
        this.setTurnCost(20, 28, 26, 3.0);
        this.setTurnCost(7, 13, 14, 2.0);
        IntArrayList expectedPath = IntArrayList.from((int[])new int[]{0, 1, 7, 8, 3, 2, 7, 12, 11, 6, 7, 13, 14, 9, 10, 5, 4, 9, 14, 19, 24, 23, 22, 21, 16, 17, 18, 19, 20, 25, 26});
        int roadCosts = 49;
        int turnCosts = 4;
        this.checkPathUsingRandomContractionOrder(expectedPath, 49, 4, 0, 26);
    }

    @Test
    public void testFindPath_pTurn_uTurnAtContractedNode() {
        this.graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 0).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.freeze();
        this.setRestriction(5, 6, 1);
        IntArrayList expectedPath = IntArrayList.from((int[])new int[]{5, 6, 4, 0, 3, 2, 4, 6, 1});
        this.checkPath(expectedPath, 8, 0, 5, 1, new int[]{0, 1, 2, 3, 4, 5, 6});
    }

    @Test
    public void testFindPath_pTurn_uTurnAtContractedNode_twoShortcutsInAndOut() {
        this.graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 0).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.freeze();
        this.setRestriction(5, 6, 7);
        IntArrayList expectedPath = IntArrayList.from((int[])new int[]{5, 6, 1, 4, 0, 3, 2, 4, 1, 6, 7});
        this.checkPath(expectedPath, 10, 0, 5, 7, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
    }

    @RepeatedTest(value=10)
    public void testFindPath_highlyConnectedGraph_compareWithDijkstra() {
        double dist;
        int to;
        int from;
        int j;
        int i;
        int size = 4;
        int maxDist = 40;
        int numQueries = 1000;
        long seed = System.nanoTime();
        LOGGER.info("Seed used to generate graph: {}", (Object)seed);
        Random rnd = new Random(seed);
        int edgeCounter = 0;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                from = i * 4 + j;
                to = from + 1;
                dist = this.nextDist(40, rnd);
                this.graph.edge(from, to).setDistance(dist).set(this.speedEnc, 10.0, 10.0);
                LOGGER.trace("final EdgeIteratorState edge{} = graph.edge({},{},{},true);", new Object[]{edgeCounter++, from, to, dist});
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                from = i * 4 + j;
                to = from + 4;
                dist = this.nextDist(40, rnd);
                this.graph.edge(from, to).setDistance(dist).set(this.speedEnc, 10.0, 10.0);
                LOGGER.trace("final EdgeIteratorState edge{} = graph.edge({},{},{},true);", new Object[]{edgeCounter++, from, to, dist});
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                int to2;
                double dist2;
                from = i * 4 + j;
                if (j < 3) {
                    dist2 = this.nextDist(40, rnd);
                    to2 = from + 4 + 1;
                    this.graph.edge(from, to2).setDistance(dist2).set(this.speedEnc, 10.0, 10.0);
                    LOGGER.trace("final EdgeIteratorState edge{} = graph.edge({},{},{},true);", new Object[]{edgeCounter++, from, to2, dist2});
                }
                if (j <= 0) continue;
                dist2 = this.nextDist(40, rnd);
                to2 = from + 4 - 1;
                this.graph.edge(from, to2).setDistance(dist2).set(this.speedEnc, 10.0, 10.0);
                LOGGER.trace("final EdgeIteratorState edge{} = graph.edge({},{},{},true);", new Object[]{edgeCounter++, from, to2, dist2});
            }
        }
        this.graph.freeze();
        EdgeExplorer inExplorer = this.graph.createEdgeExplorer();
        EdgeExplorer outExplorer = this.graph.createEdgeExplorer();
        for (int node = 0; node < 16; ++node) {
            EdgeIterator inIter = inExplorer.setBaseNode(node);
            while (inIter.next()) {
                EdgeIterator outIter = outExplorer.setBaseNode(node);
                while (outIter.next()) {
                    if (inIter.getEdge() == outIter.getEdge()) continue;
                    int cost = this.nextCost(rnd);
                    this.setCostOrRestriction((EdgeIteratorState)inIter, (EdgeIteratorState)outIter, node, cost);
                }
            }
        }
        IntArrayList contractionOrder = this.getRandomIntegerSequence(this.graph.getNodes(), rnd);
        this.checkStrict = false;
        this.compareCHWithDijkstra(1000, contractionOrder.toArray());
    }

    @Test
    public void testFindPath_bug() {
        this.graph.edge(1, 2).setDistance(180.364).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 4).setDistance(290.814).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 2).setDistance(140.554).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 4).setDistance(290.819).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 3).setDistance(290.271).set(this.speedEnc, 10.0, 10.0);
        this.setRestriction(3, 1, 2);
        this.graph.freeze();
        this.compareCHWithDijkstra(100, new int[]{1, 0, 3, 2, 4});
    }

    @Test
    public void testFindPath_bug2() {
        this.graph.edge(0, 3).setDistance(240.001).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 1).setDistance(60.087).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 1).setDistance(60.067).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(460.631).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 4).setDistance(460.184).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        this.compareCHWithDijkstra(1000, new int[]{1, 0, 3, 2, 4});
    }

    @Test
    public void testFindPath_loop() {
        this.graph.edge(0, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 8).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(8, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.setRestriction(8, 4, 6);
        this.graph.freeze();
        this.prepareCH(0, 1, 2, 3, 4, 5, 6, 7, 8);
        this.compareCHQueryWithDijkstra(0, 5);
    }

    @Test
    public void testFindPath_finiteUTurnCost() {
        this.graph.edge(0, 3).setDistance(1000.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 2).setDistance(5000.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(2000.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 1).setDistance(1000.0).set(this.speedEnc, 10.0, 0.0);
        this.setRestriction(0, 3, 1);
        this.graph.freeze();
        this.chConfig = this.chConfigs.get(2);
        this.prepareCH(4, 0, 2, 3, 1);
        Path path = this.createAlgo().calcPath(0, 1);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 3, 4, 3, 1}), (Object)path.calcNodes());
        this.compareCHQueryWithDijkstra(0, 1);
    }

    @Test
    public void testFindPath_calcTurnCostTime() {
        EdgeIteratorState edge0 = this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge1 = this.graph.edge(0, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge2 = this.graph.edge(4, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge3 = this.graph.edge(1, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge4 = this.graph.edge(1, 0).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.setTurnCost(edge0, edge4, 1, 8.0);
        this.setRestriction(edge0, edge3, 1);
        this.graph.freeze();
        this.checkPath(IntArrayList.from((int[])new int[]{2, 1, 0, 4}), 3, 8, 2, 4, new int[]{2, 0, 1, 3, 4});
    }

    @ParameterizedTest
    @ValueSource(strings={"dijkstrabi", "astarbi"})
    public void test_issue1593_full(String algo) {
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(0, 49.407117, 9.701306);
        na.setNode(1, 49.406914, 9.703393);
        na.setNode(2, 49.404004, 9.70911);
        na.setNode(3, 49.40016, 9.708787);
        na.setNode(4, 49.400883, 9.706347);
        EdgeIteratorState edge0 = this.graph.edge(4, 3).setDistance(1940.063).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge1 = this.graph.edge(1, 2).setDistance(5250.106).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge2 = this.graph.edge(1, 2).setDistance(5250.106).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge3 = this.graph.edge(4, 1).setDistance(7030.778).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge4 = this.graph.edge(2, 4).setDistance(4000.509).set(this.speedEnc, 10.0, 10.0);
        this.setRestriction(edge4, edge1, 2);
        this.setRestriction(edge1, edge4, 2);
        this.setRestriction(edge0, edge3, 4);
        this.graph.freeze();
        LocationIndexTree index = new LocationIndexTree((Graph)this.graph, (Directory)new RAMDirectory());
        index.prepareIndex();
        List<GHPoint> points = Arrays.asList(new GHPoint(49.401669187194116, 9.706821649608745), new GHPoint(49.40056349818417, 9.70767186472369), new GHPoint(49.406580835146556, 9.704665738628218), new GHPoint(49.40107534698834, 9.702248694088528));
        ArrayList<Snap> snaps = new ArrayList<Snap>(points.size());
        for (GHPoint point : points) {
            snaps.add(index.findClosest(point.getLat(), point.getLon(), EdgeFilter.ALL_EDGES));
        }
        this.automaticPrepareCH();
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, snaps);
        EdgeToEdgeRoutingAlgorithm chAlgo = new CHRoutingAlgorithmFactory(this.chGraph, queryGraph).createAlgo(new PMap().putObject("algorithm", (Object)algo));
        Path path = chAlgo.calcPath(5, 6);
        Assertions.assertFalse((boolean)path.isFound(), (String)("there should not be a path, but found: " + String.valueOf(path.calcNodes())));
    }

    @ParameterizedTest
    @ValueSource(strings={"dijkstrabi", "astarbi"})
    public void test_issue_1593_simple(String algo) {
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(1, 0.2, 0.0);
        na.setNode(3, 0.1, 0.0);
        na.setNode(2, 0.0, 0.0);
        na.setNode(0, 0.1, 0.1);
        na.setNode(5, 0.1, 0.2);
        na.setNode(4, 0.1, 0.3);
        EdgeIteratorState edge0 = this.graph.edge(3, 1).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge1 = this.graph.edge(2, 3).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 0).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 5).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 4).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.setRestriction(edge1, edge0, 3);
        this.graph.freeze();
        this.prepareCH(0, 1, 2, 3, 4, 5);
        Assertions.assertEquals((int)5, (int)this.chGraph.getBaseGraph().getEdges());
        Assertions.assertEquals((int)7, (int)this.chGraph.getEdges(), (String)"expected two shortcuts: 3->5 and 5->3");
        Assertions.assertFalse((boolean)this.findPathUsingDijkstra(2, 1).isFound());
        this.compareCHQueryWithDijkstra(2, 1);
        LocationIndexTree index = new LocationIndexTree((Graph)this.graph, (Directory)new RAMDirectory());
        index.prepareIndex();
        Snap snap = index.findClosest(0.1, 0.15, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)snap);
        Assertions.assertEquals((int)1, (int)(queryGraph.getNodes() - this.chGraph.getNodes()), (String)"expected one virtual node");
        QueryRoutingCHGraph routingCHGraph = new QueryRoutingCHGraph(this.chGraph, queryGraph);
        EdgeToEdgeRoutingAlgorithm chAlgo = new CHRoutingAlgorithmFactory((RoutingCHGraph)routingCHGraph).createAlgo(new PMap().putObject("algorithm", (Object)algo));
        Path path = chAlgo.calcPath(2, 1);
        Assertions.assertFalse((boolean)path.isFound(), (String)("no path should be found, but found " + String.valueOf(path.calcNodes())));
    }

    @ParameterizedTest
    @ValueSource(strings={"dijkstrabi", "astarbi"})
    public void testRouteViaVirtualNode(String algo) {
        this.graph.edge(0, 1).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        GHUtility.updateDistancesFor((Graph)this.graph, (int)0, (double[])new double[]{0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)1, (double[])new double[]{0.02, 0.02});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)2, (double[])new double[]{0.03, 0.03});
        this.graph.freeze();
        this.automaticPrepareCH();
        LocationIndexTree index = new LocationIndexTree((Graph)this.graph, (Directory)new RAMDirectory());
        index.prepareIndex();
        Snap snap = index.findClosest(0.01, 0.01, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)snap);
        Assertions.assertEquals((int)3, (int)snap.getClosestNode());
        Assertions.assertEquals((int)0, (int)snap.getClosestEdge().getEdge());
        EdgeToEdgeRoutingAlgorithm chAlgo = new CHRoutingAlgorithmFactory(this.chGraph, queryGraph).createAlgo(new PMap().putObject("algorithm", (Object)algo));
        Path path = chAlgo.calcPath(0, 2);
        Assertions.assertTrue((boolean)path.isFound(), (String)"it should be possible to route via a virtual node, but no path found");
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 3, 1, 2}), (Object)path.calcNodes());
        Assertions.assertEquals((double)DistancePlaneProjection.DIST_PLANE.calcDist(0.0, 0.0, 0.03, 0.03), (double)path.getDistance(), (double)0.1);
    }

    @ParameterizedTest
    @ValueSource(strings={"dijkstrabi", "astarbi"})
    public void testRouteViaVirtualNode_withAlternative(String algo) {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 0).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        GHUtility.updateDistancesFor((Graph)this.graph, (int)0, (double[])new double[]{0.01, 0.0});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)1, (double[])new double[]{0.01, 0.02});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)2, (double[])new double[]{0.0, 0.02});
        this.graph.freeze();
        this.automaticPrepareCH();
        LocationIndexTree index = new LocationIndexTree((Graph)this.graph, (Directory)new RAMDirectory());
        index.prepareIndex();
        Snap snap = index.findClosest(0.01, 0.01, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)snap);
        Assertions.assertEquals((int)3, (int)snap.getClosestNode());
        Assertions.assertEquals((int)0, (int)snap.getClosestEdge().getEdge());
        QueryRoutingCHGraph routingCHGraph = new QueryRoutingCHGraph(this.chGraph, queryGraph);
        EdgeToEdgeRoutingAlgorithm chAlgo = new CHRoutingAlgorithmFactory((RoutingCHGraph)routingCHGraph).createAlgo(new PMap().putObject("algorithm", (Object)algo));
        Path path = chAlgo.calcPath(1, 0);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 3, 0}), (Object)path.calcNodes());
    }

    @ParameterizedTest
    @ValueSource(strings={"dijkstrabi", "astarbi"})
    public void testFiniteUTurnCost_virtualViaNode(String algo) {
        this.graph.edge(4, 3).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 2).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 1).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 0).setDistance(0.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 5).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        GHUtility.updateDistancesFor((Graph)this.graph, (int)4, (double[])new double[]{0.1, 0.0});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)3, (double[])new double[]{0.1, 0.1});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)2, (double[])new double[]{0.1, 0.2});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)1, (double[])new double[]{0.1, 0.3});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)0, (double[])new double[]{0.1, 0.4});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)5, (double[])new double[]{0.0, 0.3});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)6, (double[])new double[]{0.0, 0.4});
        this.setRestriction(2, 1, 5);
        this.graph.freeze();
        this.chConfig = this.chConfigs.get(2);
        this.prepareCH(0, 1, 2, 3, 4, 5, 6);
        LocationIndexTree index = new LocationIndexTree((Graph)this.graph, (Directory)new RAMDirectory());
        index.prepareIndex();
        GHPoint virtualPoint = new GHPoint(0.1, 0.35);
        Snap snap = index.findClosest(virtualPoint.lat, virtualPoint.lon, EdgeFilter.ALL_EDGES);
        QueryGraph chQueryGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)snap);
        Assertions.assertEquals((int)3, (int)snap.getClosestEdge().getEdge());
        QueryRoutingCHGraph routingCHGraph = new QueryRoutingCHGraph(this.chGraph, chQueryGraph);
        EdgeToEdgeRoutingAlgorithm chAlgo = new CHRoutingAlgorithmFactory((RoutingCHGraph)routingCHGraph).createAlgo(new PMap().putObject("algorithm", (Object)algo));
        Path path = chAlgo.calcPath(4, 6);
        Assertions.assertTrue((boolean)path.isFound());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 3, 2, 1, 0, 1, 5, 6}), (Object)path.calcNodes());
        Snap snap2 = index.findClosest(virtualPoint.lat, virtualPoint.lon, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)snap2);
        Assertions.assertEquals((int)3, (int)snap2.getClosestEdge().getEdge());
        Weighting w = queryGraph.wrapWeighting(this.chConfig.getWeighting());
        Dijkstra dijkstra = new Dijkstra((Graph)queryGraph, w, TraversalMode.EDGE_BASED);
        Path dijkstraPath = dijkstra.calcPath(4, 6);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 3, 2, 1, 7, 0, 7, 1, 5, 6}), (Object)dijkstraPath.calcNodes());
        Assertions.assertEquals((double)dijkstraPath.getWeight(), (double)path.getWeight(), (double)0.01);
        Assertions.assertEquals((double)dijkstraPath.getDistance(), (double)path.getDistance(), (double)0.01);
        Assertions.assertEquals((float)dijkstraPath.getTime(), (float)path.getTime(), (float)5.0f);
    }

    @ParameterizedTest
    @ValueSource(strings={"dijkstrabi", "astarbi"})
    public void test_astar_issue2061(String algo) {
        this.graph.edge(0, 1).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 5).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 2).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 6).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 7).setDistance(0.0).set(this.speedEnc, 10.0, 0.0);
        GHUtility.updateDistancesFor((Graph)this.graph, (int)0, (double[])new double[]{46.5, 9.7});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)1, (double[])new double[]{46.9, 9.8});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)2, (double[])new double[]{46.7, 9.7});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)4, (double[])new double[]{46.9, 9.7});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)3, (double[])new double[]{46.8, 9.7});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)5, (double[])new double[]{47.0, 9.7});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)6, (double[])new double[]{46.3, 9.7});
        GHUtility.updateDistancesFor((Graph)this.graph, (int)7, (double[])new double[]{46.2, 9.7});
        this.graph.freeze();
        this.automaticPrepareCH();
        EdgeToEdgeRoutingAlgorithm chAlgo = new CHRoutingAlgorithmFactory(this.chGraph).createAlgo(new PMap().putObject("algorithm", (Object)algo));
        Path path = chAlgo.calcPath(0, 5);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 2, 3, 4, 5}), (Object)path.calcNodes());
    }

    @Test
    void testZeroUTurnCosts_atBarrier_issue2564() {
        this.graph.edge(0, 1).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(70.336).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(100.161).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(0.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 5).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        this.chConfig = this.chConfigs.get(1);
        this.prepareCH(0, 5, 2, 1, 3, 4);
        this.compareCHQueryWithDijkstra(0, 5);
    }

    @Test
    void testBestFwdBwdEntryUpdate() {
        this.graph.edge(2, 0).setDistance(8000.22).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(4780.84).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 4).setDistance(5470.08).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 1).setDistance(2880.95).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(900.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        this.prepareCH(1, 3, 0, 2, 4);
        this.compareCHQueryWithDijkstra(1, 2);
    }

    @Test
    void testEdgeKeyBug() {
        this.graph.edge(0, 3).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 3).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 4).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 2).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.freeze();
        this.prepareCH(2, 0, 1, 3, 4);
        Assertions.assertEquals((int)2, (int)this.chGraph.getShortcuts());
        RoutingCHEdgeIteratorState chEdge = this.chGraph.getEdgeIteratorState(6, 4);
        Assertions.assertEquals((int)3, (int)chEdge.getBaseNode());
        Assertions.assertEquals((int)4, (int)chEdge.getAdjNode());
        Assertions.assertEquals((int)2, (int)chEdge.getSkippedEdge1());
        Assertions.assertEquals((int)0, (int)chEdge.getSkippedEdge2());
        Assertions.assertEquals((int)5, (int)chEdge.getOrigEdgeKeyFirst());
        Assertions.assertEquals((int)0, (int)chEdge.getOrigEdgeKeyLast());
        this.compareCHQueryWithDijkstra(1, 3);
    }

    @RepeatedTest(value=10)
    public void testFindPath_random_compareWithDijkstra() {
        long seed = System.nanoTime();
        LOGGER.info("Seed for testFindPath_random_compareWithDijkstra: {}", (Object)seed);
        this.compareWithDijkstraOnRandomGraph(seed);
    }

    @RepeatedTest(value=10)
    public void testFindPath_random_compareWithDijkstra_finiteUTurnCost() {
        long seed = System.nanoTime();
        LOGGER.info("Seed for testFindPath_random_compareWithDijkstra_finiteUTurnCost: {}, using weighting: {}", (Object)seed, (Object)this.chConfig.getWeighting());
        this.chConfig = this.chConfigs.get(2 + new Random(seed).nextInt(this.chConfigs.size() - 2));
        this.compareWithDijkstraOnRandomGraph(seed);
    }

    @RepeatedTest(value=10)
    public void testFindPath_random_compareWithDijkstra_zeroUTurnCost() {
        long seed = System.nanoTime();
        LOGGER.info("Seed for testFindPath_random_compareWithDijkstra_zeroUTurnCost: {}, using weighting: {}", (Object)seed, (Object)this.chConfig.getWeighting());
        this.chConfig = this.chConfigs.get(1);
        this.compareWithDijkstraOnRandomGraph(seed);
    }

    private void compareWithDijkstraOnRandomGraph(long seed) {
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)this.graph, (Random)rnd, (int)20, (double)3.0, (boolean)true, (DecimalEncodedValue)this.speedEnc, null, (double)0.9, (double)0.8);
        GHUtility.addRandomTurnCosts((Graph)this.graph, (long)seed, null, (DecimalEncodedValue)this.turnCostEnc, (int)this.maxCost, (TurnCostStorage)this.turnCostStorage);
        this.graph.freeze();
        this.checkStrict = false;
        IntArrayList contractionOrder = this.getRandomIntegerSequence(this.graph.getNodes(), rnd);
        this.compareCHWithDijkstra(100, contractionOrder.toArray());
    }

    @RepeatedTest(value=10)
    public void testFindPath_heuristic_compareWithDijkstra() {
        long seed = System.nanoTime();
        LOGGER.info("Seed for testFindPath_heuristic_compareWithDijkstra: {}", (Object)seed);
        this.compareWithDijkstraOnRandomGraph_heuristic(seed);
    }

    @RepeatedTest(value=10)
    public void testFindPath_heuristic_compareWithDijkstra_finiteUTurnCost() {
        long seed = System.nanoTime();
        LOGGER.info("Seed for testFindPath_heuristic_compareWithDijkstra_finiteUTurnCost: {}, using weighting: {}", (Object)seed, (Object)this.chConfig.getWeighting());
        this.chConfig = this.chConfigs.get(2 + new Random(seed).nextInt(this.chConfigs.size() - 2));
        this.compareWithDijkstraOnRandomGraph_heuristic(seed);
    }

    private void compareWithDijkstraOnRandomGraph_heuristic(long seed) {
        GHUtility.buildRandomGraph((Graph)this.graph, (Random)new Random(seed), (int)20, (double)3.0, (boolean)true, (DecimalEncodedValue)this.speedEnc, null, (double)0.9, (double)0.8);
        GHUtility.addRandomTurnCosts((Graph)this.graph, (long)seed, null, (DecimalEncodedValue)this.turnCostEnc, (int)this.maxCost, (TurnCostStorage)this.turnCostStorage);
        this.graph.freeze();
        this.checkStrict = false;
        this.automaticCompareCHWithDijkstra(100);
    }

    private int nextCost(Random rnd) {
        return rnd.nextInt(3 * this.maxCost);
    }

    private double nextDist(int maxDist, Random rnd) {
        return rnd.nextDouble() * (double)maxDist;
    }

    private void checkPathUsingRandomContractionOrder(IntArrayList expectedPath, int expectedWeight, int expectedTurnCosts, int from, int to) {
        IntArrayList contractionOrder = this.getRandomIntegerSequence(this.graph.getNodes(), new Random());
        this.checkPath(expectedPath, expectedWeight, expectedTurnCosts, from, to, contractionOrder.toArray());
    }

    private void checkPath(IntArrayList expectedPath, int expectedEdgeWeight, int expectedTurnCosts, int from, int to, int[] contractionOrder) {
        this.checkPathUsingDijkstra(expectedPath, expectedEdgeWeight, expectedTurnCosts, from, to);
        this.checkPathUsingCH(expectedPath, expectedEdgeWeight, expectedTurnCosts, from, to, contractionOrder);
    }

    private void checkPathUsingDijkstra(IntArrayList expectedPath, int expectedEdgeWeight, int expectedTurnCosts, int from, int to) {
        Path dijkstraPath = this.findPathUsingDijkstra(from, to);
        int expectedWeight = expectedEdgeWeight + expectedTurnCosts;
        int expectedDistance = expectedEdgeWeight * 10;
        int expectedTime = (expectedEdgeWeight + expectedTurnCosts) * 1000;
        Assertions.assertEquals((Object)expectedPath, (Object)dijkstraPath.calcNodes(), (String)"Normal Dijkstra did not find expected path.");
        Assertions.assertEquals((double)expectedWeight, (double)dijkstraPath.getWeight(), (double)1.0E-6, (String)"Normal Dijkstra did not calculate expected weight.");
        Assertions.assertEquals((double)expectedDistance, (double)dijkstraPath.getDistance(), (double)1.0E-6, (String)"Normal Dijkstra did not calculate expected distance.");
        Assertions.assertEquals((float)expectedTime, (float)dijkstraPath.getTime(), (float)2.0f, (String)"Normal Dijkstra did not calculate expected time.");
    }

    private void checkPathUsingCH(IntArrayList expectedPath, int expectedEdgeWeight, int expectedTurnCosts, int from, int to, int[] contractionOrder) {
        Path chPath = this.findPathUsingCH(from, to, contractionOrder);
        int expectedWeight = expectedEdgeWeight + expectedTurnCosts;
        int expectedDistance = expectedEdgeWeight * 10;
        int expectedTime = (expectedEdgeWeight + expectedTurnCosts) * 1000;
        Assertions.assertEquals((Object)expectedPath, (Object)chPath.calcNodes(), (String)("Contraction Hierarchies did not find expected path. contraction order=" + Arrays.toString(contractionOrder)));
        Assertions.assertEquals((double)expectedWeight, (double)chPath.getWeight(), (double)1.0E-6, (String)"Contraction Hierarchies did not calculate expected weight.");
        Assertions.assertEquals((double)expectedDistance, (double)chPath.getDistance(), (double)1.0E-6, (String)"Contraction Hierarchies did not calculate expected distance.");
        Assertions.assertEquals((float)expectedTime, (float)chPath.getTime(), (float)2.0f, (String)"Contraction Hierarchies did not calculate expected time.");
    }

    private Path findPathUsingDijkstra(int from, int to) {
        Weighting w = this.graph.wrapWeighting(this.chConfig.getWeighting());
        Dijkstra dijkstra = new Dijkstra((Graph)this.graph, w, TraversalMode.EDGE_BASED);
        return dijkstra.calcPath(from, to);
    }

    private Path findPathUsingCH(int from, int to, int[] contractionOrder) {
        this.prepareCH(contractionOrder);
        RoutingAlgorithm chAlgo = this.createAlgo();
        return chAlgo.calcPath(from, to);
    }

    private void prepareCH(int ... contractionOrder) {
        LOGGER.debug("Calculating CH with contraction order {}", (Object)contractionOrder);
        if (!this.graph.isFrozen()) {
            this.graph.freeze();
        }
        NodeOrderingProvider nodeOrderingProvider = NodeOrderingProvider.fromArray((int[])contractionOrder);
        PrepareContractionHierarchies ch = PrepareContractionHierarchies.fromGraph((BaseGraph)this.graph, (CHConfig)this.chConfig).useFixedNodeOrdering(nodeOrderingProvider);
        PrepareContractionHierarchies.Result res = ch.doWork();
        this.chGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
    }

    private void automaticPrepareCH() {
        PMap pMap = new PMap();
        pMap.putObject("prepare.ch.updates.periodic", (Object)20);
        pMap.putObject("prepare.ch.updates.lazy", (Object)100);
        pMap.putObject("prepare.ch.updates.neighbor", (Object)4);
        pMap.putObject("prepare.ch.log_messages", (Object)10);
        PrepareContractionHierarchies ch = PrepareContractionHierarchies.fromGraph((BaseGraph)this.graph, (CHConfig)this.chConfig);
        ch.setParams(pMap);
        PrepareContractionHierarchies.Result res = ch.doWork();
        this.chGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
    }

    private void automaticCompareCHWithDijkstra(int numQueries) {
        long seed = System.nanoTime();
        LOGGER.info("Seed used to create random routing queries: {}", (Object)seed);
        Random rnd = new Random(seed);
        this.automaticPrepareCH();
        for (int i = 0; i < numQueries; ++i) {
            this.compareCHQueryWithDijkstra(rnd.nextInt(this.graph.getNodes()), rnd.nextInt(this.graph.getNodes()));
        }
    }

    private void compareCHWithDijkstra(int numQueries, int[] contractionOrder) {
        long seed = System.nanoTime();
        LOGGER.info("Seed used to create random routing queries: {}", (Object)seed);
        Random rnd = new Random(seed);
        this.prepareCH(contractionOrder);
        for (int i = 0; i < numQueries; ++i) {
            this.compareCHQueryWithDijkstra(rnd.nextInt(this.graph.getNodes()), rnd.nextInt(this.graph.getNodes()));
        }
    }

    private void compareCHQueryWithDijkstra(int from, int to) {
        boolean algosDisagree;
        Path dijkstraPath = this.findPathUsingDijkstra(from, to);
        RoutingAlgorithm chAlgo = this.createAlgo();
        Path chPath = chAlgo.calcPath(from, to);
        boolean bl = algosDisagree = Math.abs(dijkstraPath.getWeight() - chPath.getWeight()) > 0.01;
        if (this.checkStrict) {
            boolean bl2 = algosDisagree = algosDisagree || Math.abs(dijkstraPath.getDistance() - chPath.getDistance()) > 0.01 || Math.abs(dijkstraPath.getTime() - chPath.getTime()) > 1L;
        }
        if (algosDisagree) {
            System.out.println("Graph that produced error:");
            GHUtility.printGraphForUnitTest((Graph)this.graph, (DecimalEncodedValue)this.speedEnc);
            Assertions.fail((String)("Dijkstra and CH did not find equal shortest paths for route from " + from + " to " + to + "\n dijkstra: weight: " + dijkstraPath.getWeight() + ", distance: " + dijkstraPath.getDistance() + ", time: " + dijkstraPath.getTime() + ", nodes: " + String.valueOf(dijkstraPath.calcNodes()) + "\n       ch: weight: " + chPath.getWeight() + ", distance: " + chPath.getDistance() + ", time: " + chPath.getTime() + ", nodes: " + String.valueOf(chPath.calcNodes())));
        }
    }

    private RoutingAlgorithm createAlgo() {
        return new CHRoutingAlgorithmFactory(this.chGraph).createAlgo(new PMap().putObject("algorithm", (Object)"dijkstrabi"));
    }

    private IntArrayList getRandomIntegerSequence(int nodes, Random rnd) {
        return ArrayUtil.shuffle((IntArrayList)ArrayUtil.iota((int)nodes), (Random)rnd);
    }

    private void setRandomCostOrRestriction(int from, int via, int to, Random rnd) {
        double chance = 0.7;
        if (rnd.nextDouble() < 0.7) {
            this.setRestriction(from, via, to);
            LOGGER.trace("setRestriction({}, {}, {});", new Object[]{from, via, to});
        } else {
            this.setRandomCost(from, via, to, rnd);
        }
    }

    private void setRandomCost(int from, int via, int to, Random rnd) {
        int cost = (int)(rnd.nextDouble() * (double)this.maxCost / 2.0);
        this.setTurnCost(from, via, to, (double)cost);
        LOGGER.trace("setTurnCost({}, {}, {}, {});", new Object[]{from, via, to, cost});
    }

    private void setRestriction(int from, int via, int to) {
        this.setRestriction(this.getEdge(from, via), this.getEdge(via, to), via);
    }

    private void setRestriction(EdgeIteratorState inEdge, EdgeIteratorState outEdge, int viaNode) {
        this.graph.getTurnCostStorage().set(this.encodingManager.getTurnDecimalEncodedValue(TurnCost.key((String)"car")), inEdge.getEdge(), viaNode, outEdge.getEdge(), Double.POSITIVE_INFINITY);
    }

    private void setTurnCost(int from, int via, int to, double cost) {
        this.setTurnCost(this.getEdge(from, via), this.getEdge(via, to), via, cost);
    }

    private void setTurnCost(EdgeIteratorState inEdge, EdgeIteratorState outEdge, int viaNode, double costs) {
        this.graph.getTurnCostStorage().set(this.encodingManager.getTurnDecimalEncodedValue(TurnCost.key((String)"car")), inEdge.getEdge(), viaNode, outEdge.getEdge(), costs);
    }

    private void setCostOrRestriction(EdgeIteratorState inEdge, EdgeIteratorState outEdge, int viaNode, int cost) {
        if (cost >= this.maxCost) {
            this.setRestriction(inEdge, outEdge, viaNode);
            LOGGER.trace("setRestriction(edge{}, edge{}, {});", new Object[]{inEdge.getEdge(), outEdge.getEdge(), viaNode});
        } else {
            this.setTurnCost(inEdge, outEdge, viaNode, (double)cost);
            LOGGER.trace("setTurnCost(edge{}, edge{}, {}, {});", new Object[]{inEdge.getEdge(), outEdge.getEdge(), viaNode, cost});
        }
    }

    private EdgeIteratorState getEdge(int from, int to) {
        return GHUtility.getEdge((Graph)this.graph, (int)from, (int)to);
    }
}

