/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.EdgeBasedNodeContractor;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.CHStorageBuilder;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class EdgeBasedNodeContractorTest {
    private final int maxCost = 10;
    private DecimalEncodedValue speedEnc;
    private DecimalEncodedValue turnCostEnc;
    private BaseGraph graph;
    private Weighting weighting;
    private CHStorage chStore;
    private CHStorageBuilder chBuilder;
    private List<CHConfig> chConfigs;

    @BeforeEach
    public void setup() {
        this.initialize();
    }

    private void initialize() {
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.turnCostEnc = TurnCost.create((String)"car", (int)10);
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();
        this.graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        this.chConfigs = Arrays.asList(CHConfig.edgeBased((String)"p1", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.graph.getTurnCostStorage(), Double.POSITIVE_INFINITY)), CHConfig.edgeBased((String)"p2", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.graph.getTurnCostStorage(), 60.0)), CHConfig.edgeBased((String)"p3", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.graph.getTurnCostStorage(), 0.0)));
    }

    private void freeze() {
        this.graph.freeze();
        this.chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)this.chConfigs.get(0));
        this.chBuilder = new CHStorageBuilder(this.chStore);
        this.weighting = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)this.chStore, (CHConfig)this.chConfigs.get(0)).getWeighting();
    }

    @Test
    public void testContractNodes_simpleLoop() {
        this.graph.edge(6, 7).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge7to8 = this.graph.edge(7, 8).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge8to3 = this.graph.edge(8, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge3to2 = this.graph.edge(3, 2).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge2to7 = this.graph.edge(2, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 9).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.setRestriction(6, 7, 9);
        this.setTurnCost(8, 3, 2, 2.0);
        this.contractNodes(5, 6, 3, 2, 9, 1, 8, 4, 7, 0);
        this.checkShortcuts(this.createShortcut(2, 8, edge8to3, edge3to2, 5.0, false, true), this.createShortcut(8, 7, edge8to3.getEdgeKey(), edge2to7.getEdgeKey(), 6, edge2to7.getEdge(), 6.0, true, false), this.createShortcut(7, 7, edge7to8.getEdgeKey(), edge2to7.getEdgeKey(), edge7to8.getEdge(), 7, 8.0, true, false));
    }

    @Test
    public void testContractNodes_necessaryAlternative() {
        EdgeIteratorState e6to0 = this.graph.edge(6, 0).setDistance(40.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e0to3 = this.graph.edge(0, 3).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e6to3 = this.graph.edge(6, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e3to5 = this.graph.edge(3, 5).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 4).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.setRestriction(1, 6, 3);
        this.contractAllNodesInOrder();
        this.checkShortcuts(this.createShortcut(3, 6, e6to0, e0to3, 9.0, false, true), this.createShortcut(5, 6, e6to0.getEdgeKey(), e3to5.getEdgeKey(), 7, e3to5.getEdge(), 11.0, false, true), this.createShortcut(5, 6, e6to3, e3to5, 3.0, false, true));
    }

    @Test
    public void testContractNodes_alternativeNecessary_noUTurn() {
        EdgeIteratorState e0to4 = this.graph.edge(4, 0).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e0to2 = this.graph.edge(0, 2).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e2to3 = this.graph.edge(2, 3).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e1to3 = this.graph.edge(3, 1).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e2to4 = this.graph.edge(4, 2).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractAllNodesInOrder();
        this.checkShortcuts(this.createShortcut(2, 4, e0to4, e0to2, 8.0, false, true), this.createShortcut(3, 4, e0to4.getEdgeKey(), e2to3.getEdgeKey(), 5, e2to3.getEdge(), 10.0, false, true), this.createShortcut(3, 4, e2to4, e2to3, 4.0, false, true));
    }

    @Test
    public void testContractNodes_bidirectionalLoop() {
        this.graph.edge(1, 0).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 4).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e4to6 = this.graph.edge(4, 6).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e6to3 = this.graph.edge(6, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e3to4 = this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e4to5 = this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 2).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setRestriction(0, 4, 5);
        this.setTurnCost(6, 3, 4, 2.0);
        this.setTurnCost(4, 3, 6, 4.0);
        this.setMaxLevelOnAllNodes();
        this.contractAllNodesInOrder();
        this.checkShortcuts(this.createShortcut(4, 6, e3to4.detach(true), e6to3.detach(true), 6.0, true, false), this.createShortcut(4, 6, e6to3, e3to4, 4.0, false, true), this.createShortcut(5, 6, e6to3.getEdgeKey(), e4to5.getEdgeKey(), 8, e4to5.getEdge(), 5.0, false, true), this.createShortcut(5, 6, e4to6.detach(true), e4to5, 3.0, false, true));
    }

    @Test
    public void testContractNode_twoNormalEdges_noSourceEdgeToConnect() {
        this.graph.edge(1, 0).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 2).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(0, 3, 1, 2);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_twoNormalEdges_noTargetEdgeToConnect() {
        this.graph.edge(3, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 0).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 2).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(0, 3, 1, 2);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_twoNormalEdges_noEdgesToConnectBecauseOfTurnRestrictions() {
        this.graph.edge(0, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 2).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 4).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.setRestriction(0, 3, 2);
        this.setRestriction(2, 4, 1);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 3, 4, 1);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_twoNormalEdges_noTurncosts() {
        this.graph.edge(0, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e3to2 = this.graph.edge(3, 2).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e2to4 = this.graph.edge(2, 4).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        EdgeBasedNodeContractor nodeContractor = this.createNodeContractor();
        this.contractNode((NodeContractor)nodeContractor, 0, 0);
        this.contractNode((NodeContractor)nodeContractor, 1, 1);
        this.checkShortcuts(new Shortcut[0]);
        this.contractNode((NodeContractor)nodeContractor, 2, 2);
        this.contractNode((NodeContractor)nodeContractor, 3, 3);
        this.contractNode((NodeContractor)nodeContractor, 4, 4);
        nodeContractor.finishContraction();
        this.checkShortcuts(this.createShortcut(3, 4, e3to2, e2to4, 8.0));
    }

    @Test
    public void testContractNode_twoNormalEdges_noShortcuts() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractAllNodesInOrder();
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_twoNormalEdges_noOutgoingEdges() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 2).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 4, 1, 3);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_twoNormalEdges_noIncomingEdges() {
        this.graph.edge(1, 0).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 1).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 4, 1, 3);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_duplicateOutgoingEdges_differentWeight() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 4, 1, 3);
        this.checkShortcuts(this.createShortcut(1, 3, 2, 6, 1, 3, 2.0));
    }

    @Test
    public void testContractNode_duplicateIncomingEdges_differentWeight() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 4, 1, 3);
        this.checkShortcuts(this.createShortcut(1, 3, 4, 6, 2, 3, 2.0));
    }

    @Test
    public void testContractNode_duplicateOutgoingEdges_sameWeight() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 4, 1, 3);
        this.checkNumShortcuts(1);
    }

    @RepeatedTest(value=10)
    public void testContractNode_duplicateIncomingEdges_sameWeight() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 4, 1, 3);
        this.checkNumShortcuts(1);
    }

    @Test
    public void testContractNode_twoNormalEdges_withTurnCost() {
        this.graph.edge(0, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e3to2 = this.graph.edge(3, 2).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e2to4 = this.graph.edge(2, 4).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.setTurnCost(3, 2, 4, 4.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 1, 3, 4);
        this.checkShortcuts(this.createShortcut(3, 4, e3to2, e2to4, 12.0));
    }

    @Test
    public void testContractNode_twoNormalEdges_withTurnRestriction() {
        this.graph.edge(0, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 2).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 4).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.setRestriction(3, 2, 4);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 1, 3, 4);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_twoNormalEdges_bidirectional() {
        this.graph.edge(0, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e3to2 = this.graph.edge(3, 2).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e2to4 = this.graph.edge(2, 4).setDistance(50.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.setTurnCost(e3to2, e2to4, 2, 4.0);
        this.setTurnCost(e2to4, e3to2, 2, 4.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 1, 3, 4);
        this.checkShortcuts(this.createShortcut(3, 4, 2, 4, 1, 2, 12.0, true, false), this.createShortcut(3, 4, 5, 3, 2, 1, 12.0, false, true));
    }

    @Test
    public void testContractNode_twoNormalEdges_bidirectional_differentCosts() {
        this.graph.edge(0, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e3to2 = this.graph.edge(3, 2).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e2to4 = this.graph.edge(2, 4).setDistance(50.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.setTurnCost(e3to2, e2to4, 2, 4.0);
        this.setTurnCost(e2to4, e3to2, 2, 7.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 1, 3, 4);
        this.checkShortcuts(this.createShortcut(3, 4, e3to2, e2to4, 12.0, true, false), this.createShortcut(3, 4, e2to4.detach(true), e3to2.detach(true), 15.0, false, true));
    }

    @Test
    public void testContractNode_multiple_bidirectional_linear() {
        this.graph.edge(3, 2).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 1).setDistance(30.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 4).setDistance(60.0).set(this.speedEnc, 10.0, 10.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(1, 2, 3, 4);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_shortcutDoesNotSpanUTurn() {
        EdgeIteratorState e7to3 = this.graph.edge(7, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e3to5 = this.graph.edge(3, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e3to4 = this.graph.edge(3, 4).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.setRestriction(7, 3, 5);
        this.contractNodes(3, 4, 2, 6, 7, 5, 1);
        this.checkShortcuts(this.createShortcut(4, 7, e7to3, e3to4, 3.0, false, true), this.createShortcut(4, 5, e3to4.detach(true), e3to5, 3.0, true, false));
    }

    @Test
    public void testContractNode_multiple_loops_directTurnIsBest() {
        GraphWithTwoLoops g = new GraphWithTwoLoops(10, 10, 1, 2, 3, 4);
        g.contractAndCheckShortcuts(this.createShortcut(7, 8, g.e7to6, g.e6to8, 11.0, true, false));
    }

    @Test
    public void testContractNode_multiple_loops_leftLoopIsBest() {
        GraphWithTwoLoops g = new GraphWithTwoLoops(2, 10, 1, 2, 3, 10);
        g.contractAndCheckShortcuts(this.createShortcut(6, 7, g.e7to6.getEdgeKey(), g.e1to6.getEdgeKey(), g.e7to6.getEdge(), g.getScEdge(3), 12.0, false, true), this.createShortcut(7, 8, g.e7to6.getEdgeKey(), g.e6to8.getEdgeKey(), g.getScEdge(4), g.e6to8.getEdge(), 20.0, true, false));
    }

    @Test
    public void testContractNode_multiple_loops_rightLoopIsBest() {
        GraphWithTwoLoops g = new GraphWithTwoLoops(8, 1, 1, 2, 3, 10);
        g.contractAndCheckShortcuts(this.createShortcut(6, 7, g.e7to6.getEdgeKey(), g.e3to6.getEdgeKey(), g.e7to6.getEdge(), g.getScEdge(2), 12.0, false, true), this.createShortcut(7, 8, g.e7to6.getEdgeKey(), g.e6to8.getEdgeKey(), g.getScEdge(4), g.e6to8.getEdge(), 21.0, true, false));
    }

    @Test
    public void testContractNode_multiple_loops_leftRightLoopIsBest() {
        GraphWithTwoLoops g = new GraphWithTwoLoops(3, 10, 1, 10, 3, 10);
        g.contractAndCheckShortcuts(this.createShortcut(6, 7, g.e7to6.getEdgeKey(), g.e1to6.getEdgeKey(), g.e7to6.getEdge(), g.getScEdge(3), 13.0, false, true), this.createShortcut(6, 7, g.e7to6.getEdgeKey(), g.e3to6.getEdgeKey(), g.getScEdge(5), g.getScEdge(2), 24.0, false, true), this.createShortcut(7, 8, g.e7to6.getEdgeKey(), g.e6to8.getEdgeKey(), g.getScEdge(4), g.e6to8.getEdge(), 33.0, true, false));
    }

    @Test
    public void testContractNode_multiple_loops_rightLeftLoopIsBest() {
        GraphWithTwoLoops g = new GraphWithTwoLoops(10, 5, 4, 2, 10, 10);
        g.contractAndCheckShortcuts(this.createShortcut(6, 7, g.e7to6.getEdgeKey(), g.e3to6.getEdgeKey(), g.e7to6.getEdge(), g.getScEdge(2), 16.0, false, true), this.createShortcut(6, 7, g.e7to6.getEdgeKey(), g.e1to6.getEdgeKey(), g.getScEdge(5), g.getScEdge(3), 25.0, false, true), this.createShortcut(7, 8, g.e7to6.getEdgeKey(), g.e6to8.getEdgeKey(), g.getScEdge(4), g.e6to8.getEdge(), 33.0, true, false));
    }

    @Test
    public void testContractNode_detour_detourIsBetter() {
        GraphWithDetour g = new GraphWithDetour(2, 9, 5, 1);
        this.contractNodes(0, 4, 3, 1, 2);
        this.checkShortcuts(this.createShortcut(1, 2, g.e1to0, g.e0to2, 7.0));
    }

    @Test
    public void testContractNode_detour_detourIsWorse() {
        GraphWithDetour g = new GraphWithDetour(4, 1, 1, 7);
        this.contractNodes(0, 4, 3, 1, 2);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_detour_multipleInOut_needsShortcut() {
        GraphWithDetourMultipleInOutEdges g = new GraphWithDetourMultipleInOutEdges(0, 0, 0, 1, 3);
        this.contractNodes(0, 2, 5, 6, 7, 1, 3, 4);
        this.checkShortcuts(this.createShortcut(1, 4, g.e1to0, g.e0to4, 7.0));
    }

    @Test
    public void testContractNode_detour_multipleInOut_noShortcuts() {
        GraphWithDetourMultipleInOutEdges g = new GraphWithDetourMultipleInOutEdges(0, 0, 0, 0, 0);
        this.contractNodes(0, 2, 5, 6, 7, 1, 3, 4);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_detour_multipleInOut_restrictedIn() {
        GraphWithDetourMultipleInOutEdges g = new GraphWithDetourMultipleInOutEdges(0, 10, 0, 10, 0);
        this.contractNodes(0, 2, 5, 6, 7, 1, 3, 4);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_loopAvoidance_loopNecessary() {
        GraphWithLoop g = new GraphWithLoop(7);
        this.contractNodes(0, 1, 3, 4, 5, 2);
        int numEdges = 6;
        this.checkShortcuts(this.createShortcut(1, 2, g.e2to0, g.e0to1, 3.0, false, true), this.createShortcut(2, 2, g.e2to0.getEdgeKey(), g.e1to2.getEdgeKey(), 6, g.e1to2.getEdge(), 4.0, true, false));
    }

    @Test
    public void testContractNode_loopAvoidance_loopAvoidable() {
        GraphWithLoop g = new GraphWithLoop(3);
        this.contractNodes(0, 1, 3, 4, 5, 2);
        this.checkShortcuts(this.createShortcut(1, 2, g.e2to0, g.e0to1, 3.0, false, true));
    }

    @Test
    public void testContractNode_witnessPathsAreFound() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(50.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 9).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(9, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 7).setDistance(60.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(9, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 10).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 10, 4, 1, 5, 7, 9, 3);
        this.checkShortcuts(new Shortcut[0]);
    }

    @RepeatedTest(value=10)
    public void testContractNode_noUnnecessaryShortcut_witnessPathOfEqualWeight() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e2to3 = this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e3to4 = this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState e5to3 = this.graph.edge(5, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(3, 2, 0, 1, 5, 4);
        this.checkShortcuts(this.createShortcut(2, 4, e2to3, e3to4, 2.0), this.createShortcut(5, 4, e5to3, e3to4, 2.0));
    }

    @Test
    public void testContractNode_noUnnecessaryShortcut_differentWitnessesForDifferentOutEdges() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 5).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(3, 0, 6, 1, 2, 5, 4);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testContractNode_noUnnecessaryShortcut_differentInitialEntriesForDifferentInEdges() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(3, 0, 6, 1, 2, 5, 4);
        this.checkShortcuts(new Shortcut[0]);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testContractNode_bidirectional_edge_at_fromNode(boolean edge1to2bidirectional) {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, edge1to2bidirectional ? 10.0 : 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 5).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 1, 5, 4, 3);
        Shortcut expectedShortcuts = this.createShortcut(1, 3, 2, 4, 1, 2, 2.0);
        this.checkShortcuts(expectedShortcuts);
    }

    @Test
    public void testContractNode_bidirectional_edge_at_fromNode_going_to_node() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 5).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(5, 0, 4, 1, 2, 3);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testNodeContraction_directWitness() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 7).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 8).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 9).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(9, 6).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(10, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 11).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 6, 3, 5, 4, 0, 8, 10, 11, 1, 7, 9);
        this.checkShortcuts(this.createShortcut(3, 1, 2, 4, 1, 2, 2.0, false, true), this.createShortcut(1, 9, 2, 16, 1, 8, 2.0, true, false), this.createShortcut(5, 7, 10, 12, 5, 6, 2.0, true, false), this.createShortcut(7, 9, 18, 12, 9, 6, 2.0, false, true), this.createShortcut(4, 1, 2, 6, 12, 3, 3.0, false, true), this.createShortcut(4, 7, 8, 12, 4, 13, 3.0, true, false));
    }

    @Test
    public void testNodeContraction_witnessBetterBecauseOfTurnCostAtTargetNode() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 5).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.setTurnCost(2, 3, 4, 5.0);
        this.setTurnCost(5, 3, 4, 2.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 4, 1, 3, 5);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testNodeContraction_letShortcutsWitnessEachOther_twoIn() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 3).setDistance(40.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(3, 0, 5, 1, 4, 2);
        this.checkShortcuts(this.createShortcut(4, 2, 4, 6, 2, 3, 2.0, false, true));
    }

    @Test
    public void testNodeContraction_letShortcutsWitnessEachOther_twoOut() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 4).setDistance(40.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 5, 1, 4, 3);
        this.checkShortcuts(this.createShortcut(1, 3, 2, 4, 1, 2, 2.0));
    }

    @Test
    public void testNodeContraction_parallelEdges_onlyOneLoopShortcutNeeded() {
        EdgeIteratorState edge0 = this.graph.edge(0, 1).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge1 = this.graph.edge(1, 0).setDistance(40.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(50.0).set(this.speedEnc, 10.0, 10.0);
        this.setTurnCost(edge0, edge1, 0, 1.0);
        this.setTurnCost(edge1, edge0, 0, 2.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(0, 2, 1);
        this.checkShortcuts(this.createShortcut(1, 1, 1, 3, 0, 1, 7.0));
    }

    @Test
    public void testNodeContraction_duplicateEdge_severalLoops() {
        this.graph.edge(1, 3).setDistance(470.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 4).setDistance(190.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e2 = this.graph.edge(2, 5).setDistance(380.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e3 = this.graph.edge(2, 5).setDistance(570.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState e5 = this.graph.edge(4, 5).setDistance(560.0).set(this.speedEnc, 10.0, 10.0);
        this.setTurnCost(e3, e2, 5, 4.0);
        this.setTurnCost(e2, e3, 5, 5.0);
        this.setTurnCost(e5, e3, 5, 3.0);
        this.setTurnCost(e3, e5, 5, 2.0);
        this.setTurnCost(e2, e5, 5, 2.0);
        this.setTurnCost(e5, e2, 5, 1.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(4, 5, 1, 3, 2);
        this.checkNumShortcuts(11);
        this.checkShortcuts(this.createShortcut(5, 3, 11, 9, 5, 4, 66.0, true, false), this.createShortcut(5, 3, 8, 10, 4, 5, 66.0, false, true), this.createShortcut(3, 2, 2, 9, 1, 4, 29.0, false, true), this.createShortcut(3, 2, 8, 3, 4, 1, 29.0, true, false), this.createShortcut(5, 2, 2, 10, 1, 5, 75.0, false, true), this.createShortcut(5, 2, 11, 3, 5, 1, 75.0, true, false), this.createShortcut(2, 2, 6, 5, 3, 2, 99.0, true, false), this.createShortcut(2, 2, 6, 3, 3, 6, 134.0, true, false), this.createShortcut(2, 2, 2, 5, 8, 2, 114.0, true, false), this.createShortcut(3, 2, 4, 9, 2, 7, 106.0, false, true), this.createShortcut(3, 2, 8, 5, 9, 2, 105.0, true, false));
    }

    @Test
    public void testNodeContraction_tripleConnection() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 1).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 1).setDistance(35.0).set(this.speedEnc, 10.0, 10.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(1, 0);
        this.checkShortcuts(this.createShortcut(0, 0, 2, 5, 1, 2, 5.5), this.createShortcut(0, 0, 0, 5, 0, 2, 4.5), this.createShortcut(0, 0, 0, 3, 0, 1, 3.0));
    }

    @Test
    public void testNodeContraction_fromAndToNodesEqual() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 3).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 1, 3);
        this.checkShortcuts(new Shortcut[0]);
    }

    @Test
    public void testNodeContraction_node_in_loop() {
        this.graph.edge(0, 4).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 3).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 1).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.setRestriction(0, 4, 1);
        this.setTurnCost(4, 2, 3, 4.0);
        this.setTurnCost(3, 2, 4, 2.0);
        this.contractNodes(2, 0, 1, 4, 3);
        this.checkShortcuts(this.createShortcut(4, 3, 7, 5, 3, 2, 6.0, true, false), this.createShortcut(4, 3, 4, 6, 2, 3, 4.0, false, true));
    }

    @Test
    public void testFindPath_finiteUTurnCost() {
        this.graph.edge(0, 3).setDistance(1000.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 2).setDistance(5000.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(2000.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 1).setDistance(1000.0).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)this.chConfigs.get(1));
        this.chBuilder = new CHStorageBuilder(this.chStore);
        this.weighting = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)this.chStore, (CHConfig)this.chConfigs.get(1)).getWeighting();
        this.setMaxLevelOnAllNodes();
        this.setRestriction(0, 3, 1);
        this.contractNodes(4, 0, 1, 2, 3);
        this.checkShortcuts(this.createShortcut(2, 3, 2, 4, 1, 2, 600.0, false, true), this.createShortcut(3, 3, 2, 3, 1, 1, 260.0, true, false));
    }

    @Test
    public void testNodeContraction_turnRestrictionAndLoop() {
        this.graph.edge(0, 1).setDistance(50.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 1).setDistance(60.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(20.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 2).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 4).setDistance(30.0).set(this.speedEnc, 10.0, 0.0);
        this.setRestriction(3, 2, 4);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(0, 3, 4, 2, 1);
        this.checkNumShortcuts(1);
    }

    @Test
    public void testNodeContraction_minorWeightDeviation() {
        this.graph.edge(0, 1).setDistance(514.01).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(700.41).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(758.06).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(50.03).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(2, 0, 1, 3, 4);
        this.checkShortcuts(this.createShortcut(1, 3, 2, 4, 1, 2, 145.847));
    }

    @Test
    public void testNodeContraction_numPolledEdges() {
        this.graph.edge(3, 2).setDistance(710.203).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 3).setDistance(790.003).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 0).setDistance(210.328).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 4).setDistance(160.499).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 2).setDistance(160.487).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 1).setDistance(550.603).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 1).setDistance(330.453).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(290.665).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        EdgeBasedNodeContractor nodeContractor = this.createNodeContractor();
        nodeContractor.contractNode(0);
        Assertions.assertTrue((nodeContractor.getNumPolledEdges() > 0L ? 1 : 0) != 0, (String)"no polled edges, something is wrong");
        Assertions.assertTrue((nodeContractor.getNumPolledEdges() <= 8L ? 1 : 0) != 0, (String)("too many edges polled: " + nodeContractor.getNumPolledEdges()));
    }

    @Test
    void issue_2564() {
        this.graph.edge(0, 1).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(73.36).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(101.61).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(0.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 5).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        this.freeze();
        this.chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)this.chConfigs.get(2));
        this.chBuilder = new CHStorageBuilder(this.chStore);
        this.weighting = this.chConfigs.get(2).getWeighting();
        this.setMaxLevelOnAllNodes();
        this.contractNodes(0, 5, 2, 1, 3, 4);
        this.checkShortcuts(this.createShortcut(1, 3, 2, 4, 1, 2, 17.497, true, false), this.createShortcut(1, 3, 5, 3, 2, 1, 17.497, false, true));
    }

    private void contractNode(NodeContractor nodeContractor, int node, int level) {
        this.chBuilder.setLevel(node, level);
        nodeContractor.contractNode(node);
    }

    private void contractAllNodesInOrder() {
        EdgeBasedNodeContractor nodeContractor = this.createNodeContractor();
        for (int node = 0; node < this.graph.getNodes(); ++node) {
            this.chBuilder.setLevel(node, node);
            nodeContractor.contractNode(node);
        }
        nodeContractor.finishContraction();
    }

    private void contractNodes(int ... nodes) {
        EdgeBasedNodeContractor nodeContractor = this.createNodeContractor();
        for (int i = 0; i < nodes.length; ++i) {
            this.chBuilder.setLevel(nodes[i], i);
            nodeContractor.contractNode(nodes[i]);
        }
        nodeContractor.finishContraction();
    }

    private EdgeBasedNodeContractor createNodeContractor() {
        CHPreparationGraph.TurnCostFunction turnCostFunction = CHPreparationGraph.buildTurnCostFunctionFromTurnCostStorage((Graph)this.graph, (Weighting)this.weighting);
        CHPreparationGraph prepareGraph = CHPreparationGraph.edgeBased((int)this.graph.getNodes(), (int)this.graph.getEdges(), (CHPreparationGraph.TurnCostFunction)turnCostFunction);
        CHPreparationGraph.buildFromGraph((CHPreparationGraph)prepareGraph, (Graph)this.graph, (Weighting)this.weighting);
        EdgeBasedNodeContractor nodeContractor = new EdgeBasedNodeContractor(prepareGraph, this.chBuilder, new PMap());
        nodeContractor.initFromGraph();
        return nodeContractor;
    }

    private void setRestriction(EdgeIteratorState inEdge, EdgeIteratorState outEdge, int viaNode) {
        this.setTurnCost(inEdge, outEdge, viaNode, Double.POSITIVE_INFINITY);
    }

    private void setRestriction(int from, int via, int to) {
        this.setTurnCost(this.getEdge(from, via), this.getEdge(via, to), via, Double.POSITIVE_INFINITY);
    }

    private void setTurnCost(int from, int via, int to, double cost) {
        this.setTurnCost(this.getEdge(from, via), this.getEdge(via, to), via, cost);
    }

    private void setTurnCost(EdgeIteratorState inEdge, EdgeIteratorState outEdge, int viaNode, double cost) {
        double cost1 = cost >= 10.0 ? Double.POSITIVE_INFINITY : cost;
        this.graph.getTurnCostStorage().set(this.turnCostEnc, inEdge.getEdge(), viaNode, outEdge.getEdge(), cost1);
    }

    private EdgeIteratorState getEdge(int from, int to) {
        return GHUtility.getEdge((Graph)this.graph, (int)from, (int)to);
    }

    private Shortcut createShortcut(int from, int to, EdgeIteratorState edge1, EdgeIteratorState edge2, double weight) {
        return this.createShortcut(from, to, edge1, edge2, weight, true, false);
    }

    private Shortcut createShortcut(int from, int to, EdgeIteratorState edge1, EdgeIteratorState edge2, double weight, boolean fwd, boolean bwd) {
        return this.createShortcut(from, to, edge1.getEdgeKey(), edge2.getEdgeKey(), edge1.getEdge(), edge2.getEdge(), weight, fwd, bwd);
    }

    private Shortcut createShortcut(int from, int to, int firstOrigEdgeKey, int lastOrigEdgeKey, int skipEdge1, int skipEdge2, double weight) {
        return this.createShortcut(from, to, firstOrigEdgeKey, lastOrigEdgeKey, skipEdge1, skipEdge2, weight, true, false);
    }

    private Shortcut createShortcut(int from, int to, int firstOrigEdgeKey, int lastOrigEdgeKey, int skipEdge1, int skipEdge2, double weight, boolean fwd, boolean bwd) {
        return new Shortcut(from, to, firstOrigEdgeKey, lastOrigEdgeKey, skipEdge1, skipEdge2, weight, fwd, bwd);
    }

    private void checkShortcuts(Shortcut ... expectedShortcuts) {
        Set<Shortcut> expected = this.setOf(expectedShortcuts);
        if (expected.size() != expectedShortcuts.length) {
            Assertions.fail((String)"was given duplicate shortcuts");
        }
        this.checkShortcuts(expected);
    }

    private void checkShortcuts(Set<Shortcut> expected) {
        Assertions.assertEquals(expected, this.getCurrentShortcuts());
    }

    private void checkNumShortcuts(int expected) {
        Assertions.assertEquals((int)expected, (int)this.getCurrentShortcuts().size());
    }

    private Set<Shortcut> getCurrentShortcuts() {
        HashSet<Shortcut> shortcuts = new HashSet<Shortcut>();
        for (int i = 0; i < this.chStore.getShortcuts(); ++i) {
            long ptr = this.chStore.toShortcutPointer(i);
            shortcuts.add(new Shortcut(this.chStore.getNodeA(ptr), this.chStore.getNodeB(ptr), this.chStore.getOrigEdgeKeyFirst(ptr), this.chStore.getOrigEdgeKeyLast(ptr), this.chStore.getSkippedEdge1(ptr), this.chStore.getSkippedEdge2(ptr), this.chStore.getWeight(ptr), this.chStore.getFwdAccess(ptr), this.chStore.getBwdAccess(ptr)));
        }
        return shortcuts;
    }

    private Set<Shortcut> setOf(Shortcut ... shortcuts) {
        return new HashSet<Shortcut>(Arrays.asList(shortcuts));
    }

    private void setMaxLevelOnAllNodes() {
        this.chBuilder.setLevelForAllNodes(this.chStore.getNodes());
    }

    private static class Shortcut {
        int baseNode;
        int adjNode;
        int firstOrigEdgeKey;
        int lastOrigEdgeKey;
        double weight;
        boolean fwd;
        boolean bwd;
        int skipEdge1;
        int skipEdge2;

        public Shortcut(int baseNode, int adjNode, int firstOrigEdgeKey, int lastOrigEdgeKey, int skipEdge1, int skipEdge2, double weight, boolean fwd, boolean bwd) {
            this.baseNode = baseNode;
            this.adjNode = adjNode;
            this.firstOrigEdgeKey = firstOrigEdgeKey;
            this.lastOrigEdgeKey = lastOrigEdgeKey;
            this.weight = weight;
            this.fwd = fwd;
            this.bwd = bwd;
            this.skipEdge1 = skipEdge1;
            this.skipEdge2 = skipEdge2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Shortcut shortcut = (Shortcut)o;
            return this.baseNode == shortcut.baseNode && this.adjNode == shortcut.adjNode && this.firstOrigEdgeKey == shortcut.firstOrigEdgeKey && this.lastOrigEdgeKey == shortcut.lastOrigEdgeKey && Double.compare(shortcut.weight, this.weight) == 0 && this.fwd == shortcut.fwd && this.bwd == shortcut.bwd && this.skipEdge1 == shortcut.skipEdge1 && this.skipEdge2 == shortcut.skipEdge2;
        }

        public int hashCode() {
            return Objects.hash(this.baseNode, this.adjNode, this.firstOrigEdgeKey, this.lastOrigEdgeKey, this.weight, this.fwd, this.bwd, this.skipEdge1, this.skipEdge2);
        }

        public String toString() {
            return "Shortcut{baseNode=" + this.baseNode + ", adjNode=" + this.adjNode + ", firstOrigEdgeKey=" + this.firstOrigEdgeKey + ", lastOrigEdgeKey=" + this.lastOrigEdgeKey + ", weight=" + this.weight + ", fwd=" + this.fwd + ", bwd=" + this.bwd + ", skipEdge1=" + this.skipEdge1 + ", skipEdge2=" + this.skipEdge2 + "}";
        }
    }

    private class GraphWithTwoLoops {
        final int centerNode = 6;
        final EdgeIteratorState e0to1;
        final EdgeIteratorState e1to6;
        final EdgeIteratorState e6to0;
        final EdgeIteratorState e2to3;
        final EdgeIteratorState e3to6;
        final EdgeIteratorState e6to2;
        final EdgeIteratorState e7to6;
        final EdgeIteratorState e6to8;
        final EdgeIteratorState e9to7;
        final EdgeIteratorState e8to10;
        final EdgeIteratorState e4to6;
        final EdgeIteratorState e5to6;
        final int numEdges = 12;

        GraphWithTwoLoops(int turnCost70, int turnCost72, int turnCost12, int turnCost18, int turnCost38, int turnCost78) {
            this.e0to1 = EdgeBasedNodeContractorTest.this.graph.edge(0, 1).setDistance(30.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e1to6 = EdgeBasedNodeContractorTest.this.graph.edge(1, 6).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e6to0 = EdgeBasedNodeContractorTest.this.graph.edge(6, 0).setDistance(40.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e2to3 = EdgeBasedNodeContractorTest.this.graph.edge(2, 3).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e3to6 = EdgeBasedNodeContractorTest.this.graph.edge(3, 6).setDistance(70.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e6to2 = EdgeBasedNodeContractorTest.this.graph.edge(6, 2).setDistance(10.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e7to6 = EdgeBasedNodeContractorTest.this.graph.edge(7, 6).setDistance(10.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e6to8 = EdgeBasedNodeContractorTest.this.graph.edge(6, 8).setDistance(60.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e9to7 = EdgeBasedNodeContractorTest.this.graph.edge(9, 7).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e8to10 = EdgeBasedNodeContractorTest.this.graph.edge(8, 10).setDistance(30.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e4to6 = EdgeBasedNodeContractorTest.this.graph.edge(4, 6).setDistance(10.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e5to6 = EdgeBasedNodeContractorTest.this.graph.edge(5, 6).setDistance(10.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.numEdges = 12;
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e7to6, this.e6to0, 6, (double)turnCost70);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e7to6, this.e6to2, 6, (double)turnCost72);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e7to6, this.e6to8, 6, (double)turnCost78);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e1to6, this.e6to2, 6, (double)turnCost12);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e1to6, this.e6to8, 6, (double)turnCost18);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e3to6, this.e6to8, 6, (double)turnCost38);
            EdgeBasedNodeContractorTest.this.setRestriction(this.e4to6, this.e6to8, 6);
            EdgeBasedNodeContractorTest.this.setRestriction(this.e5to6, this.e6to2, 6);
            EdgeBasedNodeContractorTest.this.setRestriction(this.e4to6, this.e6to0, 6);
            EdgeBasedNodeContractorTest.this.freeze();
            EdgeBasedNodeContractorTest.this.setMaxLevelOnAllNodes();
        }

        private void contractAndCheckShortcuts(Shortcut ... shortcuts) {
            EdgeBasedNodeContractorTest.this.contractNodes(0, 1, 2, 3, 4, 5, 6, 9, 10, 7, 8);
            HashSet<Shortcut> expectedShortcuts = new HashSet<Shortcut>();
            expectedShortcuts.addAll(Arrays.asList(EdgeBasedNodeContractorTest.this.createShortcut(1, 6, this.e6to0, this.e0to1, 7.0, false, true), EdgeBasedNodeContractorTest.this.createShortcut(6, 6, this.e6to0.getEdgeKey(), this.e1to6.getEdgeKey(), this.getScEdge(0), this.e1to6.getEdge(), 9.0, true, false), EdgeBasedNodeContractorTest.this.createShortcut(3, 6, this.e6to2, this.e2to3, 3.0, false, true), EdgeBasedNodeContractorTest.this.createShortcut(6, 6, this.e6to2.getEdgeKey(), this.e3to6.getEdgeKey(), this.getScEdge(1), this.e3to6.getEdge(), 10.0, true, false)));
            expectedShortcuts.addAll(Arrays.asList(shortcuts));
            EdgeBasedNodeContractorTest.this.checkShortcuts(expectedShortcuts);
        }

        private int getScEdge(int shortcutId) {
            return 12 + shortcutId;
        }
    }

    private class GraphWithDetour {
        private final EdgeIteratorState e4to1;
        private final EdgeIteratorState e1to0;
        private final EdgeIteratorState e1to2;
        private final EdgeIteratorState e0to2;
        private final EdgeIteratorState e2to3;

        GraphWithDetour(int turnCost42, int turnCost13, int turnCost40, int turnCost03) {
            this.e4to1 = EdgeBasedNodeContractorTest.this.graph.edge(4, 1).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e1to0 = EdgeBasedNodeContractorTest.this.graph.edge(1, 0).setDistance(40.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e1to2 = EdgeBasedNodeContractorTest.this.graph.edge(1, 2).setDistance(30.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e0to2 = EdgeBasedNodeContractorTest.this.graph.edge(0, 2).setDistance(30.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e2to3 = EdgeBasedNodeContractorTest.this.graph.edge(2, 3).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e4to1, this.e1to2, 1, (double)turnCost42);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e4to1, this.e1to0, 1, (double)turnCost40);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e1to2, this.e2to3, 2, (double)turnCost13);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e0to2, this.e2to3, 2, (double)turnCost03);
            EdgeBasedNodeContractorTest.this.freeze();
            EdgeBasedNodeContractorTest.this.setMaxLevelOnAllNodes();
        }
    }

    private class GraphWithDetourMultipleInOutEdges {
        final EdgeIteratorState e5to1;
        final EdgeIteratorState e2to1;
        final EdgeIteratorState e1to3;
        final EdgeIteratorState e3to4;
        final EdgeIteratorState e1to0;
        final EdgeIteratorState e0to4;
        final EdgeIteratorState e4to6;
        final EdgeIteratorState e4to7;

        GraphWithDetourMultipleInOutEdges(int turnCost20, int turnCost50, int turnCost23, int turnCost53, int turnCost36) {
            this.e5to1 = EdgeBasedNodeContractorTest.this.graph.edge(5, 1).setDistance(30.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e2to1 = EdgeBasedNodeContractorTest.this.graph.edge(2, 1).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e1to3 = EdgeBasedNodeContractorTest.this.graph.edge(1, 3).setDistance(10.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e3to4 = EdgeBasedNodeContractorTest.this.graph.edge(3, 4).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e1to0 = EdgeBasedNodeContractorTest.this.graph.edge(1, 0).setDistance(50.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e0to4 = EdgeBasedNodeContractorTest.this.graph.edge(0, 4).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e4to6 = EdgeBasedNodeContractorTest.this.graph.edge(4, 6).setDistance(10.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e4to7 = EdgeBasedNodeContractorTest.this.graph.edge(4, 7).setDistance(30.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e1to3, this.e3to4, 3, 2.0);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e2to1, this.e1to0, 1, (double)turnCost20);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e2to1, this.e1to3, 1, (double)turnCost23);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e5to1, this.e1to0, 1, (double)turnCost50);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e5to1, this.e1to3, 1, (double)turnCost53);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e3to4, this.e4to6, 4, (double)turnCost36);
            EdgeBasedNodeContractorTest.this.freeze();
            EdgeBasedNodeContractorTest.this.setMaxLevelOnAllNodes();
        }
    }

    private class GraphWithLoop {
        final EdgeIteratorState e0to1;
        final EdgeIteratorState e1to2;
        final EdgeIteratorState e2to0;
        final EdgeIteratorState e3to2;
        final EdgeIteratorState e2to4;
        final EdgeIteratorState e5to2;

        GraphWithLoop(int turnCost34) {
            this.e0to1 = EdgeBasedNodeContractorTest.this.graph.edge(0, 1).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e1to2 = EdgeBasedNodeContractorTest.this.graph.edge(1, 2).setDistance(10.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e2to0 = EdgeBasedNodeContractorTest.this.graph.edge(2, 0).setDistance(10.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e3to2 = EdgeBasedNodeContractorTest.this.graph.edge(3, 2).setDistance(30.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e2to4 = EdgeBasedNodeContractorTest.this.graph.edge(2, 4).setDistance(50.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            this.e5to2 = EdgeBasedNodeContractorTest.this.graph.edge(5, 2).setDistance(20.0).set(EdgeBasedNodeContractorTest.this.speedEnc, 10.0, 0.0);
            EdgeBasedNodeContractorTest.this.setTurnCost(this.e3to2, this.e2to4, 2, (double)turnCost34);
            EdgeBasedNodeContractorTest.this.freeze();
            EdgeBasedNodeContractorTest.this.setMaxLevelOnAllNodes();
        }
    }
}

