/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.EdgeBasedWitnessPathSearcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EdgeBasedWitnessPathSearcherTest {
    @Test
    public void test_shortcut_needed_basic() {
        CHPreparationGraph graph = CHPreparationGraph.edgeBased((int)5, (int)4, (in, via, out) -> in == out ? 10.0 : 0.0);
        int edge = 0;
        graph.addEdge(0, 1, edge++, 10.0, Double.POSITIVE_INFINITY);
        graph.addEdge(1, 2, edge++, 10.0, Double.POSITIVE_INFINITY);
        graph.addEdge(2, 3, edge++, 10.0, Double.POSITIVE_INFINITY);
        graph.addEdge(3, 4, edge++, 10.0, Double.POSITIVE_INFINITY);
        graph.prepareForContraction();
        EdgeBasedWitnessPathSearcher searcher = new EdgeBasedWitnessPathSearcher(graph);
        searcher.initSearch(0, 1, 2, new EdgeBasedWitnessPathSearcher.Stats());
        double weight = searcher.runSearch(3, 6, 20.0, 100);
        Assertions.assertTrue((boolean)Double.isInfinite(weight));
    }

    @Test
    public void test_shortcut_needed_bidirectional() {
        CHPreparationGraph graph = CHPreparationGraph.edgeBased((int)5, (int)4, (in, via, out) -> in == out ? 10.0 : 0.0);
        int edge = 0;
        graph.addEdge(0, 1, edge++, 10.0, 10.0);
        graph.addEdge(1, 2, edge++, 10.0, 10.0);
        graph.addEdge(2, 3, edge++, 10.0, 10.0);
        graph.addEdge(3, 4, edge++, 10.0, 10.0);
        graph.prepareForContraction();
        EdgeBasedWitnessPathSearcher searcher = new EdgeBasedWitnessPathSearcher(graph);
        searcher.initSearch(0, 1, 2, new EdgeBasedWitnessPathSearcher.Stats());
        double weight = searcher.runSearch(3, 6, 20.0, 100);
        Assertions.assertTrue((boolean)Double.isInfinite(weight));
    }

    @Test
    public void test_witness_basic() {
        CHPreparationGraph graph = CHPreparationGraph.edgeBased((int)6, (int)6, (in, via, out) -> in == out ? 10.0 : 0.0);
        int edge = 0;
        graph.addEdge(0, 1, edge++, 10.0, Double.POSITIVE_INFINITY);
        graph.addEdge(1, 2, edge++, 10.0, Double.POSITIVE_INFINITY);
        graph.addEdge(2, 3, edge++, 20.0, Double.POSITIVE_INFINITY);
        graph.addEdge(3, 4, edge++, 10.0, Double.POSITIVE_INFINITY);
        graph.addEdge(1, 5, edge++, 10.0, Double.POSITIVE_INFINITY);
        graph.addEdge(5, 3, edge++, 10.0, Double.POSITIVE_INFINITY);
        graph.prepareForContraction();
        EdgeBasedWitnessPathSearcher searcher = new EdgeBasedWitnessPathSearcher(graph);
        searcher.initSearch(0, 1, 2, new EdgeBasedWitnessPathSearcher.Stats());
        double weight = searcher.runSearch(3, 6, 30.0, 100);
        Assertions.assertEquals((double)20.0, (double)weight, (double)1.0E-6);
    }

    @Test
    public void test_witness_bidirectional() {
        CHPreparationGraph graph = CHPreparationGraph.edgeBased((int)6, (int)6, (in, via, out) -> in == out ? 10.0 : 0.0);
        int edge = 0;
        graph.addEdge(0, 1, edge++, 10.0, 10.0);
        graph.addEdge(1, 2, edge++, 10.0, 10.0);
        graph.addEdge(2, 3, edge++, 20.0, 20.0);
        graph.addEdge(3, 4, edge++, 10.0, 10.0);
        graph.addEdge(1, 5, edge++, 10.0, 10.0);
        graph.addEdge(5, 3, edge++, 10.0, 10.0);
        graph.prepareForContraction();
        EdgeBasedWitnessPathSearcher searcher = new EdgeBasedWitnessPathSearcher(graph);
        searcher.initSearch(0, 1, 2, new EdgeBasedWitnessPathSearcher.Stats());
        double weight = searcher.runSearch(3, 6, 30.0, 100);
        Assertions.assertEquals((double)20.0, (double)weight, (double)1.0E-6);
    }
}

