/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionCH;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.NodeBasedNodeContractor;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.CHStorageBuilder;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class NodeBasedNodeContractorTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
    private final EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).build();
    private final Weighting weighting = new SpeedWeighting(this.speedEnc);
    private final BaseGraph graph = new BaseGraph.Builder(this.encodingManager).create();
    private final CHConfig chConfig = CHConfig.nodeBased((String)"profile", (Weighting)this.weighting);
    private CHStorage store;

    private NodeContractor createNodeContractor() {
        return NodeBasedNodeContractorTest.createNodeContractor(this.graph, this.store, this.chConfig);
    }

    private static NodeContractor createNodeContractor(BaseGraph g, CHStorage store, CHConfig chConfig) {
        CHPreparationGraph prepareGraph = CHPreparationGraph.nodeBased((int)g.getNodes(), (int)g.getEdges());
        CHPreparationGraph.buildFromGraph((CHPreparationGraph)prepareGraph, (Graph)g, (Weighting)RoutingCHGraphImpl.fromGraph((BaseGraph)g, (CHStorage)store, (CHConfig)chConfig).getWeighting());
        NodeBasedNodeContractor nodeContractor = new NodeBasedNodeContractor(prepareGraph, new CHStorageBuilder(store), new PMap());
        nodeContractor.initFromGraph();
        return nodeContractor;
    }

    private void freeze() {
        this.graph.freeze();
        this.store = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)this.chConfig);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDirectedGraph(boolean reverse) {
        this.graph.edge(0, 2).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(10, 2).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(11, 2).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge2to1bidirected = this.graph.edge(2, 1).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge2to1directed = this.graph.edge(2, 1).setDistance(10000.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge1to3 = this.graph.edge(1, 3).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 5).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 6).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 7).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        if (reverse) {
            this.contractInOrder(1, 0, 11, 10, 4, 5, 6, 7, 3, 2);
            this.checkShortcuts(this.expectedShortcut(3, 2, edge1to3, edge2to1bidirected, true, true));
        } else {
            this.contractInOrder(1, 0, 11, 10, 4, 5, 6, 7, 2, 3);
            this.checkShortcuts(this.expectedShortcut(2, 3, edge2to1bidirected, edge1to3, true, true));
        }
    }

    @Test
    public void testFindShortcuts_Roundabout() {
        EdgeIteratorState iter1to3 = this.graph.edge(1, 3).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState iter3to4 = this.graph.edge(3, 4).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState iter4to5 = this.graph.edge(4, 5).setDistance(100.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState iter5to6 = this.graph.edge(5, 6).setDistance(100.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState iter6to8 = this.graph.edge(6, 8).setDistance(200.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState iter8to4 = this.graph.edge(8, 4).setDistance(100.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 7).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.freeze();
        this.contractInOrder(3, 5, 7, 8, 4, 1, 6);
        RoutingCHGraph lg = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)this.store, (CHConfig)this.chConfig);
        this.checkShortcuts(this.expectedShortcut(4, 1, iter3to4, iter1to3, true, true), this.expectedShortcut(4, 6, iter8to4, iter6to8, false, true), this.expectedShortcut(4, 6, iter4to5, iter5to6, true, false), this.expectedShortcut(1, 6, lg.getEdgeIteratorState(8, 4), lg.getEdgeIteratorState(7, 6), true, false), this.expectedShortcut(1, 6, lg.getEdgeIteratorState(8, 1), lg.getEdgeIteratorState(9, 4), false, true));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testShortcutMergeBug(boolean reverse) {
        EdgeIteratorState edge1to2bidirected = this.graph.edge(1, 2).setDistance(200.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge1to2directed = this.graph.edge(1, 2).setDistance(100.0).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge2to3 = this.graph.edge(2, 3).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        if (reverse) {
            this.contractInOrder(2, 1, 3);
            this.checkShortcuts(this.expectedShortcut(1, 3, edge1to2directed, edge2to3, true, false), this.expectedShortcut(1, 3, edge1to2bidirected, edge2to3, false, true));
        } else {
            this.contractInOrder(2, 3, 1);
            this.checkShortcuts(this.expectedShortcut(3, 1, edge2to3, edge1to2bidirected, true, false), this.expectedShortcut(3, 1, edge2to3, edge1to2directed, false, true));
        }
    }

    @Test
    public void testContractNode_directed_shortcutRequired() {
        EdgeIteratorState edge1 = this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        EdgeIteratorState edge2 = this.graph.edge(1, 2).setDistance(2.0).set(this.speedEnc, 60.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractInOrder(1, 0, 2);
        this.checkShortcuts(this.expectedShortcut(0, 2, edge1, edge2, true, false));
    }

    @Test
    public void testContractNode_directed_shortcutRequired_reverse() {
        EdgeIteratorState edge1 = this.graph.edge(2, 1).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        EdgeIteratorState edge2 = this.graph.edge(1, 0).setDistance(2.0).set(this.speedEnc, 60.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.contractInOrder(1, 2, 0);
        this.checkShortcuts(this.expectedShortcut(2, 0, edge1, edge2, true, false));
    }

    @Test
    public void testContractNode_bidirected_shortcutsRequired() {
        EdgeIteratorState edge1 = this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        EdgeIteratorState edge2 = this.graph.edge(1, 2).setDistance(2.0).set(this.speedEnc, 60.0, 60.0);
        this.freeze();
        this.contractInOrder(1, 2, 0);
        this.checkShortcuts(this.expectedShortcut(2, 0, edge2, edge1, true, true));
    }

    @Test
    public void testContractNode_directed_withWitness() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.graph.edge(1, 2).setDistance(2.0).set(this.speedEnc, 60.0, 0.0);
        this.graph.edge(0, 2).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        this.createNodeContractor().contractNode(1);
        this.checkNoShortcuts();
    }

    @Test
    public void testNodeContraction_shortcutDistanceRounding() {
        double[] distances = new double[]{4.019, 1.006, 1.004, 1.006, 1.004};
        this.graph.edge(0, 4).setDistance(distances[0]).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge1 = this.graph.edge(0, 1).setDistance(distances[1]).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge2 = this.graph.edge(1, 2).setDistance(distances[2]).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge3 = this.graph.edge(2, 3).setDistance(distances[3]).set(this.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge4 = this.graph.edge(3, 4).setDistance(distances[4]).set(this.speedEnc, 10.0, 0.0);
        this.freeze();
        this.setMaxLevelOnAllNodes();
        AllEdgesIterator iter = this.graph.getAllEdges();
        double[] storedDistances = new double[iter.length()];
        int count = 0;
        while (iter.next()) {
            storedDistances[count++] = iter.getDistance();
        }
        Assertions.assertArrayEquals((double[])distances, (double[])storedDistances, (double)1.0E-6);
        this.contractInOrder(1, 3, 2, 0, 4);
        int from = 0;
        int to = 4;
        Dijkstra dikstra = new Dijkstra((Graph)this.graph, this.weighting, TraversalMode.NODE_BASED);
        Path dijkstraPath = dikstra.calcPath(from, to);
        RoutingCHGraph lg = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)this.store, (CHConfig)this.chConfig);
        DijkstraBidirectionCH ch = new DijkstraBidirectionCH(lg);
        Path chPath = ch.calcPath(from, to);
        Assertions.assertEquals((Object)dijkstraPath.calcNodes(), (Object)chPath.calcNodes());
        Assertions.assertEquals((double)dijkstraPath.getDistance(), (double)chPath.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)dijkstraPath.getWeight(), (double)chPath.getWeight(), (double)1.0E-6);
        this.checkShortcuts(this.expectedShortcut(2, 0, edge2, edge1, false, true), this.expectedShortcut(2, 4, edge3, edge4, true, false));
    }

    @Test
    public void testNodeContraction_shortcutWeightRounding() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(encodingManager).create();
        double fac = 16.666666666666668;
        double[] distances = new double[]{fac * 4.019, fac * 1.006, fac * 1.004, fac * 1.006, fac * 1.004};
        graph.edge(0, 4).setDistance(distances[0]).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        graph.edge(0, 1).setDistance(distances[1]).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        graph.edge(1, 2).setDistance(distances[2]).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        graph.edge(2, 3).setDistance(distances[3]).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        graph.edge(3, 4).setDistance(distances[4]).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)"p1", (Weighting)weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        NodeBasedNodeContractorTest.setMaxLevelOnAllNodes(chStore);
        NodeBasedNodeContractorTest.contractInOrder(graph, chStore, chConfig, 1, 3, 2, 0, 4);
        int from = 0;
        int to = 4;
        Dijkstra dikstra = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED);
        Path dijkstraPath = dikstra.calcPath(from, to);
        DijkstraBidirectionCH ch = new DijkstraBidirectionCH(RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)chStore, (CHConfig)chConfig));
        Path chPath = ch.calcPath(from, to);
        Assertions.assertEquals((Object)dijkstraPath.calcNodes(), (Object)chPath.calcNodes());
        Assertions.assertEquals((double)dijkstraPath.getDistance(), (double)chPath.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((double)dijkstraPath.getWeight(), (double)chPath.getWeight(), (double)1.0E-6);
    }

    private void contractInOrder(int ... nodeIds) {
        NodeBasedNodeContractorTest.contractInOrder(this.graph, this.store, this.chConfig, nodeIds);
    }

    private static void contractInOrder(BaseGraph g, CHStorage store, CHConfig chConfig, int ... nodeIds) {
        NodeBasedNodeContractorTest.setMaxLevelOnAllNodes(store);
        CHStorageBuilder b = new CHStorageBuilder(store);
        NodeContractor nodeContractor = NodeBasedNodeContractorTest.createNodeContractor(g, store, chConfig);
        int level = 0;
        for (int n : nodeIds) {
            b.setLevel(n, level);
            nodeContractor.contractNode(n);
            ++level;
        }
        nodeContractor.finishContraction();
    }

    private void checkShortcuts(Shortcut ... expectedShortcuts) {
        this.checkShortcuts(this.store, expectedShortcuts);
    }

    private void checkShortcuts(CHStorage store, Shortcut ... expectedShortcuts) {
        Set<Shortcut> expected = this.setOf(expectedShortcuts);
        if (expected.size() != expectedShortcuts.length) {
            Assertions.fail((String)"was given duplicate shortcuts");
        }
        HashSet<Shortcut> given = new HashSet<Shortcut>();
        for (int i = 0; i < store.getShortcuts(); ++i) {
            long ptr = store.toShortcutPointer(i);
            given.add(new Shortcut(store.getNodeA(ptr), store.getNodeB(ptr), store.getWeight(ptr), store.getFwdAccess(ptr), store.getBwdAccess(ptr), store.getSkippedEdge1(ptr), store.getSkippedEdge2(ptr)));
        }
        Assertions.assertEquals(expected, given);
    }

    private void checkNoShortcuts() {
        this.checkShortcuts(this.store, new Shortcut[0]);
    }

    private void checkNoShortcuts(CHStorage store) {
        this.checkShortcuts(store, new Shortcut[0]);
    }

    private Shortcut expectedShortcut(int baseNode, int adjNode, RoutingCHEdgeIteratorState edge1, RoutingCHEdgeIteratorState edge2, boolean fwd, boolean bwd) {
        double weight1 = edge1.getWeight(false);
        double weight2 = edge2.getWeight(false);
        return new Shortcut(baseNode, adjNode, weight1 + weight2, fwd, bwd, edge1.getEdge(), edge2.getEdge());
    }

    private Shortcut expectedShortcut(int baseNode, int adjNode, EdgeIteratorState edge1, EdgeIteratorState edge2, boolean fwd, boolean bwd) {
        double weight1 = this.getWeight(edge1);
        double weight2 = this.getWeight(edge2);
        return new Shortcut(baseNode, adjNode, weight1 + weight2, fwd, bwd, edge1.getEdge(), edge2.getEdge());
    }

    private double getWeight(EdgeIteratorState edge) {
        return this.weighting.calcEdgeWeight(edge, false);
    }

    private Set<Shortcut> setOf(Shortcut ... shortcuts) {
        return new HashSet<Shortcut>(Arrays.asList(shortcuts));
    }

    private void setMaxLevelOnAllNodes() {
        NodeBasedNodeContractorTest.setMaxLevelOnAllNodes(this.store);
    }

    private static void setMaxLevelOnAllNodes(CHStorage store) {
        new CHStorageBuilder(store).setLevelForAllNodes(store.getNodes());
    }

    private static class Shortcut {
        int baseNode;
        int adjNode;
        double weight;
        boolean fwd;
        boolean bwd;
        int skipEdge1;
        int skipEdge2;

        Shortcut(int baseNode, int adjNode, double weight, boolean fwd, boolean bwd, int skipEdge1, int skipEdge2) {
            this.baseNode = baseNode;
            this.adjNode = adjNode;
            this.weight = weight;
            this.fwd = fwd;
            this.bwd = bwd;
            this.skipEdge1 = skipEdge1;
            this.skipEdge2 = skipEdge2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Shortcut shortcut = (Shortcut)obj;
            return this.baseNode == shortcut.baseNode && this.adjNode == shortcut.adjNode && Double.compare(shortcut.weight, this.weight) == 0 && this.fwd == shortcut.fwd && this.bwd == shortcut.bwd && this.skipEdge1 == shortcut.skipEdge1 && this.skipEdge2 == shortcut.skipEdge2;
        }

        public int hashCode() {
            return Objects.hash(this.baseNode, this.adjNode, this.weight, this.fwd, this.bwd, this.skipEdge1, this.skipEdge2);
        }

        public String toString() {
            return "Shortcut{baseNode=" + this.baseNode + ", adjNode=" + this.adjNode + ", weight=" + this.weight + ", fwd=" + this.fwd + ", bwd=" + this.bwd + ", skipEdge1=" + this.skipEdge1 + ", skipEdge2=" + this.skipEdge2 + "}";
        }
    }
}

