/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.NodeBasedWitnessPathSearcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NodeBasedWitnessPathSearcherTest {
    NodeBasedWitnessPathSearcherTest() {
    }

    @Test
    void ignoreNode() {
        CHPreparationGraph p = CHPreparationGraph.nodeBased((int)5, (int)10);
        p.addEdge(0, 1, 0, 10.0, 10.0);
        p.addEdge(1, 2, 1, 10.0, 10.0);
        p.addEdge(0, 3, 2, 9.0, 9.0);
        p.addEdge(3, 2, 3, 9.0, 9.0);
        p.prepareForContraction();
        NodeBasedWitnessPathSearcher algo = new NodeBasedWitnessPathSearcher(p);
        algo.init(0, 1);
        Assertions.assertEquals((double)18.0, (double)algo.findUpperBound(2, 100.0, Integer.MAX_VALUE));
        algo.init(0, 3);
        Assertions.assertEquals((double)20.0, (double)algo.findUpperBound(2, 100.0, Integer.MAX_VALUE));
        Assertions.assertEquals((int)2, (int)algo.getSettledNodes());
    }

    @Test
    void acceptedWeight() {
        CHPreparationGraph p = CHPreparationGraph.nodeBased((int)10, (int)10);
        p.addEdge(0, 5, 0, 10.0, 10.0);
        for (int i = 0; i < 5; ++i) {
            p.addEdge(i, i + 1, i + 1, 1.0, 1.0);
        }
        p.prepareForContraction();
        NodeBasedWitnessPathSearcher algo = new NodeBasedWitnessPathSearcher(p);
        algo.init(0, -1);
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 100.0, Integer.MAX_VALUE));
        Assertions.assertEquals((int)1, (int)algo.getSettledNodes());
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 100.0, Integer.MAX_VALUE));
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 100.0, Integer.MAX_VALUE));
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 100.0, Integer.MAX_VALUE));
        Assertions.assertEquals((int)1, (int)algo.getSettledNodes());
        algo.init(0, -1);
        Assertions.assertEquals((double)5.0, (double)algo.findUpperBound(5, 8.0, Integer.MAX_VALUE));
        algo.init(0, -1);
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 1.0, Integer.MAX_VALUE));
        Assertions.assertEquals((int)2, (int)algo.getSettledNodes());
    }

    @Test
    void settledNodes() {
        CHPreparationGraph p = CHPreparationGraph.nodeBased((int)10, (int)10);
        p.addEdge(0, 5, 0, 10.0, 10.0);
        for (int i = 0; i < 5; ++i) {
            p.addEdge(i, i + 1, i + 1, 1.0, 1.0);
        }
        p.prepareForContraction();
        NodeBasedWitnessPathSearcher algo = new NodeBasedWitnessPathSearcher(p);
        algo.init(0, -1);
        Assertions.assertEquals((double)5.0, (double)algo.findUpperBound(5, 5.0, Integer.MAX_VALUE));
        Assertions.assertEquals((int)5, (int)algo.getSettledNodes());
        algo.init(0, -1);
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 5.0, 2));
        Assertions.assertEquals((int)2, (int)algo.getSettledNodes());
        algo.init(0, -1);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)algo.findUpperBound(5, 5.0, 0));
        Assertions.assertEquals((int)0, (int)algo.getSettledNodes());
        algo.init(0, -1);
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 5.0, 2));
        Assertions.assertEquals((int)2, (int)algo.getSettledNodes());
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 5.0, 2));
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 5.0, 2));
        Assertions.assertEquals((double)10.0, (double)algo.findUpperBound(5, 5.0, 2));
        Assertions.assertEquals((int)2, (int)algo.getSettledNodes());
    }
}

