/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIterator;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEuclidean;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PrepareContractionHierarchiesTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
    private final EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).build();
    private final Weighting weighting = new SpeedWeighting(this.speedEnc);
    private final CHConfig chConfig = CHConfig.nodeBased((String)"c", (Weighting)this.weighting);
    private BaseGraph g;

    private static void initDirected2(Graph g, DecimalEncodedValue speedEnc) {
        g.edge(0, 1).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(1, 2).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(2, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(3, 4).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(4, 5).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(5, 6).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(6, 7).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(7, 8).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(8, 9).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(9, 10).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(10, 11).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(11, 12).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(11, 9).setDistance(3.0).set(speedEnc, 60.0, 0.0);
        g.edge(12, 13).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(13, 14).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(14, 15).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(15, 16).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(16, 17).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(17, 0).setDistance(1.0).set(speedEnc, 60.0, 60.0);
    }

    private static void initShortcutsGraph(Graph g, DecimalEncodedValue speedEnc) {
        g.edge(0, 1).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(0, 2).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(1, 2).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(2, 3).setDistance(1.5).set(speedEnc, 60.0, 60.0);
        g.edge(1, 4).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(2, 9).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(9, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(10, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(4, 5).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(5, 6).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(6, 7).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(7, 8).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(8, 9).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(4, 11).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(9, 14).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(10, 14).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(11, 12).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(12, 15).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(12, 13).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(13, 16).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(15, 16).setDistance(2.0).set(speedEnc, 60.0, 60.0);
        g.edge(14, 16).setDistance(1.0).set(speedEnc, 60.0, 60.0);
    }

    private static void initExampleGraph(Graph g, DecimalEncodedValue speedEnc) {
        g.edge(0, 1).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(0, 2).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(0, 4).setDistance(3.0).set(speedEnc, 60.0, 60.0);
        g.edge(1, 2).setDistance(3.0).set(speedEnc, 60.0, 60.0);
        g.edge(2, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(4, 3).setDistance(2.0).set(speedEnc, 60.0, 60.0);
        g.edge(5, 1).setDistance(2.0).set(speedEnc, 60.0, 60.0);
    }

    @BeforeEach
    public void setUp() {
        this.g = this.createGraph();
    }

    private BaseGraph createGraph() {
        return new BaseGraph.Builder(this.encodingManager).create();
    }

    @Test
    public void testReturnsCorrectWeighting() {
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(this.g);
        prepare.doWork();
        Assertions.assertSame((Object)this.weighting, (Object)prepare.getCHConfig().getWeighting());
    }

    @Test
    public void testAddShortcuts() {
        PrepareContractionHierarchiesTest.initExampleGraph((Graph)this.g, this.speedEnc);
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(this.g);
        this.useNodeOrdering(prepare, new int[]{5, 3, 4, 0, 1, 2});
        PrepareContractionHierarchies.Result res = prepare.doWork();
        Assertions.assertEquals((long)2L, (long)res.getShortcuts());
    }

    @Test
    public void testMoreComplexGraph() {
        PrepareContractionHierarchiesTest.initShortcutsGraph((Graph)this.g, this.speedEnc);
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(this.g);
        this.useNodeOrdering(prepare, new int[]{0, 5, 6, 7, 8, 10, 11, 13, 15, 1, 3, 9, 14, 16, 12, 4, 2});
        PrepareContractionHierarchies.Result res = prepare.doWork();
        Assertions.assertEquals((long)7L, (long)res.getShortcuts());
    }

    @Test
    public void testDirectedGraph() {
        this.g.edge(5, 4).setDistance(3.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(4, 5).setDistance(10.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(2, 4).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(5, 2).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(3, 5).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(4, 3).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.freeze();
        Assertions.assertEquals((int)6, (int)this.g.getEdges());
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(this.g);
        PrepareContractionHierarchies.Result result = prepare.doWork();
        Assertions.assertEquals((long)2L, (long)result.getShortcuts());
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.g, (CHStorage)result.getCHStorage(), (CHConfig)result.getCHConfig());
        Assertions.assertEquals((int)8, (int)routingCHGraph.getEdges());
        EdgeToEdgeRoutingAlgorithm algo = new CHRoutingAlgorithmFactory(routingCHGraph).createAlgo(new PMap());
        Path p = algo.calcPath(4, 2);
        Assertions.assertEquals((double)3.0, (double)p.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 3, 5, 2}), (Object)p.calcNodes());
    }

    @Test
    public void testDirectedGraph2() {
        PrepareContractionHierarchiesTest.initDirected2((Graph)this.g, this.speedEnc);
        int oldCount = this.g.getEdges();
        Assertions.assertEquals((int)19, (int)oldCount);
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(this.g);
        this.useNodeOrdering(prepare, new int[]{10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 11, 12, 13, 14, 15, 16});
        PrepareContractionHierarchies.Result result = prepare.doWork();
        Assertions.assertEquals((int)oldCount, (int)this.g.getEdges());
        Assertions.assertEquals((int)oldCount, (int)GHUtility.count((EdgeIterator)this.g.getAllEdges()));
        long numShortcuts = 9L;
        Assertions.assertEquals((long)numShortcuts, (long)result.getShortcuts());
        Assertions.assertEquals((int)oldCount, (int)this.g.getEdges());
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.g, (CHStorage)result.getCHStorage(), (CHConfig)result.getCHConfig());
        Assertions.assertEquals((long)((long)oldCount + numShortcuts), (long)routingCHGraph.getEdges());
        EdgeToEdgeRoutingAlgorithm algo = new CHRoutingAlgorithmFactory(routingCHGraph).createAlgo(new PMap());
        Path p = algo.calcPath(0, 10);
        Assertions.assertEquals((double)10.0, (double)p.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}), (Object)p.calcNodes());
    }

    private static void initRoundaboutGraph(Graph g, DecimalEncodedValue speedEnc) {
        g.edge(16, 0).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(0, 9).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(0, 17).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(9, 10).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(10, 11).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(11, 28).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(28, 29).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(29, 30).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(30, 31).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(31, 4).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(17, 1).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(15, 1).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(14, 1).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(14, 18).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(18, 19).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(19, 20).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(20, 15).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(19, 21).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(21, 16).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(1, 2).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(2, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(3, 4).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(4, 5).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(5, 6).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(6, 7).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(7, 13).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(13, 12).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(12, 4).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(7, 8).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(8, 22).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(22, 23).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(23, 24).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(24, 25).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(25, 27).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(27, 5).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(25, 26).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(26, 25).setDistance(1.0).set(speedEnc, 60.0, 0.0);
    }

    @Test
    public void testRoundaboutUnpacking() {
        PrepareContractionHierarchiesTest.initRoundaboutGraph((Graph)this.g, this.speedEnc);
        int oldCount = this.g.getEdges();
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(this.g);
        this.useNodeOrdering(prepare, new int[]{26, 6, 12, 13, 2, 3, 8, 9, 10, 11, 14, 15, 16, 17, 18, 20, 21, 23, 24, 25, 19, 22, 27, 5, 29, 30, 31, 28, 7, 1, 0, 4});
        PrepareContractionHierarchies.Result res = prepare.doWork();
        Assertions.assertEquals((int)oldCount, (int)this.g.getEdges());
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.g, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
        Assertions.assertEquals((int)oldCount, (int)routingCHGraph.getBaseGraph().getEdges());
        Assertions.assertEquals((int)(oldCount + 23), (int)routingCHGraph.getEdges());
        EdgeToEdgeRoutingAlgorithm algo = new CHRoutingAlgorithmFactory(routingCHGraph).createAlgo(new PMap());
        Path p = algo.calcPath(4, 7);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 5, 6, 7}), (Object)p.calcNodes());
    }

    @Test
    public void testDisconnects() {
        this.g.edge(8, 3).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(3, 6).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(6, 1).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(1, 5).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(4, 0).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(0, 6).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(6, 2).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(2, 7).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.freeze();
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(this.g).useFixedNodeOrdering(NodeOrderingProvider.identity((int)this.g.getNodes()));
        PrepareContractionHierarchies.Result res = prepare.doWork();
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.g, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
        RoutingCHEdgeExplorer outExplorer = routingCHGraph.createOutEdgeExplorer();
        RoutingCHEdgeExplorer inExplorer = routingCHGraph.createInEdgeExplorer();
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 2, 1}), (Object)this.getAdjs(outExplorer.setBaseNode(6)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{8, 0, 3}), (Object)this.getAdjs(inExplorer.setBaseNode(6)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{6, 0}), (Object)this.getAdjs(outExplorer.setBaseNode(4)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{6, 1}), (Object)this.getAdjs(inExplorer.setBaseNode(5)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{8, 2}), (Object)this.getAdjs(inExplorer.setBaseNode(7)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3}), (Object)this.getAdjs(outExplorer.setBaseNode(8)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)this.getAdjs(inExplorer.setBaseNode(8)));
    }

    private IntArrayList getAdjs(RoutingCHEdgeIterator iter) {
        IntArrayList result = new IntArrayList();
        while (iter.next()) {
            result.add(iter.getAdjNode());
        }
        return result;
    }

    @Test
    public void testStallOnDemandViaVirtuaNode_issue1574() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph g = new BaseGraph.Builder(encodingManager).create();
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)"c", (Weighting)weighting);
        g.edge(0, 3).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        EdgeIteratorState edge31 = g.edge(3, 1).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        g.edge(1, 2).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        EdgeIteratorState edge24 = g.edge(2, 4).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        g.edge(4, 5).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        g.edge(5, 6).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        g.edge(6, 7).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        GHUtility.updateDistancesFor((Graph)g, (int)0, (double[])new double[]{0.001, 0.0});
        GHUtility.updateDistancesFor((Graph)g, (int)3, (double[])new double[]{0.001, 1.0E-4});
        GHUtility.updateDistancesFor((Graph)g, (int)1, (double[])new double[]{0.001, 2.0E-4});
        GHUtility.updateDistancesFor((Graph)g, (int)2, (double[])new double[]{0.001, 3.0E-4});
        GHUtility.updateDistancesFor((Graph)g, (int)4, (double[])new double[]{0.0, 3.0E-4});
        GHUtility.updateDistancesFor((Graph)g, (int)5, (double[])new double[]{0.0, 4.0E-4});
        GHUtility.updateDistancesFor((Graph)g, (int)6, (double[])new double[]{0.0, 5.0E-4});
        GHUtility.updateDistancesFor((Graph)g, (int)7, (double[])new double[]{0.0, 6.0E-4});
        edge31.set((DecimalEncodedValue)speedEnc, 12.0, 12.0);
        edge24.set((DecimalEncodedValue)speedEnc, 27.5, 27.5);
        PrepareContractionHierarchies pch = this.createPrepareContractionHierarchies(g, chConfig);
        PrepareContractionHierarchies.Result res = pch.useFixedNodeOrdering(NodeOrderingProvider.identity((int)g.getNodes())).doWork();
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)g, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
        Assertions.assertEquals((int)2, (int)(routingCHGraph.getEdges() - g.getEdges()), (String)"there should be exactly two (bidirectional) shortcuts (2-3) and (3-4)");
        Snap snap = new Snap(0.001, 1.5E-4);
        snap.setClosestEdge(edge31);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.setClosestNode(8);
        snap.setWayIndex(0);
        snap.calcSnappedPoint((DistanceCalc)new DistanceCalcEuclidean());
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)g, (Snap)snap);
        double weight03 = this.getWeight((Graph)queryGraph, (Weighting)weighting, 0, 3);
        double scWeight23 = weight03 + this.getEdge(routingCHGraph, 2, 3, true).getWeight(false);
        double scWeight34 = weight03 + this.getEdge(routingCHGraph, 3, 4, false).getWeight(false);
        double sptWeight2 = weight03 + this.getWeight((Graph)queryGraph, (Weighting)weighting, 3, 8) + this.getWeight((Graph)queryGraph, (Weighting)weighting, 8, 1) + this.getWeight((Graph)queryGraph, (Weighting)weighting, 1, 2);
        double sptWeight4 = sptWeight2 + this.getWeight((Graph)queryGraph, (Weighting)weighting, 2, 4);
        Assertions.assertTrue((scWeight23 < sptWeight2 ? 1 : 0) != 0, (String)"incoming shortcut weight 3->2 should be smaller than sptWeight at node 2 to make sure 2 gets stalled");
        Assertions.assertTrue((sptWeight4 < scWeight34 ? 1 : 0) != 0, (String)"sptWeight at node 4 should be smaller than shortcut weight 3->4 to make sure node 4 gets stalled");
        Path path = new CHRoutingAlgorithmFactory(routingCHGraph, queryGraph).createAlgo(new PMap()).calcPath(0, 7);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 3, 8, 1, 2, 4, 5, 6, 7}), (Object)path.calcNodes(), (String)"wrong or no path found");
    }

    private double getWeight(Graph graph, Weighting w, int from, int to) {
        return w.calcEdgeWeight(this.getEdge(graph, from, to), false);
    }

    private EdgeIteratorState getEdge(Graph graph, int from, int to) {
        EdgeIterator iter = graph.createEdgeExplorer().setBaseNode(from);
        while (iter.next()) {
            if (iter.getAdjNode() != to) continue;
            return iter;
        }
        throw new IllegalArgumentException("Could not find edge from: " + from + " to: " + to);
    }

    private RoutingCHEdgeIteratorState getEdge(RoutingCHGraph graph, int from, int to, boolean incoming) {
        RoutingCHEdgeIterator iter;
        RoutingCHEdgeIterator routingCHEdgeIterator = iter = incoming ? graph.createInEdgeExplorer().setBaseNode(from) : graph.createOutEdgeExplorer().setBaseNode(from);
        while (iter.next()) {
            if (iter.getAdjNode() != to) continue;
            return iter;
        }
        throw new IllegalArgumentException("Could not find edge from: " + from + " to: " + to);
    }

    @Test
    public void testCircleBug() {
        this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(0, 1).setDistance(4.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(0, 2).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(0, 3).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(this.g);
        PrepareContractionHierarchies.Result result = prepare.doWork();
        Assertions.assertEquals((long)0L, (long)result.getShortcuts());
    }

    @Test
    public void testBug178() {
        this.g.edge(1, 2).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(2, 1).setDistance(1.0).set(this.speedEnc, 60.0, 0.0);
        this.g.edge(5, 0).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(5, 6).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(0, 1).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(2, 3).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(3, 4).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(6, 3).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(this.g);
        this.useNodeOrdering(prepare, new int[]{4, 1, 2, 0, 5, 6, 3});
        PrepareContractionHierarchies.Result result = prepare.doWork();
        Assertions.assertEquals((long)2L, (long)result.getShortcuts());
    }

    @Test
    public void testBits() {
        int fromNode = 0x55555554;
        int endNode = 986681666;
        long edgeId = (long)fromNode << 32 | (long)endNode;
        Assertions.assertEquals((Object)BitUtil.LITTLE.toBitString(edgeId), (Object)(BitUtil.LITTLE.toLastBitString((long)fromNode, 32) + BitUtil.LITTLE.toLastBitString((long)endNode, 32)));
    }

    @Test
    public void testMultiplePreparationsIdenticalView() {
        DecimalEncodedValueImpl carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, true);
        DecimalEncodedValueImpl bikeSpeedEnc = new DecimalEncodedValueImpl("bike_speed", 4, 2.0, true);
        EncodingManager tmpEncodingManager = EncodingManager.start().add((EncodedValue)carSpeedEnc).add((EncodedValue)bikeSpeedEnc).build();
        CHConfig carProfile = CHConfig.nodeBased((String)"c1", (Weighting)new SpeedWeighting((DecimalEncodedValue)carSpeedEnc));
        CHConfig bikeProfile = CHConfig.nodeBased((String)"c2", (Weighting)new SpeedWeighting((DecimalEncodedValue)bikeSpeedEnc));
        BaseGraph graph = new BaseGraph.Builder(tmpEncodingManager).create();
        PrepareContractionHierarchiesTest.initShortcutsGraph((Graph)graph, (DecimalEncodedValue)carSpeedEnc);
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            iter.set((DecimalEncodedValue)bikeSpeedEnc, 18.0, 18.0);
        }
        graph.freeze();
        this.checkPath(graph, carProfile, 7, 5.0, (IntIndexedContainer)IntArrayList.from((int[])new int[]{3, 9, 14, 16, 13, 12}), new int[]{0, 5, 6, 7, 8, 10, 11, 13, 15, 1, 3, 9, 14, 16, 12, 4, 2});
        this.checkPath(graph, bikeProfile, 7, 5.0, (IntIndexedContainer)IntArrayList.from((int[])new int[]{3, 9, 14, 16, 13, 12}), new int[]{0, 5, 6, 7, 8, 10, 11, 13, 15, 1, 3, 9, 14, 16, 12, 4, 2});
    }

    @Test
    public void testMultiplePreparationsDifferentView() {
        DecimalEncodedValueImpl carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, true);
        DecimalEncodedValueImpl bikeSpeedEnc = new DecimalEncodedValueImpl("bike_speed", 4, 2.0, true);
        EncodingManager tmpEncodingManager = EncodingManager.start().add((EncodedValue)carSpeedEnc).add((EncodedValue)bikeSpeedEnc).build();
        CHConfig carConfig = CHConfig.nodeBased((String)"c1", (Weighting)new SpeedWeighting((DecimalEncodedValue)carSpeedEnc));
        CHConfig bikeConfig = CHConfig.nodeBased((String)"c2", (Weighting)new SpeedWeighting((DecimalEncodedValue)bikeSpeedEnc));
        BaseGraph graph = new BaseGraph.Builder(tmpEncodingManager).create();
        PrepareContractionHierarchiesTest.initShortcutsGraph((Graph)graph, (DecimalEncodedValue)carSpeedEnc);
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            iter.set((DecimalEncodedValue)bikeSpeedEnc, 18.0, 18.0);
        }
        GHUtility.getEdge((Graph)graph, (int)9, (int)14).set((DecimalEncodedValue)bikeSpeedEnc, 0.0, 0.0);
        graph.freeze();
        this.checkPath(graph, carConfig, 7, 5.0, (IntIndexedContainer)IntArrayList.from((int[])new int[]{3, 9, 14, 16, 13, 12}), new int[]{0, 5, 6, 7, 8, 10, 11, 13, 15, 1, 3, 9, 14, 16, 12, 4, 2});
        this.checkPath(graph, bikeConfig, 9, 5.0, (IntIndexedContainer)IntArrayList.from((int[])new int[]{3, 10, 14, 16, 13, 12}), new int[]{0, 5, 6, 7, 8, 10, 11, 13, 14, 15, 9, 1, 4, 3, 2, 12, 16});
    }

    @Test
    public void testReusingNodeOrdering() {
        DecimalEncodedValueImpl car1SpeedEnc = new DecimalEncodedValueImpl("car1_speed", 5, 5.0, true);
        DecimalEncodedValueImpl car2SpeedEnc = new DecimalEncodedValueImpl("car2_speed", 5, 5.0, true);
        DecimalEncodedValue car1TurnCostEnc = TurnCost.create((String)"car1", (int)1);
        DecimalEncodedValue car2TurnCostEnc = TurnCost.create((String)"car2", (int)1);
        EncodingManager em = EncodingManager.start().add((EncodedValue)car1SpeedEnc).addTurnCostEncodedValue((EncodedValue)car1TurnCostEnc).add((EncodedValue)car2SpeedEnc).addTurnCostEncodedValue((EncodedValue)car2TurnCostEnc).build();
        CHConfig car1Config = CHConfig.nodeBased((String)"c1", (Weighting)new SpeedWeighting((DecimalEncodedValue)car1SpeedEnc));
        CHConfig car2Config = CHConfig.nodeBased((String)"c2", (Weighting)new SpeedWeighting((DecimalEncodedValue)car2SpeedEnc));
        BaseGraph graph = new BaseGraph.Builder(em).create();
        int numNodes = 5000;
        int numQueries = 100;
        long seed = System.nanoTime();
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)graph, (Random)rnd, (int)numNodes, (double)1.3, (boolean)true, null, null, (double)0.9, (double)0.8);
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            double car1Fwd = rnd.nextDouble() * 100.0;
            if (rnd.nextDouble() < 0.05) {
                car1Fwd = 0.0;
            }
            double car1Bwd = rnd.nextDouble() * 100.0;
            if (rnd.nextDouble() < 0.05) {
                car1Bwd = 0.0;
            }
            double car2Fwd = rnd.nextDouble() * 100.0;
            if (rnd.nextDouble() < 0.05) {
                car2Fwd = 0.0;
            }
            double car2Bwd = rnd.nextDouble() * 100.0;
            if (rnd.nextDouble() < 0.05) {
                car2Bwd = 0.0;
            }
            iter.set((DecimalEncodedValue)car1SpeedEnc, car1Fwd, car1Bwd);
            iter.set((DecimalEncodedValue)car2SpeedEnc, car2Fwd, car2Bwd);
        }
        graph.freeze();
        PrepareContractionHierarchies car1Pch = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)car1Config);
        PrepareContractionHierarchies.Result resCar1 = car1Pch.doWork();
        CHStorage car1CHStore = resCar1.getCHStorage();
        NodeOrderingProvider nodeOrderingProvider = car1CHStore.getNodeOrderingProvider();
        PrepareContractionHierarchies car2Pch = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)car2Config).useFixedNodeOrdering(nodeOrderingProvider);
        PrepareContractionHierarchies.Result resCar2 = car2Pch.doWork();
        RoutingCHGraph car2CH = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)resCar2.getCHStorage(), (CHConfig)resCar2.getCHConfig());
        Assertions.assertTrue((car1CHStore.getShortcuts() > 0 && resCar2.getCHStorage().getShortcuts() > 0 ? 1 : 0) != 0);
        Assertions.assertNotEquals((int)car1CHStore.getShortcuts(), (int)resCar2.getCHStorage().getShortcuts());
        for (int i = 0; i < numQueries; ++i) {
            Dijkstra dijkstra = new Dijkstra((Graph)graph, car2Config.getWeighting(), TraversalMode.NODE_BASED);
            EdgeToEdgeRoutingAlgorithm chAlgo = new CHRoutingAlgorithmFactory(car2CH).createAlgo(new PMap());
            int from = rnd.nextInt(numNodes);
            int to = rnd.nextInt(numNodes);
            double dijkstraWeight = dijkstra.calcPath(from, to).getWeight();
            double chWeight = chAlgo.calcPath(from, to).getWeight();
            Assertions.assertEquals((double)dijkstraWeight, (double)chWeight, (double)0.1);
        }
    }

    private void checkPath(BaseGraph g, CHConfig c, int expShortcuts, double expDistance, IntIndexedContainer expNodes, int[] nodeOrdering) {
        PrepareContractionHierarchies prepare = this.createPrepareContractionHierarchies(g, c);
        this.useNodeOrdering(prepare, nodeOrdering);
        PrepareContractionHierarchies.Result result = prepare.doWork();
        Assertions.assertEquals((long)expShortcuts, (long)result.getShortcuts(), (String)c.toString());
        RoutingCHGraph lg = RoutingCHGraphImpl.fromGraph((BaseGraph)g, (CHStorage)result.getCHStorage(), (CHConfig)result.getCHConfig());
        EdgeToEdgeRoutingAlgorithm algo = new CHRoutingAlgorithmFactory(lg).createAlgo(new PMap());
        Path path = algo.calcPath(3, 12);
        Assertions.assertEquals((double)expDistance, (double)path.getDistance(), (double)1.0E-5, (String)path.toString());
        Assertions.assertEquals((Object)expNodes, (Object)path.calcNodes(), (String)path.toString());
    }

    private PrepareContractionHierarchies createPrepareContractionHierarchies(BaseGraph g) {
        return this.createPrepareContractionHierarchies(g, this.chConfig);
    }

    private PrepareContractionHierarchies createPrepareContractionHierarchies(BaseGraph g, CHConfig p) {
        if (!g.isFrozen()) {
            g.freeze();
        }
        return PrepareContractionHierarchies.fromGraph((BaseGraph)g, (CHConfig)p);
    }

    private void useNodeOrdering(PrepareContractionHierarchies prepare, int[] nodeOrdering) {
        prepare.useFixedNodeOrdering(NodeOrderingProvider.fromArray((int[])nodeOrdering));
    }
}

