/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.IntEncodedValueImpl;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BooleanEncodedValueTest {
    @Test
    public void testBit() {
        EncodedValue.InitializerConfig config = new EncodedValue.InitializerConfig();
        IntEncodedValueImpl intProp = new IntEncodedValueImpl("somevalue", 5, false);
        intProp.init(config);
        SimpleBooleanEncodedValue bool = new SimpleBooleanEncodedValue("access", false);
        bool.init(config);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        bool.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, false);
        Assertions.assertFalse((boolean)bool.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        bool.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        Assertions.assertTrue((boolean)bool.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testBitDirected() {
        EncodedValue.InitializerConfig config = new EncodedValue.InitializerConfig();
        SimpleBooleanEncodedValue bool = new SimpleBooleanEncodedValue("access", true);
        bool.init(config);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        bool.setBool(false, edgeId, (EdgeIntAccess)edgeIntAccess, false);
        bool.setBool(true, edgeId, (EdgeIntAccess)edgeIntAccess, true);
        Assertions.assertFalse((boolean)bool.getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)bool.getBool(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }
}

