/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DecimalEncodedValueImplTest {
    @Test
    public void getDecimal() {
        DecimalEncodedValueImpl testEnc = new DecimalEncodedValueImpl("test", 3, 1.0, false);
        testEnc.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        Assertions.assertEquals((double)0.0, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        testEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 7.0);
        Assertions.assertEquals((double)7.0, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void setMaxToInfinity() {
        DecimalEncodedValueImpl testEnc = new DecimalEncodedValueImpl("test", 3, 0.0, 1.0, false, false, true);
        testEnc.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        Assertions.assertEquals((double)0.0, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertTrue((boolean)Double.isInfinite(testEnc.getMaxOrMaxStorableDecimal()));
        Assertions.assertTrue((boolean)Double.isInfinite(testEnc.getMaxStorableDecimal()));
        Assertions.assertTrue((boolean)Double.isInfinite(testEnc.getNextStorableValue(7.0)));
        Assertions.assertEquals((double)6.0, (double)testEnc.getNextStorableValue(6.0));
        testEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 5.0);
        Assertions.assertEquals((double)5.0, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)5.0, (double)testEnc.getMaxOrMaxStorableDecimal());
        Assertions.assertTrue((boolean)Double.isInfinite(testEnc.getMaxStorableDecimal()));
        testEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertTrue((boolean)Double.isInfinite(testEnc.getMaxOrMaxStorableDecimal()));
        Assertions.assertTrue((boolean)Double.isInfinite(testEnc.getMaxStorableDecimal()));
    }

    @Test
    public void testNegative() {
        DecimalEncodedValueImpl testEnc = new DecimalEncodedValueImpl("test", 3, -6.0, 0.1, false, false, true);
        testEnc.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        Assertions.assertEquals((double)-6.0, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        testEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, -5.5);
        Assertions.assertEquals((double)-5.5, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)-5.5, (double)testEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new DecimalEncodedValueImpl("test", 3, -6.0, 0.11, false, false, true));
        Assertions.assertTrue((boolean)e.getMessage().contains("minStorableValue -6.0 is not a multiple of the specified factor"), (String)e.getMessage());
    }

    @Test
    public void testInfinityWithMinValue() {
        DecimalEncodedValueImpl testEnc = new DecimalEncodedValueImpl("test", 3, -6.0, 0.1, false, false, true);
        testEnc.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        testEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testNegateReverse() {
        DecimalEncodedValueImpl testEnc = new DecimalEncodedValueImpl("test", 4, 0.0, 0.5, true, false, false);
        testEnc.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        testEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 5.5);
        Assertions.assertEquals((double)5.5, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)-5.5, (double)testEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        testEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, -5.5);
        Assertions.assertEquals((double)-5.5, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)5.5, (double)testEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        EncodedValue.InitializerConfig config = new EncodedValue.InitializerConfig();
        new DecimalEncodedValueImpl("tmp1", 5, 1.0, false).init(config);
        testEnc = new DecimalEncodedValueImpl("tmp2", 5, 0.0, 1.0, true, false, false);
        testEnc.init(config);
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        testEnc.setDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess, 2.6);
        Assertions.assertEquals((double)-3.0, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)3.0, (double)testEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        testEnc.setDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess, -2.6);
        Assertions.assertEquals((double)3.0, (double)testEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        Assertions.assertEquals((double)-3.0, (double)testEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testNextStorableValue() {
        DecimalEncodedValueImpl enc = new DecimalEncodedValueImpl("test", 4, 3.0, false);
        enc.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        enc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 3.0);
        Assertions.assertEquals((double)3.0, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        enc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 5.0);
        Assertions.assertEquals((double)6.0, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)0.0, (double)enc.getNextStorableValue(0.0));
        Assertions.assertEquals((double)3.0, (double)enc.getNextStorableValue(0.1));
        Assertions.assertEquals((double)3.0, (double)enc.getNextStorableValue(1.5));
        Assertions.assertEquals((double)3.0, (double)enc.getNextStorableValue(2.9));
        Assertions.assertEquals((double)3.0, (double)enc.getNextStorableValue(3.0));
        Assertions.assertEquals((double)6.0, (double)enc.getNextStorableValue(3.1));
        Assertions.assertEquals((double)6.0, (double)enc.getNextStorableValue(4.5));
        Assertions.assertEquals((double)6.0, (double)enc.getNextStorableValue(5.9));
        Assertions.assertEquals((double)45.0, (double)enc.getNextStorableValue(44.3));
        Assertions.assertEquals((double)45.0, (double)enc.getNextStorableValue(45.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> enc.getNextStorableValue(46.0));
        Random rnd = new Random();
        for (int i = 0; i < 1000; ++i) {
            double value = rnd.nextDouble() * 45.0;
            double nextStorable = enc.getNextStorableValue(value);
            Assertions.assertTrue((nextStorable >= value ? 1 : 0) != 0, (String)"next storable value should be larger than the value");
            enc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, nextStorable);
            Assertions.assertEquals((double)nextStorable, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (String)"next storable value should be returned without modification");
        }
    }

    @Test
    public void smallestNonZeroValue() {
        this.assertSmallestNonZeroValue(new DecimalEncodedValueImpl("test", 5, 10.0, true), 10.0);
        this.assertSmallestNonZeroValue(new DecimalEncodedValueImpl("test", 10, 10.0, true), 10.0);
        this.assertSmallestNonZeroValue(new DecimalEncodedValueImpl("test", 5, 5.0, true), 5.0);
        this.assertSmallestNonZeroValue(new DecimalEncodedValueImpl("test", 5, 1.0, true), 1.0);
        this.assertSmallestNonZeroValue(new DecimalEncodedValueImpl("test", 5, 0.5, true), 0.5);
        this.assertSmallestNonZeroValue(new DecimalEncodedValueImpl("test", 5, 0.1, true), 0.1);
        Assertions.assertTrue((boolean)((IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> new DecimalEncodedValueImpl("test", 5, 0.0, 5.0, true, false, false).getSmallestNonZeroValue())).getMessage().contains("getting the smallest non-zero value is not possible"));
    }

    private void assertSmallestNonZeroValue(DecimalEncodedValueImpl enc, double expected) {
        enc.init(new EncodedValue.InitializerConfig());
        Assertions.assertEquals((double)expected, (double)enc.getSmallestNonZeroValue());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        enc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, enc.getSmallestNonZeroValue());
        Assertions.assertEquals((double)expected, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        enc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, enc.getSmallestNonZeroValue() / 2.0 - 0.01);
        Assertions.assertEquals((double)0.0, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testNextStorableValue_maxInfinity() {
        DecimalEncodedValueImpl enc = new DecimalEncodedValueImpl("test", 4, 0.0, 3.0, false, false, true);
        enc.init(new EncodedValue.InitializerConfig());
        Assertions.assertEquals((double)12.0, (double)enc.getNextStorableValue(11.2));
        Assertions.assertEquals((double)42.0, (double)enc.getNextStorableValue(41.3));
        Assertions.assertEquals((double)42.0, (double)enc.getNextStorableValue(42.0));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)enc.getNextStorableValue(42.1));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)enc.getNextStorableValue(45.0));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)enc.getNextStorableValue(45.1));
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        enc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 45.0);
        Assertions.assertEquals((double)42.0, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        enc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void lowestUpperBound_with_negateReverseDirection() {
        DecimalEncodedValueImpl enc = new DecimalEncodedValueImpl("test", 4, 0.0, 3.0, true, false, false);
        enc.init(new EncodedValue.InitializerConfig());
        Assertions.assertEquals((double)45.0, (double)enc.getMaxOrMaxStorableDecimal());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        enc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 3.0);
        Assertions.assertEquals((double)3.0, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)3.0, (double)enc.getMaxOrMaxStorableDecimal());
        enc.setDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess, -6.0);
        Assertions.assertEquals((double)6.0, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)6.0, (double)enc.getMaxOrMaxStorableDecimal());
        enc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 0.0);
        Assertions.assertEquals((double)0.0, (double)enc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)6.0, (double)enc.getMaxOrMaxStorableDecimal());
    }

    @Test
    public void minStorableBug() {
        DecimalEncodedValueImpl enc = new DecimalEncodedValueImpl("test", 5, -3.0, 0.2, false, true, false);
        enc.init(new EncodedValue.InitializerConfig());
        Assertions.assertEquals((double)3.2, (double)enc.getMaxStorableDecimal());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        enc.setDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess, 1.6);
        Assertions.assertEquals((double)1.6, (double)enc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess));
    }
}

