/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DecimalEncodedValueTest {
    @Test
    public void testInit() {
        DecimalEncodedValueImpl prop = new DecimalEncodedValueImpl("test", 10, 2.0, false);
        prop.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        prop.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 10.0);
        Assertions.assertEquals((double)10.0, (double)prop.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testMaxValue() {
        DecimalEncodedValueImpl ev = new DecimalEncodedValueImpl("test1", 8, 0.5, false);
        EncodingManager.start().add((EncodedValue)ev).build();
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ev.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 100.0);
        Assertions.assertEquals((double)100.0, (double)ev.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testNegativeBounds() {
        DecimalEncodedValueImpl prop = new DecimalEncodedValueImpl("test", 10, 5.0, false);
        prop.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        Assertions.assertThrows(Exception.class, () -> DecimalEncodedValueTest.lambda$testNegativeBounds$0((DecimalEncodedValue)prop, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    private static /* synthetic */ void lambda$testNegativeBounds$0(DecimalEncodedValue prop, int edgeId, EdgeIntAccess edgeIntAccess) throws Throwable {
        prop.setDecimal(false, edgeId, edgeIntAccess, -1.0);
    }
}

