/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueSerializer;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.GetOffBike;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.Lanes;
import com.graphhopper.routing.ev.MaxWidth;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.StringEncodedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EncodedValueSerializerTest {
    EncodedValueSerializerTest() {
    }

    @Test
    public void serializationAndDeserialization() {
        ArrayList<Object> encodedValues = new ArrayList<Object>();
        encodedValues.add(RoadClass.create());
        encodedValues.add(Lanes.create());
        encodedValues.add(MaxWidth.create());
        encodedValues.add(GetOffBike.create());
        StringEncodedValue namesEnc = new StringEncodedValue("names", 3, Arrays.asList("jim", "joe", "kate"), false);
        encodedValues.add(namesEnc);
        ArrayList<String> serializedEVs = new ArrayList<String>();
        for (Object e : encodedValues) {
            serializedEVs.add(EncodedValueSerializer.serializeEncodedValue((EncodedValue)e));
        }
        ArrayList<EncodedValue> deserializedEVs = new ArrayList<EncodedValue>();
        for (String s : serializedEVs) {
            deserializedEVs.add(EncodedValueSerializer.deserializeEncodedValue((String)s));
        }
        EnumEncodedValue deserializedRoadClass = (EnumEncodedValue)deserializedEVs.get(0);
        IntEncodedValue deserializedLanes = (IntEncodedValue)deserializedEVs.get(1);
        DecimalEncodedValue deserializedMaxWidth = (DecimalEncodedValue)deserializedEVs.get(2);
        BooleanEncodedValue deserializedGetOffBike = (BooleanEncodedValue)deserializedEVs.get(3);
        StringEncodedValue deserializedNames = (StringEncodedValue)deserializedEVs.get(4);
        Assertions.assertEquals((Object)"road_class", (Object)deserializedRoadClass.getName());
        Assertions.assertTrue((boolean)Arrays.toString(deserializedRoadClass.getValues()).contains("motorway"));
        Assertions.assertEquals((Object)"lanes", (Object)deserializedLanes.getName());
        Assertions.assertEquals((Object)"max_width", (Object)deserializedMaxWidth.getName());
        Assertions.assertEquals((Object)"get_off_bike", (Object)deserializedGetOffBike.getName());
        Assertions.assertEquals((Object)"names", (Object)deserializedNames.getName());
        Assertions.assertTrue((boolean)deserializedNames.getValues().contains("jim"));
    }

    @Test
    void explicitString() {
        EncodedValue.InitializerConfig initializerConfig = new EncodedValue.InitializerConfig();
        List<EncodedValue> evs = Arrays.asList(Lanes.create(), MaxWidth.create(), GetOffBike.create());
        evs.forEach(ev -> ev.init(initializerConfig));
        List serialized = evs.stream().map(EncodedValueSerializer::serializeEncodedValue).collect(Collectors.toList());
        Assertions.assertEquals((Object)"{\"className\":\"com.graphhopper.routing.ev.IntEncodedValueImpl\",\"name\":\"lanes\",\"bits\":3,\"min_storable_value\":0,\"max_storable_value\":7,\"max_value\":-2147483648,\"negate_reverse_direction\":false,\"store_two_directions\":false,\"fwd_data_index\":0,\"bwd_data_index\":0,\"fwd_shift\":0,\"bwd_shift\":-1,\"fwd_mask\":7,\"bwd_mask\":0}", serialized.get(0));
        Assertions.assertEquals((Object)"{\"className\":\"com.graphhopper.routing.ev.DecimalEncodedValueImpl\",\"name\":\"max_width\",\"bits\":7,\"min_storable_value\":0,\"max_storable_value\":127,\"max_value\":-2147483648,\"negate_reverse_direction\":false,\"store_two_directions\":false,\"fwd_data_index\":0,\"bwd_data_index\":0,\"fwd_shift\":3,\"bwd_shift\":-1,\"fwd_mask\":1016,\"bwd_mask\":0,\"factor\":0.1,\"use_maximum_as_infinity\":true}", serialized.get(1));
        Assertions.assertEquals((Object)"{\"className\":\"com.graphhopper.routing.ev.SimpleBooleanEncodedValue\",\"name\":\"get_off_bike\",\"bits\":1,\"min_storable_value\":0,\"max_storable_value\":1,\"max_value\":-2147483648,\"negate_reverse_direction\":false,\"store_two_directions\":true,\"fwd_data_index\":0,\"bwd_data_index\":0,\"fwd_shift\":10,\"bwd_shift\":11,\"fwd_mask\":1024,\"bwd_mask\":2048}", serialized.get(2));
        EncodedValue ev0 = EncodedValueSerializer.deserializeEncodedValue((String)((String)serialized.get(0)));
        Assertions.assertEquals((Object)"lanes", (Object)ev0.getName());
        EncodedValue ev1 = EncodedValueSerializer.deserializeEncodedValue((String)((String)serialized.get(1)));
        Assertions.assertEquals((Object)"max_width", (Object)ev1.getName());
        EncodedValue ev2 = EncodedValueSerializer.deserializeEncodedValue((String)((String)serialized.get(2)));
        Assertions.assertEquals((Object)"get_off_bike", (Object)ev2.getName());
    }
}

