/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.ImportUnit;
import com.graphhopper.routing.ev.ImportUnitSorter;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImportUnitSorterTest {
    @Test
    public void simple() {
        ImportUnit a = this.create("a", new String[0]);
        ImportUnit b = this.create("b", "a");
        ImportUnit c = this.create("c", "b");
        HashMap<String, ImportUnit> importUnits = new HashMap<String, ImportUnit>();
        importUnits.put("a", a);
        importUnits.put("b", b);
        importUnits.put("c", c);
        ImportUnitSorter sorter = new ImportUnitSorter(importUnits);
        List sorted = sorter.sort();
        Assertions.assertEquals((int)importUnits.size(), (int)sorted.size());
        Assertions.assertEquals(List.of("a", "b", "c"), (Object)sorted);
    }

    @Test
    public void cycle() {
        ImportUnit a = this.create("a", "b");
        ImportUnit b = this.create("b", "a");
        HashMap<String, ImportUnit> importUnits = new HashMap<String, ImportUnit>();
        importUnits.put("a", a);
        importUnits.put("b", b);
        ImportUnitSorter sorter = new ImportUnitSorter(importUnits);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((ImportUnitSorter)sorter).sort());
        Assertions.assertTrue((boolean)e.getMessage().contains("import units with cyclic dependencies are not allowed"));
    }

    private ImportUnit create(String name, String ... required) {
        return ImportUnit.create((String)name, null, null, (String[])required);
    }
}

