/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValueImpl;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IntEncodedValueImplTest {
    @Test
    public void testInvalidReverseAccess() {
        IntEncodedValueImpl prop = new IntEncodedValueImpl("test", 10, false);
        prop.init(new EncodedValue.InitializerConfig());
        try {
            prop.setInt(true, 0, (EdgeIntAccess)IntEncodedValueImplTest.createIntAccess(1), -1);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDirectedValue() {
        IntEncodedValueImpl prop = new IntEncodedValueImpl("test", 10, true);
        prop.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = IntEncodedValueImplTest.createIntAccess(1);
        prop.setInt(false, 0, (EdgeIntAccess)edgeIntAccess, 10);
        prop.setInt(true, 0, (EdgeIntAccess)edgeIntAccess, 20);
        Assertions.assertEquals((int)10, (int)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)20, (int)prop.getInt(true, 0, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void multiIntsUsage() {
        IntEncodedValueImpl prop = new IntEncodedValueImpl("test", 31, true);
        prop.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = IntEncodedValueImplTest.createIntAccess(2);
        prop.setInt(false, 0, (EdgeIntAccess)edgeIntAccess, 10);
        prop.setInt(true, 0, (EdgeIntAccess)edgeIntAccess, 20);
        Assertions.assertEquals((int)10, (int)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)20, (int)prop.getInt(true, 0, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void padding() {
        IntEncodedValueImpl prop = new IntEncodedValueImpl("test", 30, true);
        prop.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = IntEncodedValueImplTest.createIntAccess(2);
        prop.setInt(false, 0, (EdgeIntAccess)edgeIntAccess, 10);
        prop.setInt(true, 0, (EdgeIntAccess)edgeIntAccess, 20);
        Assertions.assertEquals((int)10, (int)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)20, (int)prop.getInt(true, 0, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void maxValue() {
        IntEncodedValueImpl prop = new IntEncodedValueImpl("test", 31, false);
        prop.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = IntEncodedValueImplTest.createIntAccess(2);
        prop.setInt(false, 0, (EdgeIntAccess)edgeIntAccess, Integer.MAX_VALUE);
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testSignedInt() {
        IntEncodedValueImpl prop = new IntEncodedValueImpl("test", 31, -5, false, true);
        EncodedValue.InitializerConfig config = new EncodedValue.InitializerConfig();
        prop.init(config);
        ArrayEdgeIntAccess edgeIntAccess = IntEncodedValueImplTest.createIntAccess(1);
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> IntEncodedValueImplTest.lambda$testSignedInt$0((IntEncodedValue)prop, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)exception.getMessage().contains("test value too large for encoding"), (String)exception.getMessage());
        prop.setInt(false, 0, (EdgeIntAccess)edgeIntAccess, -5);
        Assertions.assertEquals((int)-5, (int)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)-5, (int)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testSignedInt2() {
        IntEncodedValueImpl prop = new IntEncodedValueImpl("test", 31, false);
        EncodedValue.InitializerConfig config = new EncodedValue.InitializerConfig();
        prop.init(config);
        ArrayEdgeIntAccess edgeIntAccess = IntEncodedValueImplTest.createIntAccess(1);
        prop.setInt(false, 0, (EdgeIntAccess)edgeIntAccess, Integer.MAX_VALUE);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> IntEncodedValueImplTest.lambda$testSignedInt2$1((IntEncodedValue)prop, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertTrue((boolean)exception.getMessage().contains("test value too small for encoding"), (String)exception.getMessage());
    }

    @Test
    public void testNegateReverseDirection() {
        IntEncodedValueImpl prop = new IntEncodedValueImpl("test", 5, 0, true, false);
        EncodedValue.InitializerConfig config = new EncodedValue.InitializerConfig();
        prop.init(config);
        ArrayEdgeIntAccess edgeIntAccess = IntEncodedValueImplTest.createIntAccess(1);
        prop.setInt(false, 0, (EdgeIntAccess)edgeIntAccess, 5);
        Assertions.assertEquals((int)5, (int)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)-5, (int)prop.getInt(true, 0, (EdgeIntAccess)edgeIntAccess));
        prop.setInt(true, 0, (EdgeIntAccess)edgeIntAccess, 2);
        Assertions.assertEquals((int)-2, (int)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)2, (int)prop.getInt(true, 0, (EdgeIntAccess)edgeIntAccess));
        prop.setInt(false, 0, (EdgeIntAccess)edgeIntAccess, -3);
        Assertions.assertEquals((int)-3, (int)prop.getInt(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)3, (int)prop.getInt(true, 0, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    public void testEncodedValueName() {
        for (String str : Arrays.asList("blup_test", "test", "test12", "car_test_test")) {
            Assertions.assertTrue((boolean)IntEncodedValueImpl.isValidEncodedValue((String)str), (String)str);
        }
        for (String str : Arrays.asList("Test", "12test", "test|3", "car__test", "small_car$average_speed", "tes$0", "blup_te.st_", "car___test", "car$$access", "test{34", "truck__average_speed", "blup.test", "test,21", "t\u00e4st", "blup.two.three", "blup..test")) {
            Assertions.assertFalse((boolean)IntEncodedValueImpl.isValidEncodedValue((String)str), (String)str);
        }
        for (String str : Arrays.asList("break", "switch")) {
            Assertions.assertFalse((boolean)IntEncodedValueImpl.isValidEncodedValue((String)str), (String)str);
        }
    }

    private static ArrayEdgeIntAccess createIntAccess(int ints) {
        return new ArrayEdgeIntAccess(ints);
    }

    private static /* synthetic */ void lambda$testSignedInt2$1(IntEncodedValue prop, EdgeIntAccess edgeIntAccess) throws Throwable {
        prop.setInt(false, 0, edgeIntAccess, -5);
    }

    private static /* synthetic */ void lambda$testSignedInt$0(IntEncodedValue prop, EdgeIntAccess edgeIntAccess) throws Throwable {
        prop.setInt(false, 0, edgeIntAccess, Integer.MAX_VALUE);
    }
}

