/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringEncodedValueTest {
    @Test
    public void testInitExact() {
        StringEncodedValue prop = new StringEncodedValue("country", 3);
        EncodedValue.InitializerConfig init = new EncodedValue.InitializerConfig();
        Assertions.assertEquals((int)2, (int)prop.init(init));
        Assertions.assertEquals((int)2, (int)prop.bits);
        Assertions.assertEquals((int)0, (int)init.dataIndex);
        Assertions.assertEquals((int)0, (int)init.shift);
    }

    @Test
    public void testInitRoundUp() {
        StringEncodedValue prop = new StringEncodedValue("country", 33);
        EncodedValue.InitializerConfig init = new EncodedValue.InitializerConfig();
        Assertions.assertEquals((int)6, (int)prop.init(init));
        Assertions.assertEquals((int)6, (int)prop.bits);
        Assertions.assertEquals((int)0, (int)init.dataIndex);
        Assertions.assertEquals((int)0, (int)init.shift);
    }

    @Test
    public void testInitSingle() {
        StringEncodedValue prop = new StringEncodedValue("country", 1);
        EncodedValue.InitializerConfig init = new EncodedValue.InitializerConfig();
        Assertions.assertEquals((int)1, (int)prop.init(init));
        Assertions.assertEquals((int)1, (int)prop.bits);
        Assertions.assertEquals((int)0, (int)init.dataIndex);
        Assertions.assertEquals((int)0, (int)init.shift);
    }

    @Test
    public void testInitTooManyEntries() {
        List<String> values = Arrays.asList("aut", "deu", "che", "fra");
        try {
            new StringEncodedValue("country", 2, values, false);
            Assertions.fail((String)"The encoded value should only allow 3 entries");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Number of values is higher than the maximum value count"));
        }
    }

    @Test
    public void testNull() {
        StringEncodedValue prop = new StringEncodedValue("country", 3);
        prop.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        prop.setString(false, 0, (EdgeIntAccess)edgeIntAccess, null);
        Assertions.assertEquals((int)0, (int)prop.getValues().size());
    }

    @Test
    public void testEquals() {
        List<String> values = Arrays.asList("aut", "deu", "che");
        StringEncodedValue small = new StringEncodedValue("country", 3, values, false);
        small.init(new EncodedValue.InitializerConfig());
        StringEncodedValue big = new StringEncodedValue("country", 4, values, false);
        big.init(new EncodedValue.InitializerConfig());
        Assertions.assertNotEquals((Object)small, (Object)big);
    }

    @Test
    public void testLookup() {
        StringEncodedValue prop = new StringEncodedValue("country", 3);
        prop.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        Assertions.assertEquals(null, (Object)prop.getString(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)0, (int)prop.getValues().size());
        prop.setString(false, 0, (EdgeIntAccess)edgeIntAccess, "aut");
        Assertions.assertEquals((Object)"aut", (Object)prop.getString(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)1, (int)prop.getValues().size());
        prop.setString(false, 0, (EdgeIntAccess)edgeIntAccess, "deu");
        Assertions.assertEquals((Object)"deu", (Object)prop.getString(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)2, (int)prop.getValues().size());
        prop.setString(false, 0, (EdgeIntAccess)edgeIntAccess, "che");
        Assertions.assertEquals((Object)"che", (Object)prop.getString(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)3, (int)prop.getValues().size());
        prop.setString(false, 0, (EdgeIntAccess)edgeIntAccess, "deu");
        Assertions.assertEquals((Object)"deu", (Object)prop.getString(false, 0, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((int)3, (int)prop.getValues().size());
    }

    @Test
    public void testStoreTooManyEntries() {
        StringEncodedValue prop = new StringEncodedValue("country", 3);
        prop.init(new EncodedValue.InitializerConfig());
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        Assertions.assertEquals(null, (Object)prop.getString(false, 0, (EdgeIntAccess)edgeIntAccess));
        prop.setString(false, 0, (EdgeIntAccess)edgeIntAccess, "aut");
        Assertions.assertEquals((Object)"aut", (Object)prop.getString(false, 0, (EdgeIntAccess)edgeIntAccess));
        prop.setString(false, 0, (EdgeIntAccess)edgeIntAccess, "deu");
        Assertions.assertEquals((Object)"deu", (Object)prop.getString(false, 0, (EdgeIntAccess)edgeIntAccess));
        prop.setString(false, 0, (EdgeIntAccess)edgeIntAccess, "che");
        Assertions.assertEquals((Object)"che", (Object)prop.getString(false, 0, (EdgeIntAccess)edgeIntAccess));
        try {
            prop.setString(false, 0, (EdgeIntAccess)edgeIntAccess, "xyz");
            Assertions.fail((String)"The encoded value should only allow a limited number of values");
        }
        catch (IllegalStateException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Maximum number of values reached for"));
        }
    }
}

