/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.lm.LMApproximator;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.PerfectApproximator;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BalancedWeightApproximator;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;

public class LMApproximatorTest {
    @RepeatedTest(value=10)
    public void randomGraph() {
        long seed = System.nanoTime();
        this.run(seed);
    }

    private void run(long seed) {
        RAMDirectory dir = new RAMDirectory();
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        DecimalEncodedValue turnCostEnc = TurnCost.create((String)"car", (int)1);
        EncodingManager encodingManager = new EncodingManager.Builder().add((EncodedValue)speedEnc).addTurnCostEncodedValue((EncodedValue)turnCostEnc).add((EncodedValue)Subnetwork.create((String)"car")).build();
        BaseGraph graph = new BaseGraph.Builder(encodingManager).setDir((Directory)dir).withTurnCosts(true).create();
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)graph, (Random)rnd, (int)100, (double)2.2, (boolean)true, (DecimalEncodedValue)speedEnc, null, (double)0.8, (double)0.8);
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        PrepareLandmarks lm = new PrepareLandmarks((Directory)dir, graph, (EncodedValueLookup)encodingManager, new LMConfig("car", (Weighting)weighting), 16);
        lm.setMaximumWeight(10000.0);
        lm.doWork();
        LandmarkStorage landmarkStorage = lm.getLandmarkStorage();
        for (int t = 0; t < graph.getNodes(); ++t) {
            LMApproximator lmApproximator = new LMApproximator((Graph)graph, (Weighting)weighting, (Weighting)weighting, graph.getNodes(), landmarkStorage, 8, landmarkStorage.getFactor(), false);
            WeightApproximator reverseLmApproximator = lmApproximator.reverse();
            BeelineWeightApproximator beelineApproximator = new BeelineWeightApproximator(graph.getNodeAccess(), (Weighting)weighting);
            WeightApproximator reverseBeelineApproximator = beelineApproximator.reverse();
            PerfectApproximator perfectApproximator = new PerfectApproximator((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED, false);
            PerfectApproximator reversePerfectApproximator = new PerfectApproximator((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED, true);
            BalancedWeightApproximator balancedWeightApproximator = new BalancedWeightApproximator((WeightApproximator)new LMApproximator((Graph)graph, (Weighting)weighting, (Weighting)weighting, graph.getNodes(), landmarkStorage, 8, landmarkStorage.getFactor(), false));
            lmApproximator.setTo(t);
            beelineApproximator.setTo(t);
            reverseLmApproximator.setTo(t);
            reverseBeelineApproximator.setTo(t);
            perfectApproximator.setTo(t);
            reversePerfectApproximator.setTo(t);
            balancedWeightApproximator.setFromTo(0, t);
            int nOverApproximatedWeights = 0;
            int nInconsistentWeights = 0;
            for (int v = 0; v < graph.getNodes(); ++v) {
                double approximate;
                double beelineApproximatedRemainingWeight;
                Dijkstra reverseDijkstra;
                Path reversePath;
                Dijkstra dijkstra = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED);
                Path path = dijkstra.calcPath(v, t);
                if (path.isFound()) {
                    double vwApprox;
                    double vw;
                    int w;
                    double approximate2;
                    double beelineApproximatedRemainingWeight2;
                    double slack = (double)path.getEdgeCount() * 0.001;
                    double realRemainingWeight = path.getWeight();
                    double approximatedRemainingWeight = lmApproximator.approximate(v);
                    if (approximatedRemainingWeight - slack > realRemainingWeight) {
                        System.out.printf("LM: %f\treal: %f\n", approximatedRemainingWeight, realRemainingWeight);
                        ++nOverApproximatedWeights;
                    }
                    if ((beelineApproximatedRemainingWeight2 = beelineApproximator.approximate(v)) - slack > realRemainingWeight) {
                        System.out.printf("beeline: %f\treal: %f\n", beelineApproximatedRemainingWeight2, realRemainingWeight);
                        ++nOverApproximatedWeights;
                    }
                    if ((approximate2 = perfectApproximator.approximate(v)) > realRemainingWeight) {
                        System.out.printf("perfect: %f\treal: %f\n", approximate2, realRemainingWeight);
                        ++nOverApproximatedWeights;
                    }
                    EdgeIterator neighbors = graph.createEdgeExplorer(arg_0 -> LMApproximatorTest.lambda$run$0((DecimalEncodedValue)speedEnc, arg_0)).setBaseNode(v);
                    while (neighbors.next()) {
                        w = neighbors.getAdjNode();
                        vw = weighting.calcEdgeWeight((EdgeIteratorState)neighbors, false);
                        vwApprox = lmApproximator.approximate(v) - lmApproximator.approximate(w);
                        if (!(vwApprox - lm.getLandmarkStorage().getFactor() > vw)) continue;
                        System.out.printf("%f\t%f\n", vwApprox - lm.getLandmarkStorage().getFactor(), vw);
                        ++nInconsistentWeights;
                    }
                    neighbors = graph.createEdgeExplorer(arg_0 -> LMApproximatorTest.lambda$run$1((DecimalEncodedValue)speedEnc, arg_0)).setBaseNode(v);
                    while (neighbors.next()) {
                        w = neighbors.getAdjNode();
                        vw = weighting.calcEdgeWeight((EdgeIteratorState)neighbors, false);
                        vwApprox = balancedWeightApproximator.approximate(v, false) - balancedWeightApproximator.approximate(w, false);
                        if (!(vwApprox - lm.getLandmarkStorage().getFactor() > vw)) continue;
                        System.out.printf("%f\t%f\n", vwApprox - lm.getLandmarkStorage().getFactor(), vw);
                        ++nInconsistentWeights;
                    }
                }
                if (!(reversePath = (reverseDijkstra = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED)).calcPath(t, v)).isFound()) continue;
                double slack = (double)reversePath.getEdgeCount() * 0.001;
                double realRemainingWeight = reversePath.getWeight();
                double approximatedRemainingWeight = reverseLmApproximator.approximate(v);
                if (approximatedRemainingWeight - slack > realRemainingWeight) {
                    System.out.printf("LM: %f\treal: %f\n", approximatedRemainingWeight, realRemainingWeight);
                    ++nOverApproximatedWeights;
                }
                if ((beelineApproximatedRemainingWeight = reverseBeelineApproximator.approximate(v)) - slack > realRemainingWeight) {
                    System.out.printf("beeline: %f\treal: %f\n", beelineApproximatedRemainingWeight, realRemainingWeight);
                    ++nOverApproximatedWeights;
                }
                if (!((approximate = reversePerfectApproximator.approximate(v)) > realRemainingWeight)) continue;
                System.out.printf("perfect: %f\treal: %f\n", approximate, realRemainingWeight);
                ++nOverApproximatedWeights;
            }
            Assertions.assertEquals((int)0, (int)nOverApproximatedWeights, (String)("too many over approximated weights, seed: " + seed));
            Assertions.assertEquals((int)0, (int)nInconsistentWeights, (String)("too many inconsistent weights, seed: " + seed));
        }
    }

    private static /* synthetic */ boolean lambda$run$1(DecimalEncodedValue speedEnc, EdgeIteratorState edge) {
        return edge.get(speedEnc) > 0.0;
    }

    private static /* synthetic */ boolean lambda$run$0(DecimalEncodedValue speedEnc, EdgeIteratorState edge) {
        return edge.get(speedEnc) > 0.0;
    }
}

