/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMRoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.PerfectApproximator;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class LMIssueTest {
    private Directory dir;
    private BaseGraph graph;
    private DecimalEncodedValue speedEnc;
    private Weighting weighting;
    private LandmarkStorage lm;
    private EncodingManager encodingManager;

    @BeforeEach
    public void init() {
        this.dir = new RAMDirectory();
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        DecimalEncodedValue turnCostEnc = TurnCost.create((String)"car", (int)1);
        this.encodingManager = new EncodingManager.Builder().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)turnCostEnc).add((EncodedValue)Subnetwork.create((String)"car")).build();
        this.graph = new BaseGraph.Builder(this.encodingManager).withTurnCosts(true).setDir(this.dir).create();
        this.weighting = new SpeedWeighting(this.speedEnc);
    }

    private void preProcessGraph() {
        this.graph.freeze();
        PrepareLandmarks prepare = new PrepareLandmarks(this.dir, this.graph, (EncodedValueLookup)this.encodingManager, new LMConfig("car", this.weighting), 16);
        prepare.setMaximumWeight(10000.0);
        prepare.doWork();
        this.lm = prepare.getLandmarkStorage();
    }

    private RoutingAlgorithm createAlgo(Algo algo) {
        switch (algo.ordinal()) {
            case 0: {
                return new Dijkstra((Graph)this.graph, this.weighting, TraversalMode.NODE_BASED);
            }
            case 2: {
                return new AStar((Graph)this.graph, this.weighting, TraversalMode.NODE_BASED);
            }
            case 1: {
                return new AStarBidirection((Graph)this.graph, this.weighting, TraversalMode.NODE_BASED);
            }
            case 3: {
                return new LMRoutingAlgorithmFactory(this.lm).createAlgo((Graph)this.graph, this.weighting, new AlgorithmOptions().setAlgorithm("astarbi").setTraversalMode(TraversalMode.NODE_BASED));
            }
            case 4: {
                return new LMRoutingAlgorithmFactory(this.lm).createAlgo((Graph)this.graph, this.weighting, new AlgorithmOptions().setAlgorithm("astar").setTraversalMode(TraversalMode.NODE_BASED));
            }
            case 5: {
                AStarBidirection perfectastarbi = new AStarBidirection((Graph)this.graph, this.weighting, TraversalMode.NODE_BASED);
                perfectastarbi.setApproximation((WeightApproximator)new PerfectApproximator((Graph)this.graph, this.weighting, TraversalMode.NODE_BASED, false));
                return perfectastarbi;
            }
        }
        throw new IllegalArgumentException("unknown algo " + String.valueOf((Object)algo));
    }

    @ParameterizedTest
    @EnumSource
    public void lm_problem_to_node_of_fallback_approximator(Algo algo) {
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(0, 49.40515, 9.709054);
        na.setNode(1, 49.403705, 9.700517);
        na.setNode(2, 49.400112, 9.700209);
        na.setNode(3, 49.403009, 9.708364);
        na.setNode(4, 49.409021, 9.703622);
        this.graph.edge(4, 3).setDistance(1000.0).set(this.speedEnc, 120.0, 120.0);
        this.graph.edge(0, 2).setDistance(1000.0).set(this.speedEnc, 120.0, 0.0);
        this.graph.edge(1, 3).setDistance(1000.0).set(this.speedEnc, 10.0, 60.0);
        this.graph.edge(0, 1).setDistance(1000.0).set(this.speedEnc, 45.0, 0.0);
        this.graph.edge(1, 4).setDistance(1000.0).set(this.speedEnc, 45.0, 60.0);
        this.preProcessGraph();
        int source = 0;
        int target = 3;
        Path refPath = new DijkstraBidirectionRef((Graph)this.graph, this.weighting, TraversalMode.NODE_BASED).calcPath(source, target);
        Path path = this.createAlgo(algo).calcPath(source, target);
        Assertions.assertEquals((double)refPath.getWeight(), (double)path.getWeight(), (double)0.01);
        Assertions.assertEquals((double)refPath.getDistance(), (double)path.getDistance(), (double)0.1);
        Assertions.assertEquals((float)refPath.getTime(), (float)path.getTime(), (float)50.0f);
        Assertions.assertEquals((Object)refPath.calcNodes(), (Object)path.calcNodes());
    }

    @ParameterizedTest
    @EnumSource
    public void lm_issue2(Algo algo) {
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(0, 49.406987, 9.709767);
        na.setNode(1, 49.403612, 9.702953);
        na.setNode(2, 49.409755, 9.706517);
        na.setNode(3, 49.409021, 9.708649);
        na.setNode(4, 49.400674, 9.700906);
        na.setNode(5, 49.408735, 9.709486);
        na.setNode(6, 49.406402, 9.700937);
        na.setNode(7, 49.406965, 9.70266);
        na.setNode(8, 49.405227, 9.702863);
        na.setNode(9, 49.409411, 9.709085);
        this.graph.edge(0, 1).setDistance(623.197).set(this.speedEnc, 112.0, 112.0);
        this.graph.edge(5, 1).setDistance(741.414).set(this.speedEnc, 13.0, 13.0);
        this.graph.edge(9, 4).setDistance(1140.835).set(this.speedEnc, 35.0, 35.0);
        this.graph.edge(5, 6).setDistance(670.689).set(this.speedEnc, 18.0, 18.0);
        this.graph.edge(5, 9).setDistance(80.731).set(this.speedEnc, 88.0, 0.0);
        this.graph.edge(0, 9).setDistance(273.948).set(this.speedEnc, 82.0, 82.0);
        this.graph.edge(4, 0).setDistance(956.552).set(this.speedEnc, 60.0, 60.0);
        this.preProcessGraph();
        int source = 5;
        int target = 4;
        Path refPath = new DijkstraBidirectionRef((Graph)this.graph, this.weighting, TraversalMode.NODE_BASED).calcPath(source, target);
        Path path = this.createAlgo(algo).calcPath(source, target);
        Assertions.assertEquals((double)refPath.getWeight(), (double)path.getWeight(), (double)0.01);
        Assertions.assertEquals((double)refPath.getDistance(), (double)path.getDistance(), (double)0.1);
        Assertions.assertEquals((float)refPath.getTime(), (float)path.getTime(), (float)50.0f);
        Assertions.assertEquals((Object)refPath.calcNodes(), (Object)path.calcNodes());
    }

    private static enum Algo {
        DIJKSTRA,
        ASTAR_BIDIR,
        ASTAR_UNIDIR,
        LM_BIDIR,
        LM_UNIDIR,
        PERFECT_ASTAR;

    }
}

