/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMPreparationHandler;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LMPreparationHandlerTest {
    @Test
    public void testEnabled() {
        LMPreparationHandler instance = new LMPreparationHandler();
        Assertions.assertFalse((boolean)instance.isEnabled());
        instance.setLMProfiles(new LMProfile[]{new LMProfile("myconfig")});
        Assertions.assertTrue((boolean)instance.isEnabled());
    }

    @Test
    public void maximumLMWeight() {
        LMPreparationHandler handler = new LMPreparationHandler();
        handler.setLMProfiles(new LMProfile[]{new LMProfile("conf1").setMaximumLMWeight(65000.0), new LMProfile("conf2").setMaximumLMWeight(20000.0)});
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        List<LMConfig> lmConfigs = Arrays.asList(new LMConfig("conf1", (Weighting)new SpeedWeighting((DecimalEncodedValue)speedEnc)), new LMConfig("conf2", (Weighting)new SpeedWeighting((DecimalEncodedValue)speedEnc)));
        List preparations = handler.createPreparations(lmConfigs, new BaseGraph.Builder(em).build(), (EncodedValueLookup)em, null);
        Assertions.assertEquals((double)1.0, (double)((PrepareLandmarks)preparations.get(0)).getLandmarkStorage().getFactor(), (double)0.1);
        Assertions.assertEquals((double)0.3, (double)((PrepareLandmarks)preparations.get(1)).getLandmarkStorage().getFactor(), (double)0.1);
    }

    @Test
    public void testPrepareWeightingNo() {
        GraphHopperConfig ghConfig = new GraphHopperConfig();
        ghConfig.setProfiles(Collections.singletonList(new Profile("profile")));
        ghConfig.setLMProfiles(Collections.singletonList(new LMProfile("profile")));
        LMPreparationHandler handler = new LMPreparationHandler();
        handler.init(ghConfig);
        Assertions.assertTrue((boolean)handler.isEnabled());
        ghConfig.setLMProfiles(Collections.emptyList());
        handler = new LMPreparationHandler();
        handler.init(ghConfig);
        Assertions.assertFalse((boolean)handler.isEnabled());
    }
}

