/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.RoutingAlgorithmTest;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.SplitArea;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RAMDirectory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LandmarkStorageTest {
    private BaseGraph graph;
    private BooleanEncodedValue subnetworkEnc;
    private EncodingManager encodingManager;
    private DecimalEncodedValue speedEnc;

    @BeforeEach
    public void setUp() {
        this.subnetworkEnc = Subnetwork.create((String)"car");
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.encodingManager = new EncodingManager.Builder().add((EncodedValue)this.speedEnc).add((EncodedValue)this.subnetworkEnc).build();
        this.graph = new BaseGraph.Builder(this.encodingManager).create();
    }

    @AfterEach
    public void tearDown() {
        if (this.graph != null) {
            this.graph.close();
        }
    }

    @Test
    public void testInfiniteWeight() {
        RAMDirectory dir = new RAMDirectory();
        this.graph.edge(0, 1);
        LandmarkStorage lms = new LandmarkStorage(this.graph, (EncodedValueLookup)this.encodingManager, (Directory)dir, new LMConfig("car", (Weighting)new SpeedWeighting(this.speedEnc)), 8).setMaximumWeight(65536.0);
        lms.createLandmarks();
        Assertions.assertTrue((boolean)lms.isInfinity(0L));
        Assertions.assertEquals((int)65534, (int)lms.getFromWeight(0, 0));
        lms.setWeight(0L, 65534.0);
        Assertions.assertFalse((boolean)lms.isInfinity(0L));
        Assertions.assertEquals((int)65534, (int)lms.getFromWeight(0, 0));
        lms.setWeight(0L, 2.147483647E9);
        Assertions.assertFalse((boolean)lms.isInfinity(0L));
        Assertions.assertEquals((int)65534, (int)lms.getFromWeight(0, 0));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> lms.setWeight(0L, 2.147483648E9));
    }

    @Test
    public void testSetGetWeight() {
        this.graph.edge(0, 1).set(this.speedEnc, 60.0, 60.0).setDistance(40.1);
        RAMDirectory dir = new RAMDirectory();
        LandmarkStorage lms = new LandmarkStorage(this.graph, (EncodedValueLookup)this.encodingManager, (Directory)dir, new LMConfig("c1", (Weighting)new SpeedWeighting(this.speedEnc)), 4).setMaximumWeight(65536.0);
        lms._getInternalDA().create(2000L);
        lms.setWeight(0L, 65536.0);
        Assertions.assertEquals((int)65534, (int)lms.getFromWeight(0, 0));
        lms.setWeight(0L, 65535.0);
        Assertions.assertEquals((int)65534, (int)lms.getFromWeight(0, 0));
        lms.setWeight(0L, 79999.0);
        Assertions.assertEquals((int)65534, (int)lms.getFromWeight(0, 0));
    }

    @Test
    public void testWithSubnetworks() {
        this.graph.edge(0, 1).setDistance(10.1).set(this.speedEnc, 60.0, 60.0);
        this.graph.edge(1, 2).setDistance(10.2).set(this.speedEnc, 60.0, 60.0);
        this.graph.edge(2, 4).set(this.speedEnc, 0.0, 0.0);
        this.graph.edge(4, 5).setDistance(10.5).set(this.speedEnc, 60.0, 60.0);
        this.graph.edge(5, 6).setDistance(10.6).set(this.speedEnc, 60.0, 0.0);
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        this.subnetworkRemoval((Weighting)weighting, 1);
        LandmarkStorage storage = new LandmarkStorage(this.graph, (EncodedValueLookup)this.encodingManager, (Directory)new RAMDirectory(), new LMConfig("car", (Weighting)weighting), 2);
        storage.setMinimumNodes(2);
        storage.createLandmarks();
        Assertions.assertEquals((int)3, (int)storage.getSubnetworksWithLandmarks());
        Assertions.assertEquals((Object)"[2, 0]", (Object)Arrays.toString(storage.getLandmarks(1)));
        Assertions.assertEquals((Object)"[5, 4]", (Object)Arrays.toString(storage.getLandmarks(2)));
    }

    @Test
    public void testWithStronglyConnectedComponent() {
        this.graph.edge(0, 1).setDistance(10.1).set(this.speedEnc, 60.0, 60.0);
        this.graph.edge(1, 2).setDistance(10.2).set(this.speedEnc, 60.0, 60.0);
        this.graph.edge(2, 3).setDistance(10.3).set(this.speedEnc, 60.0, 0.0);
        this.graph.edge(3, 2).setDistance(10.2).set(this.speedEnc, 60.0, 0.0);
        this.graph.edge(3, 4).setDistance(10.4).set(this.speedEnc, 60.0, 60.0);
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        this.subnetworkRemoval((Weighting)weighting, 4);
        LandmarkStorage storage = new LandmarkStorage(this.graph, (EncodedValueLookup)this.encodingManager, (Directory)new RAMDirectory(), new LMConfig("car", (Weighting)weighting), 2);
        storage.setMinimumNodes(3);
        storage.createLandmarks();
        Assertions.assertEquals((int)2, (int)storage.getSubnetworksWithLandmarks());
        Assertions.assertEquals((Object)"[4, 0]", (Object)Arrays.toString(storage.getLandmarks(1)));
    }

    private void subnetworkRemoval(Weighting weighting, int minNodeSize) {
        new PrepareRoutingSubnetworks(this.graph, Collections.singletonList(new PrepareRoutingSubnetworks.PrepareJob(this.subnetworkEnc, weighting))).setMinNetworkSize(minNodeSize).doWork();
    }

    @Test
    public void testWithOnewaySubnetworks() {
        this.graph.edge(0, 1).setDistance(10.1).set(this.speedEnc, 60.0, 60.0);
        this.graph.edge(1, 2).setDistance(10.2).set(this.speedEnc, 60.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.3).set(this.speedEnc, 60.0, 0.0);
        this.graph.edge(4, 5).setDistance(10.5).set(this.speedEnc, 60.0, 60.0);
        this.graph.edge(5, 2).setDistance(10.2).set(this.speedEnc, 60.0, 0.0);
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        this.subnetworkRemoval((Weighting)weighting, 1);
        LandmarkStorage storage = new LandmarkStorage(this.graph, (EncodedValueLookup)this.encodingManager, (Directory)new RAMDirectory(), new LMConfig("car", (Weighting)weighting), 2);
        storage.setMinimumNodes(2);
        storage.createLandmarks();
        Assertions.assertEquals((int)3, (int)storage.getSubnetworksWithLandmarks());
        Assertions.assertEquals((Object)"[1, 0]", (Object)Arrays.toString(storage.getLandmarks(1)));
        Assertions.assertEquals((Object)"[5, 4]", (Object)Arrays.toString(storage.getLandmarks(2)));
    }

    @Test
    public void testWeightingConsistence1() {
        this.graph.edge(0, 1).setDistance(10.1).set(this.speedEnc, 0.0, 0.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 30.0, 30.0);
        this.graph.edge(2, 3).setDistance(10.1).set(this.speedEnc, 0.0, 0.0);
        LandmarkStorage storage = new LandmarkStorage(this.graph, (EncodedValueLookup)this.encodingManager, (Directory)new RAMDirectory(), new LMConfig("car", (Weighting)new SpeedWeighting(this.speedEnc)), 2);
        storage.setMinimumNodes(2);
        storage.createLandmarks();
        Assertions.assertEquals((int)2, (int)storage.getSubnetworksWithLandmarks());
        Assertions.assertEquals((Object)"[2, 1]", (Object)Arrays.toString(storage.getLandmarks(1)));
    }

    @Test
    public void testWeightingConsistence2() {
        this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 30.0, 30.0);
        this.graph.edge(2, 3).setDistance(10.1).set(this.speedEnc, 0.0, 0.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 30.0, 30.0);
        LandmarkStorage storage = new LandmarkStorage(this.graph, (EncodedValueLookup)this.encodingManager, (Directory)new RAMDirectory(), new LMConfig("car", (Weighting)new SpeedWeighting(this.speedEnc)), 2);
        storage.setMinimumNodes(2);
        storage.createLandmarks();
        Assertions.assertEquals((int)3, (int)storage.getSubnetworksWithLandmarks());
        Assertions.assertEquals((Object)"[1, 0]", (Object)Arrays.toString(storage.getLandmarks(1)));
        Assertions.assertEquals((Object)"[3, 2]", (Object)Arrays.toString(storage.getLandmarks(2)));
    }

    @Test
    public void testWithBorderBlocking() {
        RoutingAlgorithmTest.initBiGraph((Graph)this.graph, this.speedEnc);
        LandmarkStorage storage = new LandmarkStorage(this.graph, (EncodedValueLookup)this.encodingManager, (Directory)new RAMDirectory(), new LMConfig("car", (Weighting)new SpeedWeighting(this.speedEnc)), 2);
        final SplitArea right = new SplitArea(Collections.emptyList());
        final SplitArea left = new SplitArea(Collections.emptyList());
        AreaIndex<SplitArea> areaIndex = new AreaIndex<SplitArea>(Collections.emptyList()){

            public List<SplitArea> query(double lat, double lon) {
                if (lon > 0.00105) {
                    return Collections.singletonList(right);
                }
                return Collections.singletonList(left);
            }
        };
        storage.setAreaIndex((AreaIndex)areaIndex);
        storage.setMinimumNodes(2);
        storage.createLandmarks();
        Assertions.assertEquals((int)3, (int)storage.getSubnetworksWithLandmarks());
    }
}

