/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMRoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PrepareLandmarksTest {
    private DecimalEncodedValue speedEnc;
    private EncodingManager encodingManager;
    private BaseGraph graph;
    private TraversalMode tm;

    @BeforeEach
    public void setUp() {
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        this.encodingManager = new EncodingManager.Builder().add((EncodedValue)this.speedEnc).add((EncodedValue)Subnetwork.create((String)"car")).build();
        this.graph = new BaseGraph.Builder(this.encodingManager).create();
        this.tm = TraversalMode.NODE_BASED;
    }

    @Test
    public void testLandmarkStorageAndRouting() {
        Random rand = new Random(0L);
        int width = 15;
        int height = 15;
        for (int hIndex = 0; hIndex < height; ++hIndex) {
            for (int wIndex = 0; wIndex < width; ++wIndex) {
                int node = wIndex + hIndex * width;
                double speed = 20.0 + rand.nextDouble() * 30.0;
                if (wIndex + 1 < width) {
                    this.graph.edge(node, node + 1).set(this.speedEnc, speed);
                }
                if (hIndex + 1 < height) {
                    this.graph.edge(node, node + width).set(this.speedEnc, speed);
                }
                GHUtility.updateDistancesFor((Graph)this.graph, (int)node, (double[])new double[]{(double)(-hIndex) / 50.0, (double)wIndex / 50.0});
            }
        }
        RAMDirectory dir = new RAMDirectory();
        LocationIndexTree index = new LocationIndexTree((Graph)this.graph, (Directory)dir);
        index.prepareIndex();
        int lm = 5;
        int activeLM = 2;
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        LMConfig lmConfig = new LMConfig("car", (Weighting)weighting);
        LandmarkStorage store = new LandmarkStorage(this.graph, (EncodedValueLookup)this.encodingManager, (Directory)dir, lmConfig, lm);
        store.setMinimumNodes(2);
        store.createLandmarks();
        int[] intList = store.getLandmarks(1);
        Arrays.sort(intList);
        Assertions.assertEquals((Object)"[0, 14, 70, 182, 224]", (Object)Arrays.toString(intList));
        Assertions.assertEquals((int)2, (int)store.getSubnetworksWithLandmarks());
        Assertions.assertEquals((int)0, (int)store.getFromWeight(0, 224));
        double factor = store.getFactor();
        Assertions.assertEquals((long)1297L, (long)Math.round((double)store.getFromWeight(0, 47) * factor));
        Assertions.assertEquals((long)1011L, (long)Math.round((double)store.getFromWeight(0, 52) * factor));
        long weight1_224 = store.getFromWeight(1, 224);
        Assertions.assertEquals((long)1535L, (long)Math.round((double)weight1_224 * factor));
        long weight1_47 = store.getFromWeight(1, 47);
        Assertions.assertEquals((long)256L, (long)Math.round((double)weight1_47 * factor));
        Assertions.assertEquals((long)weight1_224, (long)store.getToWeight(1, 224));
        Assertions.assertEquals((long)weight1_47, (long)store.getToWeight(1, 47));
        int[] activeLandmarkIndices = new int[activeLM];
        Arrays.fill(activeLandmarkIndices, -1);
        store.chooseActiveLandmarks(27, 47, activeLandmarkIndices, false);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int idx : activeLandmarkIndices) {
            list.add(store.getLandmarks(1)[idx]);
        }
        Assertions.assertEquals(Arrays.asList(224, 70), list);
        PrepareLandmarks prepare = new PrepareLandmarks((Directory)new RAMDirectory(), this.graph, (EncodedValueLookup)this.encodingManager, lmConfig, 4);
        prepare.setMinimumNodes(2);
        prepare.doWork();
        LandmarkStorage lms = prepare.getLandmarkStorage();
        AStar expectedAlgo = new AStar((Graph)this.graph, (Weighting)weighting, this.tm);
        Path expectedPath = expectedAlgo.calcPath(41, 183);
        PMap hints = new PMap().putObject("lm.active_landmarks", (Object)2);
        RoutingAlgorithm oneDirAlgoWithLandmarks = new LMRoutingAlgorithmFactory(lms).createAlgo((Graph)this.graph, (Weighting)weighting, new AlgorithmOptions().setAlgorithm("astar").setTraversalMode(this.tm).setHints(hints));
        Path path = oneDirAlgoWithLandmarks.calcPath(41, 183);
        Assertions.assertEquals((double)expectedPath.getWeight(), (double)path.getWeight(), (double)0.1);
        Assertions.assertEquals((Object)expectedPath.calcNodes(), (Object)path.calcNodes());
        Assertions.assertEquals((int)(expectedAlgo.getVisitedNodes() - 136), (int)oneDirAlgoWithLandmarks.getVisitedNodes());
        RoutingAlgorithm biDirAlgoWithLandmarks = new LMRoutingAlgorithmFactory(lms).createAlgo((Graph)this.graph, (Weighting)weighting, new AlgorithmOptions().setAlgorithm("astarbi").setTraversalMode(this.tm).setHints(hints));
        path = biDirAlgoWithLandmarks.calcPath(41, 183);
        Assertions.assertEquals((double)expectedPath.getWeight(), (double)path.getWeight(), (double)0.1);
        Assertions.assertEquals((Object)expectedPath.calcNodes(), (Object)path.calcNodes());
        Assertions.assertEquals((int)(expectedAlgo.getVisitedNodes() - 163), (int)biDirAlgoWithLandmarks.getVisitedNodes());
        Snap fromSnap = index.findClosest(-0.0401, 0.2201, EdgeFilter.ALL_EDGES);
        Snap toSnap = index.findClosest(-0.2401, 0.0601, EdgeFilter.ALL_EDGES);
        QueryGraph qGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)fromSnap, (Snap)toSnap);
        RoutingAlgorithm qGraphOneDirAlgo = new LMRoutingAlgorithmFactory(lms).createAlgo((Graph)qGraph, (Weighting)weighting, new AlgorithmOptions().setAlgorithm("astar").setTraversalMode(this.tm).setHints(hints));
        path = qGraphOneDirAlgo.calcPath(fromSnap.getClosestNode(), toSnap.getClosestNode());
        expectedAlgo = new AStar((Graph)qGraph, (Weighting)weighting, this.tm);
        expectedPath = expectedAlgo.calcPath(fromSnap.getClosestNode(), toSnap.getClosestNode());
        Assertions.assertEquals((double)expectedPath.getWeight(), (double)path.getWeight(), (double)0.1);
        Assertions.assertEquals((Object)expectedPath.calcNodes(), (Object)path.calcNodes());
        Assertions.assertEquals((int)(expectedAlgo.getVisitedNodes() - 136), (int)qGraphOneDirAlgo.getVisitedNodes());
    }

    @Test
    public void testStoreAndLoad() {
        this.graph.edge(0, 1).setDistance(80000.0).set(this.speedEnc, 60.0);
        this.graph.edge(1, 2).setDistance(80000.0).set(this.speedEnc, 60.0);
        String fileStr = "./target/tmp-lm";
        Helper.removeDir((File)new File(fileStr));
        Directory dir = new RAMDirectory(fileStr, true).create();
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        LMConfig lmConfig = new LMConfig("car", (Weighting)weighting);
        PrepareLandmarks plm = new PrepareLandmarks(dir, this.graph, (EncodedValueLookup)this.encodingManager, lmConfig, 2);
        plm.setMinimumNodes(2);
        plm.doWork();
        double expectedFactor = plm.getLandmarkStorage().getFactor();
        Assertions.assertTrue((boolean)plm.getLandmarkStorage().isInitialized());
        Assertions.assertEquals((Object)Arrays.toString(new int[]{2, 0}), (Object)Arrays.toString(plm.getLandmarkStorage().getLandmarks(1)));
        Assertions.assertEquals((long)1333L, (long)Math.round((double)plm.getLandmarkStorage().getFromWeight(0, 1) * expectedFactor));
        dir = new RAMDirectory(fileStr, true);
        plm = new PrepareLandmarks(dir, this.graph, (EncodedValueLookup)this.encodingManager, lmConfig, 2);
        Assertions.assertTrue((boolean)plm.loadExisting());
        Assertions.assertEquals((double)expectedFactor, (double)plm.getLandmarkStorage().getFactor(), (double)1.0E-6);
        Assertions.assertEquals((Object)Arrays.toString(new int[]{2, 0}), (Object)Arrays.toString(plm.getLandmarkStorage().getLandmarks(1)));
        Assertions.assertEquals((long)1333L, (long)Math.round((double)plm.getLandmarkStorage().getFromWeight(0, 1) * expectedFactor));
        Helper.removeDir((File)new File(fileStr));
    }
}

