/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.routing.HeadingResolver;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.ExternalBooleanEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValueImpl;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadClassLink;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryOverlay;
import com.graphhopper.routing.querygraph.QueryOverlayBuilder;
import com.graphhopper.routing.querygraph.VirtualEdgeIterator;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistanceCalcEuclidean;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueryGraphTest {
    private EncodingManager encodingManager;
    private DecimalEncodedValue speedEnc;
    private BaseGraph g;

    @BeforeEach
    public void setUp() {
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).build();
        this.g = new BaseGraph.Builder(this.encodingManager).create();
    }

    @AfterEach
    public void tearDown() {
        this.g.close();
    }

    void initGraph(Graph g) {
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 1.0, 0.0);
        na.setNode(1, 1.0, 2.5);
        na.setNode(2, 0.0, 0.0);
        g.edge(0, 2).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{1.5, 1.0, 1.5, 1.5}));
    }

    @Test
    public void testOneVirtualNode() {
        this.initGraph((Graph)this.g);
        EdgeExplorer expl = this.g.createEdgeExplorer();
        EdgeIterator iter = expl.setBaseNode(2);
        iter.next();
        Snap res = this.createLocationResult(1.0, -1.0, (EdgeIteratorState)iter, 0, Snap.Position.TOWER);
        QueryGraph queryGraph0 = this.lookup(res);
        Assertions.assertEquals((Object)new GHPoint(0.0, 0.0), (Object)res.getSnappedPoint());
        res = this.createLocationResult(1.0, -1.0, (EdgeIteratorState)iter, 1, Snap.Position.TOWER);
        QueryGraph queryGraph1 = this.lookup(res);
        Assertions.assertEquals((Object)new GHPoint(1.0, 0.0), (Object)res.getSnappedPoint());
        iter = expl.setBaseNode(1);
        iter.next();
        res = this.createLocationResult(1.2, 2.7, (EdgeIteratorState)iter, 0, Snap.Position.TOWER);
        QueryGraph queryGraph2 = this.lookup(res);
        Assertions.assertEquals((Object)new GHPoint(1.0, 2.5), (Object)res.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)queryGraph2.getNodes());
        iter = expl.setBaseNode(1);
        iter.next();
        res = this.createLocationResult(2.0, 1.5, (EdgeIteratorState)iter, 1, Snap.Position.PILLAR);
        QueryGraph queryGraph3 = this.lookup(res);
        Assertions.assertEquals((Object)new GHPoint(1.5, 1.5), (Object)res.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)res.getClosestNode());
        Assertions.assertEquals((int)3, (int)this.getPoints((Graph)queryGraph3, 0, 3).size());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph3, 3, 1).size());
        res = this.createLocationResult(2.0, 1.7, (EdgeIteratorState)iter, 1, Snap.Position.PILLAR);
        QueryGraph queryGraph4 = this.lookup(res);
        Assertions.assertEquals((Object)new GHPoint(1.5, 1.5), (Object)res.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)res.getClosestNode());
        Assertions.assertEquals((int)3, (int)this.getPoints((Graph)queryGraph4, 0, 3).size());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph4, 3, 1).size());
        res = this.createLocationResult(1.5, 2.0, (EdgeIteratorState)iter, 0, Snap.Position.EDGE);
        QueryGraph queryGraph5 = this.lookup(res);
        Assertions.assertEquals((Object)new GHPoint(1.300019, 1.899962), (Object)res.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)res.getClosestNode());
        Assertions.assertEquals((int)4, (int)this.getPoints((Graph)queryGraph5, 0, 3).size());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph5, 3, 1).size());
        iter = expl.setBaseNode(2);
        iter.next();
        res = this.createLocationResult(0.5, 0.1, (EdgeIteratorState)iter, 0, Snap.Position.EDGE);
        QueryGraph queryGraph6 = this.lookup(res);
        Assertions.assertEquals((Object)new GHPoint(0.5, 0.0), (Object)res.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)res.getClosestNode());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph6, 0, 3).size());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph6, 3, 2).size());
    }

    @Test
    public void testFillVirtualEdges() {
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 1.0, 0.0);
        na.setNode(1, 1.0, 2.5);
        na.setNode(2, 0.0, 0.0);
        na.setNode(3, 0.0, 1.0);
        this.g.edge(0, 2).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{1.5, 1.0, 1.5, 1.5}));
        this.g.edge(1, 3);
        boolean baseNode = true;
        EdgeIterator iter = this.g.createEdgeExplorer().setBaseNode(1);
        iter.next();
        Snap snap = this.createLocationResult(2.0, 1.7, (EdgeIteratorState)iter, 1, Snap.Position.PILLAR);
        QueryOverlay queryOverlay = QueryOverlayBuilder.build((Graph)this.g, Collections.singletonList(snap));
        IntObjectMap realNodeModifications = queryOverlay.getEdgeChangesAtRealNodes();
        Assertions.assertEquals((int)2, (int)realNodeModifications.size());
        Assertions.assertEquals((Object)"[3->4]", (Object)((QueryOverlay.EdgeChanges)realNodeModifications.get(3)).getAdditionalEdges().toString());
        Assertions.assertEquals((Object)"[2]", (Object)((QueryOverlay.EdgeChanges)realNodeModifications.get(3)).getRemovedEdges().toString());
        Assertions.assertEquals((Object)"[1->4]", (Object)((QueryOverlay.EdgeChanges)realNodeModifications.get(1)).getAdditionalEdges().toString());
        Assertions.assertEquals((Object)"[2]", (Object)((QueryOverlay.EdgeChanges)realNodeModifications.get(1)).getRemovedEdges().toString());
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.g, (Snap)snap);
        EdgeIteratorState state = GHUtility.getEdge((Graph)queryGraph, (int)0, (int)1);
        Assertions.assertEquals((int)4, (int)state.fetchWayGeometry(FetchMode.ALL).size());
        state = GHUtility.getEdge((Graph)queryGraph, (int)4, (int)3);
        Assertions.assertEquals((int)2, (int)state.fetchWayGeometry(FetchMode.ALL).size());
        Assertions.assertEquals((Object)"[1->4, 1 1-0]", (Object)((VirtualEdgeIterator)queryGraph.createEdgeExplorer().setBaseNode(1)).getEdges().toString());
        Assertions.assertEquals((Object)"[3->4]", (Object)((VirtualEdgeIterator)queryGraph.createEdgeExplorer().setBaseNode(3)).getEdges().toString());
    }

    @Test
    public void testMultipleVirtualNodes() {
        this.initGraph((Graph)this.g);
        EdgeIterator iter = this.g.createEdgeExplorer().setBaseNode(1);
        iter.next();
        Snap res1 = this.createLocationResult(2.0, 1.7, (EdgeIteratorState)iter, 1, Snap.Position.PILLAR);
        QueryGraph queryGraph = this.lookup(res1);
        Assertions.assertEquals((Object)new GHPoint(1.5, 1.5), (Object)res1.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)res1.getClosestNode());
        Assertions.assertEquals((int)3, (int)this.getPoints((Graph)queryGraph, 0, 3).size());
        PointList pl = this.getPoints((Graph)queryGraph, 3, 1);
        Assertions.assertEquals((int)2, (int)pl.size());
        Assertions.assertEquals((Object)new GHPoint(1.5, 1.5), (Object)pl.get(0));
        Assertions.assertEquals((Object)new GHPoint(1.0, 2.5), (Object)pl.get(1));
        EdgeIteratorState edge = GHUtility.getEdge((Graph)queryGraph, (int)3, (int)1);
        Assertions.assertNotNull((Object)queryGraph.getEdgeIteratorState(edge.getEdge(), 3));
        Assertions.assertNotNull((Object)queryGraph.getEdgeIteratorState(edge.getEdge(), 1));
        edge = GHUtility.getEdge((Graph)queryGraph, (int)3, (int)0);
        Assertions.assertNotNull((Object)queryGraph.getEdgeIteratorState(edge.getEdge(), 3));
        Assertions.assertNotNull((Object)queryGraph.getEdgeIteratorState(edge.getEdge(), 0));
        iter = this.g.createEdgeExplorer().setBaseNode(1);
        iter.next();
        res1 = this.createLocationResult(2.0, 1.7, (EdgeIteratorState)iter, 1, Snap.Position.PILLAR);
        Snap res2 = this.createLocationResult(1.5, 2.0, (EdgeIteratorState)iter, 0, Snap.Position.EDGE);
        queryGraph = this.lookup(Arrays.asList(res1, res2));
        Assertions.assertEquals((int)4, (int)res2.getClosestNode());
        Assertions.assertEquals((Object)new GHPoint(1.300019, 1.899962), (Object)res2.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)res1.getClosestNode());
        Assertions.assertEquals((Object)new GHPoint(1.5, 1.5), (Object)res1.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)this.getPoints((Graph)queryGraph, 3, 0).size());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph, 3, 4).size());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph, 4, 1).size());
        Assertions.assertNull((Object)GHUtility.getEdge((Graph)queryGraph, (int)4, (int)0));
        Assertions.assertNull((Object)GHUtility.getEdge((Graph)queryGraph, (int)3, (int)1));
    }

    @Test
    public void testOneWay() {
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.0, 1.0);
        this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 0.0);
        EdgeIteratorState edge = GHUtility.getEdge((Graph)this.g, (int)0, (int)1);
        Snap res1 = this.createLocationResult(0.1, 0.1, edge, 0, Snap.Position.EDGE);
        Snap res2 = this.createLocationResult(0.1, 0.9, edge, 0, Snap.Position.EDGE);
        QueryGraph queryGraph = this.lookup(Arrays.asList(res2, res1));
        Assertions.assertEquals((int)2, (int)res1.getClosestNode());
        Assertions.assertEquals((Object)new GHPoint(0.0, 0.1), (Object)res1.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)res2.getClosestNode());
        Assertions.assertEquals((Object)new GHPoint(0.0, 0.9), (Object)res2.getSnappedPoint());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph, 0, 2).size());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph, 2, 3).size());
        Assertions.assertEquals((int)2, (int)this.getPoints((Graph)queryGraph, 3, 1).size());
        Assertions.assertNull((Object)GHUtility.getEdge((Graph)queryGraph, (int)3, (int)0));
        Assertions.assertNull((Object)GHUtility.getEdge((Graph)queryGraph, (int)2, (int)1));
    }

    @Test
    public void testVirtEdges() {
        this.initGraph((Graph)this.g);
        EdgeIterator iter = this.g.createEdgeExplorer().setBaseNode(0);
        iter.next();
        List<EdgeIteratorState> vEdges = Collections.singletonList(iter.detach(false));
        VirtualEdgeIterator vi = new VirtualEdgeIterator(EdgeFilter.ALL_EDGES, vEdges);
        Assertions.assertTrue((boolean)vi.next());
    }

    @Test
    public void testUseMeanElevation() {
        this.g.close();
        this.g = new BaseGraph.Builder(this.encodingManager).set3D(true).create();
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 0.0, 0.0, 0.0);
        na.setNode(1, 0.0, 1.0E-4, 20.0);
        EdgeIteratorState edge = this.g.edge(0, 1);
        EdgeIteratorState edgeReverse = edge.detach(true);
        DistanceCalcEuclidean distCalc = new DistanceCalcEuclidean();
        Snap snap = new Snap(0.0, 5.0E-5);
        snap.setClosestEdge(edge);
        snap.setWayIndex(0);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.calcSnappedPoint((DistanceCalc)distCalc);
        Assertions.assertEquals((double)10.0, (double)snap.getSnappedPoint().getEle(), (double)0.1);
        snap = new Snap(0.0, 5.0E-5);
        snap.setClosestEdge(edgeReverse);
        snap.setWayIndex(0);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.calcSnappedPoint((DistanceCalc)distCalc);
        Assertions.assertEquals((double)10.0, (double)snap.getSnappedPoint().getEle(), (double)0.1);
    }

    @Test
    public void testLoopStreet_Issue151() {
        this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(1, 3).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        this.g.edge(3, 4).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        EdgeIteratorState edge = this.g.edge(1, 3).setDistance(20.0).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{-0.001, 0.001, -0.001, 0.002}));
        GHUtility.updateDistancesFor((Graph)this.g, (int)0, (double[])new double[]{0.0, 0.0});
        GHUtility.updateDistancesFor((Graph)this.g, (int)1, (double[])new double[]{0.0, 0.001});
        GHUtility.updateDistancesFor((Graph)this.g, (int)3, (double[])new double[]{0.0, 0.002});
        GHUtility.updateDistancesFor((Graph)this.g, (int)4, (double[])new double[]{0.0, 0.003});
        Snap snap = new Snap(-5.0E-4, 0.001);
        snap.setClosestEdge(edge);
        snap.setWayIndex(1);
        snap.calcSnappedPoint((DistanceCalc)new DistanceCalcEuclidean());
        QueryGraph qg = this.lookup(snap);
        EdgeExplorer ee = qg.createEdgeExplorer();
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{0, 5, 3}), (Object)GHUtility.getNeighbors((EdgeIterator)ee.setBaseNode(1)));
    }

    @Test
    public void testEdgesShareOneNode() {
        this.initGraph((Graph)this.g);
        EdgeIteratorState iter = GHUtility.getEdge((Graph)this.g, (int)0, (int)2);
        Snap res1 = this.createLocationResult(0.5, 0.0, iter, 0, Snap.Position.EDGE);
        iter = GHUtility.getEdge((Graph)this.g, (int)1, (int)0);
        Snap res2 = this.createLocationResult(1.5, 2.0, iter, 0, Snap.Position.EDGE);
        QueryGraph queryGraph = this.lookup(Arrays.asList(res1, res2));
        Assertions.assertEquals((Object)new GHPoint(0.5, 0.0), (Object)res1.getSnappedPoint());
        Assertions.assertEquals((Object)new GHPoint(1.300019, 1.899962), (Object)res2.getSnappedPoint());
        Assertions.assertNotNull((Object)GHUtility.getEdge((Graph)queryGraph, (int)0, (int)4));
        Assertions.assertNotNull((Object)GHUtility.getEdge((Graph)queryGraph, (int)0, (int)3));
    }

    @Test
    public void testAvoidDuplicateVirtualNodesIfIdentical() {
        this.initGraph((Graph)this.g);
        EdgeIteratorState edgeState = GHUtility.getEdge((Graph)this.g, (int)0, (int)2);
        Snap res1 = this.createLocationResult(0.5, 0.0, edgeState, 0, Snap.Position.EDGE);
        Snap res2 = this.createLocationResult(0.5, 0.0, edgeState, 0, Snap.Position.EDGE);
        this.lookup(Arrays.asList(res1, res2));
        Assertions.assertEquals((Object)new GHPoint(0.5, 0.0), (Object)res1.getSnappedPoint());
        Assertions.assertEquals((Object)new GHPoint(0.5, 0.0), (Object)res2.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)res1.getClosestNode());
        Assertions.assertEquals((int)3, (int)res2.getClosestNode());
        edgeState = GHUtility.getEdge((Graph)this.g, (int)0, (int)1);
        res1 = this.createLocationResult(1.0, 0.0, edgeState, 0, Snap.Position.TOWER);
        edgeState = GHUtility.getEdge((Graph)this.g, (int)0, (int)2);
        res2 = this.createLocationResult(0.5, 0.0, edgeState, 0, Snap.Position.EDGE);
        QueryGraph queryGraph = this.lookup(Arrays.asList(res1, res2));
        Assertions.assertEquals((int)queryGraph.getNodes(), (int)(this.g.getNodes() + 1));
        EdgeIterator iter = queryGraph.createEdgeExplorer().setBaseNode(0);
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{1, 3}), (Object)GHUtility.getNeighbors((EdgeIterator)iter));
    }

    @Test
    void towerSnapWhenCrossingPointIsOnEdgeButCloseToTower() {
        this.g.getNodeAccess().setNode(0, 49.0, 11.001);
        this.g.getNodeAccess().setNode(1, 49.0, 11.002);
        this.g.getNodeAccess().setNode(2, 49.0003, 11.002);
        this.g.edge(0, 1);
        this.g.edge(1, 2);
        LocationIndexTree locationIndex = new LocationIndexTree((Graph)this.g, (Directory)new RAMDirectory());
        locationIndex.prepareIndex();
        Snap snap = locationIndex.findClosest(49.000001, 11.008, EdgeFilter.ALL_EDGES);
        Assertions.assertEquals((Object)Snap.Position.TOWER, (Object)snap.getSnappedPosition());
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.g, (Snap)snap);
        Assertions.assertEquals((int)this.g.getNodes(), (int)queryGraph.getNodes());
    }

    @Test
    public void testGetEdgeProps() {
        this.initGraph((Graph)this.g);
        EdgeIteratorState e1 = GHUtility.getEdge((Graph)this.g, (int)0, (int)2);
        Snap res1 = this.createLocationResult(0.5, 0.0, e1, 0, Snap.Position.EDGE);
        QueryGraph queryGraph = this.lookup(res1);
        e1 = GHUtility.getEdge((Graph)queryGraph, (int)res1.getClosestNode(), (int)0);
        EdgeIteratorState e2 = queryGraph.getEdgeIteratorState(e1.getEdge(), Integer.MIN_VALUE);
        Assertions.assertEquals((int)e1.getEdge(), (int)e2.getEdge());
    }

    PointList getPoints(Graph g, int base, int adj) {
        EdgeIteratorState edge = GHUtility.getEdge((Graph)g, (int)base, (int)adj);
        if (edge == null) {
            throw new IllegalStateException("edge " + base + "-" + adj + " not found");
        }
        return edge.fetchWayGeometry(FetchMode.ALL);
    }

    public Snap createLocationResult(double lat, double lon, EdgeIteratorState edge, int wayIndex, Snap.Position pos) {
        if (edge == null) {
            throw new IllegalStateException("Specify edge != null");
        }
        Snap tmp = new Snap(lat, lon);
        tmp.setClosestEdge(edge);
        tmp.setWayIndex(wayIndex);
        tmp.setSnappedPosition(pos);
        tmp.calcSnappedPoint((DistanceCalc)new DistanceCalcEarth());
        return tmp;
    }

    @Test
    public void testIteration_Issue163() {
        EdgeFilter inEdgeFilter = edge -> edge.getReverse(this.speedEnc) > 0.0;
        EdgeFilter outEdgeFilter = edge -> edge.get(this.speedEnc) > 0.0;
        EdgeExplorer inExplorer = this.g.createEdgeExplorer(inEdgeFilter);
        EdgeExplorer outExplorer = this.g.createEdgeExplorer(outEdgeFilter);
        int nodeA = 0;
        int nodeB = 1;
        this.g.getNodeAccess().setNode(nodeA, 1.0, 0.0);
        this.g.getNodeAccess().setNode(nodeB, 1.0, 10.0);
        this.g.edge(nodeA, nodeB).setDistance(10.0).set(this.speedEnc, 60.0, 0.0).setWayGeometry(Helper.createPointList((double[])new double[]{1.5, 3.0, 1.5, 7.0}));
        this.assertEdgeIdsStayingEqual(inExplorer, outExplorer, nodeA, nodeB);
        EdgeIteratorState it = GHUtility.getEdge((Graph)this.g, (int)nodeA, (int)nodeB);
        Snap snap1 = this.createLocationResult(1.5, 3.0, it, 1, Snap.Position.PILLAR);
        Snap snap2 = this.createLocationResult(1.5, 7.0, it, 2, Snap.Position.PILLAR);
        QueryGraph q = this.lookup(Arrays.asList(snap1, snap2));
        int nodeC = snap1.getClosestNode();
        int nodeD = snap2.getClosestNode();
        inExplorer = q.createEdgeExplorer(inEdgeFilter);
        outExplorer = q.createEdgeExplorer(outEdgeFilter);
        this.assertEdgeIdsStayingEqual(inExplorer, outExplorer, nodeA, nodeC);
        this.assertEdgeIdsStayingEqual(inExplorer, outExplorer, nodeC, nodeD);
        this.assertEdgeIdsStayingEqual(inExplorer, outExplorer, nodeD, nodeB);
    }

    private void assertEdgeIdsStayingEqual(EdgeExplorer inExplorer, EdgeExplorer outExplorer, int startNode, int endNode) {
        EdgeIterator it = outExplorer.setBaseNode(startNode);
        it.next();
        Assertions.assertEquals((int)startNode, (int)it.getBaseNode());
        Assertions.assertEquals((int)endNode, (int)it.getAdjNode());
        int expectedEdgeId = it.getEdge();
        Assertions.assertFalse((boolean)it.next());
        it = inExplorer.setBaseNode(endNode);
        it.next();
        Assertions.assertEquals((int)endNode, (int)it.getBaseNode());
        Assertions.assertEquals((int)startNode, (int)it.getAdjNode());
        Assertions.assertEquals((int)expectedEdgeId, (int)it.getEdge(), (String)"The edge id is not the same,");
        Assertions.assertFalse((boolean)it.next());
    }

    @Test
    public void testTurnCostsProperlyPropagated_Issue282() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        DecimalEncodedValue turnCostEnc = TurnCost.create((String)"car", (int)15);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).addTurnCostEncodedValue((EncodedValue)turnCostEnc).build();
        BaseGraph graphWithTurnCosts = new BaseGraph.Builder(em).withTurnCosts(true).create();
        TurnCostStorage turnExt = graphWithTurnCosts.getTurnCostStorage();
        NodeAccess na = graphWithTurnCosts.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.0, 0.01);
        na.setNode(2, 0.01, 0.01);
        EdgeIteratorState edge0 = graphWithTurnCosts.edge(0, 1).setDistance(10.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        EdgeIteratorState edge1 = graphWithTurnCosts.edge(2, 1).setDistance(10.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc, turnCostEnc, graphWithTurnCosts.getTurnCostStorage(), Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)0.0, (double)weighting.calcTurnWeight(edge0.getEdge(), 1, edge1.getEdge()), (double)0.1);
        turnExt.set(turnCostEnc, edge0.getEdge(), 1, edge1.getEdge(), 10.0);
        Assertions.assertEquals((double)10.0, (double)weighting.calcTurnWeight(edge0.getEdge(), 1, edge1.getEdge()), (double)0.1);
        Snap res1 = this.createLocationResult(0.0, 0.005, edge0, 0, Snap.Position.EDGE);
        Snap res2 = this.createLocationResult(0.005, 0.01, edge1, 0, Snap.Position.EDGE);
        QueryGraph qGraph = QueryGraph.create((BaseGraph)graphWithTurnCosts, (Snap)res1, (Snap)res2);
        weighting = qGraph.wrapWeighting((Weighting)weighting);
        int fromQueryEdge = GHUtility.getEdge((Graph)qGraph, (int)res1.getClosestNode(), (int)1).getEdge();
        int toQueryEdge = GHUtility.getEdge((Graph)qGraph, (int)res2.getClosestNode(), (int)1).getEdge();
        Assertions.assertEquals((double)10.0, (double)weighting.calcTurnWeight(fromQueryEdge, 1, toQueryEdge), (double)0.1);
        graphWithTurnCosts.close();
    }

    private Snap fakeEdgeSnap(EdgeIteratorState edge, double lat, double lon, int wayIndex) {
        Snap snap = new Snap(lat, lon);
        snap.setClosestEdge(edge);
        snap.setWayIndex(wayIndex);
        snap.setSnappedPosition(Snap.Position.EDGE);
        snap.calcSnappedPoint((DistanceCalc)new DistanceCalcEuclidean());
        return snap;
    }

    private boolean isAvoidEdge(EdgeIteratorState edge) {
        return edge.get(EdgeIteratorState.UNFAVORED_EDGE);
    }

    @Test
    public void testEnforceHeading() {
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.0, 2.0);
        this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{2.0, 0.0, 2.0, 2.0}));
        EdgeIteratorState edge = GHUtility.getEdge((Graph)this.g, (int)0, (int)1);
        Snap snap = this.fakeEdgeSnap(edge, 1.5, 0.0, 0);
        QueryGraph queryGraph = this.lookup(snap);
        HeadingResolver headingResolver = new HeadingResolver((Graph)queryGraph);
        IntArrayList unfavoredEdges = headingResolver.getEdgesWithDifferentHeading(snap.getClosestNode(), 0.0);
        queryGraph.unfavorVirtualEdges(unfavoredEdges);
        boolean expect = true;
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(1, 2)));
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(1, 0)));
        queryGraph.clearUnfavoredStatus();
        expect = false;
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(1, 2)));
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(1, 0)));
        unfavoredEdges = headingResolver.getEdgesWithDifferentHeading(snap.getClosestNode(), 180.0);
        queryGraph.unfavorVirtualEdges(unfavoredEdges);
        expect = true;
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(2, 1)));
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(2, 2)));
        snap = this.fakeEdgeSnap(edge, 1.5, 2.0, 2);
        queryGraph = this.lookup(Arrays.asList(snap));
        unfavoredEdges = headingResolver.getEdgesWithDifferentHeading(snap.getClosestNode(), 180.0);
        queryGraph.unfavorVirtualEdges(unfavoredEdges);
        expect = true;
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(2, 1)));
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(2, 2)));
        queryGraph.clearUnfavoredStatus();
        unfavoredEdges = headingResolver.getEdgesWithDifferentHeading(snap.getClosestNode(), 0.0);
        queryGraph.unfavorVirtualEdges(unfavoredEdges);
        expect = true;
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(1, 0)));
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge(queryGraph.getEdgeIteratorState(1, 2)));
    }

    @Test
    public void testUnfavoredEdgeDirections() {
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.0, 2.0);
        EdgeIteratorState edge = this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        Snap snap = this.fakeEdgeSnap(edge, 0.0, 1.0, 0);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.g, (Snap)snap);
        queryGraph.unfavorVirtualEdge(1);
        Assertions.assertTrue((boolean)GHUtility.getEdge((Graph)queryGraph, (int)2, (int)0).get(EdgeIteratorState.UNFAVORED_EDGE));
        Assertions.assertTrue((boolean)GHUtility.getEdge((Graph)queryGraph, (int)2, (int)0).getReverse(EdgeIteratorState.UNFAVORED_EDGE));
        Assertions.assertTrue((boolean)GHUtility.getEdge((Graph)queryGraph, (int)0, (int)2).get(EdgeIteratorState.UNFAVORED_EDGE));
        Assertions.assertTrue((boolean)GHUtility.getEdge((Graph)queryGraph, (int)0, (int)2).getReverse(EdgeIteratorState.UNFAVORED_EDGE));
        Assertions.assertFalse((boolean)GHUtility.getEdge((Graph)queryGraph, (int)2, (int)1).get(EdgeIteratorState.UNFAVORED_EDGE));
        Assertions.assertFalse((boolean)GHUtility.getEdge((Graph)queryGraph, (int)2, (int)1).getReverse(EdgeIteratorState.UNFAVORED_EDGE));
        Assertions.assertFalse((boolean)GHUtility.getEdge((Graph)queryGraph, (int)1, (int)2).get(EdgeIteratorState.UNFAVORED_EDGE));
        Assertions.assertFalse((boolean)GHUtility.getEdge((Graph)queryGraph, (int)1, (int)2).getReverse(EdgeIteratorState.UNFAVORED_EDGE));
    }

    @Test
    public void testUnfavorVirtualEdgePair() {
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.0, 2.0);
        this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{2.0, 0.0, 2.0, 2.0}));
        EdgeIteratorState edge = GHUtility.getEdge((Graph)this.g, (int)0, (int)1);
        Snap snap = this.fakeEdgeSnap(edge, 1.5, 0.0, 0);
        QueryGraph queryGraph = this.lookup(snap);
        queryGraph.unfavorVirtualEdge(1);
        VirtualEdgeIteratorState incomingEdge = (VirtualEdgeIteratorState)queryGraph.getEdgeIteratorState(1, 2);
        VirtualEdgeIteratorState incomingEdgeReverse = (VirtualEdgeIteratorState)queryGraph.getEdgeIteratorState(1, incomingEdge.getBaseNode());
        boolean expect = true;
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge((EdgeIteratorState)incomingEdge));
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge((EdgeIteratorState)incomingEdgeReverse));
        Assertions.assertEquals(new LinkedHashSet<VirtualEdgeIteratorState>(Arrays.asList(incomingEdge, incomingEdgeReverse)), (Object)queryGraph.getUnfavoredVirtualEdges());
        queryGraph.clearUnfavoredStatus();
        expect = false;
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge((EdgeIteratorState)incomingEdge));
        Assertions.assertEquals((Object)expect, (Object)this.isAvoidEdge((EdgeIteratorState)incomingEdgeReverse));
        Assertions.assertEquals(new LinkedHashSet(), (Object)queryGraph.getUnfavoredVirtualEdges());
    }

    @Test
    public void testInternalAPIOriginalEdgeKey() {
        this.initGraph((Graph)this.g);
        EdgeExplorer explorer = this.g.createEdgeExplorer();
        EdgeIterator iter = explorer.setBaseNode(1);
        Assertions.assertTrue((boolean)iter.next());
        Snap res = this.createLocationResult(2.0, 1.5, (EdgeIteratorState)iter, 1, Snap.Position.PILLAR);
        QueryGraph queryGraph = this.lookup(res);
        Assertions.assertEquals((Object)new GHPoint(1.5, 1.5), (Object)res.getSnappedPoint());
        Assertions.assertEquals((int)3, (int)res.getClosestNode());
        EdgeExplorer qGraphExplorer = queryGraph.createEdgeExplorer();
        iter = qGraphExplorer.setBaseNode(3);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)2, (int)iter.getEdge());
        Assertions.assertEquals((int)0, (int)iter.getAdjNode());
        Assertions.assertEquals((int)3, (int)((VirtualEdgeIteratorState)queryGraph.getEdgeIteratorState(iter.getEdge(), 0)).getOriginalEdgeKey());
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)3, (int)iter.getEdge());
        Assertions.assertEquals((int)1, (int)iter.getAdjNode());
        Assertions.assertEquals((int)2, (int)((VirtualEdgeIteratorState)queryGraph.getEdgeIteratorState(iter.getEdge(), 1)).getOriginalEdgeKey());
    }

    @Test
    public void testWayGeometry_edge() {
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.3, 0.3);
        this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{0.1, 0.1, 0.2, 0.2}));
        LocationIndexTree locationIndex = new LocationIndexTree((Graph)this.g, (Directory)new RAMDirectory());
        locationIndex.prepareIndex();
        Snap snap = locationIndex.findClosest(0.15, 0.15, EdgeFilter.ALL_EDGES);
        Assertions.assertTrue((boolean)snap.isValid());
        Assertions.assertEquals((Object)Snap.Position.EDGE, (Object)snap.getSnappedPosition(), (String)"this test was supposed to test the Position.EDGE case");
        QueryGraph queryGraph = this.lookup(snap);
        EdgeIterator iter = queryGraph.createEdgeExplorer().setBaseNode(snap.getClosestNode());
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)0, (int)iter.getAdjNode());
        Assertions.assertEquals((int)1, (int)iter.fetchWayGeometry(FetchMode.PILLAR_ONLY).size());
        Assertions.assertEquals((int)2, (int)iter.fetchWayGeometry(FetchMode.BASE_AND_PILLAR).size());
        Assertions.assertEquals((int)2, (int)iter.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ).size());
        Assertions.assertEquals((int)3, (int)iter.fetchWayGeometry(FetchMode.ALL).size());
        Assertions.assertEquals((Object)Helper.createPointList((double[])new double[]{0.15, 0.15, 0.1, 0.1, 0.0, 0.0}), (Object)iter.fetchWayGeometry(FetchMode.ALL));
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)1, (int)iter.getAdjNode());
        Assertions.assertEquals((int)1, (int)iter.fetchWayGeometry(FetchMode.PILLAR_ONLY).size());
        Assertions.assertEquals((int)2, (int)iter.fetchWayGeometry(FetchMode.BASE_AND_PILLAR).size());
        Assertions.assertEquals((int)2, (int)iter.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ).size());
        Assertions.assertEquals((int)3, (int)iter.fetchWayGeometry(FetchMode.ALL).size());
        Assertions.assertEquals((Object)Helper.createPointList((double[])new double[]{0.15, 0.15, 0.2, 0.2, 0.3, 0.3}), (Object)iter.fetchWayGeometry(FetchMode.ALL));
        Assertions.assertFalse((boolean)iter.next());
    }

    @Test
    public void testWayGeometry_pillar() {
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.5, 0.1);
        this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{0.1, 0.1, 0.2, 0.2}));
        LocationIndexTree locationIndex = new LocationIndexTree((Graph)this.g, (Directory)new RAMDirectory());
        locationIndex.prepareIndex();
        Snap snap = locationIndex.findClosest(0.2, 0.21, EdgeFilter.ALL_EDGES);
        Assertions.assertTrue((boolean)snap.isValid());
        Assertions.assertEquals((Object)Snap.Position.PILLAR, (Object)snap.getSnappedPosition(), (String)"this test was supposed to test the Position.PILLAR case");
        QueryGraph queryGraph = this.lookup(snap);
        EdgeIterator iter = queryGraph.createEdgeExplorer().setBaseNode(snap.getClosestNode());
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)0, (int)iter.getAdjNode());
        Assertions.assertEquals((int)1, (int)iter.fetchWayGeometry(FetchMode.PILLAR_ONLY).size());
        Assertions.assertEquals((int)2, (int)iter.fetchWayGeometry(FetchMode.BASE_AND_PILLAR).size());
        Assertions.assertEquals((int)2, (int)iter.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ).size());
        Assertions.assertEquals((int)3, (int)iter.fetchWayGeometry(FetchMode.ALL).size());
        Assertions.assertEquals((Object)Helper.createPointList((double[])new double[]{0.2, 0.2, 0.1, 0.1, 0.0, 0.0}), (Object)iter.fetchWayGeometry(FetchMode.ALL));
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)1, (int)iter.getAdjNode());
        Assertions.assertEquals((int)0, (int)iter.fetchWayGeometry(FetchMode.PILLAR_ONLY).size());
        Assertions.assertEquals((int)1, (int)iter.fetchWayGeometry(FetchMode.BASE_AND_PILLAR).size());
        Assertions.assertEquals((int)1, (int)iter.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ).size());
        Assertions.assertEquals((int)2, (int)iter.fetchWayGeometry(FetchMode.ALL).size());
        Assertions.assertEquals((Object)Helper.createPointList((double[])new double[]{0.2, 0.2, 0.5, 0.1}), (Object)iter.fetchWayGeometry(FetchMode.ALL));
        Assertions.assertFalse((boolean)iter.next());
    }

    @Test
    public void testVirtualEdgeDistance() {
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 0.0, 0.0);
        na.setNode(1, 0.0, 1.0);
        na.setNode(2, 2.0, 2.0);
        DistancePlaneProjection distCalc = DistancePlaneProjection.DIST_PLANE;
        double dist = 0.0;
        dist += distCalc.calcDist(0.0, 0.0, 1.0, 0.0);
        dist += distCalc.calcDist(1.0, 0.0, 1.0, 1.0);
        this.g.edge(0, 1).setDistance(dist += distCalc.calcDist(1.0, 1.0, 0.0, 1.0)).set(this.speedEnc, 60.0, 60.0).setWayGeometry(Helper.createPointList((double[])new double[]{1.0, 0.0, 1.0, 1.0}));
        LocationIndexTree index = new LocationIndexTree((Graph)this.g, (Directory)new RAMDirectory());
        index.prepareIndex();
        Snap snap = index.findClosest(1.01, 0.7, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = this.lookup(snap);
        EdgeIterator iter = queryGraph.createEdgeExplorer().setBaseNode(3);
        double virtualEdgeDistanceSum = 0.0;
        while (iter.next()) {
            virtualEdgeDistanceSum += iter.getDistance();
        }
        double directDist = this.g.getEdgeIteratorState(0, 1).getDistance();
        Assertions.assertEquals((double)directDist, (double)virtualEdgeDistanceSum, (double)0.001);
    }

    @Test
    public void testVirtualEdgeIds() {
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph g = new BaseGraph.Builder(em).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 50.0, 10.1);
        na.setNode(1, 50.0, 10.2);
        double dist = DistanceCalcEarth.DIST_EARTH.calcDist(na.getLat(0), na.getLon(0), na.getLat(1), na.getLon(1));
        EdgeIteratorState edge = g.edge(0, 1).setDistance(dist).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        edge.set((DecimalEncodedValue)speedEnc, 50.0);
        edge.setReverse((DecimalEncodedValue)speedEnc, 100.0);
        Snap snap = this.createLocationResult(50.0, 10.15, edge, 0, Snap.Position.EDGE);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)g, (Snap)snap);
        Assertions.assertEquals((int)3, (int)queryGraph.getNodes());
        Assertions.assertEquals((int)3, (int)queryGraph.getEdges());
        Assertions.assertEquals((int)4, (int)queryGraph.getVirtualEdges().size());
        EdgeIteratorState edge_0x = queryGraph.getEdgeIteratorState(1, 2);
        EdgeIteratorState edge_x0 = queryGraph.getEdgeIteratorState(1, 0);
        EdgeIteratorState edge_x1 = queryGraph.getEdgeIteratorState(2, 1);
        EdgeIteratorState edge_1x = queryGraph.getEdgeIteratorState(2, 2);
        this.assertNodes(edge_0x, 0, 2);
        this.assertNodes(edge_x0, 2, 0);
        this.assertNodes(edge_x1, 2, 1);
        this.assertNodes(edge_1x, 1, 2);
        Assertions.assertEquals((int)1, (int)edge_0x.getEdge());
        Assertions.assertEquals((int)1, (int)edge_x0.getEdge());
        Assertions.assertEquals((int)2, (int)edge_x1.getEdge());
        Assertions.assertEquals((int)2, (int)edge_1x.getEdge());
        Assertions.assertEquals((int)2, (int)edge_0x.getEdgeKey());
        Assertions.assertEquals((int)3, (int)edge_x0.getEdgeKey());
        Assertions.assertEquals((int)4, (int)edge_x1.getEdgeKey());
        Assertions.assertEquals((int)5, (int)edge_1x.getEdgeKey());
        this.assertNodes(queryGraph.getEdgeIteratorStateForKey(2), 0, 2);
        this.assertNodes(queryGraph.getEdgeIteratorStateForKey(3), 2, 0);
        this.assertNodes(queryGraph.getEdgeIteratorStateForKey(4), 2, 1);
        this.assertNodes(queryGraph.getEdgeIteratorStateForKey(5), 1, 2);
        Assertions.assertSame(queryGraph.getVirtualEdges().get(0), (Object)edge_0x);
        Assertions.assertSame(queryGraph.getVirtualEdges().get(1), (Object)edge_x0);
        Assertions.assertSame(queryGraph.getVirtualEdges().get(2), (Object)edge_x1);
        Assertions.assertSame(queryGraph.getVirtualEdges().get(3), (Object)edge_1x);
        for (EdgeIteratorState e : Arrays.asList(edge_0x, edge_x1)) {
            Assertions.assertEquals((double)50.0, (double)e.get((DecimalEncodedValue)speedEnc), (double)1.0E-6);
            Assertions.assertEquals((double)100.0, (double)e.getReverse((DecimalEncodedValue)speedEnc), (double)1.0E-6);
        }
        for (EdgeIteratorState e : Arrays.asList(edge_x0, edge_1x)) {
            Assertions.assertEquals((double)100.0, (double)e.get((DecimalEncodedValue)speedEnc), (double)1.0E-6);
            Assertions.assertEquals((double)50.0, (double)e.getReverse((DecimalEncodedValue)speedEnc), (double)1.0E-6);
        }
        try {
            queryGraph.getEdgeIteratorState(3, 2);
            Assertions.fail((String)"there should be an error");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testVirtualEdgeIds_reverse() {
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph g = new BaseGraph.Builder(em).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 50.0, 10.1);
        na.setNode(1, 50.0, 10.2);
        double dist = DistanceCalcEarth.DIST_EARTH.calcDist(na.getLat(0), na.getLon(0), na.getLat(1), na.getLon(1));
        EdgeIteratorState edge = g.edge(1, 0).setDistance(dist).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        edge.set((DecimalEncodedValue)speedEnc, 100.0, 50.0);
        Snap snap = this.createLocationResult(50.0, 10.15, edge, 0, Snap.Position.EDGE);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)g, (Snap)snap);
        Assertions.assertEquals((int)3, (int)queryGraph.getNodes());
        Assertions.assertEquals((int)3, (int)queryGraph.getEdges());
        Assertions.assertEquals((int)4, (int)queryGraph.getVirtualEdges().size());
        EdgeIteratorState edge_0x = queryGraph.getEdgeIteratorState(1, 2);
        EdgeIteratorState edge_x0 = queryGraph.getEdgeIteratorState(1, 0);
        EdgeIteratorState edge_x1 = queryGraph.getEdgeIteratorState(2, 1);
        EdgeIteratorState edge_1x = queryGraph.getEdgeIteratorState(2, 2);
        this.assertNodes(edge_0x, 0, 2);
        this.assertNodes(edge_x0, 2, 0);
        this.assertNodes(edge_x1, 2, 1);
        this.assertNodes(edge_1x, 1, 2);
        Assertions.assertEquals((int)1, (int)edge_0x.getEdge());
        Assertions.assertEquals((int)1, (int)edge_x0.getEdge());
        Assertions.assertEquals((int)2, (int)edge_x1.getEdge());
        Assertions.assertEquals((int)2, (int)edge_1x.getEdge());
        Assertions.assertEquals((int)2, (int)edge_0x.getEdgeKey());
        Assertions.assertEquals((int)3, (int)edge_x0.getEdgeKey());
        Assertions.assertEquals((int)4, (int)edge_x1.getEdgeKey());
        Assertions.assertEquals((int)5, (int)edge_1x.getEdgeKey());
        this.assertNodes(queryGraph.getEdgeIteratorStateForKey(2), 0, 2);
        this.assertNodes(queryGraph.getEdgeIteratorStateForKey(3), 2, 0);
        this.assertNodes(queryGraph.getEdgeIteratorStateForKey(4), 2, 1);
        this.assertNodes(queryGraph.getEdgeIteratorStateForKey(5), 1, 2);
        Assertions.assertSame(queryGraph.getVirtualEdges().get(0), (Object)edge_0x);
        Assertions.assertSame(queryGraph.getVirtualEdges().get(1), (Object)edge_x0);
        Assertions.assertSame(queryGraph.getVirtualEdges().get(2), (Object)edge_x1);
        Assertions.assertSame(queryGraph.getVirtualEdges().get(3), (Object)edge_1x);
        for (EdgeIteratorState e : Arrays.asList(edge_0x, edge_x1)) {
            Assertions.assertEquals((double)50.0, (double)e.get((DecimalEncodedValue)speedEnc), (double)1.0E-6);
            Assertions.assertEquals((double)100.0, (double)e.getReverse((DecimalEncodedValue)speedEnc), (double)1.0E-6);
        }
        for (EdgeIteratorState e : Arrays.asList(edge_x0, edge_1x)) {
            Assertions.assertEquals((double)100.0, (double)e.get((DecimalEncodedValue)speedEnc), (double)1.0E-6);
            Assertions.assertEquals((double)50.0, (double)e.getReverse((DecimalEncodedValue)speedEnc), (double)1.0E-6);
        }
        try {
            queryGraph.getEdgeIteratorState(3, 2);
            Assertions.fail((String)"there should be an error");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void assertNodes(EdgeIteratorState edge, int base, int adj) {
        Assertions.assertEquals((int)base, (int)edge.getBaseNode());
        Assertions.assertEquals((int)adj, (int)edge.getAdjNode());
    }

    @Test
    public void testTotalEdgeCount() {
        BaseGraph g = new BaseGraph.Builder(1).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 50.0, 10.0);
        na.setNode(1, 50.0, 10.3);
        g.edge(0, 1);
        LocationIndexTree locationIndex = new LocationIndexTree((Graph)g, g.getDirectory());
        locationIndex.prepareIndex();
        Snap snap1 = locationIndex.findClosest(50.0, 10.1, EdgeFilter.ALL_EDGES);
        Snap snap2 = locationIndex.findClosest(50.0, 10.2, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)g, (Snap)snap1, (Snap)snap2);
        Assertions.assertEquals((int)4, (int)queryGraph.getNodes());
        Assertions.assertEquals((int)8, (int)queryGraph.getVirtualEdges().size());
        Assertions.assertEquals((int)5, (int)queryGraph.getEdges());
        Assertions.assertEquals((Object)"[1],[4],[1, 2],[2, 4]", (Object)IntStream.range(0, queryGraph.getNodes()).mapToObj(i -> GHUtility.getEdgeIds((EdgeIterator)queryGraph.createEdgeExplorer().setBaseNode(i)).toString()).collect(Collectors.joining(",")));
        Assertions.assertEquals((Object)"0 0-1,0->2,2->3,2->3,3->1", (Object)IntStream.range(0, queryGraph.getEdges()).mapToObj(i -> queryGraph.getEdgeIteratorState(i, Integer.MIN_VALUE).toString()).collect(Collectors.joining(",")));
    }

    @Test
    public void testExternalEV() {
        IntEncodedValueImpl intEnc = new IntEncodedValueImpl("my_int", 3, true);
        EnumEncodedValue enumEnc = RoadClass.create();
        BooleanEncodedValue roadClassLincEnc = RoadClassLink.create();
        ExternalBooleanEncodedValue externalEnc = new ExternalBooleanEncodedValue("my_ext", true);
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)intEnc).add((EncodedValue)enumEnc).add((EncodedValue)roadClassLincEnc).add((EncodedValue)externalEnc).build();
        BaseGraph g = new BaseGraph.Builder(encodingManager).create();
        g.edge(0, 1).set((IntEncodedValue)intEnc, 5).set(enumEnc, (Enum)RoadClass.BRIDLEWAY).set(roadClassLincEnc, true).set((BooleanEncodedValue)externalEnc, false, true);
        g.edge(1, 2).set((IntEncodedValue)intEnc, 2).set(enumEnc, (Enum)RoadClass.CYCLEWAY).set(roadClassLincEnc, false).set((BooleanEncodedValue)externalEnc, false, true);
        g.edge(2, 3).set((IntEncodedValue)intEnc, 7).set(enumEnc, (Enum)RoadClass.PRIMARY).set(roadClassLincEnc, true).set((BooleanEncodedValue)externalEnc, true, false);
        g.edge(3, 4).set((IntEncodedValue)intEnc, 1).set(enumEnc, (Enum)RoadClass.MOTORWAY).set(roadClassLincEnc, false).set((BooleanEncodedValue)externalEnc, true, false);
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 50.0, 10.0);
        na.setNode(1, 50.1, 10.1);
        na.setNode(2, 50.2, 10.2);
        na.setNode(3, 50.3, 10.3);
        na.setNode(4, 50.4, 10.4);
        LocationIndexTree locationIndex = new LocationIndexTree((Graph)g, g.getDirectory());
        locationIndex.prepareIndex();
        Snap snap1 = locationIndex.findClosest(50.05, 10.05, EdgeFilter.ALL_EDGES);
        Snap snap2 = locationIndex.findClosest(50.35, 10.35, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)g, (Snap)snap1, (Snap)snap2);
        Assertions.assertEquals((int)7, (int)queryGraph.getNodes());
        Assertions.assertEquals((int)4, (int)queryGraph.getBaseGraph().getEdges());
        Assertions.assertEquals((int)8, (int)queryGraph.getVirtualEdges().size());
        EdgeIteratorState virt05 = queryGraph.getEdgeIteratorState(4, 5);
        Assertions.assertFalse((boolean)queryGraph.getEdgeIteratorState(0, 1).get((BooleanEncodedValue)externalEnc));
        Assertions.assertTrue((boolean)queryGraph.getEdgeIteratorState(0, 1).getReverse((BooleanEncodedValue)externalEnc));
        Assertions.assertFalse((boolean)virt05.get((BooleanEncodedValue)externalEnc));
        Assertions.assertTrue((boolean)virt05.getReverse((BooleanEncodedValue)externalEnc));
        Assertions.assertEquals((Object)RoadClass.MOTORWAY, (Object)queryGraph.getEdgeIteratorState(3, 4).get(enumEnc));
        EdgeIteratorState virt64 = queryGraph.getEdgeIteratorState(7, 4);
        Assertions.assertEquals((int)6, (int)virt64.getBaseNode());
        Assertions.assertEquals((int)4, (int)virt64.getAdjNode());
        Assertions.assertEquals((Object)RoadClass.MOTORWAY, (Object)virt64.get(enumEnc));
        Assertions.assertTrue((boolean)virt64.get((BooleanEncodedValue)externalEnc));
        Assertions.assertFalse((boolean)virt64.getReverse((BooleanEncodedValue)externalEnc));
    }

    @Test
    public void directedKeyValues() {
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 1.0, 0.0);
        na.setNode(1, 1.0, 2.5);
        HashMap<String, KVStorage.KValue> kvs = new HashMap<String, KVStorage.KValue>();
        kvs.put("a", new KVStorage.KValue((Object)"hello", null));
        kvs.put("b", new KVStorage.KValue(null, (Object)"world"));
        EdgeIteratorState origEdge = this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(kvs);
        Assertions.assertEquals((Object)origEdge.getKeyValues().toString(), (Object)origEdge.detach(true).getKeyValues().toString());
        Assertions.assertEquals((Object)"hello", (Object)origEdge.getValue("a"));
        Assertions.assertNull((Object)origEdge.detach(true).getValue("a"));
        Assertions.assertEquals((Object)"world", (Object)origEdge.detach(true).getValue("b"));
        Assertions.assertNull((Object)origEdge.getValue("b"));
        LocationIndexTree index = new LocationIndexTree((Graph)this.g, (Directory)new RAMDirectory());
        index.prepareIndex();
        Snap snap = index.findClosest(1.01, 0.7, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = this.lookup(snap);
        EdgeIteratorState edge0ToSnap = queryGraph.getEdgeIteratorState(1, 2);
        Assertions.assertEquals((Object)edge0ToSnap.getKeyValues().toString(), (Object)edge0ToSnap.detach(true).getKeyValues().toString());
        Assertions.assertEquals((Object)"hello", (Object)edge0ToSnap.getValue("a"));
        Assertions.assertNull((Object)edge0ToSnap.detach(true).getValue("a"));
        Assertions.assertEquals((Object)"world", (Object)edge0ToSnap.detach(true).getValue("b"));
        Assertions.assertNull((Object)edge0ToSnap.getValue("b"));
    }

    @Test
    void veryShortEdge() {
        EdgeIteratorState e = this.g.edge(0, 1);
        NodeAccess na = this.g.getNodeAccess();
        na.setNode(0, 40.0, 6.0);
        na.setNode(1, 40.0, 6.000001);
        double edgeDist = DistancePlaneProjection.DIST_PLANE.calcDist(na.getLat(0), na.getLon(0), na.getLat(1), na.getLon(1));
        Assertions.assertEquals((double)0.085, (double)edgeDist, (double)0.001);
        double queryLat = 40.001;
        double queryLon = 6.0000009;
        double queryTo0 = DistancePlaneProjection.DIST_PLANE.calcDist(queryLat, queryLon, na.getLat(0), na.getLon(0));
        double queryTo1 = DistancePlaneProjection.DIST_PLANE.calcDist(queryLat, queryLon, na.getLat(1), na.getLon(1));
        Assertions.assertEquals((double)111.194953, (double)queryTo0, (double)1.0E-7);
        Assertions.assertEquals((double)111.1949269, (double)queryTo1, (double)1.0E-7);
        GHPoint crossingPoint = DistancePlaneProjection.DIST_PLANE.calcCrossingPointToEdge(queryLat, queryLon, na.getLat(0), na.getLon(0), na.getLat(1), na.getLon(1));
        double distCrossingTo0 = DistancePlaneProjection.DIST_PLANE.calcDist(crossingPoint.lat, crossingPoint.lon, na.getLat(0), na.getLon(0));
        double distCrossingTo1 = DistancePlaneProjection.DIST_PLANE.calcDist(crossingPoint.lat, crossingPoint.lon, na.getLat(1), na.getLon(1));
        Assertions.assertEquals((double)0.0766, (double)distCrossingTo0, (double)1.0E-4);
        Assertions.assertEquals((double)0.0085, (double)distCrossingTo1, (double)1.0E-4);
        Assertions.assertTrue((distCrossingTo1 < distCrossingTo0 ? 1 : 0) != 0);
        LocationIndexTree index = new LocationIndexTree((Graph)this.g, (Directory)new RAMDirectory());
        index.prepareIndex();
        Snap snap = index.findClosest(queryLat, queryLon, EdgeFilter.ALL_EDGES);
        Assertions.assertEquals((Object)Snap.Position.TOWER, (Object)snap.getSnappedPosition());
        int closestNode = snap.getClosestNode();
        Assertions.assertEquals((int)0, (int)closestNode);
        Assertions.assertEquals((double)na.getLat(closestNode), (double)snap.getSnappedPoint().getLat());
        Assertions.assertEquals((double)na.getLon(closestNode), (double)snap.getSnappedPoint().getLon());
        Assertions.assertEquals((double)queryTo0, (double)snap.getQueryDistance());
        Assertions.assertEquals((int)0, (int)snap.getWayIndex());
    }

    private QueryGraph lookup(Snap res) {
        return this.lookup(Collections.singletonList(res));
    }

    private QueryGraph lookup(List<Snap> snaps) {
        return QueryGraph.create((BaseGraph)this.g, snaps);
    }
}

