/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.subnetwork.EdgeBasedTarjanSCC;
import com.graphhopper.routing.subnetwork.TarjanSCCTest;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.GHUtility;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class EdgeBasedTarjanSCCTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
    private final BaseGraph g;
    private final EdgeBasedTarjanSCC.EdgeTransitionFilter fwdAccessFilter;

    public EdgeBasedTarjanSCCTest() {
        EncodedValue.InitializerConfig evConf = new EncodedValue.InitializerConfig();
        this.speedEnc.init(evConf);
        this.g = new BaseGraph.Builder(evConf.getRequiredBytes()).create();
        this.fwdAccessFilter = (prev, edge) -> edge.get(this.speedEnc) > 0.0;
    }

    @Test
    public void linearSingle() {
        this.g.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        EdgeBasedTarjanSCC.ConnectedComponents result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)false);
        Assertions.assertEquals((int)2, (int)result.getEdgeKeys());
        Assertions.assertEquals((int)1, (int)result.getTotalComponents());
        Assertions.assertEquals((int)1, (int)result.getComponents().size());
        Assertions.assertTrue((boolean)result.getSingleEdgeComponents().isEmpty());
        Assertions.assertEquals(result.getComponents().get(0), (Object)result.getBiggestComponent());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 0}), result.getComponents().get(0));
    }

    @Test
    public void linearSimple() {
        this.g.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        EdgeBasedTarjanSCC.ConnectedComponents result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)false);
        Assertions.assertEquals((int)4, (int)result.getEdgeKeys());
        Assertions.assertEquals((int)1, (int)result.getTotalComponents());
        Assertions.assertEquals((int)1, (int)result.getComponents().size());
        Assertions.assertTrue((boolean)result.getSingleEdgeComponents().isEmpty());
        Assertions.assertEquals(result.getComponents().get(0), (Object)result.getBiggestComponent());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 3, 2, 0}), result.getComponents().get(0));
    }

    @Test
    public void linearOneWay() {
        this.g.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        EdgeBasedTarjanSCC.ConnectedComponents result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)false);
        Assertions.assertEquals((int)4, (int)result.getEdgeKeys());
        Assertions.assertEquals((int)4, (int)result.getTotalComponents());
        Assertions.assertEquals((int)0, (int)result.getComponents().size());
        Assertions.assertEquals((long)4L, (long)result.getSingleEdgeComponents().cardinality());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)result.getBiggestComponent());
    }

    @Test
    public void linearBidirectionalEdge() {
        this.g.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(3, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        EdgeBasedTarjanSCC.ConnectedComponents result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)false);
        Assertions.assertEquals((int)6, (int)result.getEdgeKeys());
        Assertions.assertEquals((int)5, (int)result.getTotalComponents());
        Assertions.assertEquals((int)1, (int)result.getComponents().size());
        Assertions.assertEquals((long)4L, (long)result.getSingleEdgeComponents().cardinality());
        Assertions.assertEquals(result.getComponents().get(0), (Object)result.getBiggestComponent());
    }

    @Test
    public void oneWayBridges() {
        this.g.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(2, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(2, 4).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(3, 5).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(4, 5).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(5, 6).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(6, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        EdgeBasedTarjanSCC.ConnectedComponents result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)false);
        Assertions.assertEquals((int)16, (int)result.getEdgeKeys());
        Assertions.assertEquals((int)7, (int)result.getTotalComponents());
        Assertions.assertEquals((int)3, (int)result.getComponents().size());
        Assertions.assertEquals((long)4L, (long)result.getSingleEdgeComponents().cardinality());
        Assertions.assertEquals(result.getComponents().get(1), (Object)result.getBiggestComponent());
    }

    @Test
    public void tree() {
        this.g.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(1, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(2, 4).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(2, 6).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(4, 5).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(6, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(6, 8).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        EdgeBasedTarjanSCC.ConnectedComponents result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)false);
        Assertions.assertEquals((int)16, (int)result.getEdgeKeys());
        Assertions.assertEquals((int)1, (int)result.getTotalComponents());
        Assertions.assertEquals((int)1, (int)result.getComponents().size());
        Assertions.assertTrue((boolean)result.getSingleEdgeComponents().isEmpty());
        Assertions.assertEquals(result.getComponents().get(0), (Object)result.getBiggestComponent());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 3, 7, 11, 10, 6, 9, 13, 12, 15, 14, 8, 2, 5, 4, 0}), result.getComponents().get(0));
    }

    @Test
    public void smallGraph() {
        this.g.edge(0, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(0, 3).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(2, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        EdgeBasedTarjanSCC.ConnectedComponents result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)false);
        Assertions.assertEquals((int)6, (int)result.getEdgeKeys());
        Assertions.assertEquals((int)5, (int)result.getTotalComponents());
        Assertions.assertEquals((int)1, (int)result.getComponents().size());
        Assertions.assertEquals(result.getComponents().get(0), (Object)result.getBiggestComponent());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4}), result.getComponents().get(0));
        Assertions.assertEquals((long)4L, (long)result.getSingleEdgeComponents().cardinality());
        for (IntCursor c : IntArrayList.from((int[])new int[]{0, 1, 2, 3})) {
            Assertions.assertTrue((boolean)result.getSingleEdgeComponents().get(c.value));
        }
    }

    @Test
    public void biggerGraph() {
        this.g.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(2, 1).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(1, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(2, 4).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(6, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(4, 5).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(5, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(6, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(6, 8).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        EdgeBasedTarjanSCC.ConnectedComponents result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)false);
        Assertions.assertEquals((int)18, (int)result.getEdgeKeys());
        Assertions.assertEquals((int)6, (int)result.getTotalComponents());
        Assertions.assertEquals((int)2, (int)result.getComponents().size());
        Assertions.assertEquals(result.getComponents().get(1), (Object)result.getBiggestComponent());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 5, 4, 0}), result.getComponents().get(0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 8, 13, 14, 17, 16, 15, 12, 10, 6}), result.getComponents().get(1));
        Assertions.assertEquals((long)4L, (long)result.getSingleEdgeComponents().cardinality());
        for (IntCursor c : IntArrayList.from((int[])new int[]{9, 2, 3, 11})) {
            Assertions.assertTrue((boolean)result.getSingleEdgeComponents().get(c.value));
        }
    }

    @Test
    public void withTurnRestriction() {
        this.g.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(2, 3).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(3, 0).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.g.edge(2, 4).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        EdgeBasedTarjanSCC.ConnectedComponents result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)false);
        Assertions.assertEquals((int)7, (int)result.getTotalComponents());
        Assertions.assertEquals((int)1, (int)result.getComponents().size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{6, 4, 2, 0}), (Object)result.getBiggestComponent());
        Assertions.assertEquals((long)6L, (long)result.getSingleEdgeComponents().cardinality());
        for (IntCursor c : IntArrayList.from((int[])new int[]{1, 3, 5, 7, 8, 9})) {
            Assertions.assertTrue((boolean)result.getSingleEdgeComponents().get(c.value));
        }
        result = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (prev, edge) -> this.fwdAccessFilter.accept(prev, edge) && (prev != 1 || edge.getBaseNode() != 2 || edge.getEdge() != 2), (boolean)false);
        Assertions.assertEquals((int)10, (int)result.getTotalComponents());
        Assertions.assertEquals((int)0, (int)result.getComponents().size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)result.getBiggestComponent());
        Assertions.assertEquals((long)10L, (long)result.getSingleEdgeComponents().cardinality());
        for (IntCursor c : IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9})) {
            Assertions.assertTrue((boolean)result.getSingleEdgeComponents().get(c.value));
        }
    }

    @RepeatedTest(value=20)
    public void implicitVsExplicitRecursion() {
        this.doImplicitVsExplicit(true);
        this.doImplicitVsExplicit(false);
    }

    private void doImplicitVsExplicit(boolean excludeSingle) {
        long seed = System.nanoTime();
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)this.g, (Random)rnd, (int)500, (double)2.0, (boolean)true, (DecimalEncodedValue)this.speedEnc, (Double)60.0, (double)0.7, (double)0.0);
        EdgeBasedTarjanSCC.ConnectedComponents implicit = EdgeBasedTarjanSCC.findComponentsRecursive((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)excludeSingle);
        EdgeBasedTarjanSCC.ConnectedComponents explicit = EdgeBasedTarjanSCC.findComponents((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)excludeSingle);
        Assertions.assertEquals((int)(2 * this.g.getEdges()), (int)implicit.getEdgeKeys(), (String)"total number of edge keys in connected components should equal twice the number of edges in graph");
        Assertions.assertEquals((int)(2 * this.g.getEdges()), (int)explicit.getEdgeKeys(), (String)"total number of edge keys in connected components should equal twice the number of edges in graph");
        this.compareResults(this.g, seed, implicit, explicit);
    }

    @Test
    public void withStartEdges_simple() {
        this.g.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(3, 0).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(5, 6).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(6, 7).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.g.edge(8, 9).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeBasedTarjanSCC.ConnectedComponents components = EdgeBasedTarjanSCC.findComponentsForStartEdges((Graph)this.g, (prev, edge) -> true, (IntContainer)IntArrayList.from((int[])new int[]{0}));
        Assertions.assertEquals((int)8, (int)components.getEdgeKeys());
        Assertions.assertEquals((int)1, (int)components.getComponents().size());
        components = EdgeBasedTarjanSCC.findComponentsForStartEdges((Graph)this.g, (prev, edge) -> true, (IntContainer)IntArrayList.from((int[])new int[]{0, 4, 7}));
        Assertions.assertEquals((int)16, (int)components.getEdgeKeys());
        Assertions.assertEquals((int)3, (int)components.getComponents().size());
        components = EdgeBasedTarjanSCC.findComponentsForStartEdges((Graph)this.g, (prev, edge) -> edge.getEdge() > 3 && edge.getEdge() < 7, (IntContainer)IntArrayList.from((int[])new int[]{0, 4, 7}));
        Assertions.assertEquals((int)6, (int)components.getEdgeKeys());
        Assertions.assertEquals((int)1, (int)components.getComponents().size());
    }

    @RepeatedTest(value=20)
    public void withStartEdges_comparison() {
        long seed = System.nanoTime();
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)this.g, (Random)rnd, (int)500, (double)2.0, (boolean)true, (DecimalEncodedValue)this.speedEnc, (Double)60.0, (double)0.7, (double)0.0);
        EdgeBasedTarjanSCC.ConnectedComponents components = EdgeBasedTarjanSCC.findComponents((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (boolean)true);
        IntArrayList edges = new IntArrayList();
        AllEdgesIterator iter = this.g.getAllEdges();
        while (iter.next()) {
            edges.add(iter.getEdge());
        }
        EdgeBasedTarjanSCC.ConnectedComponents componentsForStartEdges = EdgeBasedTarjanSCC.findComponentsForStartEdges((Graph)this.g, (EdgeBasedTarjanSCC.EdgeTransitionFilter)this.fwdAccessFilter, (IntContainer)edges);
        this.compareResults(this.g, seed, components, componentsForStartEdges);
    }

    private void compareResults(BaseGraph g, long seed, EdgeBasedTarjanSCC.ConnectedComponents expected, EdgeBasedTarjanSCC.ConnectedComponents given) {
        Assertions.assertEquals((int)expected.getEdgeKeys(), (int)given.getEdgeKeys());
        Set<TarjanSCCTest.IntWithArray> componentsImplicit = TarjanSCCTest.buildComponentSet(expected.getComponents());
        Set<TarjanSCCTest.IntWithArray> componentsExplicit = TarjanSCCTest.buildComponentSet(given.getComponents());
        if (!componentsExplicit.equals(componentsImplicit)) {
            System.out.println("seed: " + seed);
            GHUtility.printGraphForUnitTest((Graph)g, (DecimalEncodedValue)this.speedEnc);
            Assertions.assertEquals(componentsExplicit, componentsImplicit, (String)"Components for this graph are not the same for the two implementations");
        }
        if (!expected.getSingleEdgeComponents().equals((Object)given.getSingleEdgeComponents())) {
            System.out.println("seed: " + seed);
            GHUtility.printGraphForUnitTest((Graph)g, (DecimalEncodedValue)this.speedEnc);
            Assertions.assertEquals((Object)expected.getSingleEdgeComponents(), (Object)given.getSingleEdgeComponents());
        }
        Assertions.assertEquals((Object)expected.getBiggestComponent(), (Object)given.getBiggestComponent(), (String)("seed: " + seed));
        Assertions.assertEquals((int)expected.getEdgeKeys(), (int)given.getEdgeKeys(), (String)("seed: " + seed));
        Assertions.assertEquals((int)expected.getTotalComponents(), (int)given.getTotalComponents(), (String)("seed: " + seed));
    }
}

