/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PrepareRoutingSubnetworksTest {
    private static BaseGraph createSubnetworkTestStorage(EncodingManager encodingManager, DecimalEncodedValue speedEnc1, DecimalEncodedValue speedEnc2) {
        BaseGraph g = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        g.edge(3, 4).setDistance(1.0);
        g.edge(0, 1).setDistance(1.0);
        g.edge(1, 3).setDistance(1.0);
        g.edge(0, 2).setDistance(1.0);
        g.edge(2, 3).setDistance(1.0);
        g.edge(3, 7).setDistance(1.0);
        g.edge(7, 8).setDistance(1.0);
        g.edge(4, 5).setDistance(1.0);
        g.edge(5, 6).setDistance(1.0);
        g.edge(4, 6).setDistance(1.0);
        AllEdgesIterator iter = g.getAllEdges();
        while (iter.next()) {
            if (iter.getEdge() == 0) continue;
            iter.set(speedEnc1, 10.0, 10.0);
            if (speedEnc2 == null) continue;
            iter.set(speedEnc2, 10.0, 10.0);
        }
        return g;
    }

    @Test
    public void testPrepareSubnetworks_oneVehicle() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        BooleanEncodedValue subnetworkEnc = Subnetwork.create((String)"car");
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).add((EncodedValue)subnetworkEnc).build();
        BaseGraph g = PrepareRoutingSubnetworksTest.createSubnetworkTestStorage(em, (DecimalEncodedValue)speedEnc, null);
        PrepareRoutingSubnetworks instance = new PrepareRoutingSubnetworks(g, Collections.singletonList(PrepareRoutingSubnetworksTest.createJob(subnetworkEnc, (DecimalEncodedValue)speedEnc)));
        instance.setMinNetworkSize(4);
        Assertions.assertEquals((int)3, (int)instance.doWork());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 8, 9}), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, subnetworkEnc));
        g = PrepareRoutingSubnetworksTest.createSubnetworkTestStorage(em, (DecimalEncodedValue)speedEnc, null);
        instance = new PrepareRoutingSubnetworks(g, Collections.singletonList(PrepareRoutingSubnetworksTest.createJob(subnetworkEnc, (DecimalEncodedValue)speedEnc)));
        instance.setMinNetworkSize(3);
        Assertions.assertEquals((int)0, (int)instance.doWork());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, subnetworkEnc));
    }

    @Test
    public void testPrepareSubnetworks_twoVehicles() {
        DecimalEncodedValueImpl carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, true);
        BooleanEncodedValue carSubnetworkEnc = Subnetwork.create((String)"car");
        DecimalEncodedValueImpl bikeSpeedEnc = new DecimalEncodedValueImpl("bike_speed", 4, 2.0, true);
        BooleanEncodedValue bikeSubnetworkEnc = Subnetwork.create((String)"bike");
        EncodingManager em = EncodingManager.start().add((EncodedValue)carSpeedEnc).add((EncodedValue)carSubnetworkEnc).add((EncodedValue)bikeSpeedEnc).add((EncodedValue)bikeSubnetworkEnc).build();
        BaseGraph g = PrepareRoutingSubnetworksTest.createSubnetworkTestStorage(em, (DecimalEncodedValue)carSpeedEnc, (DecimalEncodedValue)bikeSpeedEnc);
        EdgeIteratorState edge = GHUtility.getEdge((Graph)g, (int)3, (int)4);
        edge.set((DecimalEncodedValue)carSpeedEnc, 0.0, 0.0);
        edge.set((DecimalEncodedValue)bikeSpeedEnc, 5.0, 5.0);
        List<PrepareRoutingSubnetworks.PrepareJob> prepareJobs = Arrays.asList(PrepareRoutingSubnetworksTest.createJob(carSubnetworkEnc, (DecimalEncodedValue)carSpeedEnc), PrepareRoutingSubnetworksTest.createJob(bikeSubnetworkEnc, (DecimalEncodedValue)bikeSpeedEnc));
        PrepareRoutingSubnetworks instance = new PrepareRoutingSubnetworks(g, prepareJobs);
        instance.setMinNetworkSize(5);
        Assertions.assertEquals((int)3, (int)instance.doWork());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 8, 9}), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, carSubnetworkEnc));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, bikeSubnetworkEnc));
        g = PrepareRoutingSubnetworksTest.createSubnetworkTestStorage(em, (DecimalEncodedValue)carSpeedEnc, (DecimalEncodedValue)bikeSpeedEnc);
        edge = GHUtility.getEdge((Graph)g, (int)3, (int)4);
        edge.set((DecimalEncodedValue)carSpeedEnc, 0.0, 0.0);
        edge.set((DecimalEncodedValue)bikeSpeedEnc, 0.0, 0.0);
        instance = new PrepareRoutingSubnetworks(g, prepareJobs);
        instance.setMinNetworkSize(5);
        Assertions.assertEquals((int)6, (int)instance.doWork());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 8, 9}), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, carSubnetworkEnc));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 8, 9}), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, bikeSubnetworkEnc));
    }

    @Test
    public void testPrepareSubnetwork_withTurnCosts() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        DecimalEncodedValue turnCostEnc = TurnCost.create((String)"car", (int)1);
        BooleanEncodedValue subnetworkEnc = Subnetwork.create((String)"car");
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).add((EncodedValue)subnetworkEnc).addTurnCostEncodedValue((EncodedValue)turnCostEnc).build();
        BaseGraph g = PrepareRoutingSubnetworksTest.createSubnetworkTestStorage(em, (DecimalEncodedValue)speedEnc, null);
        PrepareRoutingSubnetworks instance = new PrepareRoutingSubnetworks(g, Collections.singletonList(PrepareRoutingSubnetworksTest.createJob(subnetworkEnc, (DecimalEncodedValue)speedEnc, turnCostEnc, g.getTurnCostStorage(), 0.0)));
        instance.setMinNetworkSize(4);
        Assertions.assertEquals((int)3, (int)instance.doWork());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 8, 9}), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, subnetworkEnc));
        g = PrepareRoutingSubnetworksTest.createSubnetworkTestStorage(em, (DecimalEncodedValue)speedEnc, null);
        EdgeIteratorState edge = GHUtility.getEdge((Graph)g, (int)3, (int)4);
        edge.set((DecimalEncodedValue)speedEnc, 10.0, 10.0);
        instance = new PrepareRoutingSubnetworks(g, Collections.singletonList(PrepareRoutingSubnetworksTest.createJob(subnetworkEnc, (DecimalEncodedValue)speedEnc, turnCostEnc, g.getTurnCostStorage(), 0.0)));
        instance.setMinNetworkSize(4);
        Assertions.assertEquals((int)0, (int)instance.doWork());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, subnetworkEnc));
        g = PrepareRoutingSubnetworksTest.createSubnetworkTestStorage(em, (DecimalEncodedValue)speedEnc, null);
        edge = GHUtility.getEdge((Graph)g, (int)3, (int)4);
        edge.set((DecimalEncodedValue)speedEnc, 10.0, 10.0);
        g.getTurnCostStorage().set(turnCostEnc, 0, 4, 7, Double.POSITIVE_INFINITY);
        g.getTurnCostStorage().set(turnCostEnc, 0, 4, 9, Double.POSITIVE_INFINITY);
        instance = new PrepareRoutingSubnetworks(g, Collections.singletonList(PrepareRoutingSubnetworksTest.createJob(subnetworkEnc, (DecimalEncodedValue)speedEnc, turnCostEnc, g.getTurnCostStorage(), 0.0)));
        instance.setMinNetworkSize(4);
        Assertions.assertEquals((int)3, (int)instance.doWork());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 8, 9}), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, subnetworkEnc));
    }

    private BaseGraph createSubnetworkTestStorageWithOneWays(EncodingManager em, DecimalEncodedValue speedEnc) {
        BaseGraph g = new BaseGraph.Builder(em).create();
        g.edge(0, 1).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(1, 2).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(2, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(3, 4).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(5, 4).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(5, 6).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(7, 8).setDistance(1.0).set(speedEnc, 60.0, 0.0);
        g.edge(8, 9).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        g.edge(9, 10).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        return g;
    }

    @Test
    public void testPrepareSubnetworks_withOneWays() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        BooleanEncodedValue subnetworkEnc = Subnetwork.create((String)"car");
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).add((EncodedValue)subnetworkEnc).build();
        BaseGraph g = this.createSubnetworkTestStorageWithOneWays(em, (DecimalEncodedValue)speedEnc);
        Assertions.assertEquals((int)11, (int)g.getNodes());
        PrepareRoutingSubnetworks.PrepareJob job = PrepareRoutingSubnetworksTest.createJob(subnetworkEnc, (DecimalEncodedValue)speedEnc);
        PrepareRoutingSubnetworks instance = new PrepareRoutingSubnetworks(g, Collections.singletonList(job)).setMinNetworkSize(2);
        int subnetworkEdges = instance.doWork();
        Assertions.assertEquals((int)3, (int)subnetworkEdges);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 5, 6}), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, subnetworkEnc));
        g = this.createSubnetworkTestStorageWithOneWays(em, (DecimalEncodedValue)speedEnc);
        Assertions.assertEquals((int)11, (int)g.getNodes());
        instance = new PrepareRoutingSubnetworks(g, Collections.singletonList(job)).setMinNetworkSize(3);
        subnetworkEdges = instance.doWork();
        Assertions.assertEquals((int)5, (int)subnetworkEdges);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 5, 6, 7, 8}), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, subnetworkEnc));
    }

    @Test
    public void testNodeOrderingRegression() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        BooleanEncodedValue subnetworkEnc = Subnetwork.create((String)"car");
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).add((EncodedValue)subnetworkEnc).build();
        BaseGraph g = new BaseGraph.Builder(em).create();
        g.edge(1, 2).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        g.edge(2, 0).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 0.0);
        g.edge(0, 3).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        g.edge(3, 4).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        g.edge(4, 5).setDistance(1.0).set((DecimalEncodedValue)speedEnc, 60.0, 60.0);
        PrepareRoutingSubnetworks.PrepareJob job = PrepareRoutingSubnetworksTest.createJob(subnetworkEnc, (DecimalEncodedValue)speedEnc);
        PrepareRoutingSubnetworks instance = new PrepareRoutingSubnetworks(g, Collections.singletonList(job)).setMinNetworkSize(2);
        int subnetworkEdges = instance.doWork();
        Assertions.assertEquals((int)2, (int)subnetworkEdges);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1}), (Object)PrepareRoutingSubnetworksTest.getSubnetworkEdges(g, subnetworkEnc));
    }

    private static IntArrayList getSubnetworkEdges(BaseGraph graph, BooleanEncodedValue subnetworkEnc) {
        IntArrayList result = new IntArrayList();
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            if (!iter.get(subnetworkEnc)) continue;
            result.add(iter.getEdge());
        }
        return result;
    }

    private static PrepareRoutingSubnetworks.PrepareJob createJob(BooleanEncodedValue subnetworkEnc, DecimalEncodedValue speedEnc) {
        return new PrepareRoutingSubnetworks.PrepareJob(subnetworkEnc, (Weighting)new SpeedWeighting(speedEnc));
    }

    private static PrepareRoutingSubnetworks.PrepareJob createJob(BooleanEncodedValue subnetworkEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue turnCostEnc, TurnCostStorage turnCostStorage, double uTurnCosts) {
        return new PrepareRoutingSubnetworks.PrepareJob(subnetworkEnc, (Weighting)new SpeedWeighting(speedEnc, turnCostEnc, turnCostStorage, uTurnCosts));
    }
}

