/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.subnetwork.TarjanSCC;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.GHUtility;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class TarjanSCCTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
    private final BaseGraph graph;
    private final EdgeFilter edgeFilter;

    public TarjanSCCTest() {
        EncodedValue.InitializerConfig evConf = new EncodedValue.InitializerConfig();
        this.speedEnc.init(evConf);
        this.graph = new BaseGraph.Builder(evConf.getRequiredBytes()).create();
        this.edgeFilter = edge -> edge.get(this.speedEnc) > 0.0;
    }

    @Test
    public void testFindComponents() {
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 4).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 8).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 4).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(8, 4).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(8, 11).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(12, 11).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(9, 12).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(9, 15).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 13).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 5).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(13, 5).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(6, 14).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(10, 14).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        TarjanSCC.ConnectedComponents scc = TarjanSCC.findComponentsRecursive((Graph)this.graph, (EdgeFilter)this.edgeFilter, (boolean)false);
        List components = scc.getComponents();
        Assertions.assertEquals((int)4, (int)components.size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{13, 5, 3, 7, 0}), components.get(0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2, 4, 12, 11, 8, 1}), components.get(1));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{10, 14, 6}), components.get(2));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{15, 9}), components.get(3));
        Assertions.assertEquals((int)16, (int)scc.getNodes());
        Assertions.assertEquals((long)0L, (long)scc.getSingleNodeComponents().cardinality());
        Assertions.assertEquals(components.get(1), (Object)scc.getBiggestComponent());
    }

    @Test
    public void test481() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 0).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 3).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 6).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(6, 7).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(7, 4).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        TarjanSCC.ConnectedComponents scc = TarjanSCC.findComponentsRecursive((Graph)this.graph, (EdgeFilter)this.edgeFilter, (boolean)false);
        List components = scc.getComponents();
        Assertions.assertEquals((int)3, (int)scc.getTotalComponents());
        Assertions.assertEquals((int)2, (int)components.size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2, 1, 0}), components.get(1));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 6, 5, 4}), components.get(0));
        Assertions.assertEquals((long)1L, (long)scc.getSingleNodeComponents().cardinality());
        Assertions.assertTrue((boolean)scc.getSingleNodeComponents().get(3));
        Assertions.assertEquals((int)8, (int)scc.getNodes());
        Assertions.assertEquals(components.get(0), (Object)scc.getBiggestComponent());
        scc = TarjanSCC.findComponentsRecursive((Graph)this.graph, (EdgeFilter)this.edgeFilter, (boolean)true);
        Assertions.assertTrue((boolean)scc.getSingleNodeComponents().isEmpty());
        Assertions.assertEquals((int)3, (int)scc.getTotalComponents());
        Assertions.assertEquals((int)2, (int)scc.getComponents().size());
        Assertions.assertEquals((int)8, (int)scc.getNodes());
    }

    @Test
    public void testTarjan_issue761() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 6).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(6, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(7, 8).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 9).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(9, 10).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(10, 11).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(11, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 12).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(12, 13).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(13, 14).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(14, 15).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(15, 13).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(15, 16).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        TarjanSCC.ConnectedComponents scc = TarjanSCC.findComponentsRecursive((Graph)this.graph, (EdgeFilter)this.edgeFilter, (boolean)false);
        Assertions.assertEquals((int)2, (int)scc.getTotalComponents());
        Assertions.assertTrue((boolean)scc.getSingleNodeComponents().isEmpty());
        Assertions.assertEquals((int)17, (int)scc.getNodes());
        Assertions.assertEquals(scc.getComponents().get(1), (Object)scc.getBiggestComponent());
        Assertions.assertEquals((int)2, (int)scc.getComponents().size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{14, 16, 15, 13, 12, 5}), scc.getComponents().get(0));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{8, 7, 6, 3, 4, 9, 10, 11, 2, 1, 0}), scc.getComponents().get(1));
    }

    @RepeatedTest(value=30)
    public void implicitVsExplicitRecursion() {
        this.doImplicitVsExplicit(true);
        this.doImplicitVsExplicit(false);
    }

    private void doImplicitVsExplicit(boolean excludeSingle) {
        long seed = System.nanoTime();
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)this.graph, (Random)rnd, (int)1000, (double)2.0, (boolean)true, (DecimalEncodedValue)this.speedEnc, (Double)60.0, (double)0.7, (double)0.0);
        TarjanSCC.ConnectedComponents implicit = TarjanSCC.findComponentsRecursive((Graph)this.graph, (EdgeFilter)this.edgeFilter, (boolean)excludeSingle);
        TarjanSCC.ConnectedComponents explicit = TarjanSCC.findComponents((Graph)this.graph, (EdgeFilter)this.edgeFilter, (boolean)excludeSingle);
        Assertions.assertEquals((int)this.graph.getNodes(), (int)implicit.getNodes(), (String)"total number of nodes in connected components should equal number of nodes in graph");
        Assertions.assertEquals((int)this.graph.getNodes(), (int)explicit.getNodes(), (String)"total number of nodes in connected components should equal number of nodes in graph");
        Set<IntWithArray> componentsImplicit = TarjanSCCTest.buildComponentSet(implicit.getComponents());
        Set<IntWithArray> componentsExplicit = TarjanSCCTest.buildComponentSet(explicit.getComponents());
        if (!componentsExplicit.equals(componentsImplicit)) {
            System.out.println("seed: " + seed);
            GHUtility.printGraphForUnitTest((Graph)this.graph, (DecimalEncodedValue)this.speedEnc);
            Assertions.assertEquals(componentsExplicit, componentsImplicit, (String)"The components found for this graph are different between the implicit and explicit implementation");
        }
        if (!implicit.getSingleNodeComponents().equals((Object)explicit.getSingleNodeComponents())) {
            System.out.println("seed: " + seed);
            GHUtility.printGraphForUnitTest((Graph)this.graph, (DecimalEncodedValue)this.speedEnc);
            Assertions.assertEquals((Object)implicit.getSingleNodeComponents(), (Object)explicit.getSingleNodeComponents());
        }
        Assertions.assertEquals((Object)implicit.getBiggestComponent(), (Object)explicit.getBiggestComponent(), (String)("seed: " + seed));
        Assertions.assertEquals((int)implicit.getNodes(), (int)explicit.getNodes(), (String)("seed: " + seed));
        Assertions.assertEquals((int)implicit.getTotalComponents(), (int)explicit.getTotalComponents(), (String)("seed: " + seed));
    }

    public static Set<IntWithArray> buildComponentSet(List<IntArrayList> arrays) {
        HashSet<IntWithArray> result = new HashSet<IntWithArray>();
        for (IntArrayList c : arrays) {
            c.trimToSize();
            Arrays.sort(c.buffer);
            for (IntCursor cursor : c) {
                result.add(new IntWithArray(cursor.value, c));
            }
        }
        return result;
    }

    public static class IntWithArray {
        private final int myInt;
        private final IntArrayList array;

        public IntWithArray(int myInt, IntArrayList array) {
            this.myInt = myInt;
            this.array = array;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntWithArray that = (IntWithArray)o;
            return this.myInt == that.myInt && Objects.equals(this.array, that.array);
        }

        public int hashCode() {
            return Objects.hash(this.myInt, this.array);
        }
    }
}

