/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.Curvature;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.CurvatureCalculator;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.util.PointList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CurvatureCalculatorTest {
    private final EncodingManager em = EncodingManager.start().add((EncodedValue)Curvature.create()).build();

    CurvatureCalculatorTest() {
    }

    @Test
    public void testCurvature() {
        CurvatureCalculator calculator = new CurvatureCalculator(this.em.getDecimalEncodedValue("curvature"));
        ArrayEdgeIntAccess intAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        int edgeId = 0;
        calculator.handleWayTags(edgeId, (EdgeIntAccess)intAccess, this.getStraightWay(), null);
        double valueStraight = this.em.getDecimalEncodedValue("curvature").getDecimal(false, edgeId, (EdgeIntAccess)intAccess);
        intAccess = ArrayEdgeIntAccess.createFromBytes((int)this.em.getBytesForFlags());
        calculator.handleWayTags(edgeId, (EdgeIntAccess)intAccess, this.getCurvyWay(), null);
        double valueCurvy = this.em.getDecimalEncodedValue("curvature").getDecimal(false, edgeId, (EdgeIntAccess)intAccess);
        Assertions.assertTrue((valueCurvy < valueStraight ? 1 : 0) != 0, (String)"The bendiness of the straight road is smaller than the one of the curvy road");
    }

    private ReaderWay getStraightWay() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        PointList pointList = new PointList();
        pointList.add(50.9, 13.13);
        pointList.add(50.899, 13.13);
        way.setTag("point_list", (Object)pointList);
        way.setTag("edge_distance", (Object)100.0);
        return way;
    }

    private ReaderWay getCurvyWay() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        PointList pointList = new PointList();
        pointList.add(50.9, 13.13);
        pointList.add(50.899, 13.129);
        pointList.add(50.899, 13.13);
        way.setTag("point_list", (Object)pointList);
        way.setTag("edge_distance", (Object)160.0);
        return way;
    }
}

