/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.BikeAccessParser;
import com.graphhopper.routing.util.parsers.CarAccessParser;
import com.graphhopper.routing.util.parsers.FootAccessParser;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EncodingManagerTest {
    @Test
    public void testSupportFords() {
        EncodingManager manager = new EncodingManager.Builder().add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)VehicleAccess.create((String)"bike")).add((EncodedValue)VehicleAccess.create((String)"foot")).add((EncodedValue)Roundabout.create()).build();
        Assertions.assertFalse((boolean)new CarAccessParser((EncodedValueLookup)manager, new PMap()).isBlockFords());
        Assertions.assertFalse((boolean)new BikeAccessParser((EncodedValueLookup)manager, new PMap()).isBlockFords());
        Assertions.assertFalse((boolean)new FootAccessParser((EncodedValueLookup)manager, new PMap()).isBlockFords());
        Assertions.assertTrue((boolean)new CarAccessParser((EncodedValueLookup)manager, new PMap("block_fords=true")).isBlockFords());
        Assertions.assertTrue((boolean)new BikeAccessParser((EncodedValueLookup)manager, new PMap("block_fords=true")).isBlockFords());
        Assertions.assertTrue((boolean)new FootAccessParser((EncodedValueLookup)manager, new PMap("block_fords=true")).isBlockFords());
        Assertions.assertFalse((boolean)new CarAccessParser((EncodedValueLookup)manager, new PMap("block_fords=false")).isBlockFords());
        Assertions.assertFalse((boolean)new BikeAccessParser((EncodedValueLookup)manager, new PMap("block_fords=false")).isBlockFords());
        Assertions.assertFalse((boolean)new FootAccessParser((EncodedValueLookup)manager, new PMap("block_fords=false")).isBlockFords());
    }

    @Test
    public void testRegisterOnlyOnceAllowed() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager.start().add((EncodedValue)speedEnc).build();
        Assertions.assertThrows(IllegalStateException.class, () -> EncodingManager.start().add((EncodedValue)speedEnc).build());
    }

    @Test
    public void testGetVehicles() {
        EncodingManager em = EncodingManager.start().add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)VehicleAccess.create((String)"bike")).add((EncodedValue)VehicleSpeed.create((String)"bike", (int)4, (double)2.0, (boolean)true)).add((EncodedValue)VehicleSpeed.create((String)"roads", (int)5, (double)5.0, (boolean)false)).add((EncodedValue)VehicleAccess.create((String)"hike")).add((EncodedValue)new DecimalEncodedValueImpl("whatever_hike_average_speed_2022", 5, 5.0, true)).add((EncodedValue)RoadAccess.create()).build();
        Assertions.assertEquals(Arrays.asList("bike", "hike"), (Object)em.getVehicles());
    }
}

