/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.storage.IntsRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FerrySpeedCalculatorTest {
    final DecimalEncodedValue ferrySpeedEnc = FerrySpeed.create();
    final EncodingManager em = new EncodingManager.Builder().add((EncodedValue)this.ferrySpeedEnc).build();
    final FerrySpeedCalculator calc = new FerrySpeedCalculator(this.ferrySpeedEnc);

    FerrySpeedCalculatorTest() {
    }

    @Test
    public void testSpeed() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("route", (Object)"ferry");
        way.setTag("edge_distance", (Object)30000.0);
        way.setTag("speed_from_duration", (Object)60.0);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        this.calc.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((double)44.0, (double)this.ferrySpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way = new ReaderWay(1L);
        way.setTag("route", (Object)"shuttle_train");
        way.setTag("motorcar", (Object)"yes");
        way.setTag("bicycle", (Object)"no");
        way.setTag("way_distance", (Object)50000.0);
        way.setTag("speed_from_duration", (Object)85.71428571428571);
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.calc.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((double)62.0, (double)this.ferrySpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        way = new ReaderWay(1L);
        way.setTag("route", (Object)"ferry");
        way.setTag("motorcar", (Object)"yes");
        way.setTag("way_distance", (Object)100.0);
        way.setTag("speed_from_duration", (Object)0.5);
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.calc.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((double)2.0, (double)this.ferrySpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        edgeIntAccess = new ArrayEdgeIntAccess(1);
        this.ferrySpeedEnc.setDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess, 2.5);
        Assertions.assertEquals((double)2.0, (double)this.ferrySpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        way = new ReaderWay(1L);
        way.setTag("route", (Object)"ferry");
        way.setTag("motorcar", (Object)"yes");
        way.setTag("edge_distance", (Object)100.0);
        this.calc.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((double)2.0, (double)this.ferrySpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess));
    }

    @Test
    void testRawSpeed() {
        this.checkSpeed(30.0, null, Math.round(21.42857142857143));
        this.checkSpeed(45.0, null, Math.round(32.142857142857146));
        this.checkSpeed(100.0, null, this.ferrySpeedEnc.getMaxStorableDecimal());
        this.checkSpeed(0.5, null, this.ferrySpeedEnc.getSmallestNonZeroValue());
        this.checkSpeed(null, 100.0, this.ferrySpeedEnc.getSmallestNonZeroValue());
        this.checkSpeed(null, 1000.0, 6.0);
        Assertions.assertThrows(IllegalStateException.class, () -> this.checkSpeed(null, null, 6.0));
    }

    private void checkSpeed(Double speedFromDuration, Double edgeDistance, double expected) {
        ReaderWay way = new ReaderWay(0L);
        if (speedFromDuration != null) {
            way.setTag("speed_from_duration", (Object)speedFromDuration);
        }
        if (edgeDistance != null) {
            way.setTag("edge_distance", (Object)edgeDistance);
        }
        Assertions.assertEquals((double)expected, (double)FerrySpeedCalculator.minmax((double)FerrySpeedCalculator.getSpeed((ReaderWay)way), (DecimalEncodedValue)this.ferrySpeedEnc));
    }
}

