/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.HeadingEdgeFilter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.GHPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HeadingEdgeFilterTest {
    HeadingEdgeFilterTest() {
    }

    @Test
    public void getHeading() {
        GHPoint point = new GHPoint(55.67093, 12.577294);
        SimpleBooleanEncodedValue carAccessEnc = new SimpleBooleanEncodedValue("car_access", true);
        DecimalEncodedValueImpl carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)carAccessEnc).add((EncodedValue)carSpeedEnc).build();
        BaseGraph g = new BaseGraph.Builder(em).create();
        EdgeIteratorState edge = g.edge(0, 1);
        g.getNodeAccess().setNode(0, 55.671044, 12.5771583);
        g.getNodeAccess().setNode(1, 55.6704136, 12.5784324);
        Assertions.assertEquals((double)131.2, (double)HeadingEdgeFilter.getHeadingOfGeometryNearPoint((EdgeIteratorState)edge, (GHPoint)point, (double)20.0), (double)0.1);
    }
}

