/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Lanes;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.MaxSpeedEstimated;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.State;
import com.graphhopper.routing.ev.Surface;
import com.graphhopper.routing.ev.UrbanDensity;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.MaxSpeedCalculator;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.util.EdgeIteratorState;
import de.westnordost.osm_legal_default_speeds.LegalDefaultSpeeds;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MaxSpeedCalculatorTest {
    private final LegalDefaultSpeeds defaultSpeeds = MaxSpeedCalculator.createLegalDefaultSpeeds();
    private MaxSpeedCalculator calc;
    private BaseGraph graph;
    private EncodingManager em;
    private EnumEncodedValue<UrbanDensity> urbanDensity;
    private DecimalEncodedValue maxSpeedEnc;
    private BooleanEncodedValue maxSpeedEstEnc;
    private OSMParsers parsers;

    MaxSpeedCalculatorTest() {
    }

    @BeforeEach
    public void setup() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false);
        EnumEncodedValue roadClassEnc = RoadClass.create();
        this.urbanDensity = UrbanDensity.create();
        EnumEncodedValue countryEnc = Country.create();
        this.maxSpeedEnc = MaxSpeed.create();
        this.maxSpeedEstEnc = MaxSpeedEstimated.create();
        this.em = EncodingManager.start().add(this.urbanDensity).add((EncodedValue)countryEnc).add((EncodedValue)Roundabout.create()).add((EncodedValue)Surface.create()).add((EncodedValue)Lanes.create()).add((EncodedValue)roadClassEnc).add((EncodedValue)this.maxSpeedEnc).add((EncodedValue)this.maxSpeedEstEnc).add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        this.graph = new BaseGraph.Builder(this.em).create();
        this.calc = new MaxSpeedCalculator(this.defaultSpeeds);
        this.parsers = new OSMParsers();
        this.parsers.addWayTagParser((TagParser)new OSMMaxSpeedParser(this.maxSpeedEnc));
        this.parsers.addWayTagParser(this.calc.getParser());
        this.calc.createDataAccessForParser((Directory)new RAMDirectory());
    }

    @Test
    public void internalMaxSpeed() {
        EdgeIntAccess storage = this.calc.getInternalMaxSpeedStorage();
        DecimalEncodedValue ruralEnc = this.calc.getRuralMaxSpeedEnc();
        ruralEnc.setDecimal(false, 0, storage, Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)ruralEnc.getDecimal(false, 0, storage));
        ruralEnc.setDecimal(false, 1, storage, 33.0);
        Assertions.assertEquals((double)34.0, (double)ruralEnc.getDecimal(false, 1, storage));
        DecimalEncodedValue urbanEnc = this.calc.getUrbanMaxSpeedEnc();
        urbanEnc.setDecimal(false, 1, storage, Double.POSITIVE_INFINITY);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)urbanEnc.getDecimal(false, 1, storage));
        urbanEnc.setDecimal(false, 0, storage, 46.0);
        Assertions.assertEquals((double)46.0, (double)urbanEnc.getDecimal(false, 0, storage));
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)ruralEnc.getDecimal(false, 0, storage));
        Assertions.assertEquals((double)34.0, (double)ruralEnc.getDecimal(false, 1, storage));
    }

    EdgeIteratorState createEdge(ReaderWay way) {
        EdgeIteratorState edge = this.graph.edge(0, 1);
        EdgeIntAccess edgeIntAccess = this.graph.getEdgeAccess();
        this.parsers.handleWayTags(edge.getEdge(), edgeIntAccess, way, this.em.createRelationFlags());
        return edge;
    }

    @Test
    public void testCityGermany() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"primary");
        EdgeIteratorState edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.CITY);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)50.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        Assertions.assertTrue((boolean)edge.get(this.maxSpeedEstEnc));
        way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"motorway");
        edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.CITY);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)150.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"residential");
        edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.CITY);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)50.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"residential");
        way.setTag("maxspeed", (Object)"70");
        edge = this.createEdge(way);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)70.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        Assertions.assertFalse((boolean)edge.get(this.maxSpeedEstEnc));
    }

    @Test
    public void testRuralGermany() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"primary");
        EdgeIteratorState edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.RURAL);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)100.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        Assertions.assertEquals((double)100.0, (double)edge.getReverse(this.maxSpeedEnc), (double)1.0);
        way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"motorway");
        edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.RURAL);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)150.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"residential");
        edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.RURAL);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)100.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
    }

    @Test
    public void testRoundabout() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.CRI);
        way.setTag("highway", (Object)"primary");
        EdgeIteratorState edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.CITY);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)50.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.CRI);
        way.setTag("highway", (Object)"primary");
        way.setTag("junction", (Object)"roundabout");
        edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.CITY);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)30.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
    }

    @Test
    public void testLanes() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.CHL);
        way.setTag("highway", (Object)"primary");
        EdgeIteratorState edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.RURAL);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)100.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.CHL);
        way.setTag("highway", (Object)"primary");
        way.setTag("lanes", (Object)"4");
        edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.RURAL);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)120.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
    }

    @Test
    public void testSurface() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.LTU);
        way.setTag("highway", (Object)"primary");
        EdgeIteratorState edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.RURAL);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)90.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.LTU);
        way.setTag("highway", (Object)"primary");
        way.setTag("surface", (Object)"compacted");
        edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.RURAL);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)70.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
    }

    @Test
    public void testLivingStreetWithWalk() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.AUT);
        way.setTag("highway", (Object)"living_street");
        EdgeIteratorState edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.CITY);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)6.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
    }

    @Test
    public void testLivingStreetWithMaxSpeed() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"living_street");
        way.setTag("maxspeed", (Object)"30");
        EdgeIteratorState edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.CITY);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)30.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        Assertions.assertEquals((double)30.0, (double)edge.getReverse(this.maxSpeedEnc), (double)1.0);
    }

    @Test
    public void testFwdBwd() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"primary");
        way.setTag("maxspeed:forward", (Object)"50");
        way.setTag("maxspeed:backward", (Object)"70");
        EdgeIteratorState edge = this.createEdge(way);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)50.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        Assertions.assertEquals((double)70.0, (double)edge.getReverse(this.maxSpeedEnc), (double)1.0);
    }

    @Test
    public void testFwdOnly() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.DEU);
        way.setTag("highway", (Object)"primary");
        way.setTag("maxspeed:forward", (Object)"50");
        EdgeIteratorState edge = this.createEdge(way);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)50.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        Assertions.assertEquals((double)100.0, (double)edge.getReverse(this.maxSpeedEnc), (double)1.0);
    }

    @Test
    public void testDifferentStates() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.USA);
        way.setTag("highway", (Object)"primary");
        way.setTag("country_state", (Object)State.US_CA);
        EdgeIteratorState edge1 = this.createEdge(way);
        way.setTag("country_state", (Object)State.US_FL);
        EdgeIteratorState edge2 = this.createEdge(way);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)106.0, (double)edge1.get(this.maxSpeedEnc));
        Assertions.assertEquals((double)90.0, (double)edge2.get(this.maxSpeedEnc));
    }

    @Test
    public void testRawAccess_RuralIsDefault_IfNoUrbanDensityWasSet() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("highway", "primary");
        LegalDefaultSpeeds.Result res = this.defaultSpeeds.getSpeedLimits(Country.DEU.getAlpha2(), tags, new ArrayList(), (name, eval) -> (Boolean)eval.invoke());
        Assertions.assertEquals((Object)"100", (Object)((String)res.getTags().get("maxspeed")).toString());
    }

    @Test
    public void testRawAccess_FwdBwdSpeedsAreIgnored() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("highway", "primary");
        tags.put("maxspeed:forward", "70");
        tags.put("maxspeed:backward", "30");
        LegalDefaultSpeeds.Result res = this.defaultSpeeds.getSpeedLimits(Country.DEU.getAlpha2(), tags, new ArrayList(), (name, eval) -> (Boolean)eval.invoke());
        Assertions.assertNull(res.getTags().get("maxspeed:forward"));
        Assertions.assertEquals((Object)"100", (Object)((String)res.getTags().get("maxspeed")).toString());
    }

    @Test
    public void testGBR() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.GBR);
        way.setTag("highway", (Object)"primary");
        EdgeIteratorState edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.CITY);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)48.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.RURAL);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)98.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
        way.setTag("highway", (Object)"motorway");
        edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.RURAL);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)114.0, (double)edge.get(this.maxSpeedEnc), (double)1.0);
    }

    @Test
    public void testUnsupportedCountry() {
        ReaderWay way = new ReaderWay(0L);
        way.setTag("country", (Object)Country.AIA);
        way.setTag("highway", (Object)"primary");
        EdgeIteratorState edge = this.createEdge(way).set(this.urbanDensity, (Enum)UrbanDensity.CITY);
        this.calc.fillMaxSpeed((Graph)this.graph, this.em);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)edge.get(this.maxSpeedEnc), (double)1.0);
    }
}

