/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.NameSimilarityEdgeFilter;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NameSimilarityEdgeFilterTest {
    private final GHPoint basePoint = new GHPoint(49.4652132, 11.1435159);

    @Test
    public void testAccept() {
        NameSimilarityEdgeFilter edgeFilter = this.createNameSimilarityEdgeFilter("Laufamholzstra\u00dfe 154 N\u00fcrnberg");
        EdgeIteratorState edge = this.createTestEdgeIterator("Laufamholzstra\u00dfe, ST1333");
        edge.getName();
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edge = this.createTestEdgeIterator("Hauptstra\u00dfe");
        Assertions.assertFalse((boolean)edgeFilter.accept(edge));
        edge = this.createTestEdgeIterator("Lorem Ipsum");
        Assertions.assertFalse((boolean)edgeFilter.accept(edge));
        edge = this.createTestEdgeIterator("");
        Assertions.assertFalse((boolean)edgeFilter.accept(edge));
        edge = this.createTestEdgeIterator(null);
        Assertions.assertFalse((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter(null);
        edge = this.createTestEdgeIterator("Laufamholzstra\u00dfe, ST1333");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter("");
        edge = this.createTestEdgeIterator("Laufamholzstra\u00dfe, ST1333");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter("Johannesstra\u00dfe, Rastenberg, Deutschland");
        edge = this.createTestEdgeIterator("Laufamholzstra\u00dfe, ST1333");
        Assertions.assertFalse((boolean)edgeFilter.accept(edge));
        edge = this.createTestEdgeIterator("Johannesstra\u00dfe");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter("Hauptstra\u00dfe");
        edge = this.createTestEdgeIterator("Teststra\u00dfe");
        Assertions.assertFalse((boolean)edgeFilter.accept(edge));
        edge = this.createTestEdgeIterator("Hauptstra\u00dfe");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edge = this.createTestEdgeIterator("Hauptstrasse");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edge = this.createTestEdgeIterator("Hauptstr.");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
    }

    @Test
    public void testDistanceFiltering() {
        BaseGraph g = new BaseGraph.Builder(1).create();
        NodeAccess na = g.getNodeAccess();
        GHPoint pointFarAway = new GHPoint(49.458629, 11.146124);
        GHPoint point25mAway = new GHPoint(49.464871, 11.143575);
        GHPoint point200mAway = new GHPoint(49.464598, 11.149039);
        int farAwayId = 0;
        int nodeId50 = 1;
        int nodeID200 = 2;
        na.setNode(farAwayId, pointFarAway.lat, pointFarAway.lon);
        na.setNode(nodeId50, point25mAway.lat, point25mAway.lon);
        na.setNode(nodeID200, point200mAway.lat, point200mAway.lon);
        EdgeIteratorState edge1 = g.edge(nodeId50, farAwayId).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Wentworth Street")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Wentworth Street").accept(edge1));
        EdgeIteratorState edge2 = g.edge(nodeID200, farAwayId).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Wentworth Street")));
        Assertions.assertFalse((boolean)this.createNameSimilarityEdgeFilter("Wentworth Street").accept(edge2));
    }

    @Test
    public void testAcceptFromNominatim() {
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Wentworth Street, Caringbah South").accept(this.createTestEdgeIterator("Wentworth Street")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Zum Toffental, Altdorf bei N\u00fcrnnberg").accept(this.createTestEdgeIterator("Zum Toffental")));
    }

    @Test
    public void testAcceptFromGoogleMapsGeocoding() {
        NameSimilarityEdgeFilter edgeFilter = this.createNameSimilarityEdgeFilter("Rue Notre-Dame O Montr\u00e9al");
        Assertions.assertFalse((boolean)edgeFilter.accept(this.createTestEdgeIterator("Rue Dupr\u00e9")));
        Assertions.assertTrue((boolean)edgeFilter.accept(this.createTestEdgeIterator("Rue Notre-Dame Ouest")));
        edgeFilter = this.createNameSimilarityEdgeFilter("Rue Saint-Antoine O, Montr\u00e9al");
        Assertions.assertTrue((boolean)edgeFilter.accept(this.createTestEdgeIterator("Rue Saint-Antoine O")));
        Assertions.assertFalse((boolean)edgeFilter.accept(this.createTestEdgeIterator("Rue Saint-Jacques")));
        edgeFilter = this.createNameSimilarityEdgeFilter("Rue de Bleury");
        Assertions.assertTrue((boolean)edgeFilter.accept(this.createTestEdgeIterator("Rue de Bleury")));
        Assertions.assertFalse((boolean)edgeFilter.accept(this.createTestEdgeIterator("Rue Balmoral")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Main Rd").accept(this.createTestEdgeIterator("Main Road")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Main Road").accept(this.createTestEdgeIterator("Main Rd")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Main Rd").accept(this.createTestEdgeIterator("Main Road, New York")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Cape Point Rd").accept(this.createTestEdgeIterator("Cape Point")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Cape Point Rd").accept(this.createTestEdgeIterator("Cape Point Road")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Av. Juan Ram\u00f3n Ram\u00edrez").accept(this.createTestEdgeIterator("Avenida Juan Ram\u00f3n Ram\u00edrez")));
    }

    @Test
    public void testAcceptStForStreet() {
        EdgeIteratorState edge = this.createTestEdgeIterator("Augustine Street");
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Augustine St").accept(edge));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Augustine Street").accept(edge));
        edge = this.createTestEdgeIterator("Augustine St");
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Augustine St").accept(edge));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Augustine Street").accept(edge));
    }

    @Test
    public void testWithDash() {
        EdgeIteratorState edge = this.createTestEdgeIterator("Ben-Gurion-Stra\u00dfe");
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Ben-Gurion").accept(edge));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Ben Gurion").accept(edge));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("Ben Gurion Strasse").accept(edge));
        Assertions.assertFalse((boolean)this.createNameSimilarityEdgeFilter("Potsdamer Str.").accept(edge));
    }

    @Test
    public void normalization() {
        Assertions.assertEquals((Object)"northderby", (Object)this.createNameSimilarityEdgeFilter("North Derby Lane").getNormalizedPointHint());
        Assertions.assertEquals((Object)"28north", (Object)this.createNameSimilarityEdgeFilter("I-28 N").getNormalizedPointHint());
        Assertions.assertEquals((Object)"28north", (Object)this.createNameSimilarityEdgeFilter(" I-28    N  ").getNormalizedPointHint());
        Assertions.assertEquals((Object)"south23rd", (Object)this.createNameSimilarityEdgeFilter("S 23rd St").getNormalizedPointHint());
        Assertions.assertEquals((Object)"66", (Object)this.createNameSimilarityEdgeFilter("Route 66").getNormalizedPointHint());
        Assertions.assertEquals((Object)"fayettecounty1", (Object)this.createNameSimilarityEdgeFilter("Fayette County Rd 1").getNormalizedPointHint());
        Assertions.assertEquals((Object)"112", (Object)this.createNameSimilarityEdgeFilter("A B C 1 12").getNormalizedPointHint());
    }

    @Test
    public void testServiceMix() {
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("North Derby Lane").accept(this.createTestEdgeIterator("N Derby Ln")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("N Derby Ln").accept(this.createTestEdgeIterator("North Derby Lane")));
        Assertions.assertFalse((boolean)this.createNameSimilarityEdgeFilter("North Derby Lane").accept(this.createTestEdgeIterator("I-29 N")));
        Assertions.assertFalse((boolean)this.createNameSimilarityEdgeFilter("I-29 N").accept(this.createTestEdgeIterator("North Derby Lane")));
        Assertions.assertTrue((boolean)this.createNameSimilarityEdgeFilter("George Street").accept(this.createTestEdgeIterator("George St")));
    }

    @Test
    public void testAcceptWithTypos() {
        NameSimilarityEdgeFilter edgeFilter = this.createNameSimilarityEdgeFilter("Laufamholzstra\u00dfe 154 N\u00fcrnberg");
        EdgeIteratorState edge = this.createTestEdgeIterator("Laufamholzstra\u00dfe, ST1333");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter("Kaufamholzstra\u00dfe");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter("Kaufamholystra\u00dfe");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter("Kaufmholystra\u00dfe");
        Assertions.assertFalse((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter("Hauptstra\u00dfe");
        edge = this.createTestEdgeIterator("Hauptstra\u00dfe");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter("Hauptstrase");
        Assertions.assertTrue((boolean)edgeFilter.accept(edge));
        edgeFilter = this.createNameSimilarityEdgeFilter("Lauptstrase");
    }

    private NameSimilarityEdgeFilter createNameSimilarityEdgeFilter(String pointHint) {
        return new NameSimilarityEdgeFilter(edgeState -> true, pointHint, this.basePoint, 100.0);
    }

    @Test
    public void curvedWayGeometry_issue2319() {
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        PointList pointList = new PointList(20, false);
        pointList.add(43.844377, -79.264005);
        pointList.add(43.843771, -79.263824);
        pointList.add(43.843743, -79.2638);
        pointList.add(43.843725, -79.26375);
        pointList.add(43.843724, -79.263676);
        pointList.add(43.843801, -79.263412);
        pointList.add(43.843866, -79.263);
        pointList.add(43.843873, -79.262838);
        pointList.add(43.843863, -79.262801);
        pointList.add(43.843781, -79.262729);
        pointList.add(43.842408, -79.262395);
        pointList.add(43.842363, -79.262397);
        pointList.add(43.842336, -79.262422);
        pointList.add(43.842168, -79.263186);
        pointList.add(43.842152, -79.263348);
        pointList.add(43.842225, -79.263421);
        pointList.add(43.842379, -79.263441);
        pointList.add(43.842668, -79.26352);
        pointList.add(43.842777, -79.263566);
        pointList.add(43.842832, -79.263627);
        pointList.add(43.842833, -79.263739);
        pointList.add(43.842807, -79.263802);
        pointList.add(43.842691, -79.264477);
        pointList.add(43.842711, -79.264588);
        graph.getNodeAccess().setNode(0, 43.844521, -79.263976);
        graph.getNodeAccess().setNode(1, 43.842775, -79.264649);
        EdgeIteratorState doubtfire = graph.edge(0, 1).setWayGeometry(pointList).set((BooleanEncodedValue)accessEnc, true, true).set((DecimalEncodedValue)speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Doubtfire Crescent")));
        EdgeIteratorState golden = graph.edge(0, 1).set((BooleanEncodedValue)accessEnc, true, true).set((DecimalEncodedValue)speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Golden Avenue")));
        graph.getNodeAccess().setNode(2, 43.841501560244744, -79.26366394602502);
        graph.getNodeAccess().setNode(3, 43.842247922172724, -79.2605663670726);
        PointList pointList2 = new PointList(1, false);
        pointList2.add(43.84191413615452, -79.261912128223);
        EdgeIteratorState denison = graph.edge(2, 3).setWayGeometry(pointList2).set((BooleanEncodedValue)accessEnc, true, true).set((DecimalEncodedValue)speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"Denison Street")));
        double qlat = 43.842122;
        double qLon = -79.262162;
        NameSimilarityEdgeFilter filter = new NameSimilarityEdgeFilter(EdgeFilter.ALL_EDGES, "doubtfire", new GHPoint(qlat, qLon), 1000.0);
        Assertions.assertFalse((boolean)filter.accept(golden));
        Assertions.assertFalse((boolean)filter.accept(denison));
        Assertions.assertTrue((boolean)filter.accept(doubtfire));
        filter = new NameSimilarityEdgeFilter(EdgeFilter.ALL_EDGES, "doubtfire", new GHPoint(qlat, qLon), 100.0);
        Assertions.assertFalse((boolean)filter.accept(golden));
        Assertions.assertFalse((boolean)filter.accept(denison));
        Assertions.assertTrue((boolean)filter.accept(doubtfire));
    }

    private EdgeIteratorState createTestEdgeIterator(String name) {
        PointList pointList = new PointList();
        pointList.add(this.basePoint);
        EdgeIteratorState edge = new BaseGraph.Builder(1).create().edge(0, 1).setWayGeometry(pointList);
        if (name != null) {
            edge.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)name)));
        }
        return edge;
    }
}

