/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.AverageSlope;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.MaxSlope;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.SlopeCalculator;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PointList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SlopeCalculatorTest {
    SlopeCalculatorTest() {
    }

    @Test
    void simpleElevation() {
        DecimalEncodedValue averageEnc = AverageSlope.create();
        DecimalEncodedValue maxEnc = MaxSlope.create();
        new EncodingManager.Builder().add((EncodedValue)averageEnc).add((EncodedValue)maxEnc).build();
        SlopeCalculator creator = new SlopeCalculator(maxEnc, averageEnc);
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay way = new ReaderWay(1L);
        PointList pointList = new PointList(5, true);
        pointList.add(51.0, 12.001, 0.0);
        pointList.add(51.0, 12.002, 3.5);
        pointList.add(51.0, 12.003, 4.0);
        pointList.add(51.0, 12.004, 2.0);
        way.setTag("point_list", (Object)pointList);
        creator.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((double)Math.round(0.9523809523809524), (double)averageEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.001);
        Assertions.assertEquals((double)(-Math.round(0.9523809523809524)), (double)averageEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.001);
        Assertions.assertEquals((double)Math.round(1.6666666666666667), (double)maxEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.001);
        Assertions.assertEquals((double)(-Math.round(1.6666666666666667)), (double)maxEnc.getDecimal(true, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.001);
    }

    @Test
    public void testAveragingOfMaxSlope() {
        DecimalEncodedValue averageEnc = AverageSlope.create();
        DecimalEncodedValue maxEnc = MaxSlope.create();
        new EncodingManager.Builder().add((EncodedValue)averageEnc).add((EncodedValue)maxEnc).build();
        SlopeCalculator creator = new SlopeCalculator(maxEnc, averageEnc);
        ArrayEdgeIntAccess intAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        ReaderWay way = new ReaderWay(1L);
        PointList pointList = new PointList(5, true);
        pointList.add(51.0, 12.001, 10.0);
        pointList.add(51.0, 12.0014, 8.0);
        pointList.add(51.0, 12.0034, 8.0);
        pointList.add(51.0, 12.0054, 0.0);
        pointList.add(51.0, 12.007, 7.0);
        way.setTag("point_list", (Object)pointList);
        creator.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((double)(-Math.round(3.8095238095238098)), (double)maxEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess), (double)0.001);
        Assertions.assertEquals((double)Math.round(3.8095238095238098), (double)maxEnc.getDecimal(true, edgeId, (EdgeIntAccess)intAccess), (double)0.001);
    }

    @Test
    public void testMaxSlopeLargerThanMaxStorableDecimal() {
        PointList pointList = new PointList(5, true);
        pointList.add(47.7281561, 11.9993135, 1163.0);
        pointList.add(47.7282782, 11.9991944, 1163.0);
        pointList.add(47.7283135, 11.9991135, 1178.0);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("point_list", (Object)pointList);
        ArrayEdgeIntAccess intAccess = new ArrayEdgeIntAccess(1);
        DecimalEncodedValue averageEnc = AverageSlope.create();
        DecimalEncodedValue maxEnc = MaxSlope.create();
        new EncodingManager.Builder().add((EncodedValue)averageEnc).add((EncodedValue)maxEnc).build();
        SlopeCalculator creator = new SlopeCalculator(maxEnc, averageEnc);
        int edgeId = 0;
        creator.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((double)31.0, (double)maxEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess), (double)0.001);
        Assertions.assertEquals((double)-31.0, (double)averageEnc.getDecimal(true, edgeId, (EdgeIntAccess)intAccess), (double)0.001);
    }

    @Test
    public void testMaxSlopeSmallerThanMinStorableDecimal() {
        PointList pointList = new PointList(5, true);
        pointList.add(47.7283135, 11.9991135, 1178.0);
        pointList.add(47.7282782, 11.9991944, 1163.0);
        pointList.add(47.7281561, 11.9993135, 1163.0);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("point_list", (Object)pointList);
        ArrayEdgeIntAccess intAccess = new ArrayEdgeIntAccess(1);
        DecimalEncodedValue averageEnc = AverageSlope.create();
        DecimalEncodedValue maxEnc = MaxSlope.create();
        new EncodingManager.Builder().add((EncodedValue)averageEnc).add((EncodedValue)maxEnc).build();
        SlopeCalculator creator = new SlopeCalculator(maxEnc, averageEnc);
        int edgeId = 0;
        creator.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((double)-31.0, (double)maxEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess), (double)0.001);
        Assertions.assertEquals((double)31.0, (double)averageEnc.getDecimal(true, edgeId, (EdgeIntAccess)intAccess), (double)0.001);
    }

    @Test
    public void test2D() {
        ArrayEdgeIntAccess intAccess = new ArrayEdgeIntAccess(1);
        int edgeId = 0;
        PointList pointList = new PointList(5, false);
        pointList.add(47.7283135, 11.9991135);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("point_list", (Object)pointList);
        DecimalEncodedValue averageEnc = AverageSlope.create();
        DecimalEncodedValue maxEnc = MaxSlope.create();
        new EncodingManager.Builder().add((EncodedValue)averageEnc).add((EncodedValue)maxEnc).build();
        SlopeCalculator creator = new SlopeCalculator(maxEnc, averageEnc);
        creator.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, IntsRef.EMPTY);
        Assertions.assertEquals((double)0.0, (double)maxEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess), (double)0.001);
        Assertions.assertEquals((double)0.0, (double)averageEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess), (double)0.001);
    }
}

