/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.SnapPreventionEdgeFilter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnapPreventionEdgeFilterTest {
    @Test
    public void accept() {
        EdgeFilter trueFilter = edgeState -> true;
        EncodingManager em = new EncodingManager.Builder().add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadEnvironment.create()).build();
        EnumEncodedValue rcEnc = em.getEnumEncodedValue("road_class", RoadClass.class);
        EnumEncodedValue reEnc = em.getEnumEncodedValue("road_environment", RoadEnvironment.class);
        SnapPreventionEdgeFilter filter = new SnapPreventionEdgeFilter(trueFilter, rcEnc, reEnc, Arrays.asList("motorway", "ferry"));
        BaseGraph graph = new BaseGraph.Builder(em).create();
        EdgeIteratorState edge = graph.edge(0, 1).setDistance(1.0);
        Assertions.assertTrue((boolean)filter.accept(edge));
        edge.set(reEnc, (Enum)RoadEnvironment.FERRY);
        Assertions.assertFalse((boolean)filter.accept(edge));
        edge.set(reEnc, (Enum)RoadEnvironment.FORD);
        Assertions.assertTrue((boolean)filter.accept(edge));
        edge.set(rcEnc, (Enum)RoadClass.RESIDENTIAL);
        Assertions.assertTrue((boolean)filter.accept(edge));
        edge.set(rcEnc, (Enum)RoadClass.MOTORWAY);
        Assertions.assertFalse((boolean)filter.accept(edge));
    }
}

