/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.countryrules;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.europe.AustriaCountryRule;
import com.graphhopper.routing.util.countryrules.europe.GermanyCountryRule;
import com.graphhopper.routing.util.countryrules.europe.HungaryCountryRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CountryRuleTest {
    CountryRuleTest() {
    }

    @Test
    void germany() {
        GermanyCountryRule rule = new GermanyCountryRule();
        Assertions.assertEquals((Object)RoadAccess.DESTINATION, (Object)rule.getAccess(this.createReaderWay("track"), TransportationMode.CAR, RoadAccess.YES));
        Assertions.assertEquals((Object)RoadAccess.YES, (Object)rule.getAccess(this.createReaderWay("primary"), TransportationMode.CAR, RoadAccess.YES));
    }

    @Test
    void austria() {
        AustriaCountryRule rule = new AustriaCountryRule();
        Assertions.assertEquals((Object)RoadAccess.FORESTRY, (Object)rule.getAccess(this.createReaderWay("track"), TransportationMode.CAR, RoadAccess.YES));
        Assertions.assertEquals((Object)RoadAccess.YES, (Object)rule.getAccess(this.createReaderWay("primary"), TransportationMode.CAR, RoadAccess.YES));
        Assertions.assertEquals((Object)RoadAccess.DESTINATION, (Object)rule.getAccess(this.createReaderWay("living_street"), TransportationMode.CAR, RoadAccess.YES));
    }

    @Test
    void hungary() {
        HungaryCountryRule rule = new HungaryCountryRule();
        Assertions.assertEquals((Object)RoadAccess.YES, (Object)rule.getAccess(this.createReaderWay("primary"), TransportationMode.CAR, RoadAccess.YES));
        Assertions.assertEquals((Object)RoadAccess.DESTINATION, (Object)rule.getAccess(this.createReaderWay("living_street"), TransportationMode.CAR, RoadAccess.YES));
        Assertions.assertEquals((Object)RoadAccess.YES, (Object)rule.getAccess(this.createReaderWay("living_street"), TransportationMode.BIKE, RoadAccess.YES));
        Assertions.assertEquals((Object)RoadAccess.PRIVATE, (Object)rule.getAccess(this.createReaderWay("living_street"), TransportationMode.CAR, RoadAccess.PRIVATE));
        Assertions.assertEquals((Object)RoadAccess.PRIVATE, (Object)rule.getAccess(this.createReaderWay("living_street"), TransportationMode.BIKE, RoadAccess.PRIVATE));
    }

    private ReaderWay createReaderWay(String highway) {
        ReaderWay readerWay = new ReaderWay(123L);
        readerWay.setTag("highway", (Object)highway);
        return readerWay;
    }
}

