/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.MtbNetwork;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.BikeCommonAccessParser;
import com.graphhopper.routing.util.parsers.BikeCommonAverageSpeedParser;
import com.graphhopper.routing.util.parsers.BikeCommonPriorityParser;
import com.graphhopper.routing.util.parsers.OSMBikeNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMMtbNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMSmoothnessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractBikeTagParserTester {
    protected EncodingManager encodingManager;
    protected BikeCommonAccessParser accessParser;
    protected BikeCommonAverageSpeedParser speedParser;
    protected BikeCommonPriorityParser priorityParser;
    protected OSMParsers osmParsers;
    protected DecimalEncodedValue priorityEnc;
    protected DecimalEncodedValue avgSpeedEnc;
    protected BooleanEncodedValue accessEnc;

    @BeforeEach
    public void setUp() {
        this.encodingManager = this.createEncodingManager();
        this.accessParser = this.createAccessParser((EncodedValueLookup)this.encodingManager, new PMap("block_fords=true"));
        this.speedParser = this.createAverageSpeedParser((EncodedValueLookup)this.encodingManager);
        this.priorityParser = this.createPriorityParser((EncodedValueLookup)this.encodingManager);
        this.osmParsers = new OSMParsers().addRelationTagParser(relConfig -> new OSMBikeNetworkTagParser(this.encodingManager.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class), relConfig)).addRelationTagParser(relConfig -> new OSMMtbNetworkTagParser(this.encodingManager.getEnumEncodedValue(MtbNetwork.KEY, RouteNetwork.class), relConfig)).addWayTagParser((TagParser)new OSMSmoothnessParser(this.encodingManager.getEnumEncodedValue("smoothness", Smoothness.class))).addWayTagParser((TagParser)this.accessParser).addWayTagParser((TagParser)this.speedParser).addWayTagParser((TagParser)this.priorityParser);
        this.priorityEnc = this.priorityParser.getPriorityEnc();
        this.avgSpeedEnc = this.speedParser.getAverageSpeedEnc();
        this.accessEnc = this.accessParser.getAccessEnc();
    }

    protected abstract EncodingManager createEncodingManager();

    protected abstract BikeCommonAccessParser createAccessParser(EncodedValueLookup var1, PMap var2);

    protected abstract BikeCommonAverageSpeedParser createAverageSpeedParser(EncodedValueLookup var1);

    protected abstract BikeCommonPriorityParser createPriorityParser(EncodedValueLookup var1);

    protected void assertPriority(PriorityCode expectedPrio, ReaderWay way) {
        IntsRef relFlags = this.osmParsers.handleRelationTags(new ReaderRelation(0L), this.osmParsers.createRelationFlags());
        ArrayEdgeIntAccess intAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.osmParsers.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, relFlags);
        Assertions.assertEquals((double)PriorityCode.getValue((int)expectedPrio.getValue()), (double)this.priorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess), (double)0.01);
    }

    protected void assertPriorityAndSpeed(PriorityCode expectedPrio, double expectedSpeed, ReaderWay way) {
        this.assertPriorityAndSpeed(expectedPrio, expectedSpeed, way, new ReaderRelation(0L));
    }

    protected void assertPriorityAndSpeed(PriorityCode expectedPrio, double expectedSpeed, ReaderWay way, ReaderRelation rel) {
        IntsRef relFlags = this.osmParsers.handleRelationTags(rel, this.osmParsers.createRelationFlags());
        ArrayEdgeIntAccess intAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.osmParsers.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, relFlags);
        Assertions.assertEquals((double)PriorityCode.getValue((int)expectedPrio.getValue()), (double)this.priorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess), (double)0.01);
        Assertions.assertEquals((double)expectedSpeed, (double)this.avgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess), (double)0.1);
        Assertions.assertEquals((double)expectedSpeed, (double)this.avgSpeedEnc.getDecimal(true, edgeId, (EdgeIntAccess)intAccess), (double)0.1);
    }

    protected double getSpeedFromFlags(ReaderWay way) {
        IntsRef relFlags = this.osmParsers.createRelationFlags();
        ArrayEdgeIntAccess intAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.osmParsers.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, relFlags);
        return this.avgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess);
    }

    @Test
    public void testAccess() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"motorway");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("highway", (Object)"motorway");
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("highway", (Object)"footway");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("highway", (Object)"footway");
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("highway", (Object)"pedestrian");
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("highway", (Object)"pedestrian");
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"yes");
        way.setTag("highway", (Object)"cycleway");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"path");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("vehicle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"path");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("highway", (Object)"path");
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"track");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("mtb", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("foot", (Object)"official");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"official");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"service");
        way.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("motorroad", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("ford", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        way.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("bicycle", (Object)"dismount");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        way.setTag("vehicle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"dismount");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"cycleway");
        way.setTag("cycleway", (Object)"track");
        way.setTag("railway", (Object)"abandoned");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"platform");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"platform");
        way.setTag("bicycle", (Object)"dismount");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"platform");
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("vehicle", (Object)"forestry");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
    }

    @Test
    public void testRelation() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("bicycle", (Object)"yes");
        way.setTag("foot", (Object)"yes");
        way.setTag("motor_vehicle", (Object)"agricultural");
        way.setTag("surface", (Object)"gravel");
        way.setTag("tracktype", (Object)"grade3");
        ReaderRelation rel = new ReaderRelation(0L);
        rel.setTag("type", (Object)"route");
        rel.setTag("network", (Object)"rcn");
        rel.setTag("route", (Object)"bicycle");
        ReaderRelation rel2 = new ReaderRelation(1L);
        rel2.setTag("type", (Object)"route");
        rel2.setTag("network", (Object)"lcn");
        rel2.setTag("route", (Object)"bicycle");
        IntsRef relFlags = this.osmParsers.handleRelationTags(rel2, this.osmParsers.handleRelationTags(rel, this.osmParsers.createRelationFlags()));
        ArrayEdgeIntAccess intAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.osmParsers.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, relFlags);
        EnumEncodedValue enc = this.encodingManager.getEnumEncodedValue(RouteNetwork.key((String)"bike"), RouteNetwork.class);
        Assertions.assertEquals((Object)RouteNetwork.REGIONAL, (Object)enc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
    }

    @Test
    public void testTramStations() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("railway", (Object)"rail");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("railway", (Object)"station");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("railway", (Object)"station");
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way = new ReaderWay(1L);
        way.setTag("railway", (Object)"platform");
        ArrayEdgeIntAccess intAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, null);
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, null);
        Assertions.assertEquals((double)4.0, (double)this.avgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess));
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)intAccess));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("railway", (Object)"platform");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, null);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)intAccess));
        this.speedParser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way, null);
        Assertions.assertEquals((double)4.0, (double)this.avgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess));
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("railway", (Object)"platform");
        way.setTag("bicycle", (Object)"no");
        intAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, way);
        Assertions.assertEquals((double)0.0, (double)this.avgSpeedEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess));
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)intAccess));
    }

    @Test
    public void testAvoidTunnel() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"residential");
        this.assertPriority(PriorityCode.PREFER, osmWay);
        osmWay.setTag("tunnel", (Object)"yes");
        this.assertPriority(PriorityCode.UNCHANGED, osmWay);
        osmWay.setTag("highway", (Object)"secondary");
        osmWay.setTag("tunnel", (Object)"yes");
        this.assertPriority(PriorityCode.BAD, osmWay);
        osmWay.setTag("bicycle", (Object)"designated");
        this.assertPriority(PriorityCode.PREFER, osmWay);
    }

    @Test
    public void testTram() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("railway", (Object)"tram");
        this.assertPriority(PriorityCode.AVOID_MORE, way);
        way.setTag("bicycle", (Object)"designated");
        this.assertPriority(PriorityCode.PREFER, way);
    }

    @Test
    public void testService() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"service");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.setTag("service", (Object)"parking_aisle");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
    }

    @Test
    public void testSteps() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"steps");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 2.0, way);
        way.setTag("bicycle", (Object)"designated");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 2.0, way);
    }

    @Test
    public void testReduceToMaxSpeed() {
        ReaderWay way = new ReaderWay(12L);
        way.setTag("maxspeed", (Object)"90");
        Assertions.assertEquals((double)12.0, (double)this.speedParser.applyMaxSpeed(way, 12.0, true), (double)0.01);
    }

    @Test
    public void testHandleWayTagsCallsHandlePriority() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"cycleway");
        ArrayEdgeIntAccess intAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.priorityParser.handleWayTags(edgeId, (EdgeIntAccess)intAccess, osmWay, null);
        Assertions.assertEquals((double)PriorityCode.getValue((int)PriorityCode.VERY_NICE.getValue()), (double)this.priorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)intAccess), (double)0.001);
    }

    @Test
    public void testLockedGate() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        node.setTag("locked", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
    }

    @Test
    public void testNoBike() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
    }

    @Test
    public void testBarrierAccess() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        node.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        node.setTag("access", (Object)"yes");
        node.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        node.setTag("access", (Object)"no");
        node.setTag("foot", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"gate");
        node.setTag("access", (Object)"no");
        node.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
    }

    @Test
    public void testBarrierAccessFord() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("ford", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
    }

    @Test
    public void testFerries() {
        ReaderWay way = new ReaderWay(1L);
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("bicycle", (Object)"no");
        Assertions.assertFalse((boolean)this.accessParser.getAccess(way).isFerry());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        way.setTag("foot", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.getAccess(way).isFerry());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        way.setTag("bicycle", (Object)"yes");
        way.setTag("access", (Object)"private");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        way.setTag("bicycle", (Object)"designated");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("bicycle", (Object)"official");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("bicycle", (Object)"permissive");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("foot", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isFerry());
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("bicycle", (Object)"designated");
        way.setTag("access", (Object)"private");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("route", (Object)"ferry");
        way.setTag("foot", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
    }

    @Test
    void privateAndFords() {
        BikeCommonAccessParser bike = this.createAccessParser((EncodedValueLookup)this.encodingManager, new PMap());
        Assertions.assertFalse((boolean)bike.isBlockFords());
        Assertions.assertTrue((boolean)bike.restrictedValues.contains("private"));
        Assertions.assertFalse((boolean)bike.allowedValues.contains("private"));
        ReaderNode node = new ReaderNode(1L, 1.0, 1.0);
        node.setTag("access", (Object)"private");
        Assertions.assertTrue((boolean)bike.isBarrier(node));
        bike = this.createAccessParser((EncodedValueLookup)this.encodingManager, new PMap("block_fords=true|block_private=false"));
        Assertions.assertTrue((boolean)bike.isBlockFords());
        Assertions.assertFalse((boolean)bike.restrictedValues.contains("private"));
        Assertions.assertTrue((boolean)bike.allowedValues.contains("private"));
        Assertions.assertFalse((boolean)bike.isBarrier(node));
    }

    @Test
    public void testOneway() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"tertiary");
        this.assertAccess(way, true, true);
        way.setTag("oneway", (Object)"yes");
        this.assertAccess(way, true, false);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("oneway:bicycle", (Object)"yes");
        this.assertAccess(way, true, false);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("oneway:bicycle", (Object)"no");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("oneway:bicycle", (Object)"-1");
        this.assertAccess(way, false, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("cycleway:right:oneway", (Object)"no");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("cycleway:right:oneway", (Object)"-1");
        this.assertAccess(way, false, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("vehicle:forward", (Object)"no");
        this.assertAccess(way, false, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("bicycle:forward", (Object)"no");
        this.assertAccess(way, false, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("vehicle:backward", (Object)"no");
        this.assertAccess(way, true, false);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("motor_vehicle:backward", (Object)"no");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("bicycle:backward", (Object)"no");
        this.assertAccess(way, true, false);
        way.setTag("bicycle:backward", (Object)"yes");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("oneway", (Object)"yes");
        way.setTag("bicycle:backward", (Object)"yes");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("oneway", (Object)"-1");
        way.setTag("bicycle:forward", (Object)"yes");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("bicycle:forward", (Object)"use_sidepath");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("bicycle:forward", (Object)"use_sidepath");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("cycleway", (Object)"opposite");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("oneway", (Object)"yes");
        way.setTag("cycleway:left", (Object)"opposite_lane");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        way.setTag("cycleway:left:oneway", (Object)"-1");
        way.setTag("cycleway:both", (Object)"track");
        this.assertAccess(way, true, true);
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("cycleway:both", (Object)"no");
        this.assertAccess(way, true, false);
    }

    @Test
    public void testOnewayIssue3162() {
        ReaderWay way = new ReaderWay(1L);
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        way.setTag("cycleway:left:oneway", (Object)"yes");
        way.setTag("cycleway:right:oneway", (Object)"-1");
        this.assertAccess(way, true, true);
        way.setTag("cycleway:left:oneway", (Object)"-1");
        way.setTag("cycleway:right:oneway", (Object)"yes");
        this.assertAccess(way, true, true);
        way.setTag("cycleway:left:oneway", (Object)"1");
        way.setTag("cycleway:right:oneway", (Object)"-1");
        this.assertAccess(way, true, true);
        way.setTag("cycleway:left:oneway", (Object)"no");
        way.setTag("cycleway:right:oneway", (Object)"yes");
        this.assertAccess(way, true, true);
        way.setTag("cycleway:left:oneway", (Object)"no");
        way.setTag("cycleway:right:oneway", (Object)"1");
        this.assertAccess(way, true, true);
        way.setTag("cycleway:left:oneway", (Object)"no");
        way.setTag("cycleway:right:oneway", (Object)"-1");
        this.assertAccess(way, true, true);
        way.setTag("cycleway:left:oneway", (Object)"yes");
        way.setTag("cycleway:right:oneway", (Object)"no");
        this.assertAccess(way, true, true);
        way.setTag("cycleway:left:oneway", (Object)"-1");
        way.setTag("cycleway:right:oneway", (Object)"no");
        this.assertAccess(way, true, true);
        way.setTag("cycleway:left:oneway", (Object)"-1");
        way.setTag("cycleway:right:oneway", (Object)"-1");
        this.assertAccess(way, true, true);
    }

    private void assertAccess(ReaderWay way, boolean fwd, boolean bwd) {
        ArrayEdgeIntAccess edgeIntAccess = new ArrayEdgeIntAccess(1);
        int edge = 0;
        IntsRef relationFlags = new IntsRef(1);
        this.accessParser.handleWayTags(edge, (EdgeIntAccess)edgeIntAccess, way, relationFlags);
        if (fwd) {
            Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edge, (EdgeIntAccess)edgeIntAccess));
        }
        if (bwd) {
            Assertions.assertTrue((boolean)this.accessEnc.getBool(true, edge, (EdgeIntAccess)edgeIntAccess));
        }
    }
}

