/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BikeRoadAccess;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.ev.FootRoadAccess;
import com.graphhopper.routing.ev.HikeRating;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.MtbRating;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.BikeAccessParser;
import com.graphhopper.routing.util.parsers.BikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.BikePriorityParser;
import com.graphhopper.routing.util.parsers.MountainBikeAccessParser;
import com.graphhopper.routing.util.parsers.MountainBikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.MountainBikePriorityParser;
import com.graphhopper.routing.util.parsers.OSMHikeRatingParser;
import com.graphhopper.routing.util.parsers.OSMMtbRatingParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.RacingBikeAccessParser;
import com.graphhopper.routing.util.parsers.RacingBikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.RacingBikePriorityParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BikeCustomModelTest {
    private EncodingManager em;
    private OSMParsers parsers;

    @BeforeEach
    public void setup() {
        IntEncodedValue bikeRating = MtbRating.create();
        IntEncodedValue hikeRating = HikeRating.create();
        EnumEncodedValue bikeRA = BikeRoadAccess.create();
        this.em = new EncodingManager.Builder().add((EncodedValue)VehicleAccess.create((String)"bike")).add((EncodedValue)VehicleSpeed.create((String)"bike", (int)4, (double)2.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"bike", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)VehicleAccess.create((String)"mtb")).add((EncodedValue)VehicleSpeed.create((String)"mtb", (int)4, (double)2.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"mtb", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)VehicleAccess.create((String)"racingbike")).add((EncodedValue)VehicleSpeed.create((String)"racingbike", (int)4, (double)2.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"racingbike", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)FerrySpeed.create()).add((EncodedValue)Country.create()).add((EncodedValue)RoadClass.create()).add((EncodedValue)RouteNetwork.create((String)BikeNetwork.KEY)).add((EncodedValue)Roundabout.create()).add((EncodedValue)Smoothness.create()).add((EncodedValue)RoadAccess.create()).add((EncodedValue)bikeRA).add((EncodedValue)FootRoadAccess.create()).add((EncodedValue)bikeRating).add((EncodedValue)hikeRating).build();
        this.parsers = new OSMParsers().addWayTagParser((TagParser)new OSMMtbRatingParser(bikeRating)).addWayTagParser((TagParser)new OSMHikeRatingParser(hikeRating));
        this.parsers.addWayTagParser((TagParser)new BikeAccessParser((EncodedValueLookup)this.em, new PMap()));
        this.parsers.addWayTagParser((TagParser)new MountainBikeAccessParser((EncodedValueLookup)this.em, new PMap()));
        this.parsers.addWayTagParser((TagParser)new RacingBikeAccessParser((EncodedValueLookup)this.em, new PMap()));
        this.parsers.addWayTagParser((TagParser)new BikeAverageSpeedParser((EncodedValueLookup)this.em));
        this.parsers.addWayTagParser((TagParser)new MountainBikeAverageSpeedParser((EncodedValueLookup)this.em));
        this.parsers.addWayTagParser((TagParser)new RacingBikeAverageSpeedParser((EncodedValueLookup)this.em));
        this.parsers.addWayTagParser((TagParser)new BikePriorityParser((EncodedValueLookup)this.em));
        this.parsers.addWayTagParser((TagParser)new MountainBikePriorityParser((EncodedValueLookup)this.em));
        this.parsers.addWayTagParser((TagParser)new RacingBikePriorityParser((EncodedValueLookup)this.em));
        this.parsers.addWayTagParser((TagParser)new OSMRoadAccessParser(bikeRA, OSMRoadAccessParser.toOSMRestrictions((TransportationMode)TransportationMode.BIKE), (readerWay, accessValue) -> accessValue, BikeRoadAccess::find));
    }

    EdgeIteratorState createEdge(ReaderWay way) {
        BaseGraph graph = new BaseGraph.Builder(this.em).create();
        EdgeIteratorState edge = graph.edge(0, 1);
        EdgeIntAccess edgeIntAccess = graph.getEdgeAccess();
        this.parsers.handleWayTags(edge.getEdge(), edgeIntAccess, way, this.em.createRelationFlags());
        return edge;
    }

    @Test
    public void testCustomBike() {
        CustomModel cm = GHUtility.loadCustomModelFromJar((String)"bike.json");
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"path");
        way.setTag("surface", (Object)"ground");
        EdgeIteratorState edge = this.createEdge(way);
        CustomWeighting.Parameters p = CustomModelParser.createWeightingParameters((CustomModel)cm, (EncodedValueLookup)this.em);
        Assertions.assertEquals((double)0.9, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("mtb:scale", (Object)"0");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.9, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("mtb:scale", (Object)"1+");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.9, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("mtb:scale", (Object)"2-");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.removeTag("mtb:scale");
        way.setTag("sac_scale", (Object)"hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.9, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("sac_scale", (Object)"mountain_hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        Assertions.assertEquals((double)4.0, (double)p.getEdgeToSpeedMapping().get(edge, false), (double)0.01);
        way.clearTags();
        way.setTag("highway", (Object)"tertiary");
        way.setTag("vehicle", (Object)"destination");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)6.0, (double)p.getEdgeToSpeedMapping().get(edge, false), (double)0.01);
    }

    @Test
    public void testCustomMtbBike() {
        CustomModel cm = GHUtility.loadCustomModelFromJar((String)"mtb.json");
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"path");
        way.setTag("surface", (Object)"ground");
        EdgeIteratorState edge = this.createEdge(way);
        CustomWeighting.Parameters p = CustomModelParser.createWeightingParameters((CustomModel)cm, (EncodedValueLookup)this.em);
        Assertions.assertEquals((double)1.2, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        Assertions.assertEquals((double)16.0, (double)p.getEdgeToSpeedMapping().get(edge, false), (double)0.01);
        way.setTag("mtb:scale", (Object)"3");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.6, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("mtb:scale", (Object)"5");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.6, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        Assertions.assertEquals((double)4.0, (double)p.getEdgeToSpeedMapping().get(edge, false), (double)0.01);
        way.setTag("mtb:scale", (Object)"6");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.removeTag("mtb:scale");
        way.setTag("sac_scale", (Object)"hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)1.2, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("sac_scale", (Object)"mountain_hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)1.2, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("sac_scale", (Object)"alpine_hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)1.2, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("sac_scale", (Object)"demanding_alpine_hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
    }

    @Test
    public void testCustomRacingBike() {
        CustomModel cm = GHUtility.loadCustomModelFromJar((String)"racingbike.json");
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"path");
        EdgeIteratorState edge = this.createEdge(way);
        CustomWeighting.Parameters p = CustomModelParser.createWeightingParameters((CustomModel)cm, (EncodedValueLookup)this.em);
        Assertions.assertEquals((double)0.9, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        Assertions.assertEquals((double)8.0, (double)p.getEdgeToSpeedMapping().get(edge, false), (double)0.01);
        way.setTag("mtb:scale", (Object)"0");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.9, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("mtb:scale", (Object)"1");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.45, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("mtb:scale", (Object)"2");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.removeTag("mtb:scale");
        way.setTag("sac_scale", (Object)"hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.9, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("sac_scale", (Object)"mountain_hiking");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)0.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
    }
}

