/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.ArrayEdgeIntAccess;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.ev.MtbNetwork;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.AbstractBikeTagParserTester;
import com.graphhopper.routing.util.parsers.BikeAccessParser;
import com.graphhopper.routing.util.parsers.BikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.BikeCommonAccessParser;
import com.graphhopper.routing.util.parsers.BikeCommonAverageSpeedParser;
import com.graphhopper.routing.util.parsers.BikeCommonPriorityParser;
import com.graphhopper.routing.util.parsers.BikePriorityParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BikeTagParserTest
extends AbstractBikeTagParserTester {
    @Override
    protected EncodingManager createEncodingManager() {
        return new EncodingManager.Builder().add((EncodedValue)VehicleAccess.create((String)"bike")).add((EncodedValue)VehicleSpeed.create((String)"bike", (int)4, (double)2.0, (boolean)false)).add((EncodedValue)VehiclePriority.create((String)"bike", (int)4, (double)PriorityCode.getFactor((int)1), (boolean)false)).add((EncodedValue)Roundabout.create()).add((EncodedValue)Smoothness.create()).add((EncodedValue)FerrySpeed.create()).add((EncodedValue)RouteNetwork.create((String)BikeNetwork.KEY)).add((EncodedValue)RouteNetwork.create((String)MtbNetwork.KEY)).build();
    }

    @Override
    protected BikeCommonAccessParser createAccessParser(EncodedValueLookup lookup, PMap pMap) {
        return new BikeAccessParser(lookup, pMap);
    }

    @Override
    protected BikeCommonAverageSpeedParser createAverageSpeedParser(EncodedValueLookup lookup) {
        return new BikeAverageSpeedParser(lookup);
    }

    @Override
    protected BikeCommonPriorityParser createPriorityParser(EncodedValueLookup lookup) {
        return new BikePriorityParser(lookup);
    }

    @Test
    public void testSpeedAndPriority() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 18.0, way);
        way.setTag("scenic", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.AVOID_MORE, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"living_street");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 6.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"footway");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.setTag("surface", (Object)"paved");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        way.setTag("bicycle", (Object)"dismount");
        this.assertPriorityAndSpeed(PriorityCode.AVOID, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"footway");
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.setTag("segregated", (Object)"no");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.setTag("segregated", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"footway");
        way.setTag("surface", (Object)"paved");
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.setTag("surface", (Object)"cobblestone");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 8.0, way);
        way.setTag("segregated", (Object)"yes");
        way.setTag("surface", (Object)"paved");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"platform");
        way.setTag("surface", (Object)"paved");
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.setTag("segregated", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"cycleway");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 18.0, way);
        int cyclewaySpeed = 18;
        way.setTag("foot", (Object)"yes");
        way.setTag("segregated", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.setTag("segregated", (Object)"no");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, cyclewaySpeed, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("bicycle", (Object)"designated");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.setTag("foot", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, cyclewaySpeed, way);
        way.setTag("foot", (Object)"no");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.setTag("segregated", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.setTag("segregated", (Object)"no");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.setTag("segregated", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, cyclewaySpeed, way);
        way.setTag("surface", (Object)"unpaved");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.setTag("surface", (Object)"paved");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("bicycle", (Object)"designated");
        way.setTag("segregated", (Object)"no");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.setTag("surface", (Object)"asphalt");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.setTag("tracktype", (Object)"grade1");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.removeTag("surface");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("surface", (Object)"paved");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("surface", (Object)"ground");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("bicycle", (Object)"designated");
        way.setTag("tracktype", (Object)"grade4");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 6.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"platform");
        way.setTag("surface", (Object)"paved");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"footway");
        way.setTag("surface", (Object)"paved");
        way.setTag("bicycle", (Object)"designated");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.clearTags();
        way.setTag("highway", (Object)"footway");
        way.setTag("tracktype", (Object)"grade4");
        way.setTag("bicycle", (Object)"designated");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 6.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"platform");
        way.setTag("surface", (Object)"paved");
        way.setTag("bicycle", (Object)"designated");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, cyclewaySpeed, way);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 12.0, way);
        way.setTag("vehicle", (Object)"no");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 4.0, way);
        way.setTag("vehicle", (Object)"forestry;agricultural");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("surface", (Object)"concrete");
        way.setTag("vehicle", (Object)"agricultural");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("tracktype", (Object)"grade1");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 18.0, way);
        way.setTag("highway", (Object)"track");
        way.setTag("tracktype", (Object)"grade2");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 12.0, way);
        way.setTag("highway", (Object)"track");
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 12.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"steps");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 2.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("bicycle", (Object)"use_sidepath");
        this.assertPriorityAndSpeed(PriorityCode.REACH_DESTINATION, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"steps");
        way.setTag("surface", (Object)"wood");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 2.0, way);
        way.setTag("maxspeed", (Object)"20");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 2.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 12.0, way);
        way.setTag("surface", (Object)"paved");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("surface", (Object)"ground");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("bicycle", (Object)"yes");
        way.setTag("surface", (Object)"fine_gravel");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 14.0, way);
        way.setTag("surface", (Object)"unknown_surface");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 4.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("surface", (Object)"fine_gravel");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 14.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("surface", (Object)"gravel");
        way.setTag("tracktype", (Object)"grade2");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 12.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("surface", (Object)"paved");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        this.assertPriorityAndSpeed(PriorityCode.BAD, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("surface", (Object)"asphalt");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"motorway");
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.REACH_DESTINATION, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"trunk");
        this.assertPriorityAndSpeed(PriorityCode.REACH_DESTINATION, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"cycleway");
        way.setTag("vehicle", (Object)"no");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 4.0, way);
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 18.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"bridleway");
        this.assertPriorityAndSpeed(PriorityCode.AVOID, 4.0, way);
        way.setTag("surface", (Object)"gravel");
        this.assertPriorityAndSpeed(PriorityCode.AVOID, 12.0, way);
        way.setTag("bicycle", (Object)"designated");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
    }

    @Test
    public void testSmoothness() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"residential");
        way.setTag("smoothness", (Object)"excellent");
        Assertions.assertEquals((double)20.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"bad");
        Assertions.assertEquals((double)12.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"impassable");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"unknown");
        Assertions.assertEquals((double)12.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("surface", (Object)"ground");
        Assertions.assertEquals((double)12.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"bad");
        Assertions.assertEquals((double)8.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("tracktype", (Object)"grade5");
        Assertions.assertEquals((double)4.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"bad");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
        way.setTag("smoothness", (Object)"impassable");
        Assertions.assertEquals((double)2.0, (double)this.getSpeedFromFlags(way), (double)0.01);
    }

    @Test
    public void testLowMaxSpeedIsIgnored() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"residential");
        way.setTag("maxspeed", (Object)"3");
        Assertions.assertEquals((double)18.0, (double)this.getSpeedFromFlags(way), (double)0.01);
    }

    @Test
    public void testCycleway() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("surface", (Object)"paved");
        this.assertPriority(PriorityCode.BAD, way);
        way.setTag("cycleway", (Object)"track");
        this.assertPriority(PriorityCode.PREFER, way);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("cycleway:left", (Object)"lane");
        this.assertPriority(PriorityCode.SLIGHT_PREFER, way);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("cycleway:right", (Object)"lane");
        this.assertPriority(PriorityCode.SLIGHT_PREFER, way);
        way.setTag("cycleway:left", (Object)"no");
        this.assertPriority(PriorityCode.SLIGHT_PREFER, way);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("cycleway:both", (Object)"lane");
        this.assertPriority(PriorityCode.SLIGHT_PREFER, way);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("cycleway:left", (Object)"opposite_lane");
        this.assertPriority(PriorityCode.BAD, way);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("oneway", (Object)"yes");
        way.setTag("cycleway", (Object)"opposite_track");
        this.assertPriority(PriorityCode.SLIGHT_PREFER, way);
        way.clearTags();
        way.setTag("highway", (Object)"primary");
        way.setTag("cycleway:bicycle", (Object)"designated");
        this.assertPriority(PriorityCode.PREFER, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("bicycle_road", (Object)"yes");
        this.assertPriority(PriorityCode.VERY_NICE, way);
        way.clearTags();
        way.setTag("highway", (Object)"path");
        way.setTag("cyclestreet", (Object)"yes");
        this.assertPriority(PriorityCode.VERY_NICE, way);
        way.clearTags();
        way.setTag("highway", (Object)"secondary");
        way.setTag("cycleway", (Object)"lane");
        way.setTag("cycleway:lane", (Object)"advisory");
        this.assertPriority(PriorityCode.SLIGHT_PREFER, way);
    }

    @Test
    public void testWayAcceptance() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"cycleway");
        way.setTag("vehicle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("bicycle", (Object)"designated");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"cycleway");
        way.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("bicycle", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.clearTags();
        way.setTag("highway", (Object)"motorway");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).canSkip());
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"residential");
        way.setTag("bicycle", (Object)"yes");
        way.setTag("access", (Object)"no");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"bridleway");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("bicycle", (Object)"yes");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.clearTags();
        way.setTag("highway", (Object)"track");
        way.setTag("vehicle", (Object)"forestry");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
        way.setTag("vehicle", (Object)"agricultural;forestry");
        Assertions.assertTrue((boolean)this.accessParser.getAccess(way).isWay());
    }

    @Test
    public void testPreferenceForSlowSpeed() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"tertiary");
        this.assertPriority(PriorityCode.UNCHANGED, osmWay);
    }

    @Test
    public void testHandleWayTagsInfluencedByRelation() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"road");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 12.0, osmWay);
        osmWay.setTag("lcn", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 12.0, osmWay);
        osmWay.removeTag("lcn");
        ReaderRelation osmRel = new ReaderRelation(1L);
        osmRel.setTag("route", (Object)"bicycle");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 12.0, osmWay, osmRel);
        osmRel.setTag("network", (Object)"lcn");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 12.0, osmWay, osmRel);
        osmRel.setTag("network", (Object)"rcn");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 12.0, osmWay, osmRel);
        osmWay.setTag("lcn", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 12.0, osmWay, osmRel);
        osmRel.setTag("network", (Object)"ncn");
        this.assertPriorityAndSpeed(PriorityCode.BEST, 12.0, osmWay, osmRel);
        osmWay.clearTags();
        osmWay.setTag("highway", (Object)"tertiary");
        osmRel.setTag("route", (Object)"bicycle");
        osmRel.setTag("network", (Object)"lcn");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 18.0, osmWay, osmRel);
    }

    @Test
    public void testUnchangedRelationShouldNotInfluencePriority() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"secondary");
        ReaderRelation osmRel = new ReaderRelation(1L);
        osmRel.setTag("description", (Object)"something");
        this.assertPriorityAndSpeed(PriorityCode.AVOID, 18.0, osmWay, osmRel);
    }

    @Test
    public void testCalcPriority() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"tertiary");
        ReaderRelation osmRel = new ReaderRelation(1L);
        osmRel.setTag("route", (Object)"bicycle");
        osmRel.setTag("network", (Object)"icn");
        IntsRef relFlags = this.osmParsers.handleRelationTags(osmRel, this.osmParsers.createRelationFlags());
        ArrayEdgeIntAccess edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        int edgeId = 0;
        this.osmParsers.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, osmWay, relFlags);
        Assertions.assertEquals((Object)RouteNetwork.INTERNATIONAL, (Object)this.encodingManager.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class).getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)PriorityCode.getValue((int)PriorityCode.BEST.getValue()), (double)this.priorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        osmRel = new ReaderRelation(1L);
        osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"track");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        this.osmParsers.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, osmWay, this.osmParsers.createRelationFlags());
        Assertions.assertEquals((Object)RouteNetwork.MISSING, (Object)this.encodingManager.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class).getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)PriorityCode.getValue((int)PriorityCode.UNCHANGED.getValue()), (double)this.priorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
        osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"whatever");
        edgeIntAccess = ArrayEdgeIntAccess.createFromBytes((int)this.encodingManager.getBytesForFlags());
        this.osmParsers.handleWayTags(edgeId, (EdgeIntAccess)edgeIntAccess, osmWay, this.osmParsers.createRelationFlags());
        Assertions.assertFalse((boolean)this.accessParser.getAccessEnc().getBool(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((Object)RouteNetwork.MISSING, (Object)this.encodingManager.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class).getEnum(false, edgeId, (EdgeIntAccess)edgeIntAccess));
        Assertions.assertEquals((double)PriorityCode.getValue((int)PriorityCode.UNCHANGED.getValue()), (double)this.priorityEnc.getDecimal(false, edgeId, (EdgeIntAccess)edgeIntAccess), (double)0.1);
    }

    @Test
    public void testMaxSpeed() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"tertiary");
        way.setTag("maxspeed", (Object)"90");
        this.assertPriorityAndSpeed(PriorityCode.AVOID, 18.0, way);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"track");
        way.setTag("maxspeed", (Object)"90");
        this.assertPriorityAndSpeed(PriorityCode.UNCHANGED, 12.0, way);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"secondary");
        way.setTag("maxspeed", (Object)"10");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 10.0, way);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"residential");
        way.setTag("maxspeed", (Object)"15");
        this.assertPriorityAndSpeed(PriorityCode.VERY_NICE, 16.0, way);
    }

    @Override
    @Test
    public void testBarrierAccess() {
        ReaderNode node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"kissing_gate");
        Assertions.assertTrue((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"kissing_gate");
        node.setTag("bicycle", (Object)"yes");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
        node = new ReaderNode(1L, -1.0, -1.0);
        node.setTag("barrier", (Object)"cattle_grid");
        Assertions.assertFalse((boolean)this.accessParser.isBarrier(node));
    }

    @Test
    public void testClassBicycle() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"tertiary");
        way.setTag("class:bicycle", (Object)"3");
        this.assertPriority(PriorityCode.BEST, way);
        way.setTag("scenic", (Object)"yes");
        this.assertPriority(PriorityCode.BEST, way);
        way.setTag("scenic", (Object)"no");
        way.setTag("class:bicycle", (Object)"2");
        this.assertPriority(PriorityCode.VERY_NICE, way);
        way.setTag("class:bicycle", (Object)"1");
        this.assertPriority(PriorityCode.PREFER, way);
        way.setTag("class:bicycle", (Object)"0");
        this.assertPriority(PriorityCode.UNCHANGED, way);
        way.setTag("class:bicycle", (Object)"invalidvalue");
        this.assertPriority(PriorityCode.UNCHANGED, way);
        way.setTag("class:bicycle", (Object)"-1");
        this.assertPriority(PriorityCode.SLIGHT_AVOID, way);
        way.setTag("class:bicycle", (Object)"-2");
        this.assertPriority(PriorityCode.AVOID, way);
        way.setTag("class:bicycle", (Object)"-3");
        this.assertPriority(PriorityCode.AVOID_MORE, way);
        way.setTag("highway", (Object)"residential");
        way.setTag("bicycle", (Object)"designated");
        way.setTag("class:bicycle", (Object)"3");
        this.assertPriority(PriorityCode.BEST, way);
        way.setTag("class:bicycle:touring", (Object)"2");
        this.assertPriority(PriorityCode.VERY_NICE, way);
        way.setTag("maxspeed", (Object)"15");
        this.assertPriority(PriorityCode.BEST, way);
    }

    @Test
    public void testAvoidMotorway() {
        ReaderWay osmWay = new ReaderWay(1L);
        osmWay.setTag("highway", (Object)"motorway");
        osmWay.setTag("bicycle", (Object)"yes");
        this.assertPriority(PriorityCode.REACH_DESTINATION, osmWay);
    }

    @Test
    public void temporalAccess() {
        int edgeId = 0;
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("access:conditional", (Object)"no @ (May - June)");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("bicycle:conditional", (Object)"no @ (May - June)");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("bicycle", (Object)"no");
        way.setTag("access:conditional", (Object)"yes @ (May - June)");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("bicycle", (Object)"no");
        way.setTag("bicycle:conditional", (Object)"yes @ (21:00-9:00)");
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }

    @Test
    public void temporalAccessWithPermit() {
        BikeCommonAccessParser tmpAccessParser = this.createAccessParser((EncodedValueLookup)this.encodingManager, new PMap("block_private=false"));
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"primary");
        way.setTag("bicycle", (Object)"no");
        way.setTag("bicycle:conditional", (Object)"permit @ (21:00-9:00)");
        int edgeId = 0;
        ArrayEdgeIntAccess access = new ArrayEdgeIntAccess(1);
        tmpAccessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertTrue((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
        access = new ArrayEdgeIntAccess(1);
        this.accessParser.handleWayTags(edgeId, (EdgeIntAccess)access, way, null);
        Assertions.assertFalse((boolean)this.accessEnc.getBool(false, edgeId, (EdgeIntAccess)access));
    }

    @Test
    public void testPedestrian() {
        ReaderWay way = new ReaderWay(1L);
        way.setTag("highway", (Object)"pedestrian");
        this.assertPriorityAndSpeed(PriorityCode.SLIGHT_AVOID, 4.0, way);
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.setTag("surface", (Object)"asphalt");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 12.0, way);
        way.clearTags();
        way.setTag("highway", (Object)"pedestrian");
        way.setTag("cycleway:right", (Object)"track");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, way);
        way.setTag("bicycle", (Object)"yes");
        this.assertPriorityAndSpeed(PriorityCode.PREFER, 18.0, way);
    }
}

