/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.BusAccess;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.MaxHeight;
import com.graphhopper.routing.ev.MaxWeight;
import com.graphhopper.routing.ev.MaxWidth;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.ModeAccessParser;
import com.graphhopper.routing.util.parsers.OSMMaxWeightParser;
import com.graphhopper.routing.util.parsers.OSMMaxWidthParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BusCustomModelTest {
    private EncodingManager em;
    private OSMParsers parsers;

    @BeforeEach
    public void setup() {
        BooleanEncodedValue busAccess = BusAccess.create();
        EnumEncodedValue roadClass = RoadClass.create();
        DecimalEncodedValue maxHeight = MaxHeight.create();
        DecimalEncodedValue maxWidth = MaxWidth.create();
        DecimalEncodedValue maxWeight = MaxWeight.create();
        this.em = new EncodingManager.Builder().add((EncodedValue)busAccess).add((EncodedValue)VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false)).add((EncodedValue)Roundabout.create()).add((EncodedValue)RoadAccess.create()).add((EncodedValue)roadClass).add((EncodedValue)maxWeight).add((EncodedValue)maxWidth).add((EncodedValue)maxHeight).build();
        this.parsers = new OSMParsers().addWayTagParser((TagParser)new OSMRoadClassParser(roadClass)).addWayTagParser((TagParser)new OSMMaxWeightParser(maxHeight)).addWayTagParser((TagParser)new OSMMaxWidthParser(maxWidth)).addWayTagParser((TagParser)new OSMMaxWeightParser(maxWeight)).addWayTagParser((TagParser)new ModeAccessParser(OSMRoadAccessParser.toOSMRestrictions((TransportationMode)TransportationMode.BUS), busAccess, true, this.em.getBooleanEncodedValue("roundabout"), Set.of(), Set.of()));
    }

    EdgeIteratorState createEdge(ReaderWay way) {
        BaseGraph graph = new BaseGraph.Builder(this.em).create();
        EdgeIteratorState edge = graph.edge(0, 1);
        this.parsers.handleWayTags(edge.getEdge(), graph.getEdgeAccess(), way, this.em.createRelationFlags());
        return edge;
    }

    @Test
    public void testHikePrivate() {
        CustomModel cm = GHUtility.loadCustomModelFromJar((String)"bus.json");
        ReaderWay way = new ReaderWay(0L);
        way.setTag("highway", (Object)"steps");
        EdgeIteratorState edge = this.createEdge(way);
        CustomWeighting.Parameters p = CustomModelParser.createWeightingParameters((CustomModel)cm, (EncodedValueLookup)this.em);
        Assertions.assertEquals((double)0.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
        way.setTag("highway", (Object)"busway");
        edge = this.createEdge(way);
        Assertions.assertEquals((double)1.0, (double)p.getEdgeToPriorityMapping().get(edge, false), (double)0.01);
    }
}

